"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEnv = exports.ENV_EXPIRATION = exports.ENV_SESSION = exports.ENV_SECRET = exports.ENV_KEY = void 0;
const property_provider_1 = require("@aws-sdk/property-provider");
exports.ENV_KEY = "AWS_ACCESS_KEY_ID";
exports.ENV_SECRET = "AWS_SECRET_ACCESS_KEY";
exports.ENV_SESSION = "AWS_SESSION_TOKEN";
exports.ENV_EXPIRATION = "AWS_CREDENTIAL_EXPIRATION";
/**
 * Source AWS credentials from known environment variables. If either the
 * `AWS_ACCESS_KEY_ID` or `AWS_SECRET_ACCESS_KEY` environment variable is not
 * set in this process, the provider will return a rejected promise.
 */
function fromEnv() {
    return () => {
        const accessKeyId = process.env[exports.ENV_KEY];
        const secretAccessKey = process.env[exports.ENV_SECRET];
        const expiry = process.env[exports.ENV_EXPIRATION];
        if (accessKeyId && secretAccessKey) {
            return Promise.resolve({
                accessKeyId,
                secretAccessKey,
                sessionToken: process.env[exports.ENV_SESSION],
                expiration: expiry ? new Date(expiry) : undefined,
            });
        }
        return Promise.reject(new property_provider_1.ProviderError("Unable to find environment variable credentials."));
    };
}
exports.fromEnv = fromEnv;
//# sourceMappingURL=data:application/json;base64,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