import { ProviderError } from "@aws-sdk/property-provider";
export var ENV_KEY = "AWS_ACCESS_KEY_ID";
export var ENV_SECRET = "AWS_SECRET_ACCESS_KEY";
export var ENV_SESSION = "AWS_SESSION_TOKEN";
export var ENV_EXPIRATION = "AWS_CREDENTIAL_EXPIRATION";
/**
 * Source AWS credentials from known environment variables. If either the
 * `AWS_ACCESS_KEY_ID` or `AWS_SECRET_ACCESS_KEY` environment variable is not
 * set in this process, the provider will return a rejected promise.
 */
export function fromEnv() {
    return function () {
        var accessKeyId = process.env[ENV_KEY];
        var secretAccessKey = process.env[ENV_SECRET];
        var expiry = process.env[ENV_EXPIRATION];
        if (accessKeyId && secretAccessKey) {
            return Promise.resolve({
                accessKeyId: accessKeyId,
                secretAccessKey: secretAccessKey,
                sessionToken: process.env[ENV_SESSION],
                expiration: expiry ? new Date(expiry) : undefined,
            });
        }
        return Promise.reject(new ProviderError("Unable to find environment variable credentials."));
    };
}
//# sourceMappingURL=data:application/json;base64,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