import { Crc32 } from "@aws-crypto/crc32";
// All prelude components are unsigned, 32-bit integers
var PRELUDE_MEMBER_LENGTH = 4;
// The prelude consists of two components
var PRELUDE_LENGTH = PRELUDE_MEMBER_LENGTH * 2;
// Checksums are always CRC32 hashes.
var CHECKSUM_LENGTH = 4;
// Messages must include a full prelude, a prelude checksum, and a message checksum
var MINIMUM_MESSAGE_LENGTH = PRELUDE_LENGTH + CHECKSUM_LENGTH * 2;
/**
 * @internal
 */
export function splitMessage(_a) {
    var byteLength = _a.byteLength, byteOffset = _a.byteOffset, buffer = _a.buffer;
    if (byteLength < MINIMUM_MESSAGE_LENGTH) {
        throw new Error("Provided message too short to accommodate event stream message overhead");
    }
    var view = new DataView(buffer, byteOffset, byteLength);
    var messageLength = view.getUint32(0, false);
    if (byteLength !== messageLength) {
        throw new Error("Reported message length does not match received message length");
    }
    var headerLength = view.getUint32(PRELUDE_MEMBER_LENGTH, false);
    var expectedPreludeChecksum = view.getUint32(PRELUDE_LENGTH, false);
    var expectedMessageChecksum = view.getUint32(byteLength - CHECKSUM_LENGTH, false);
    var checksummer = new Crc32().update(new Uint8Array(buffer, byteOffset, PRELUDE_LENGTH));
    if (expectedPreludeChecksum !== checksummer.digest()) {
        throw new Error("The prelude checksum specified in the message (" + expectedPreludeChecksum + ") does not match the calculated CRC32 checksum (" + checksummer.digest() + ")");
    }
    checksummer.update(new Uint8Array(buffer, byteOffset + PRELUDE_LENGTH, byteLength - (PRELUDE_LENGTH + CHECKSUM_LENGTH)));
    if (expectedMessageChecksum !== checksummer.digest()) {
        throw new Error("The message checksum (" + checksummer.digest() + ") did not match the expected value of " + expectedMessageChecksum);
    }
    return {
        headers: new DataView(buffer, byteOffset + PRELUDE_LENGTH + CHECKSUM_LENGTH, headerLength),
        body: new Uint8Array(buffer, byteOffset + PRELUDE_LENGTH + CHECKSUM_LENGTH + headerLength, messageLength - headerLength - (PRELUDE_LENGTH + CHECKSUM_LENGTH + CHECKSUM_LENGTH)),
    };
}
//# sourceMappingURL=data:application/json;base64,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