"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Hash = void 0;
const util_buffer_from_1 = require("@aws-sdk/util-buffer-from");
const buffer_1 = require("buffer");
const crypto_1 = require("crypto");
class Hash {
    constructor(algorithmIdentifier, secret) {
        this.hash = secret ? crypto_1.createHmac(algorithmIdentifier, castSourceData(secret)) : crypto_1.createHash(algorithmIdentifier);
    }
    update(toHash, encoding) {
        this.hash.update(castSourceData(toHash, encoding));
    }
    digest() {
        return Promise.resolve(this.hash.digest());
    }
}
exports.Hash = Hash;
function castSourceData(toCast, encoding) {
    if (buffer_1.Buffer.isBuffer(toCast)) {
        return toCast;
    }
    if (typeof toCast === "string") {
        return util_buffer_from_1.fromString(toCast, encoding);
    }
    if (ArrayBuffer.isView(toCast)) {
        return util_buffer_from_1.fromArrayBuffer(toCast.buffer, toCast.byteOffset, toCast.byteLength);
    }
    return util_buffer_from_1.fromArrayBuffer(toCast);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsZ0VBQXdGO0FBQ3hGLG1DQUFnQztBQUNoQyxtQ0FBd0U7QUFFeEUsTUFBYSxJQUFJO0lBR2YsWUFBWSxtQkFBMkIsRUFBRSxNQUFtQjtRQUMxRCxJQUFJLENBQUMsSUFBSSxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUMsbUJBQVUsQ0FBQyxtQkFBbUIsRUFBRSxjQUFjLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsbUJBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ2pILENBQUM7SUFFRCxNQUFNLENBQUMsTUFBa0IsRUFBRSxRQUFzQztRQUMvRCxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVELE1BQU07UUFDSixPQUFPLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7Q0FDRjtBQWRELG9CQWNDO0FBRUQsU0FBUyxjQUFjLENBQUMsTUFBa0IsRUFBRSxRQUF5QjtJQUNuRSxJQUFJLGVBQU0sQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDM0IsT0FBTyxNQUFNLENBQUM7S0FDZjtJQUVELElBQUksT0FBTyxNQUFNLEtBQUssUUFBUSxFQUFFO1FBQzlCLE9BQU8sNkJBQVUsQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFDLENBQUM7S0FDckM7SUFFRCxJQUFJLFdBQVcsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDOUIsT0FBTyxrQ0FBZSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLFVBQVUsRUFBRSxNQUFNLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0U7SUFFRCxPQUFPLGtDQUFlLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDakMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEhhc2ggYXMgSUhhc2gsIFNvdXJjZURhdGEgfSBmcm9tIFwiQGF3cy1zZGsvdHlwZXNcIjtcbmltcG9ydCB7IGZyb21BcnJheUJ1ZmZlciwgZnJvbVN0cmluZywgU3RyaW5nRW5jb2RpbmcgfSBmcm9tIFwiQGF3cy1zZGsvdXRpbC1idWZmZXItZnJvbVwiO1xuaW1wb3J0IHsgQnVmZmVyIH0gZnJvbSBcImJ1ZmZlclwiO1xuaW1wb3J0IHsgY3JlYXRlSGFzaCwgY3JlYXRlSG1hYywgSGFzaCBhcyBOb2RlSGFzaCwgSG1hYyB9IGZyb20gXCJjcnlwdG9cIjtcblxuZXhwb3J0IGNsYXNzIEhhc2ggaW1wbGVtZW50cyBJSGFzaCB7XG4gIHByaXZhdGUgcmVhZG9ubHkgaGFzaDogTm9kZUhhc2ggfCBIbWFjO1xuXG4gIGNvbnN0cnVjdG9yKGFsZ29yaXRobUlkZW50aWZpZXI6IHN0cmluZywgc2VjcmV0PzogU291cmNlRGF0YSkge1xuICAgIHRoaXMuaGFzaCA9IHNlY3JldCA/IGNyZWF0ZUhtYWMoYWxnb3JpdGhtSWRlbnRpZmllciwgY2FzdFNvdXJjZURhdGEoc2VjcmV0KSkgOiBjcmVhdGVIYXNoKGFsZ29yaXRobUlkZW50aWZpZXIpO1xuICB9XG5cbiAgdXBkYXRlKHRvSGFzaDogU291cmNlRGF0YSwgZW5jb2Rpbmc/OiBcInV0ZjhcIiB8IFwiYXNjaWlcIiB8IFwibGF0aW4xXCIpOiB2b2lkIHtcbiAgICB0aGlzLmhhc2gudXBkYXRlKGNhc3RTb3VyY2VEYXRhKHRvSGFzaCwgZW5jb2RpbmcpKTtcbiAgfVxuXG4gIGRpZ2VzdCgpOiBQcm9taXNlPFVpbnQ4QXJyYXk+IHtcbiAgICByZXR1cm4gUHJvbWlzZS5yZXNvbHZlKHRoaXMuaGFzaC5kaWdlc3QoKSk7XG4gIH1cbn1cblxuZnVuY3Rpb24gY2FzdFNvdXJjZURhdGEodG9DYXN0OiBTb3VyY2VEYXRhLCBlbmNvZGluZz86IFN0cmluZ0VuY29kaW5nKTogQnVmZmVyIHtcbiAgaWYgKEJ1ZmZlci5pc0J1ZmZlcih0b0Nhc3QpKSB7XG4gICAgcmV0dXJuIHRvQ2FzdDtcbiAgfVxuXG4gIGlmICh0eXBlb2YgdG9DYXN0ID09PSBcInN0cmluZ1wiKSB7XG4gICAgcmV0dXJuIGZyb21TdHJpbmcodG9DYXN0LCBlbmNvZGluZyk7XG4gIH1cblxuICBpZiAoQXJyYXlCdWZmZXIuaXNWaWV3KHRvQ2FzdCkpIHtcbiAgICByZXR1cm4gZnJvbUFycmF5QnVmZmVyKHRvQ2FzdC5idWZmZXIsIHRvQ2FzdC5ieXRlT2Zmc2V0LCB0b0Nhc3QuYnl0ZUxlbmd0aCk7XG4gIH1cblxuICByZXR1cm4gZnJvbUFycmF5QnVmZmVyKHRvQ2FzdCk7XG59XG4iXX0=