import { fromArrayBuffer, fromString } from "@aws-sdk/util-buffer-from";
import { Buffer } from "buffer";
import { createHash, createHmac } from "crypto";
var Hash = /** @class */ (function () {
    function Hash(algorithmIdentifier, secret) {
        this.hash = secret ? createHmac(algorithmIdentifier, castSourceData(secret)) : createHash(algorithmIdentifier);
    }
    Hash.prototype.update = function (toHash, encoding) {
        this.hash.update(castSourceData(toHash, encoding));
    };
    Hash.prototype.digest = function () {
        return Promise.resolve(this.hash.digest());
    };
    return Hash;
}());
export { Hash };
function castSourceData(toCast, encoding) {
    if (Buffer.isBuffer(toCast)) {
        return toCast;
    }
    if (typeof toCast === "string") {
        return fromString(toCast, encoding);
    }
    if (ArrayBuffer.isView(toCast)) {
        return fromArrayBuffer(toCast.buffer, toCast.byteOffset, toCast.byteLength);
    }
    return fromArrayBuffer(toCast);
}
//# sourceMappingURL=data:application/json;base64,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