import { createReadStream } from "fs";
import { HashCalculator } from "./hash-calculator";
export var fileStreamHasher = function fileStreamHasher(hashCtor, fileStream) {
    return new Promise(function (resolve, reject) {
        if (!isReadStream(fileStream)) {
            reject(new Error("Unable to calculate hash for non-file streams."));
            return;
        }
        var fileStreamTee = createReadStream(fileStream.path, {
            start: fileStream.start,
            end: fileStream.end,
        });
        var hash = new hashCtor();
        var hashCalculator = new HashCalculator(hash);
        fileStreamTee.pipe(hashCalculator);
        fileStreamTee.on("error", function (err) {
            // if the source errors, the destination stream needs to manually end
            hashCalculator.end();
            reject(err);
        });
        hashCalculator.on("error", reject);
        hashCalculator.on("finish", function () {
            hash.digest().then(resolve).catch(reject);
        });
    });
};
function isReadStream(stream) {
    return typeof stream.path === "string";
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLGdCQUFnQixFQUFjLE1BQU0sSUFBSSxDQUFDO0FBR2xELE9BQU8sRUFBRSxjQUFjLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUVuRCxNQUFNLENBQUMsSUFBTSxnQkFBZ0IsR0FBMkIsU0FBUyxnQkFBZ0IsQ0FDL0UsUUFBeUIsRUFDekIsVUFBb0I7SUFFcEIsT0FBTyxJQUFJLE9BQU8sQ0FBQyxVQUFDLE9BQU8sRUFBRSxNQUFNO1FBQ2pDLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDN0IsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLGdEQUFnRCxDQUFDLENBQUMsQ0FBQztZQUNwRSxPQUFPO1NBQ1I7UUFFRCxJQUFNLGFBQWEsR0FBRyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFO1lBQ3RELEtBQUssRUFBRyxVQUFrQixDQUFDLEtBQUs7WUFDaEMsR0FBRyxFQUFHLFVBQWtCLENBQUMsR0FBRztTQUM3QixDQUFDLENBQUM7UUFFSCxJQUFNLElBQUksR0FBRyxJQUFJLFFBQVEsRUFBRSxDQUFDO1FBQzVCLElBQU0sY0FBYyxHQUFHLElBQUksY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRWhELGFBQWEsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDbkMsYUFBYSxDQUFDLEVBQUUsQ0FBQyxPQUFPLEVBQUUsVUFBQyxHQUFRO1lBQ2pDLHFFQUFxRTtZQUNyRSxjQUFjLENBQUMsR0FBRyxFQUFFLENBQUM7WUFDckIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2QsQ0FBQyxDQUFDLENBQUM7UUFDSCxjQUFjLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxNQUFNLENBQUMsQ0FBQztRQUNuQyxjQUFjLENBQUMsRUFBRSxDQUFDLFFBQVEsRUFBRTtZQUMxQixJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUM1QyxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDO0FBRUYsU0FBUyxZQUFZLENBQUMsTUFBZ0I7SUFDcEMsT0FBTyxPQUFRLE1BQXFCLENBQUMsSUFBSSxLQUFLLFFBQVEsQ0FBQztBQUN6RCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSGFzaENvbnN0cnVjdG9yLCBTdHJlYW1IYXNoZXIgfSBmcm9tIFwiQGF3cy1zZGsvdHlwZXNcIjtcbmltcG9ydCB7IGNyZWF0ZVJlYWRTdHJlYW0sIFJlYWRTdHJlYW0gfSBmcm9tIFwiZnNcIjtcbmltcG9ydCB7IFJlYWRhYmxlIH0gZnJvbSBcInN0cmVhbVwiO1xuXG5pbXBvcnQgeyBIYXNoQ2FsY3VsYXRvciB9IGZyb20gXCIuL2hhc2gtY2FsY3VsYXRvclwiO1xuXG5leHBvcnQgY29uc3QgZmlsZVN0cmVhbUhhc2hlcjogU3RyZWFtSGFzaGVyPFJlYWRhYmxlPiA9IGZ1bmN0aW9uIGZpbGVTdHJlYW1IYXNoZXIoXG4gIGhhc2hDdG9yOiBIYXNoQ29uc3RydWN0b3IsXG4gIGZpbGVTdHJlYW06IFJlYWRhYmxlXG4pOiBQcm9taXNlPFVpbnQ4QXJyYXk+IHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBpZiAoIWlzUmVhZFN0cmVhbShmaWxlU3RyZWFtKSkge1xuICAgICAgcmVqZWN0KG5ldyBFcnJvcihcIlVuYWJsZSB0byBjYWxjdWxhdGUgaGFzaCBmb3Igbm9uLWZpbGUgc3RyZWFtcy5cIikpO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IGZpbGVTdHJlYW1UZWUgPSBjcmVhdGVSZWFkU3RyZWFtKGZpbGVTdHJlYW0ucGF0aCwge1xuICAgICAgc3RhcnQ6IChmaWxlU3RyZWFtIGFzIGFueSkuc3RhcnQsXG4gICAgICBlbmQ6IChmaWxlU3RyZWFtIGFzIGFueSkuZW5kLFxuICAgIH0pO1xuXG4gICAgY29uc3QgaGFzaCA9IG5ldyBoYXNoQ3RvcigpO1xuICAgIGNvbnN0IGhhc2hDYWxjdWxhdG9yID0gbmV3IEhhc2hDYWxjdWxhdG9yKGhhc2gpO1xuXG4gICAgZmlsZVN0cmVhbVRlZS5waXBlKGhhc2hDYWxjdWxhdG9yKTtcbiAgICBmaWxlU3RyZWFtVGVlLm9uKFwiZXJyb3JcIiwgKGVycjogYW55KSA9PiB7XG4gICAgICAvLyBpZiB0aGUgc291cmNlIGVycm9ycywgdGhlIGRlc3RpbmF0aW9uIHN0cmVhbSBuZWVkcyB0byBtYW51YWxseSBlbmRcbiAgICAgIGhhc2hDYWxjdWxhdG9yLmVuZCgpO1xuICAgICAgcmVqZWN0KGVycik7XG4gICAgfSk7XG4gICAgaGFzaENhbGN1bGF0b3Iub24oXCJlcnJvclwiLCByZWplY3QpO1xuICAgIGhhc2hDYWxjdWxhdG9yLm9uKFwiZmluaXNoXCIsIGZ1bmN0aW9uICh0aGlzOiBIYXNoQ2FsY3VsYXRvcikge1xuICAgICAgaGFzaC5kaWdlc3QoKS50aGVuKHJlc29sdmUpLmNhdGNoKHJlamVjdCk7XG4gICAgfSk7XG4gIH0pO1xufTtcblxuZnVuY3Rpb24gaXNSZWFkU3RyZWFtKHN0cmVhbTogUmVhZGFibGUpOiBzdHJlYW0gaXMgUmVhZFN0cmVhbSB7XG4gIHJldHVybiB0eXBlb2YgKHN0cmVhbSBhcyBSZWFkU3RyZWFtKS5wYXRoID09PSBcInN0cmluZ1wiO1xufVxuIl19