"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Md5 = void 0;
const util_utf8_browser_1 = require("@aws-sdk/util-utf8-browser");
const constants_1 = require("./constants");
class Md5 {
    constructor() {
        this.state = Uint32Array.from(constants_1.INIT);
        this.buffer = new DataView(new ArrayBuffer(constants_1.BLOCK_SIZE));
        this.bufferLength = 0;
        this.bytesHashed = 0;
        this.finished = false;
    }
    update(sourceData) {
        if (isEmptyData(sourceData)) {
            return;
        }
        else if (this.finished) {
            throw new Error("Attempted to update an already finished hash.");
        }
        const data = convertToBuffer(sourceData);
        let position = 0;
        let { byteLength } = data;
        this.bytesHashed += byteLength;
        while (byteLength > 0) {
            this.buffer.setUint8(this.bufferLength++, data[position++]);
            byteLength--;
            if (this.bufferLength === constants_1.BLOCK_SIZE) {
                this.hashBuffer();
                this.bufferLength = 0;
            }
        }
    }
    async digest() {
        if (!this.finished) {
            const { buffer, bufferLength: undecoratedLength, bytesHashed } = this;
            const bitsHashed = bytesHashed * 8;
            buffer.setUint8(this.bufferLength++, 0b10000000);
            // Ensure the final block has enough room for the hashed length
            if (undecoratedLength % constants_1.BLOCK_SIZE >= constants_1.BLOCK_SIZE - 8) {
                for (let i = this.bufferLength; i < constants_1.BLOCK_SIZE; i++) {
                    buffer.setUint8(i, 0);
                }
                this.hashBuffer();
                this.bufferLength = 0;
            }
            for (let i = this.bufferLength; i < constants_1.BLOCK_SIZE - 8; i++) {
                buffer.setUint8(i, 0);
            }
            buffer.setUint32(constants_1.BLOCK_SIZE - 8, bitsHashed >>> 0, true);
            buffer.setUint32(constants_1.BLOCK_SIZE - 4, Math.floor(bitsHashed / 0x100000000), true);
            this.hashBuffer();
            this.finished = true;
        }
        const out = new DataView(new ArrayBuffer(constants_1.DIGEST_LENGTH));
        for (let i = 0; i < 4; i++) {
            out.setUint32(i * 4, this.state[i], true);
        }
        return new Uint8Array(out.buffer, out.byteOffset, out.byteLength);
    }
    hashBuffer() {
        const { buffer, state } = this;
        let a = state[0], b = state[1], c = state[2], d = state[3];
        a = ff(a, b, c, d, buffer.getUint32(0, true), 7, 0xd76aa478);
        d = ff(d, a, b, c, buffer.getUint32(4, true), 12, 0xe8c7b756);
        c = ff(c, d, a, b, buffer.getUint32(8, true), 17, 0x242070db);
        b = ff(b, c, d, a, buffer.getUint32(12, true), 22, 0xc1bdceee);
        a = ff(a, b, c, d, buffer.getUint32(16, true), 7, 0xf57c0faf);
        d = ff(d, a, b, c, buffer.getUint32(20, true), 12, 0x4787c62a);
        c = ff(c, d, a, b, buffer.getUint32(24, true), 17, 0xa8304613);
        b = ff(b, c, d, a, buffer.getUint32(28, true), 22, 0xfd469501);
        a = ff(a, b, c, d, buffer.getUint32(32, true), 7, 0x698098d8);
        d = ff(d, a, b, c, buffer.getUint32(36, true), 12, 0x8b44f7af);
        c = ff(c, d, a, b, buffer.getUint32(40, true), 17, 0xffff5bb1);
        b = ff(b, c, d, a, buffer.getUint32(44, true), 22, 0x895cd7be);
        a = ff(a, b, c, d, buffer.getUint32(48, true), 7, 0x6b901122);
        d = ff(d, a, b, c, buffer.getUint32(52, true), 12, 0xfd987193);
        c = ff(c, d, a, b, buffer.getUint32(56, true), 17, 0xa679438e);
        b = ff(b, c, d, a, buffer.getUint32(60, true), 22, 0x49b40821);
        a = gg(a, b, c, d, buffer.getUint32(4, true), 5, 0xf61e2562);
        d = gg(d, a, b, c, buffer.getUint32(24, true), 9, 0xc040b340);
        c = gg(c, d, a, b, buffer.getUint32(44, true), 14, 0x265e5a51);
        b = gg(b, c, d, a, buffer.getUint32(0, true), 20, 0xe9b6c7aa);
        a = gg(a, b, c, d, buffer.getUint32(20, true), 5, 0xd62f105d);
        d = gg(d, a, b, c, buffer.getUint32(40, true), 9, 0x02441453);
        c = gg(c, d, a, b, buffer.getUint32(60, true), 14, 0xd8a1e681);
        b = gg(b, c, d, a, buffer.getUint32(16, true), 20, 0xe7d3fbc8);
        a = gg(a, b, c, d, buffer.getUint32(36, true), 5, 0x21e1cde6);
        d = gg(d, a, b, c, buffer.getUint32(56, true), 9, 0xc33707d6);
        c = gg(c, d, a, b, buffer.getUint32(12, true), 14, 0xf4d50d87);
        b = gg(b, c, d, a, buffer.getUint32(32, true), 20, 0x455a14ed);
        a = gg(a, b, c, d, buffer.getUint32(52, true), 5, 0xa9e3e905);
        d = gg(d, a, b, c, buffer.getUint32(8, true), 9, 0xfcefa3f8);
        c = gg(c, d, a, b, buffer.getUint32(28, true), 14, 0x676f02d9);
        b = gg(b, c, d, a, buffer.getUint32(48, true), 20, 0x8d2a4c8a);
        a = hh(a, b, c, d, buffer.getUint32(20, true), 4, 0xfffa3942);
        d = hh(d, a, b, c, buffer.getUint32(32, true), 11, 0x8771f681);
        c = hh(c, d, a, b, buffer.getUint32(44, true), 16, 0x6d9d6122);
        b = hh(b, c, d, a, buffer.getUint32(56, true), 23, 0xfde5380c);
        a = hh(a, b, c, d, buffer.getUint32(4, true), 4, 0xa4beea44);
        d = hh(d, a, b, c, buffer.getUint32(16, true), 11, 0x4bdecfa9);
        c = hh(c, d, a, b, buffer.getUint32(28, true), 16, 0xf6bb4b60);
        b = hh(b, c, d, a, buffer.getUint32(40, true), 23, 0xbebfbc70);
        a = hh(a, b, c, d, buffer.getUint32(52, true), 4, 0x289b7ec6);
        d = hh(d, a, b, c, buffer.getUint32(0, true), 11, 0xeaa127fa);
        c = hh(c, d, a, b, buffer.getUint32(12, true), 16, 0xd4ef3085);
        b = hh(b, c, d, a, buffer.getUint32(24, true), 23, 0x04881d05);
        a = hh(a, b, c, d, buffer.getUint32(36, true), 4, 0xd9d4d039);
        d = hh(d, a, b, c, buffer.getUint32(48, true), 11, 0xe6db99e5);
        c = hh(c, d, a, b, buffer.getUint32(60, true), 16, 0x1fa27cf8);
        b = hh(b, c, d, a, buffer.getUint32(8, true), 23, 0xc4ac5665);
        a = ii(a, b, c, d, buffer.getUint32(0, true), 6, 0xf4292244);
        d = ii(d, a, b, c, buffer.getUint32(28, true), 10, 0x432aff97);
        c = ii(c, d, a, b, buffer.getUint32(56, true), 15, 0xab9423a7);
        b = ii(b, c, d, a, buffer.getUint32(20, true), 21, 0xfc93a039);
        a = ii(a, b, c, d, buffer.getUint32(48, true), 6, 0x655b59c3);
        d = ii(d, a, b, c, buffer.getUint32(12, true), 10, 0x8f0ccc92);
        c = ii(c, d, a, b, buffer.getUint32(40, true), 15, 0xffeff47d);
        b = ii(b, c, d, a, buffer.getUint32(4, true), 21, 0x85845dd1);
        a = ii(a, b, c, d, buffer.getUint32(32, true), 6, 0x6fa87e4f);
        d = ii(d, a, b, c, buffer.getUint32(60, true), 10, 0xfe2ce6e0);
        c = ii(c, d, a, b, buffer.getUint32(24, true), 15, 0xa3014314);
        b = ii(b, c, d, a, buffer.getUint32(52, true), 21, 0x4e0811a1);
        a = ii(a, b, c, d, buffer.getUint32(16, true), 6, 0xf7537e82);
        d = ii(d, a, b, c, buffer.getUint32(44, true), 10, 0xbd3af235);
        c = ii(c, d, a, b, buffer.getUint32(8, true), 15, 0x2ad7d2bb);
        b = ii(b, c, d, a, buffer.getUint32(36, true), 21, 0xeb86d391);
        state[0] = (a + state[0]) & 0xffffffff;
        state[1] = (b + state[1]) & 0xffffffff;
        state[2] = (c + state[2]) & 0xffffffff;
        state[3] = (d + state[3]) & 0xffffffff;
    }
}
exports.Md5 = Md5;
function cmn(q, a, b, x, s, t) {
    a = (((a + q) & 0xffffffff) + ((x + t) & 0xffffffff)) & 0xffffffff;
    return (((a << s) | (a >>> (32 - s))) + b) & 0xffffffff;
}
function ff(a, b, c, d, x, s, t) {
    return cmn((b & c) | (~b & d), a, b, x, s, t);
}
function gg(a, b, c, d, x, s, t) {
    return cmn((b & d) | (c & ~d), a, b, x, s, t);
}
function hh(a, b, c, d, x, s, t) {
    return cmn(b ^ c ^ d, a, b, x, s, t);
}
function ii(a, b, c, d, x, s, t) {
    return cmn(c ^ (b | ~d), a, b, x, s, t);
}
function isEmptyData(data) {
    if (typeof data === "string") {
        return data.length === 0;
    }
    return data.byteLength === 0;
}
function convertToBuffer(data) {
    if (typeof data === "string") {
        return util_utf8_browser_1.fromUtf8(data);
    }
    if (ArrayBuffer.isView(data)) {
        return new Uint8Array(data.buffer, data.byteOffset, data.byteLength / Uint8Array.BYTES_PER_ELEMENT);
    }
    return new Uint8Array(data);
}
//# sourceMappingURL=data:application/json;base64,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