"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NODE_USE_ARN_REGION_CONFIG_OPTIONS = exports.NODE_USE_ARN_REGION_INI_NAME = exports.NODE_USE_ARN_REGION_ENV_NAME = exports.resolveBucketEndpointConfig = void 0;
function resolveBucketEndpointConfig(input) {
    const { bucketEndpoint = false, forcePathStyle = false, useAccelerateEndpoint = false, useDualstackEndpoint = false, useArnRegion = false, } = input;
    return {
        ...input,
        bucketEndpoint,
        forcePathStyle,
        useAccelerateEndpoint,
        useDualstackEndpoint,
        useArnRegion: typeof useArnRegion === "function" ? useArnRegion : () => Promise.resolve(useArnRegion),
    };
}
exports.resolveBucketEndpointConfig = resolveBucketEndpointConfig;
exports.NODE_USE_ARN_REGION_ENV_NAME = "AWS_S3_USE_ARN_REGION";
exports.NODE_USE_ARN_REGION_INI_NAME = "s3_use_arn_region";
/**
 * Config to load useArnRegion from environment variables and shared INI files
 *
 * @api private
 */
exports.NODE_USE_ARN_REGION_CONFIG_OPTIONS = {
    environmentVariableSelector: (env) => {
        if (!Object.prototype.hasOwnProperty.call(env, exports.NODE_USE_ARN_REGION_ENV_NAME))
            return undefined;
        if (env[exports.NODE_USE_ARN_REGION_ENV_NAME] === "true")
            return true;
        if (env[exports.NODE_USE_ARN_REGION_ENV_NAME] === "false")
            return false;
        throw new Error(`Cannot load env ${exports.NODE_USE_ARN_REGION_ENV_NAME}. Expected "true" or "false", got ${env[exports.NODE_USE_ARN_REGION_ENV_NAME]}.`);
    },
    configFileSelector: (profile) => {
        if (!Object.prototype.hasOwnProperty.call(profile, exports.NODE_USE_ARN_REGION_INI_NAME))
            return undefined;
        if (profile[exports.NODE_USE_ARN_REGION_INI_NAME] === "true")
            return true;
        if (profile[exports.NODE_USE_ARN_REGION_INI_NAME] === "false")
            return false;
        throw new Error(`Cannot load shared config entry ${exports.NODE_USE_ARN_REGION_INI_NAME}. Expected "true" or "false", got ${profile[exports.NODE_USE_ARN_REGION_INI_NAME]}.`);
    },
    default: false,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlndXJhdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY29uZmlndXJhdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBMkNBLFNBQWdCLDJCQUEyQixDQUN6QyxLQUF5RDtJQUV6RCxNQUFNLEVBQ0osY0FBYyxHQUFHLEtBQUssRUFDdEIsY0FBYyxHQUFHLEtBQUssRUFDdEIscUJBQXFCLEdBQUcsS0FBSyxFQUM3QixvQkFBb0IsR0FBRyxLQUFLLEVBQzVCLFlBQVksR0FBRyxLQUFLLEdBQ3JCLEdBQUcsS0FBSyxDQUFDO0lBQ1YsT0FBTztRQUNMLEdBQUcsS0FBSztRQUNSLGNBQWM7UUFDZCxjQUFjO1FBQ2QscUJBQXFCO1FBQ3JCLG9CQUFvQjtRQUNwQixZQUFZLEVBQUUsT0FBTyxZQUFZLEtBQUssVUFBVSxDQUFDLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDO0tBQ3RHLENBQUM7QUFDSixDQUFDO0FBbEJELGtFQWtCQztBQUVZLFFBQUEsNEJBQTRCLEdBQUcsdUJBQXVCLENBQUM7QUFDdkQsUUFBQSw0QkFBNEIsR0FBRyxtQkFBbUIsQ0FBQztBQUVoRTs7OztHQUlHO0FBQ1UsUUFBQSxrQ0FBa0MsR0FBbUM7SUFDaEYsMkJBQTJCLEVBQUUsQ0FBQyxHQUFzQixFQUFFLEVBQUU7UUFDdEQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsb0NBQTRCLENBQUM7WUFBRSxPQUFPLFNBQVMsQ0FBQztRQUMvRixJQUFJLEdBQUcsQ0FBQyxvQ0FBNEIsQ0FBQyxLQUFLLE1BQU07WUFBRSxPQUFPLElBQUksQ0FBQztRQUM5RCxJQUFJLEdBQUcsQ0FBQyxvQ0FBNEIsQ0FBQyxLQUFLLE9BQU87WUFBRSxPQUFPLEtBQUssQ0FBQztRQUNoRSxNQUFNLElBQUksS0FBSyxDQUNiLG1CQUFtQixvQ0FBNEIscUNBQXFDLEdBQUcsQ0FBQyxvQ0FBNEIsQ0FBQyxHQUFHLENBQ3pILENBQUM7SUFDSixDQUFDO0lBQ0Qsa0JBQWtCLEVBQUUsQ0FBQyxPQUFPLEVBQUUsRUFBRTtRQUM5QixJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxvQ0FBNEIsQ0FBQztZQUFFLE9BQU8sU0FBUyxDQUFDO1FBQ25HLElBQUksT0FBTyxDQUFDLG9DQUE0QixDQUFDLEtBQUssTUFBTTtZQUFFLE9BQU8sSUFBSSxDQUFDO1FBQ2xFLElBQUksT0FBTyxDQUFDLG9DQUE0QixDQUFDLEtBQUssT0FBTztZQUFFLE9BQU8sS0FBSyxDQUFDO1FBQ3BFLE1BQU0sSUFBSSxLQUFLLENBQ2IsbUNBQW1DLG9DQUE0QixxQ0FBcUMsT0FBTyxDQUFDLG9DQUE0QixDQUFDLEdBQUcsQ0FDN0ksQ0FBQztJQUNKLENBQUM7SUFDRCxPQUFPLEVBQUUsS0FBSztDQUNmLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBMb2FkZWRDb25maWdTZWxlY3RvcnMgfSBmcm9tIFwiQGF3cy1zZGsvbm9kZS1jb25maWctcHJvdmlkZXJcIjtcbmltcG9ydCB7IFByb3ZpZGVyLCBSZWdpb25JbmZvUHJvdmlkZXIgfSBmcm9tIFwiQGF3cy1zZGsvdHlwZXNcIjtcblxuZXhwb3J0IGludGVyZmFjZSBCdWNrZXRFbmRwb2ludElucHV0Q29uZmlnIHtcbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhlIHByb3ZpZGVkIGVuZHBvaW50IGFkZHJlc3NlcyBhbiBpbmRpdmlkdWFsIGJ1Y2tldC5cbiAgICovXG4gIGJ1Y2tldEVuZHBvaW50PzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gZm9yY2UgcGF0aCBzdHlsZSBVUkxzIGZvciBTMyBvYmplY3RzIChlLmcuLCBodHRwczovL3MzLmFtYXpvbmF3cy5jb20vPGJ1Y2tldE5hbWU+LzxrZXk+IGluc3RlYWQgb2YgaHR0cHM6Ly88YnVja2V0TmFtZT4uczMuYW1hem9uYXdzLmNvbS88a2V5PlxuICAgKi9cbiAgZm9yY2VQYXRoU3R5bGU/OiBib29sZWFuO1xuICAvKipcbiAgICogV2hldGhlciB0byB1c2UgdGhlIFMzIFRyYW5zZmVyIEFjY2VsZXJhdGlvbiBlbmRwb2ludCBieSBkZWZhdWx0XG4gICAqL1xuICB1c2VBY2NlbGVyYXRlRW5kcG9pbnQ/OiBib29sZWFuO1xuICAvKipcbiAgICogRW5hYmxlcyBJUHY2L0lQdjQgZHVhbHN0YWNrIGVuZHBvaW50LiBXaGVuIGEgRE5TIGxvb2t1cCBpcyBwZXJmb3JtZWQgb24gYW4gZW5kcG9pbnQgb2YgdGhpcyB0eXBlLCBpdCByZXR1cm5zIGFuIOKAnEHigJ0gcmVjb3JkIHdpdGggYW4gSVB2NCBhZGRyZXNzIGFuZCBhbiDigJxBQUFB4oCdIHJlY29yZCB3aXRoIGFuIElQdjYgYWRkcmVzcy4gSW4gbW9zdCBjYXNlcyB0aGUgbmV0d29yayBzdGFjayBpbiB0aGUgY2xpZW50IGVudmlyb25tZW50IHdpbGwgYXV0b21hdGljYWxseSBwcmVmZXIgdGhlIEFBQUEgcmVjb3JkIGFuZCBtYWtlIGEgY29ubmVjdGlvbiB1c2luZyB0aGUgSVB2NiBhZGRyZXNzLiBOb3RlLCBob3dldmVyLCB0aGF0IGN1cnJlbnRseSBvbiBXaW5kb3dzLCB0aGUgSVB2NCBhZGRyZXNzIHdpbGwgYmUgcHJlZmVycmVkLlxuICAgKi9cbiAgdXNlRHVhbHN0YWNrRW5kcG9pbnQ/OiBib29sZWFuO1xuICAvKipcbiAgICogV2hldGhlciB0byBvdmVycmlkZSB0aGUgcmVxdWVzdCByZWdpb24gd2l0aCB0aGUgcmVnaW9uIGluZmVycmVkIGZyb20gcmVxdWVzdGVkIHJlc291cmNlJ3MgQVJOLiBEZWZhdWx0cyB0byBmYWxzZVxuICAgKi9cbiAgdXNlQXJuUmVnaW9uPzogYm9vbGVhbiB8IFByb3ZpZGVyPGJvb2xlYW4+O1xufVxuXG5pbnRlcmZhY2UgUHJldmlvdXNseVJlc29sdmVkIHtcbiAgaXNDdXN0b21FbmRwb2ludDogYm9vbGVhbjtcbiAgcmVnaW9uOiBQcm92aWRlcjxzdHJpbmc+O1xuICByZWdpb25JbmZvUHJvdmlkZXI6IFJlZ2lvbkluZm9Qcm92aWRlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBCdWNrZXRFbmRwb2ludFJlc29sdmVkQ29uZmlnIHtcbiAgaXNDdXN0b21FbmRwb2ludDogYm9vbGVhbjtcbiAgYnVja2V0RW5kcG9pbnQ6IGJvb2xlYW47XG4gIGZvcmNlUGF0aFN0eWxlOiBib29sZWFuO1xuICB1c2VBY2NlbGVyYXRlRW5kcG9pbnQ6IGJvb2xlYW47XG4gIHVzZUR1YWxzdGFja0VuZHBvaW50OiBib29sZWFuO1xuICB1c2VBcm5SZWdpb246IFByb3ZpZGVyPGJvb2xlYW4+O1xuICByZWdpb246IFByb3ZpZGVyPHN0cmluZz47XG4gIHJlZ2lvbkluZm9Qcm92aWRlcjogUmVnaW9uSW5mb1Byb3ZpZGVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVzb2x2ZUJ1Y2tldEVuZHBvaW50Q29uZmlnPFQ+KFxuICBpbnB1dDogVCAmIFByZXZpb3VzbHlSZXNvbHZlZCAmIEJ1Y2tldEVuZHBvaW50SW5wdXRDb25maWdcbik6IFQgJiBCdWNrZXRFbmRwb2ludFJlc29sdmVkQ29uZmlnIHtcbiAgY29uc3Qge1xuICAgIGJ1Y2tldEVuZHBvaW50ID0gZmFsc2UsXG4gICAgZm9yY2VQYXRoU3R5bGUgPSBmYWxzZSxcbiAgICB1c2VBY2NlbGVyYXRlRW5kcG9pbnQgPSBmYWxzZSxcbiAgICB1c2VEdWFsc3RhY2tFbmRwb2ludCA9IGZhbHNlLFxuICAgIHVzZUFyblJlZ2lvbiA9IGZhbHNlLFxuICB9ID0gaW5wdXQ7XG4gIHJldHVybiB7XG4gICAgLi4uaW5wdXQsXG4gICAgYnVja2V0RW5kcG9pbnQsXG4gICAgZm9yY2VQYXRoU3R5bGUsXG4gICAgdXNlQWNjZWxlcmF0ZUVuZHBvaW50LFxuICAgIHVzZUR1YWxzdGFja0VuZHBvaW50LFxuICAgIHVzZUFyblJlZ2lvbjogdHlwZW9mIHVzZUFyblJlZ2lvbiA9PT0gXCJmdW5jdGlvblwiID8gdXNlQXJuUmVnaW9uIDogKCkgPT4gUHJvbWlzZS5yZXNvbHZlKHVzZUFyblJlZ2lvbiksXG4gIH07XG59XG5cbmV4cG9ydCBjb25zdCBOT0RFX1VTRV9BUk5fUkVHSU9OX0VOVl9OQU1FID0gXCJBV1NfUzNfVVNFX0FSTl9SRUdJT05cIjtcbmV4cG9ydCBjb25zdCBOT0RFX1VTRV9BUk5fUkVHSU9OX0lOSV9OQU1FID0gXCJzM191c2VfYXJuX3JlZ2lvblwiO1xuXG4vKipcbiAqIENvbmZpZyB0byBsb2FkIHVzZUFyblJlZ2lvbiBmcm9tIGVudmlyb25tZW50IHZhcmlhYmxlcyBhbmQgc2hhcmVkIElOSSBmaWxlc1xuICpcbiAqIEBhcGkgcHJpdmF0ZVxuICovXG5leHBvcnQgY29uc3QgTk9ERV9VU0VfQVJOX1JFR0lPTl9DT05GSUdfT1BUSU9OUzogTG9hZGVkQ29uZmlnU2VsZWN0b3JzPGJvb2xlYW4+ID0ge1xuICBlbnZpcm9ubWVudFZhcmlhYmxlU2VsZWN0b3I6IChlbnY6IE5vZGVKUy5Qcm9jZXNzRW52KSA9PiB7XG4gICAgaWYgKCFPYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5LmNhbGwoZW52LCBOT0RFX1VTRV9BUk5fUkVHSU9OX0VOVl9OQU1FKSkgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICBpZiAoZW52W05PREVfVVNFX0FSTl9SRUdJT05fRU5WX05BTUVdID09PSBcInRydWVcIikgcmV0dXJuIHRydWU7XG4gICAgaWYgKGVudltOT0RFX1VTRV9BUk5fUkVHSU9OX0VOVl9OQU1FXSA9PT0gXCJmYWxzZVwiKSByZXR1cm4gZmFsc2U7XG4gICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgYENhbm5vdCBsb2FkIGVudiAke05PREVfVVNFX0FSTl9SRUdJT05fRU5WX05BTUV9LiBFeHBlY3RlZCBcInRydWVcIiBvciBcImZhbHNlXCIsIGdvdCAke2VudltOT0RFX1VTRV9BUk5fUkVHSU9OX0VOVl9OQU1FXX0uYFxuICAgICk7XG4gIH0sXG4gIGNvbmZpZ0ZpbGVTZWxlY3RvcjogKHByb2ZpbGUpID0+IHtcbiAgICBpZiAoIU9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChwcm9maWxlLCBOT0RFX1VTRV9BUk5fUkVHSU9OX0lOSV9OQU1FKSkgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICBpZiAocHJvZmlsZVtOT0RFX1VTRV9BUk5fUkVHSU9OX0lOSV9OQU1FXSA9PT0gXCJ0cnVlXCIpIHJldHVybiB0cnVlO1xuICAgIGlmIChwcm9maWxlW05PREVfVVNFX0FSTl9SRUdJT05fSU5JX05BTUVdID09PSBcImZhbHNlXCIpIHJldHVybiBmYWxzZTtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICBgQ2Fubm90IGxvYWQgc2hhcmVkIGNvbmZpZyBlbnRyeSAke05PREVfVVNFX0FSTl9SRUdJT05fSU5JX05BTUV9LiBFeHBlY3RlZCBcInRydWVcIiBvciBcImZhbHNlXCIsIGdvdCAke3Byb2ZpbGVbTk9ERV9VU0VfQVJOX1JFR0lPTl9JTklfTkFNRV19LmBcbiAgICApO1xuICB9LFxuICBkZWZhdWx0OiBmYWxzZSxcbn07XG4iXX0=