import { __assign, __awaiter, __generator } from "tslib";
import { HttpRequest } from "@aws-sdk/protocol-http";
import { parse as parseArn, validate as validateArn } from "@aws-sdk/util-arn-parser";
import { bucketHostname } from "./bucketHostname";
import { getPseudoRegion } from "./bucketHostnameUtils";
export var bucketEndpointMiddleware = function (options) { return function (next, context) { return function (args) { return __awaiter(void 0, void 0, void 0, function () {
    var bucketName, replaceBucketInPath, request, bucketArn, clientRegion, _a, _b, partition, _c, signingRegion, useArnRegion, _d, hostname, bucketEndpoint, modifiedSigningRegion, signingService, clientRegion, _e, _f, hostname, bucketEndpoint;
    return __generator(this, function (_g) {
        switch (_g.label) {
            case 0:
                bucketName = args.input.Bucket;
                replaceBucketInPath = options.bucketEndpoint;
                request = args.request;
                if (!HttpRequest.isInstance(request)) return [3 /*break*/, 8];
                if (!options.bucketEndpoint) return [3 /*break*/, 1];
                request.hostname = bucketName;
                return [3 /*break*/, 7];
            case 1:
                if (!validateArn(bucketName)) return [3 /*break*/, 5];
                bucketArn = parseArn(bucketName);
                _a = getPseudoRegion;
                return [4 /*yield*/, options.region()];
            case 2:
                clientRegion = _a.apply(void 0, [_g.sent()]);
                return [4 /*yield*/, options.regionInfoProvider(clientRegion)];
            case 3:
                _b = (_g.sent()) || {}, partition = _b.partition, _c = _b.signingRegion, signingRegion = _c === void 0 ? clientRegion : _c;
                return [4 /*yield*/, options.useArnRegion()];
            case 4:
                useArnRegion = _g.sent();
                _d = bucketHostname({
                    bucketName: bucketArn,
                    baseHostname: request.hostname,
                    accelerateEndpoint: options.useAccelerateEndpoint,
                    dualstackEndpoint: options.useDualstackEndpoint,
                    pathStyleEndpoint: options.forcePathStyle,
                    tlsCompatible: request.protocol === "https:",
                    useArnRegion: useArnRegion,
                    clientPartition: partition,
                    clientSigningRegion: signingRegion,
                    clientRegion: clientRegion,
                    isCustomEndpoint: options.isCustomEndpoint,
                }), hostname = _d.hostname, bucketEndpoint = _d.bucketEndpoint, modifiedSigningRegion = _d.signingRegion, signingService = _d.signingService;
                // If the request needs to use a region or service name inferred from ARN that different from client region, we
                // need to set them in the handler context so the signer will use them
                if (modifiedSigningRegion && modifiedSigningRegion !== signingRegion) {
                    context["signing_region"] = modifiedSigningRegion;
                }
                if (signingService && signingService !== "s3") {
                    context["signing_service"] = signingService;
                }
                request.hostname = hostname;
                replaceBucketInPath = bucketEndpoint;
                return [3 /*break*/, 7];
            case 5:
                _e = getPseudoRegion;
                return [4 /*yield*/, options.region()];
            case 6:
                clientRegion = _e.apply(void 0, [_g.sent()]);
                _f = bucketHostname({
                    bucketName: bucketName,
                    clientRegion: clientRegion,
                    baseHostname: request.hostname,
                    accelerateEndpoint: options.useAccelerateEndpoint,
                    dualstackEndpoint: options.useDualstackEndpoint,
                    pathStyleEndpoint: options.forcePathStyle,
                    tlsCompatible: request.protocol === "https:",
                    isCustomEndpoint: options.isCustomEndpoint,
                }), hostname = _f.hostname, bucketEndpoint = _f.bucketEndpoint;
                request.hostname = hostname;
                replaceBucketInPath = bucketEndpoint;
                _g.label = 7;
            case 7:
                if (replaceBucketInPath) {
                    request.path = request.path.replace(/^(\/)?[^\/]+/, "");
                    if (request.path === "") {
                        request.path = "/";
                    }
                }
                _g.label = 8;
            case 8: return [2 /*return*/, next(__assign(__assign({}, args), { request: request }))];
        }
    });
}); }; }; };
export var bucketEndpointMiddlewareOptions = {
    tags: ["BUCKET_ENDPOINT"],
    name: "bucketEndpointMiddleware",
    relation: "before",
    toMiddleware: "hostHeaderMiddleware",
    override: true,
};
export var getBucketEndpointPlugin = function (options) { return ({
    applyToStack: function (clientStack) {
        clientStack.addRelativeTo(bucketEndpointMiddleware(options), bucketEndpointMiddlewareOptions);
    },
}); };
//# sourceMappingURL=data:application/json;base64,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