"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUseRegionalEndpointPlugin = exports.useRegionalEndpointMiddlewareOptions = exports.useRegionalEndpointMiddleware = void 0;
const protocol_http_1 = require("@aws-sdk/protocol-http");
/**
 * @internal
 */
const useRegionalEndpointMiddleware = (config) => (next) => async (args) => {
    const { request } = args;
    if (!protocol_http_1.HttpRequest.isInstance(request) || config.isCustomEndpoint)
        return next({ ...args });
    if (request.hostname === "s3.amazonaws.com") {
        request.hostname = "s3.us-east-1.amazonaws.com";
    }
    else if ("aws-global" === (await config.region())) {
        request.hostname = "s3.amazonaws.com";
    }
    return next({ ...args });
};
exports.useRegionalEndpointMiddleware = useRegionalEndpointMiddleware;
/**
 * @internal
 */
exports.useRegionalEndpointMiddlewareOptions = {
    step: "build",
    tags: ["USE_REGIONAL_ENDPOINT", "S3"],
    name: "useRegionalEndpointMiddleware",
    override: true,
};
/**
 * @internal
 */
const getUseRegionalEndpointPlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add(exports.useRegionalEndpointMiddleware(config), exports.useRegionalEndpointMiddlewareOptions);
    },
});
exports.getUseRegionalEndpointPlugin = getUseRegionalEndpointPlugin;
//# sourceMappingURL=data:application/json;base64,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