"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValidateBucketNamePlugin = exports.validateBucketNameMiddlewareOptions = exports.validateBucketNameMiddleware = void 0;
const util_arn_parser_1 = require("@aws-sdk/util-arn-parser");
/**
 * @internal
 */
function validateBucketNameMiddleware() {
    return (next) => async (args) => {
        const { input: { Bucket }, } = args;
        if (typeof Bucket === "string" && !util_arn_parser_1.validate(Bucket) && Bucket.indexOf("/") >= 0) {
            const err = new Error(`Bucket name shouldn't contain '/', received '${Bucket}'`);
            err.name = "InvalidBucketName";
            throw err;
        }
        return next({ ...args });
    };
}
exports.validateBucketNameMiddleware = validateBucketNameMiddleware;
/**
 * @internal
 */
exports.validateBucketNameMiddlewareOptions = {
    step: "initialize",
    tags: ["VALIDATE_BUCKET_NAME"],
    name: "validateBucketNameMiddleware",
    override: true,
};
/**
 * @internal
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const getValidateBucketNamePlugin = (unused) => ({
    applyToStack: (clientStack) => {
        clientStack.add(validateBucketNameMiddleware(), exports.validateBucketNameMiddlewareOptions);
    },
});
exports.getValidateBucketNamePlugin = getValidateBucketNamePlugin;
//# sourceMappingURL=data:application/json;base64,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