import { __awaiter, __generator } from "tslib";
import { HttpResponse } from "@aws-sdk/protocol-http";
/**
 * In case of an internal error/terminated connection, S3 operations may return 200 errors. CopyObject, UploadPartCopy,
 * CompleteMultipartUpload may return empty payload or payload with only xml Preamble.
 * @internal
 */
export var throw200ExceptionsMiddleware = function (config) { return function (next) { return function (args) { return __awaiter(void 0, void 0, void 0, function () {
    var result, response, statusCode, body, bodyBytes, bodyString, err;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, next(args)];
            case 1:
                result = _a.sent();
                response = result.response;
                if (!HttpResponse.isInstance(response))
                    return [2 /*return*/, result];
                statusCode = response.statusCode, body = response.body;
                if (statusCode < 200 && statusCode >= 300)
                    return [2 /*return*/, result];
                return [4 /*yield*/, collectBody(body, config)];
            case 2:
                bodyBytes = _a.sent();
                return [4 /*yield*/, collectBodyString(bodyBytes, config)];
            case 3:
                bodyString = _a.sent();
                if (bodyBytes.length === 0) {
                    err = new Error("S3 aborted request");
                    err.name = "InternalError";
                    throw err;
                }
                if (bodyString && bodyString.match("<Error>")) {
                    // Set the error code to 4XX so that error deserializer can parse them
                    response.statusCode = 400;
                }
                // Body stream is consumed and paused at this point. So replace the response.body to the collected bytes.
                // So that the deserializer can consume the body as normal.
                response.body = bodyBytes;
                return [2 /*return*/, result];
        }
    });
}); }; }; };
// Collect low-level response body stream to Uint8Array.
var collectBody = function (streamBody, context) {
    if (streamBody === void 0) { streamBody = new Uint8Array(); }
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
// Encode Uint8Array data into string with utf-8.
var collectBodyString = function (streamBody, context) {
    return collectBody(streamBody, context).then(function (body) { return context.utf8Encoder(body); });
};
/**
 * @internal
 */
export var throw200ExceptionsMiddlewareOptions = {
    relation: "after",
    toMiddleware: "deserializerMiddleware",
    tags: ["THROW_200_EXCEPTIONS", "S3"],
    name: "throw200ExceptionsMiddleware",
    override: true,
};
/**
 *
 * @internal
 */
export var getThrow200ExceptionsPlugin = function (config) { return ({
    applyToStack: function (clientStack) {
        clientStack.addRelativeTo(throw200ExceptionsMiddleware(config), throw200ExceptionsMiddlewareOptions);
    },
}); };
//# sourceMappingURL=data:application/json;base64,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