import { __assign, __awaiter, __generator } from "tslib";
import { HttpRequest } from "@aws-sdk/protocol-http";
/**
 * @internal
 */
export var useRegionalEndpointMiddleware = function (config) { return function (next) { return function (args) { return __awaiter(void 0, void 0, void 0, function () {
    var request, _a;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                request = args.request;
                if (!HttpRequest.isInstance(request) || config.isCustomEndpoint)
                    return [2 /*return*/, next(__assign({}, args))];
                if (!(request.hostname === "s3.amazonaws.com")) return [3 /*break*/, 1];
                request.hostname = "s3.us-east-1.amazonaws.com";
                return [3 /*break*/, 3];
            case 1:
                _a = "aws-global";
                return [4 /*yield*/, config.region()];
            case 2:
                if (_a === (_b.sent())) {
                    request.hostname = "s3.amazonaws.com";
                }
                _b.label = 3;
            case 3: return [2 /*return*/, next(__assign({}, args))];
        }
    });
}); }; }; };
/**
 * @internal
 */
export var useRegionalEndpointMiddlewareOptions = {
    step: "build",
    tags: ["USE_REGIONAL_ENDPOINT", "S3"],
    name: "useRegionalEndpointMiddleware",
    override: true,
};
/**
 * @internal
 */
export var getUseRegionalEndpointPlugin = function (config) { return ({
    applyToStack: function (clientStack) {
        clientStack.add(useRegionalEndpointMiddleware(config), useRegionalEndpointMiddlewareOptions);
    },
}); };
//# sourceMappingURL=data:application/json;base64,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