import { __assign, __awaiter, __generator } from "tslib";
import { validate as validateArn } from "@aws-sdk/util-arn-parser";
/**
 * @internal
 */
export function validateBucketNameMiddleware() {
    var _this = this;
    return function (next) { return function (args) { return __awaiter(_this, void 0, void 0, function () {
        var Bucket, err;
        return __generator(this, function (_a) {
            Bucket = args.input.Bucket;
            if (typeof Bucket === "string" && !validateArn(Bucket) && Bucket.indexOf("/") >= 0) {
                err = new Error("Bucket name shouldn't contain '/', received '" + Bucket + "'");
                err.name = "InvalidBucketName";
                throw err;
            }
            return [2 /*return*/, next(__assign({}, args))];
        });
    }); }; };
}
/**
 * @internal
 */
export var validateBucketNameMiddlewareOptions = {
    step: "initialize",
    tags: ["VALIDATE_BUCKET_NAME"],
    name: "validateBucketNameMiddleware",
    override: true,
};
/**
 * @internal
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export var getValidateBucketNamePlugin = function (unused) { return ({
    applyToStack: function (clientStack) {
        clientStack.add(validateBucketNameMiddleware(), validateBucketNameMiddlewareOptions);
    },
}); };
//# sourceMappingURL=data:application/json;base64,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