"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializerMiddleware = void 0;
const deserializerMiddleware = (options, deserializer) => (next, context) => async (args) => {
    const { response } = await next(args);
    const parsed = await deserializer(response, options);
    return {
        response,
        output: parsed,
    };
};
exports.deserializerMiddleware = deserializerMiddleware;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzZXJpYWxpemVyTWlkZGxld2FyZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9kZXNlcmlhbGl6ZXJNaWRkbGV3YXJlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQVNPLE1BQU0sc0JBQXNCLEdBQUcsQ0FDcEMsT0FBcUIsRUFDckIsWUFBMEQsRUFDcEIsRUFBRSxDQUFDLENBQ3pDLElBQXVDLEVBQ3ZDLE9BQWdDLEVBQ0csRUFBRSxDQUFDLEtBQUssRUFDM0MsSUFBd0MsRUFDRyxFQUFFO0lBQzdDLE1BQU0sRUFBRSxRQUFRLEVBQUUsR0FBRyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN0QyxNQUFNLE1BQU0sR0FBRyxNQUFNLFlBQVksQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDckQsT0FBTztRQUNMLFFBQVE7UUFDUixNQUFNLEVBQUUsTUFBZ0I7S0FDekIsQ0FBQztBQUNKLENBQUMsQ0FBQztBQWZXLFFBQUEsc0JBQXNCLDBCQWVqQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIERlc2VyaWFsaXplSGFuZGxlcixcbiAgRGVzZXJpYWxpemVIYW5kbGVyQXJndW1lbnRzLFxuICBEZXNlcmlhbGl6ZUhhbmRsZXJPdXRwdXQsXG4gIERlc2VyaWFsaXplTWlkZGxld2FyZSxcbiAgSGFuZGxlckV4ZWN1dGlvbkNvbnRleHQsXG4gIFJlc3BvbnNlRGVzZXJpYWxpemVyLFxufSBmcm9tIFwiQGF3cy1zZGsvdHlwZXNcIjtcblxuZXhwb3J0IGNvbnN0IGRlc2VyaWFsaXplck1pZGRsZXdhcmUgPSA8SW5wdXQgZXh0ZW5kcyBvYmplY3QsIE91dHB1dCBleHRlbmRzIG9iamVjdCwgUnVudGltZVV0aWxzID0gYW55PihcbiAgb3B0aW9uczogUnVudGltZVV0aWxzLFxuICBkZXNlcmlhbGl6ZXI6IFJlc3BvbnNlRGVzZXJpYWxpemVyPGFueSwgYW55LCBSdW50aW1lVXRpbHM+XG4pOiBEZXNlcmlhbGl6ZU1pZGRsZXdhcmU8SW5wdXQsIE91dHB1dD4gPT4gKFxuICBuZXh0OiBEZXNlcmlhbGl6ZUhhbmRsZXI8SW5wdXQsIE91dHB1dD4sXG4gIGNvbnRleHQ6IEhhbmRsZXJFeGVjdXRpb25Db250ZXh0XG4pOiBEZXNlcmlhbGl6ZUhhbmRsZXI8SW5wdXQsIE91dHB1dD4gPT4gYXN5bmMgKFxuICBhcmdzOiBEZXNlcmlhbGl6ZUhhbmRsZXJBcmd1bWVudHM8SW5wdXQ+XG4pOiBQcm9taXNlPERlc2VyaWFsaXplSGFuZGxlck91dHB1dDxPdXRwdXQ+PiA9PiB7XG4gIGNvbnN0IHsgcmVzcG9uc2UgfSA9IGF3YWl0IG5leHQoYXJncyk7XG4gIGNvbnN0IHBhcnNlZCA9IGF3YWl0IGRlc2VyaWFsaXplcihyZXNwb25zZSwgb3B0aW9ucyk7XG4gIHJldHVybiB7XG4gICAgcmVzcG9uc2UsXG4gICAgb3V0cHV0OiBwYXJzZWQgYXMgT3V0cHV0LFxuICB9O1xufTtcbiJdfQ==