"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSerdePlugin = exports.serializerMiddlewareOption = exports.deserializerMiddlewareOption = void 0;
const deserializerMiddleware_1 = require("./deserializerMiddleware");
const serializerMiddleware_1 = require("./serializerMiddleware");
exports.deserializerMiddlewareOption = {
    name: "deserializerMiddleware",
    step: "deserialize",
    tags: ["DESERIALIZER"],
    override: true,
};
exports.serializerMiddlewareOption = {
    name: "serializerMiddleware",
    step: "serialize",
    tags: ["SERIALIZER"],
    override: true,
};
function getSerdePlugin(config, serializer, deserializer) {
    return {
        applyToStack: (commandStack) => {
            commandStack.add(deserializerMiddleware_1.deserializerMiddleware(config, deserializer), exports.deserializerMiddlewareOption);
            commandStack.add(serializerMiddleware_1.serializerMiddleware(config, serializer), exports.serializerMiddlewareOption);
        },
    };
}
exports.getSerdePlugin = getSerdePlugin;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VyZGVQbHVnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2VyZGVQbHVnaW4udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBV0EscUVBQWtFO0FBQ2xFLGlFQUE4RDtBQUVqRCxRQUFBLDRCQUE0QixHQUE4QjtJQUNyRSxJQUFJLEVBQUUsd0JBQXdCO0lBQzlCLElBQUksRUFBRSxhQUFhO0lBQ25CLElBQUksRUFBRSxDQUFDLGNBQWMsQ0FBQztJQUN0QixRQUFRLEVBQUUsSUFBSTtDQUNmLENBQUM7QUFFVyxRQUFBLDBCQUEwQixHQUE0QjtJQUNqRSxJQUFJLEVBQUUsc0JBQXNCO0lBQzVCLElBQUksRUFBRSxXQUFXO0lBQ2pCLElBQUksRUFBRSxDQUFDLFlBQVksQ0FBQztJQUNwQixRQUFRLEVBQUUsSUFBSTtDQUNmLENBQUM7QUFFRixTQUFnQixjQUFjLENBSzVCLE1BQW9CLEVBQ3BCLFVBQWdELEVBQ2hELFlBQWlFO0lBRWpFLE9BQU87UUFDTCxZQUFZLEVBQUUsQ0FBQyxZQUFvRCxFQUFFLEVBQUU7WUFDckUsWUFBWSxDQUFDLEdBQUcsQ0FBQywrQ0FBc0IsQ0FBQyxNQUFNLEVBQUUsWUFBWSxDQUFDLEVBQUUsb0NBQTRCLENBQUMsQ0FBQztZQUM3RixZQUFZLENBQUMsR0FBRyxDQUFDLDJDQUFvQixDQUFDLE1BQU0sRUFBRSxVQUFVLENBQUMsRUFBRSxrQ0FBMEIsQ0FBQyxDQUFDO1FBQ3pGLENBQUM7S0FDRixDQUFDO0FBQ0osQ0FBQztBQWZELHdDQWVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgRGVzZXJpYWxpemVIYW5kbGVyT3B0aW9ucyxcbiAgRW5kcG9pbnRCZWFyZXIsXG4gIE1ldGFkYXRhQmVhcmVyLFxuICBNaWRkbGV3YXJlU3RhY2ssXG4gIFBsdWdnYWJsZSxcbiAgUmVxdWVzdFNlcmlhbGl6ZXIsXG4gIFJlc3BvbnNlRGVzZXJpYWxpemVyLFxuICBTZXJpYWxpemVIYW5kbGVyT3B0aW9ucyxcbn0gZnJvbSBcIkBhd3Mtc2RrL3R5cGVzXCI7XG5cbmltcG9ydCB7IGRlc2VyaWFsaXplck1pZGRsZXdhcmUgfSBmcm9tIFwiLi9kZXNlcmlhbGl6ZXJNaWRkbGV3YXJlXCI7XG5pbXBvcnQgeyBzZXJpYWxpemVyTWlkZGxld2FyZSB9IGZyb20gXCIuL3NlcmlhbGl6ZXJNaWRkbGV3YXJlXCI7XG5cbmV4cG9ydCBjb25zdCBkZXNlcmlhbGl6ZXJNaWRkbGV3YXJlT3B0aW9uOiBEZXNlcmlhbGl6ZUhhbmRsZXJPcHRpb25zID0ge1xuICBuYW1lOiBcImRlc2VyaWFsaXplck1pZGRsZXdhcmVcIixcbiAgc3RlcDogXCJkZXNlcmlhbGl6ZVwiLFxuICB0YWdzOiBbXCJERVNFUklBTElaRVJcIl0sXG4gIG92ZXJyaWRlOiB0cnVlLFxufTtcblxuZXhwb3J0IGNvbnN0IHNlcmlhbGl6ZXJNaWRkbGV3YXJlT3B0aW9uOiBTZXJpYWxpemVIYW5kbGVyT3B0aW9ucyA9IHtcbiAgbmFtZTogXCJzZXJpYWxpemVyTWlkZGxld2FyZVwiLFxuICBzdGVwOiBcInNlcmlhbGl6ZVwiLFxuICB0YWdzOiBbXCJTRVJJQUxJWkVSXCJdLFxuICBvdmVycmlkZTogdHJ1ZSxcbn07XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRTZXJkZVBsdWdpbjxcbiAgSW5wdXRUeXBlIGV4dGVuZHMgb2JqZWN0LFxuICBTZXJEZUNvbnRleHQgZXh0ZW5kcyBFbmRwb2ludEJlYXJlcixcbiAgT3V0cHV0VHlwZSBleHRlbmRzIE1ldGFkYXRhQmVhcmVyXG4+KFxuICBjb25maWc6IFNlckRlQ29udGV4dCxcbiAgc2VyaWFsaXplcjogUmVxdWVzdFNlcmlhbGl6ZXI8YW55LCBTZXJEZUNvbnRleHQ+LFxuICBkZXNlcmlhbGl6ZXI6IFJlc3BvbnNlRGVzZXJpYWxpemVyPE91dHB1dFR5cGUsIGFueSwgU2VyRGVDb250ZXh0PlxuKTogUGx1Z2dhYmxlPElucHV0VHlwZSwgT3V0cHV0VHlwZT4ge1xuICByZXR1cm4ge1xuICAgIGFwcGx5VG9TdGFjazogKGNvbW1hbmRTdGFjazogTWlkZGxld2FyZVN0YWNrPElucHV0VHlwZSwgT3V0cHV0VHlwZT4pID0+IHtcbiAgICAgIGNvbW1hbmRTdGFjay5hZGQoZGVzZXJpYWxpemVyTWlkZGxld2FyZShjb25maWcsIGRlc2VyaWFsaXplciksIGRlc2VyaWFsaXplck1pZGRsZXdhcmVPcHRpb24pO1xuICAgICAgY29tbWFuZFN0YWNrLmFkZChzZXJpYWxpemVyTWlkZGxld2FyZShjb25maWcsIHNlcmlhbGl6ZXIpLCBzZXJpYWxpemVyTWlkZGxld2FyZU9wdGlvbik7XG4gICAgfSxcbiAgfTtcbn1cbiJdfQ==