import { deserializerMiddleware } from "./deserializerMiddleware";
import { serializerMiddleware } from "./serializerMiddleware";
export var deserializerMiddlewareOption = {
    name: "deserializerMiddleware",
    step: "deserialize",
    tags: ["DESERIALIZER"],
    override: true,
};
export var serializerMiddlewareOption = {
    name: "serializerMiddleware",
    step: "serialize",
    tags: ["SERIALIZER"],
    override: true,
};
export function getSerdePlugin(config, serializer, deserializer) {
    return {
        applyToStack: function (commandStack) {
            commandStack.add(deserializerMiddleware(config, deserializer), deserializerMiddlewareOption);
            commandStack.add(serializerMiddleware(config, serializer), serializerMiddlewareOption);
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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