"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeRequestBody = void 0;
const stream_1 = require("stream");
function writeRequestBody(httpRequest, request) {
    const expect = request.headers["Expect"] || request.headers["expect"];
    if (expect === "100-continue") {
        httpRequest.on("continue", () => {
            writeBody(httpRequest, request.body);
        });
    }
    else {
        writeBody(httpRequest, request.body);
    }
}
exports.writeRequestBody = writeRequestBody;
function writeBody(httpRequest, body) {
    if (body instanceof stream_1.Readable) {
        // pipe automatically handles end
        body.pipe(httpRequest);
    }
    else if (body) {
        httpRequest.end(Buffer.from(body));
    }
    else {
        httpRequest.end();
    }
}
//# sourceMappingURL=data:application/json;base64,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