export var setSocketTimeout = function (request, reject, timeoutInMs) {
    if (timeoutInMs === void 0) { timeoutInMs = 0; }
    request.setTimeout(timeoutInMs, function () {
        // destroy the request
        request.destroy();
        reject(Object.assign(new Error("Connection timed out after " + timeoutInMs + " ms"), { name: "TimeoutError" }));
    });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0LXNvY2tldC10aW1lb3V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3NldC1zb2NrZXQtdGltZW91dC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFFQSxNQUFNLENBQUMsSUFBTSxnQkFBZ0IsR0FBRyxVQUFDLE9BQXNCLEVBQUUsTUFBNEIsRUFBRSxXQUFlO0lBQWYsNEJBQUEsRUFBQSxlQUFlO0lBQ3BHLE9BQU8sQ0FBQyxVQUFVLENBQUMsV0FBVyxFQUFFO1FBQzlCLHNCQUFzQjtRQUN0QixPQUFPLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDbEIsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsZ0NBQThCLFdBQVcsUUFBSyxDQUFDLEVBQUUsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQzdHLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2xpZW50UmVxdWVzdCB9IGZyb20gXCJodHRwXCI7XG5cbmV4cG9ydCBjb25zdCBzZXRTb2NrZXRUaW1lb3V0ID0gKHJlcXVlc3Q6IENsaWVudFJlcXVlc3QsIHJlamVjdDogKGVycjogRXJyb3IpID0+IHZvaWQsIHRpbWVvdXRJbk1zID0gMCkgPT4ge1xuICByZXF1ZXN0LnNldFRpbWVvdXQodGltZW91dEluTXMsICgpID0+IHtcbiAgICAvLyBkZXN0cm95IHRoZSByZXF1ZXN0XG4gICAgcmVxdWVzdC5kZXN0cm95KCk7XG4gICAgcmVqZWN0KE9iamVjdC5hc3NpZ24obmV3IEVycm9yKGBDb25uZWN0aW9uIHRpbWVkIG91dCBhZnRlciAke3RpbWVvdXRJbk1zfSBtc2ApLCB7IG5hbWU6IFwiVGltZW91dEVycm9yXCIgfSkpO1xuICB9KTtcbn07XG4iXX0=