import { Readable } from "stream";
export function writeRequestBody(httpRequest, request) {
    var expect = request.headers["Expect"] || request.headers["expect"];
    if (expect === "100-continue") {
        httpRequest.on("continue", function () {
            writeBody(httpRequest, request.body);
        });
    }
    else {
        writeBody(httpRequest, request.body);
    }
}
function writeBody(httpRequest, body) {
    if (body instanceof Readable) {
        // pipe automatically handles end
        body.pipe(httpRequest);
    }
    else if (body) {
        httpRequest.end(Buffer.from(body));
    }
    else {
        httpRequest.end();
    }
}
//# sourceMappingURL=data:application/json;base64,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