"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRequest = void 0;
class HttpRequest {
    constructor(options) {
        this.method = options.method || "GET";
        this.hostname = options.hostname || "localhost";
        this.port = options.port;
        this.query = options.query || {};
        this.headers = options.headers || {};
        this.body = options.body;
        this.protocol = options.protocol
            ? options.protocol.substr(-1) !== ":"
                ? `${options.protocol}:`
                : options.protocol
            : "https:";
        this.path = options.path ? (options.path.charAt(0) !== "/" ? `/${options.path}` : options.path) : "/";
    }
    static isInstance(request) {
        //determine if request is a valid httpRequest
        if (!request)
            return false;
        const req = request;
        return ("method" in req &&
            "protocol" in req &&
            "hostname" in req &&
            "path" in req &&
            typeof req["query"] === "object" &&
            typeof req["headers"] === "object");
    }
    clone() {
        const cloned = new HttpRequest({
            ...this,
            headers: { ...this.headers },
        });
        if (cloned.query)
            cloned.query = cloneQuery(cloned.query);
        return cloned;
    }
}
exports.HttpRequest = HttpRequest;
function cloneQuery(query) {
    return Object.keys(query).reduce((carry, paramName) => {
        const param = query[paramName];
        return {
            ...carry,
            [paramName]: Array.isArray(param) ? [...param] : param,
        };
    }, {});
}
//# sourceMappingURL=data:application/json;base64,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