"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSignedUrl = void 0;
const protocol_http_1 = require("@aws-sdk/protocol-http");
const util_format_url_1 = require("@aws-sdk/util-format-url");
const presigner_1 = require("./presigner");
const getSignedUrl = async (client, command, options = {}) => {
    const s3Presigner = new presigner_1.S3RequestPresigner({ ...client.config });
    const presignInterceptMiddleware = (next, context) => async (args) => {
        var _a, _b;
        const { request } = args;
        if (!protocol_http_1.HttpRequest.isInstance(request)) {
            throw new Error("Request to be presigned is not an valid HTTP request.");
        }
        // Retry information headers are not meaningful in presigned URLs
        delete request.headers["amz-sdk-invocation-id"];
        delete request.headers["amz-sdk-request"];
        const presigned = await s3Presigner.presign(request, {
            ...options,
            signingRegion: (_a = options.signingRegion) !== null && _a !== void 0 ? _a : context["signing_region"],
            signingService: (_b = options.signingService) !== null && _b !== void 0 ? _b : context["signing_service"],
        });
        return {
            // Intercept the middleware stack by returning fake response
            response: {},
            output: {
                $metadata: { httpStatusCode: 200 },
                presigned,
            },
        };
    };
    const middlewareName = "presignInterceptMiddleware";
    client.middlewareStack.addRelativeTo(presignInterceptMiddleware, {
        name: middlewareName,
        relation: "before",
        toMiddleware: "awsAuthMiddleware",
        override: true,
    });
    let presigned;
    try {
        const output = await client.send(command);
        //@ts-ignore the output is faked, so it's not actually OutputType
        presigned = output.presigned;
    }
    finally {
        client.middlewareStack.remove(middlewareName);
    }
    return util_format_url_1.formatUrl(presigned);
};
exports.getSignedUrl = getSignedUrl;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0U2lnbmVkVXJsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dldFNpZ25lZFVybC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwwREFBcUQ7QUFHckQsOERBQXFEO0FBRXJELDJDQUFpRDtBQUUxQyxNQUFNLFlBQVksR0FBRyxLQUFLLEVBSy9CLE1BQXlELEVBQ3pELE9BQTZFLEVBQzdFLFVBQXNDLEVBQUUsRUFDdkIsRUFBRTtJQUNuQixNQUFNLFdBQVcsR0FBRyxJQUFJLDhCQUFrQixDQUFDLEVBQUUsR0FBRyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUNqRSxNQUFNLDBCQUEwQixHQUFxRCxDQUFDLElBQUksRUFBRSxPQUFPLEVBQUUsRUFBRSxDQUFDLEtBQUssRUFDM0csSUFBSSxFQUNKLEVBQUU7O1FBQ0YsTUFBTSxFQUFFLE9BQU8sRUFBRSxHQUFHLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsMkJBQVcsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDcEMsTUFBTSxJQUFJLEtBQUssQ0FBQyx1REFBdUQsQ0FBQyxDQUFDO1NBQzFFO1FBQ0QsaUVBQWlFO1FBQ2pFLE9BQU8sT0FBTyxDQUFDLE9BQU8sQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2hELE9BQU8sT0FBTyxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBRTFDLE1BQU0sU0FBUyxHQUFHLE1BQU0sV0FBVyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDbkQsR0FBRyxPQUFPO1lBQ1YsYUFBYSxRQUFFLE9BQU8sQ0FBQyxhQUFhLG1DQUFJLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztZQUNqRSxjQUFjLFFBQUUsT0FBTyxDQUFDLGNBQWMsbUNBQUksT0FBTyxDQUFDLGlCQUFpQixDQUFDO1NBQ3JFLENBQUMsQ0FBQztRQUNILE9BQU87WUFDTCw0REFBNEQ7WUFDNUQsUUFBUSxFQUFFLEVBQUU7WUFDWixNQUFNLEVBQUU7Z0JBQ04sU0FBUyxFQUFFLEVBQUUsY0FBYyxFQUFFLEdBQUcsRUFBRTtnQkFDbEMsU0FBUzthQUNWO1NBQ0ssQ0FBQztJQUNYLENBQUMsQ0FBQztJQUNGLE1BQU0sY0FBYyxHQUFHLDRCQUE0QixDQUFDO0lBQ3BELE1BQU0sQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDLDBCQUEwQixFQUFFO1FBQy9ELElBQUksRUFBRSxjQUFjO1FBQ3BCLFFBQVEsRUFBRSxRQUFRO1FBQ2xCLFlBQVksRUFBRSxtQkFBbUI7UUFDakMsUUFBUSxFQUFFLElBQUk7S0FDZixDQUFDLENBQUM7SUFFSCxJQUFJLFNBQXNCLENBQUM7SUFDM0IsSUFBSTtRQUNGLE1BQU0sTUFBTSxHQUFHLE1BQU0sTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMxQyxpRUFBaUU7UUFDakUsU0FBUyxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7S0FDOUI7WUFBUztRQUNSLE1BQU0sQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0tBQy9DO0lBRUQsT0FBTywyQkFBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQzlCLENBQUMsQ0FBQztBQXJEVyxRQUFBLFlBQVksZ0JBcUR2QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEh0dHBSZXF1ZXN0IH0gZnJvbSBcIkBhd3Mtc2RrL3Byb3RvY29sLWh0dHBcIjtcbmltcG9ydCB7IENsaWVudCwgQ29tbWFuZCB9IGZyb20gXCJAYXdzLXNkay9zbWl0aHktY2xpZW50XCI7XG5pbXBvcnQgeyBCdWlsZE1pZGRsZXdhcmUsIE1ldGFkYXRhQmVhcmVyLCBSZXF1ZXN0UHJlc2lnbmluZ0FyZ3VtZW50cyB9IGZyb20gXCJAYXdzLXNkay90eXBlc1wiO1xuaW1wb3J0IHsgZm9ybWF0VXJsIH0gZnJvbSBcIkBhd3Mtc2RrL3V0aWwtZm9ybWF0LXVybFwiO1xuXG5pbXBvcnQgeyBTM1JlcXVlc3RQcmVzaWduZXIgfSBmcm9tIFwiLi9wcmVzaWduZXJcIjtcblxuZXhwb3J0IGNvbnN0IGdldFNpZ25lZFVybCA9IGFzeW5jIDxcbiAgSW5wdXRUeXBlc1VuaW9uIGV4dGVuZHMgb2JqZWN0LFxuICBJbnB1dFR5cGUgZXh0ZW5kcyBJbnB1dFR5cGVzVW5pb24sXG4gIE91dHB1dFR5cGUgZXh0ZW5kcyBNZXRhZGF0YUJlYXJlciA9IE1ldGFkYXRhQmVhcmVyXG4+KFxuICBjbGllbnQ6IENsaWVudDxhbnksIElucHV0VHlwZXNVbmlvbiwgTWV0YWRhdGFCZWFyZXIsIGFueT4sXG4gIGNvbW1hbmQ6IENvbW1hbmQ8SW5wdXRUeXBlLCBPdXRwdXRUeXBlLCBhbnksIElucHV0VHlwZXNVbmlvbiwgTWV0YWRhdGFCZWFyZXI+LFxuICBvcHRpb25zOiBSZXF1ZXN0UHJlc2lnbmluZ0FyZ3VtZW50cyA9IHt9XG4pOiBQcm9taXNlPHN0cmluZz4gPT4ge1xuICBjb25zdCBzM1ByZXNpZ25lciA9IG5ldyBTM1JlcXVlc3RQcmVzaWduZXIoeyAuLi5jbGllbnQuY29uZmlnIH0pO1xuICBjb25zdCBwcmVzaWduSW50ZXJjZXB0TWlkZGxld2FyZTogQnVpbGRNaWRkbGV3YXJlPElucHV0VHlwZXNVbmlvbiwgTWV0YWRhdGFCZWFyZXI+ID0gKG5leHQsIGNvbnRleHQpID0+IGFzeW5jIChcbiAgICBhcmdzXG4gICkgPT4ge1xuICAgIGNvbnN0IHsgcmVxdWVzdCB9ID0gYXJncztcbiAgICBpZiAoIUh0dHBSZXF1ZXN0LmlzSW5zdGFuY2UocmVxdWVzdCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcIlJlcXVlc3QgdG8gYmUgcHJlc2lnbmVkIGlzIG5vdCBhbiB2YWxpZCBIVFRQIHJlcXVlc3QuXCIpO1xuICAgIH1cbiAgICAvLyBSZXRyeSBpbmZvcm1hdGlvbiBoZWFkZXJzIGFyZSBub3QgbWVhbmluZ2Z1bCBpbiBwcmVzaWduZWQgVVJMc1xuICAgIGRlbGV0ZSByZXF1ZXN0LmhlYWRlcnNbXCJhbXotc2RrLWludm9jYXRpb24taWRcIl07XG4gICAgZGVsZXRlIHJlcXVlc3QuaGVhZGVyc1tcImFtei1zZGstcmVxdWVzdFwiXTtcblxuICAgIGNvbnN0IHByZXNpZ25lZCA9IGF3YWl0IHMzUHJlc2lnbmVyLnByZXNpZ24ocmVxdWVzdCwge1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIHNpZ25pbmdSZWdpb246IG9wdGlvbnMuc2lnbmluZ1JlZ2lvbiA/PyBjb250ZXh0W1wic2lnbmluZ19yZWdpb25cIl0sXG4gICAgICBzaWduaW5nU2VydmljZTogb3B0aW9ucy5zaWduaW5nU2VydmljZSA/PyBjb250ZXh0W1wic2lnbmluZ19zZXJ2aWNlXCJdLFxuICAgIH0pO1xuICAgIHJldHVybiB7XG4gICAgICAvLyBJbnRlcmNlcHQgdGhlIG1pZGRsZXdhcmUgc3RhY2sgYnkgcmV0dXJuaW5nIGZha2UgcmVzcG9uc2VcbiAgICAgIHJlc3BvbnNlOiB7fSxcbiAgICAgIG91dHB1dDoge1xuICAgICAgICAkbWV0YWRhdGE6IHsgaHR0cFN0YXR1c0NvZGU6IDIwMCB9LFxuICAgICAgICBwcmVzaWduZWQsXG4gICAgICB9LFxuICAgIH0gYXMgYW55O1xuICB9O1xuICBjb25zdCBtaWRkbGV3YXJlTmFtZSA9IFwicHJlc2lnbkludGVyY2VwdE1pZGRsZXdhcmVcIjtcbiAgY2xpZW50Lm1pZGRsZXdhcmVTdGFjay5hZGRSZWxhdGl2ZVRvKHByZXNpZ25JbnRlcmNlcHRNaWRkbGV3YXJlLCB7XG4gICAgbmFtZTogbWlkZGxld2FyZU5hbWUsXG4gICAgcmVsYXRpb246IFwiYmVmb3JlXCIsXG4gICAgdG9NaWRkbGV3YXJlOiBcImF3c0F1dGhNaWRkbGV3YXJlXCIsXG4gICAgb3ZlcnJpZGU6IHRydWUsXG4gIH0pO1xuXG4gIGxldCBwcmVzaWduZWQ6IEh0dHBSZXF1ZXN0O1xuICB0cnkge1xuICAgIGNvbnN0IG91dHB1dCA9IGF3YWl0IGNsaWVudC5zZW5kKGNvbW1hbmQpO1xuICAgIC8vQHRzLWlnbm9yZSB0aGUgb3V0cHV0IGlzIGZha2VkLCBzbyBpdCdzIG5vdCBhY3R1YWxseSBPdXRwdXRUeXBlXG4gICAgcHJlc2lnbmVkID0gb3V0cHV0LnByZXNpZ25lZDtcbiAgfSBmaW5hbGx5IHtcbiAgICBjbGllbnQubWlkZGxld2FyZVN0YWNrLnJlbW92ZShtaWRkbGV3YXJlTmFtZSk7XG4gIH1cblxuICByZXR1cm4gZm9ybWF0VXJsKHByZXNpZ25lZCk7XG59O1xuIl19