import { __assign, __awaiter, __generator } from "tslib";
import { HttpRequest } from "@aws-sdk/protocol-http";
import { formatUrl } from "@aws-sdk/util-format-url";
import { S3RequestPresigner } from "./presigner";
export var getSignedUrl = function (client, command, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var s3Presigner, presignInterceptMiddleware, middlewareName, presigned, output;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    s3Presigner = new S3RequestPresigner(__assign({}, client.config));
                    presignInterceptMiddleware = function (next, context) { return function (args) { return __awaiter(void 0, void 0, void 0, function () {
                        var request, presigned;
                        var _a, _b;
                        return __generator(this, function (_c) {
                            switch (_c.label) {
                                case 0:
                                    request = args.request;
                                    if (!HttpRequest.isInstance(request)) {
                                        throw new Error("Request to be presigned is not an valid HTTP request.");
                                    }
                                    // Retry information headers are not meaningful in presigned URLs
                                    delete request.headers["amz-sdk-invocation-id"];
                                    delete request.headers["amz-sdk-request"];
                                    return [4 /*yield*/, s3Presigner.presign(request, __assign(__assign({}, options), { signingRegion: (_a = options.signingRegion) !== null && _a !== void 0 ? _a : context["signing_region"], signingService: (_b = options.signingService) !== null && _b !== void 0 ? _b : context["signing_service"] }))];
                                case 1:
                                    presigned = _c.sent();
                                    return [2 /*return*/, {
                                            // Intercept the middleware stack by returning fake response
                                            response: {},
                                            output: {
                                                $metadata: { httpStatusCode: 200 },
                                                presigned: presigned,
                                            },
                                        }];
                            }
                        });
                    }); }; };
                    middlewareName = "presignInterceptMiddleware";
                    client.middlewareStack.addRelativeTo(presignInterceptMiddleware, {
                        name: middlewareName,
                        relation: "before",
                        toMiddleware: "awsAuthMiddleware",
                        override: true,
                    });
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, , 3, 4]);
                    return [4 /*yield*/, client.send(command)];
                case 2:
                    output = _a.sent();
                    //@ts-ignore the output is faked, so it's not actually OutputType
                    presigned = output.presigned;
                    return [3 /*break*/, 4];
                case 3:
                    client.middlewareStack.remove(middlewareName);
                    return [7 /*endfinally*/];
                case 4: return [2 /*return*/, formatUrl(presigned)];
            }
        });
    });
};
//# sourceMappingURL=data:application/json;base64,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