"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBase64 = exports.fromBase64 = void 0;
const alphabetByEncoding = {};
const alphabetByValue = new Array(64);
for (let i = 0, start = "A".charCodeAt(0), limit = "Z".charCodeAt(0); i + start <= limit; i++) {
    const char = String.fromCharCode(i + start);
    alphabetByEncoding[char] = i;
    alphabetByValue[i] = char;
}
for (let i = 0, start = "a".charCodeAt(0), limit = "z".charCodeAt(0); i + start <= limit; i++) {
    const char = String.fromCharCode(i + start);
    const index = i + 26;
    alphabetByEncoding[char] = index;
    alphabetByValue[index] = char;
}
for (let i = 0; i < 10; i++) {
    alphabetByEncoding[i.toString(10)] = i + 52;
    const char = i.toString(10);
    const index = i + 52;
    alphabetByEncoding[char] = index;
    alphabetByValue[index] = char;
}
alphabetByEncoding["+"] = 62;
alphabetByValue[62] = "+";
alphabetByEncoding["/"] = 63;
alphabetByValue[63] = "/";
const bitsPerLetter = 6;
const bitsPerByte = 8;
const maxLetterValue = 0b111111;
/**
 * Converts a base-64 encoded string to a Uint8Array of bytes.
 *
 * @param input The base-64 encoded string
 *
 * @see https://tools.ietf.org/html/rfc4648#section-4
 */
function fromBase64(input) {
    let totalByteLength = (input.length / 4) * 3;
    if (input.substr(-2) === "==") {
        totalByteLength -= 2;
    }
    else if (input.substr(-1) === "=") {
        totalByteLength--;
    }
    const out = new ArrayBuffer(totalByteLength);
    const dataView = new DataView(out);
    for (let i = 0; i < input.length; i += 4) {
        let bits = 0;
        let bitLength = 0;
        for (let j = i, limit = i + 3; j <= limit; j++) {
            if (input[j] !== "=") {
                bits |= alphabetByEncoding[input[j]] << ((limit - j) * bitsPerLetter);
                bitLength += bitsPerLetter;
            }
            else {
                bits >>= bitsPerLetter;
            }
        }
        const chunkOffset = (i / 4) * 3;
        bits >>= bitLength % bitsPerByte;
        const byteLength = Math.floor(bitLength / bitsPerByte);
        for (let k = 0; k < byteLength; k++) {
            const offset = (byteLength - k - 1) * bitsPerByte;
            dataView.setUint8(chunkOffset + k, (bits & (255 << offset)) >> offset);
        }
    }
    return new Uint8Array(out);
}
exports.fromBase64 = fromBase64;
/**
 * Converts a Uint8Array of binary data to a base-64 encoded string.
 *
 * @param input The binary data to encode
 *
 * @see https://tools.ietf.org/html/rfc4648#section-4
 */
function toBase64(input) {
    let str = "";
    for (let i = 0; i < input.length; i += 3) {
        let bits = 0;
        let bitLength = 0;
        for (let j = i, limit = Math.min(i + 3, input.length); j < limit; j++) {
            bits |= input[j] << ((limit - j - 1) * bitsPerByte);
            bitLength += bitsPerByte;
        }
        const bitClusterCount = Math.ceil(bitLength / bitsPerLetter);
        bits <<= bitClusterCount * bitsPerLetter - bitLength;
        for (let k = 1; k <= bitClusterCount; k++) {
            const offset = (bitClusterCount - k) * bitsPerLetter;
            str += alphabetByValue[(bits & (maxLetterValue << offset)) >> offset];
        }
        str += "==".slice(0, 4 - bitClusterCount);
    }
    return str;
}
exports.toBase64 = toBase64;
//# sourceMappingURL=data:application/json;base64,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