"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBase64 = exports.fromBase64 = void 0;
const util_buffer_from_1 = require("@aws-sdk/util-buffer-from");
/**
 * Converts a base-64 encoded string to a Uint8Array of bytes using Node.JS's
 * `buffer` module.
 *
 * @param input The base-64 encoded string
 */
function fromBase64(input) {
    const buffer = util_buffer_from_1.fromString(input, "base64");
    return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);
}
exports.fromBase64 = fromBase64;
/**
 * Converts a Uint8Array of binary data to a base-64 encoded string using
 * Node.JS's `buffer` module.
 *
 * @param input The binary data to encode
 */
function toBase64(input) {
    return util_buffer_from_1.fromArrayBuffer(input.buffer, input.byteOffset, input.byteLength).toString("base64");
}
exports.toBase64 = toBase64;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsZ0VBQXdFO0FBRXhFOzs7OztHQUtHO0FBQ0gsU0FBZ0IsVUFBVSxDQUFDLEtBQWE7SUFDdEMsTUFBTSxNQUFNLEdBQUcsNkJBQVUsQ0FBQyxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFFM0MsT0FBTyxJQUFJLFVBQVUsQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxVQUFVLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0FBQzdFLENBQUM7QUFKRCxnQ0FJQztBQUVEOzs7OztHQUtHO0FBQ0gsU0FBZ0IsUUFBUSxDQUFDLEtBQWlCO0lBQ3hDLE9BQU8sa0NBQWUsQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUM5RixDQUFDO0FBRkQsNEJBRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBmcm9tQXJyYXlCdWZmZXIsIGZyb21TdHJpbmcgfSBmcm9tIFwiQGF3cy1zZGsvdXRpbC1idWZmZXItZnJvbVwiO1xuXG4vKipcbiAqIENvbnZlcnRzIGEgYmFzZS02NCBlbmNvZGVkIHN0cmluZyB0byBhIFVpbnQ4QXJyYXkgb2YgYnl0ZXMgdXNpbmcgTm9kZS5KUydzXG4gKiBgYnVmZmVyYCBtb2R1bGUuXG4gKlxuICogQHBhcmFtIGlucHV0IFRoZSBiYXNlLTY0IGVuY29kZWQgc3RyaW5nXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmcm9tQmFzZTY0KGlucHV0OiBzdHJpbmcpOiBVaW50OEFycmF5IHtcbiAgY29uc3QgYnVmZmVyID0gZnJvbVN0cmluZyhpbnB1dCwgXCJiYXNlNjRcIik7XG5cbiAgcmV0dXJuIG5ldyBVaW50OEFycmF5KGJ1ZmZlci5idWZmZXIsIGJ1ZmZlci5ieXRlT2Zmc2V0LCBidWZmZXIuYnl0ZUxlbmd0aCk7XG59XG5cbi8qKlxuICogQ29udmVydHMgYSBVaW50OEFycmF5IG9mIGJpbmFyeSBkYXRhIHRvIGEgYmFzZS02NCBlbmNvZGVkIHN0cmluZyB1c2luZ1xuICogTm9kZS5KUydzIGBidWZmZXJgIG1vZHVsZS5cbiAqXG4gKiBAcGFyYW0gaW5wdXQgVGhlIGJpbmFyeSBkYXRhIHRvIGVuY29kZVxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9CYXNlNjQoaW5wdXQ6IFVpbnQ4QXJyYXkpOiBzdHJpbmcge1xuICByZXR1cm4gZnJvbUFycmF5QnVmZmVyKGlucHV0LmJ1ZmZlciwgaW5wdXQuYnl0ZU9mZnNldCwgaW5wdXQuYnl0ZUxlbmd0aCkudG9TdHJpbmcoXCJiYXNlNjRcIik7XG59XG4iXX0=