import { fromArrayBuffer, fromString } from "@aws-sdk/util-buffer-from";
/**
 * Converts a base-64 encoded string to a Uint8Array of bytes using Node.JS's
 * `buffer` module.
 *
 * @param input The base-64 encoded string
 */
export function fromBase64(input) {
    var buffer = fromString(input, "base64");
    return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);
}
/**
 * Converts a Uint8Array of binary data to a base-64 encoded string using
 * Node.JS's `buffer` module.
 *
 * @param input The binary data to encode
 */
export function toBase64(input) {
    return fromArrayBuffer(input.buffer, input.byteOffset, input.byteLength).toString("base64");
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLGVBQWUsRUFBRSxVQUFVLEVBQUUsTUFBTSwyQkFBMkIsQ0FBQztBQUV4RTs7Ozs7R0FLRztBQUNILE1BQU0sVUFBVSxVQUFVLENBQUMsS0FBYTtJQUN0QyxJQUFNLE1BQU0sR0FBRyxVQUFVLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBRTNDLE9BQU8sSUFBSSxVQUFVLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUM3RSxDQUFDO0FBRUQ7Ozs7O0dBS0c7QUFDSCxNQUFNLFVBQVUsUUFBUSxDQUFDLEtBQWlCO0lBQ3hDLE9BQU8sZUFBZSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBQzlGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBmcm9tQXJyYXlCdWZmZXIsIGZyb21TdHJpbmcgfSBmcm9tIFwiQGF3cy1zZGsvdXRpbC1idWZmZXItZnJvbVwiO1xuXG4vKipcbiAqIENvbnZlcnRzIGEgYmFzZS02NCBlbmNvZGVkIHN0cmluZyB0byBhIFVpbnQ4QXJyYXkgb2YgYnl0ZXMgdXNpbmcgTm9kZS5KUydzXG4gKiBgYnVmZmVyYCBtb2R1bGUuXG4gKlxuICogQHBhcmFtIGlucHV0IFRoZSBiYXNlLTY0IGVuY29kZWQgc3RyaW5nXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmcm9tQmFzZTY0KGlucHV0OiBzdHJpbmcpOiBVaW50OEFycmF5IHtcbiAgY29uc3QgYnVmZmVyID0gZnJvbVN0cmluZyhpbnB1dCwgXCJiYXNlNjRcIik7XG5cbiAgcmV0dXJuIG5ldyBVaW50OEFycmF5KGJ1ZmZlci5idWZmZXIsIGJ1ZmZlci5ieXRlT2Zmc2V0LCBidWZmZXIuYnl0ZUxlbmd0aCk7XG59XG5cbi8qKlxuICogQ29udmVydHMgYSBVaW50OEFycmF5IG9mIGJpbmFyeSBkYXRhIHRvIGEgYmFzZS02NCBlbmNvZGVkIHN0cmluZyB1c2luZ1xuICogTm9kZS5KUydzIGBidWZmZXJgIG1vZHVsZS5cbiAqXG4gKiBAcGFyYW0gaW5wdXQgVGhlIGJpbmFyeSBkYXRhIHRvIGVuY29kZVxuICovXG5leHBvcnQgZnVuY3Rpb24gdG9CYXNlNjQoaW5wdXQ6IFVpbnQ4QXJyYXkpOiBzdHJpbmcge1xuICByZXR1cm4gZnJvbUFycmF5QnVmZmVyKGlucHV0LmJ1ZmZlciwgaW5wdXQuYnl0ZU9mZnNldCwgaW5wdXQuYnl0ZUxlbmd0aCkudG9TdHJpbmcoXCJiYXNlNjRcIik7XG59XG4iXX0=