export function calculateBodyLength(body) {
    if (typeof body === "string") {
        var len = body.length;
        for (var i = len - 1; i >= 0; i--) {
            var code = body.charCodeAt(i);
            if (code > 0x7f && code <= 0x7ff)
                len++;
            else if (code > 0x7ff && code <= 0xffff)
                len += 2;
        }
        return len;
    }
    else if (typeof body.byteLength === "number") {
        // handles Uint8Array, ArrayBuffer, Buffer, and ArrayBufferView
        return body.byteLength;
    }
    else if (typeof body.size === "number") {
        // handles browser File object
        return body.size;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsTUFBTSxVQUFVLG1CQUFtQixDQUFDLElBQVM7SUFDM0MsSUFBSSxPQUFPLElBQUksS0FBSyxRQUFRLEVBQUU7UUFDNUIsSUFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUV0QixLQUFLLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUNqQyxJQUFNLElBQUksR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2hDLElBQUksSUFBSSxHQUFHLElBQUksSUFBSSxJQUFJLElBQUksS0FBSztnQkFBRSxHQUFHLEVBQUUsQ0FBQztpQkFDbkMsSUFBSSxJQUFJLEdBQUcsS0FBSyxJQUFJLElBQUksSUFBSSxNQUFNO2dCQUFFLEdBQUcsSUFBSSxDQUFDLENBQUM7U0FDbkQ7UUFFRCxPQUFPLEdBQUcsQ0FBQztLQUNaO1NBQU0sSUFBSSxPQUFPLElBQUksQ0FBQyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQzlDLCtEQUErRDtRQUMvRCxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7S0FDeEI7U0FBTSxJQUFJLE9BQU8sSUFBSSxDQUFDLElBQUksS0FBSyxRQUFRLEVBQUU7UUFDeEMsOEJBQThCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztLQUNsQjtBQUNILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gY2FsY3VsYXRlQm9keUxlbmd0aChib2R5OiBhbnkpOiBudW1iZXIgfCB1bmRlZmluZWQge1xuICBpZiAodHlwZW9mIGJvZHkgPT09IFwic3RyaW5nXCIpIHtcbiAgICBsZXQgbGVuID0gYm9keS5sZW5ndGg7XG5cbiAgICBmb3IgKGxldCBpID0gbGVuIC0gMTsgaSA+PSAwOyBpLS0pIHtcbiAgICAgIGNvbnN0IGNvZGUgPSBib2R5LmNoYXJDb2RlQXQoaSk7XG4gICAgICBpZiAoY29kZSA+IDB4N2YgJiYgY29kZSA8PSAweDdmZikgbGVuKys7XG4gICAgICBlbHNlIGlmIChjb2RlID4gMHg3ZmYgJiYgY29kZSA8PSAweGZmZmYpIGxlbiArPSAyO1xuICAgIH1cblxuICAgIHJldHVybiBsZW47XG4gIH0gZWxzZSBpZiAodHlwZW9mIGJvZHkuYnl0ZUxlbmd0aCA9PT0gXCJudW1iZXJcIikge1xuICAgIC8vIGhhbmRsZXMgVWludDhBcnJheSwgQXJyYXlCdWZmZXIsIEJ1ZmZlciwgYW5kIEFycmF5QnVmZmVyVmlld1xuICAgIHJldHVybiBib2R5LmJ5dGVMZW5ndGg7XG4gIH0gZWxzZSBpZiAodHlwZW9mIGJvZHkuc2l6ZSA9PT0gXCJudW1iZXJcIikge1xuICAgIC8vIGhhbmRsZXMgYnJvd3NlciBGaWxlIG9iamVjdFxuICAgIHJldHVybiBib2R5LnNpemU7XG4gIH1cbn1cbiJdfQ==