import { lstatSync } from "fs";
export function calculateBodyLength(body) {
    if (!body) {
        return 0;
    }
    if (typeof body === "string") {
        return Buffer.from(body).length;
    }
    else if (typeof body.byteLength === "number") {
        // handles Uint8Array, ArrayBuffer, Buffer, and ArrayBufferView
        return body.byteLength;
    }
    else if (typeof body.size === "number") {
        return body.size;
    }
    else if (typeof body.path === "string") {
        // handles fs readable streams
        return lstatSync(body.path).size;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLElBQUksQ0FBQztBQUUvQixNQUFNLFVBQVUsbUJBQW1CLENBQUMsSUFBUztJQUMzQyxJQUFJLENBQUMsSUFBSSxFQUFFO1FBQ1QsT0FBTyxDQUFDLENBQUM7S0FDVjtJQUNELElBQUksT0FBTyxJQUFJLEtBQUssUUFBUSxFQUFFO1FBQzVCLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLENBQUM7S0FDakM7U0FBTSxJQUFJLE9BQU8sSUFBSSxDQUFDLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDOUMsK0RBQStEO1FBQy9ELE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztLQUN4QjtTQUFNLElBQUksT0FBTyxJQUFJLENBQUMsSUFBSSxLQUFLLFFBQVEsRUFBRTtRQUN4QyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7S0FDbEI7U0FBTSxJQUFJLE9BQU8sSUFBSSxDQUFDLElBQUksS0FBSyxRQUFRLEVBQUU7UUFDeEMsOEJBQThCO1FBQzlCLE9BQU8sU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUM7S0FDbEM7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgbHN0YXRTeW5jIH0gZnJvbSBcImZzXCI7XG5cbmV4cG9ydCBmdW5jdGlvbiBjYWxjdWxhdGVCb2R5TGVuZ3RoKGJvZHk6IGFueSk6IG51bWJlciB8IHVuZGVmaW5lZCB7XG4gIGlmICghYm9keSkge1xuICAgIHJldHVybiAwO1xuICB9XG4gIGlmICh0eXBlb2YgYm9keSA9PT0gXCJzdHJpbmdcIikge1xuICAgIHJldHVybiBCdWZmZXIuZnJvbShib2R5KS5sZW5ndGg7XG4gIH0gZWxzZSBpZiAodHlwZW9mIGJvZHkuYnl0ZUxlbmd0aCA9PT0gXCJudW1iZXJcIikge1xuICAgIC8vIGhhbmRsZXMgVWludDhBcnJheSwgQXJyYXlCdWZmZXIsIEJ1ZmZlciwgYW5kIEFycmF5QnVmZmVyVmlld1xuICAgIHJldHVybiBib2R5LmJ5dGVMZW5ndGg7XG4gIH0gZWxzZSBpZiAodHlwZW9mIGJvZHkuc2l6ZSA9PT0gXCJudW1iZXJcIikge1xuICAgIHJldHVybiBib2R5LnNpemU7XG4gIH0gZWxzZSBpZiAodHlwZW9mIGJvZHkucGF0aCA9PT0gXCJzdHJpbmdcIikge1xuICAgIC8vIGhhbmRsZXMgZnMgcmVhZGFibGUgc3RyZWFtc1xuICAgIHJldHVybiBsc3RhdFN5bmMoYm9keS5wYXRoKS5zaXplO1xuICB9XG59XG4iXX0=