"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromString = exports.fromArrayBuffer = void 0;
const is_array_buffer_1 = require("@aws-sdk/is-array-buffer");
const buffer_1 = require("buffer");
const fromArrayBuffer = (input, offset = 0, length = input.byteLength - offset) => {
    if (!is_array_buffer_1.isArrayBuffer(input)) {
        throw new TypeError(`The "input" argument must be ArrayBuffer. Received type ${typeof input} (${input})`);
    }
    return buffer_1.Buffer.from(input, offset, length);
};
exports.fromArrayBuffer = fromArrayBuffer;
const fromString = (input, encoding) => {
    if (typeof input !== "string") {
        throw new TypeError(`The "input" argument must be of type string. Received type ${typeof input} (${input})`);
    }
    return encoding ? buffer_1.Buffer.from(input, encoding) : buffer_1.Buffer.from(input);
};
exports.fromString = fromString;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOERBQXlEO0FBQ3pELG1DQUFnQztBQUV6QixNQUFNLGVBQWUsR0FBRyxDQUFDLEtBQWtCLEVBQUUsTUFBTSxHQUFHLENBQUMsRUFBRSxTQUFpQixLQUFLLENBQUMsVUFBVSxHQUFHLE1BQU0sRUFBVSxFQUFFO0lBQ3BILElBQUksQ0FBQywrQkFBYSxDQUFDLEtBQUssQ0FBQyxFQUFFO1FBQ3pCLE1BQU0sSUFBSSxTQUFTLENBQUMsMkRBQTJELE9BQU8sS0FBSyxLQUFLLEtBQUssR0FBRyxDQUFDLENBQUM7S0FDM0c7SUFFRCxPQUFPLGVBQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUM1QyxDQUFDLENBQUM7QUFOVyxRQUFBLGVBQWUsbUJBTTFCO0FBSUssTUFBTSxVQUFVLEdBQUcsQ0FBQyxLQUFhLEVBQUUsUUFBeUIsRUFBVSxFQUFFO0lBQzdFLElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxFQUFFO1FBQzdCLE1BQU0sSUFBSSxTQUFTLENBQUMsOERBQThELE9BQU8sS0FBSyxLQUFLLEtBQUssR0FBRyxDQUFDLENBQUM7S0FDOUc7SUFFRCxPQUFPLFFBQVEsQ0FBQyxDQUFDLENBQUMsZUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLGVBQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDdEUsQ0FBQyxDQUFDO0FBTlcsUUFBQSxVQUFVLGNBTXJCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNBcnJheUJ1ZmZlciB9IGZyb20gXCJAYXdzLXNkay9pcy1hcnJheS1idWZmZXJcIjtcbmltcG9ydCB7IEJ1ZmZlciB9IGZyb20gXCJidWZmZXJcIjtcblxuZXhwb3J0IGNvbnN0IGZyb21BcnJheUJ1ZmZlciA9IChpbnB1dDogQXJyYXlCdWZmZXIsIG9mZnNldCA9IDAsIGxlbmd0aDogbnVtYmVyID0gaW5wdXQuYnl0ZUxlbmd0aCAtIG9mZnNldCk6IEJ1ZmZlciA9PiB7XG4gIGlmICghaXNBcnJheUJ1ZmZlcihpbnB1dCkpIHtcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKGBUaGUgXCJpbnB1dFwiIGFyZ3VtZW50IG11c3QgYmUgQXJyYXlCdWZmZXIuIFJlY2VpdmVkIHR5cGUgJHt0eXBlb2YgaW5wdXR9ICgke2lucHV0fSlgKTtcbiAgfVxuXG4gIHJldHVybiBCdWZmZXIuZnJvbShpbnB1dCwgb2Zmc2V0LCBsZW5ndGgpO1xufTtcblxuZXhwb3J0IHR5cGUgU3RyaW5nRW5jb2RpbmcgPSBcImFzY2lpXCIgfCBcInV0ZjhcIiB8IFwidXRmMTZsZVwiIHwgXCJ1Y3MyXCIgfCBcImJhc2U2NFwiIHwgXCJsYXRpbjFcIiB8IFwiYmluYXJ5XCIgfCBcImhleFwiO1xuXG5leHBvcnQgY29uc3QgZnJvbVN0cmluZyA9IChpbnB1dDogc3RyaW5nLCBlbmNvZGluZz86IFN0cmluZ0VuY29kaW5nKTogQnVmZmVyID0+IHtcbiAgaWYgKHR5cGVvZiBpbnB1dCAhPT0gXCJzdHJpbmdcIikge1xuICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYFRoZSBcImlucHV0XCIgYXJndW1lbnQgbXVzdCBiZSBvZiB0eXBlIHN0cmluZy4gUmVjZWl2ZWQgdHlwZSAke3R5cGVvZiBpbnB1dH0gKCR7aW5wdXR9KWApO1xuICB9XG5cbiAgcmV0dXJuIGVuY29kaW5nID8gQnVmZmVyLmZyb20oaW5wdXQsIGVuY29kaW5nKSA6IEJ1ZmZlci5mcm9tKGlucHV0KTtcbn07XG4iXX0=