import { isArrayBuffer } from "@aws-sdk/is-array-buffer";
import { Buffer } from "buffer";
export var fromArrayBuffer = function (input, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (length === void 0) { length = input.byteLength - offset; }
    if (!isArrayBuffer(input)) {
        throw new TypeError("The \"input\" argument must be ArrayBuffer. Received type " + typeof input + " (" + input + ")");
    }
    return Buffer.from(input, offset, length);
};
export var fromString = function (input, encoding) {
    if (typeof input !== "string") {
        throw new TypeError("The \"input\" argument must be of type string. Received type " + typeof input + " (" + input + ")");
    }
    return encoding ? Buffer.from(input, encoding) : Buffer.from(input);
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLDBCQUEwQixDQUFDO0FBQ3pELE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxRQUFRLENBQUM7QUFFaEMsTUFBTSxDQUFDLElBQU0sZUFBZSxHQUFHLFVBQUMsS0FBa0IsRUFBRSxNQUFVLEVBQUUsTUFBMEM7SUFBdEQsdUJBQUEsRUFBQSxVQUFVO0lBQUUsdUJBQUEsRUFBQSxTQUFpQixLQUFLLENBQUMsVUFBVSxHQUFHLE1BQU07SUFDeEcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsRUFBRTtRQUN6QixNQUFNLElBQUksU0FBUyxDQUFDLCtEQUEyRCxPQUFPLEtBQUssVUFBSyxLQUFLLE1BQUcsQ0FBQyxDQUFDO0tBQzNHO0lBRUQsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDNUMsQ0FBQyxDQUFDO0FBSUYsTUFBTSxDQUFDLElBQU0sVUFBVSxHQUFHLFVBQUMsS0FBYSxFQUFFLFFBQXlCO0lBQ2pFLElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxFQUFFO1FBQzdCLE1BQU0sSUFBSSxTQUFTLENBQUMsa0VBQThELE9BQU8sS0FBSyxVQUFLLEtBQUssTUFBRyxDQUFDLENBQUM7S0FDOUc7SUFFRCxPQUFPLFFBQVEsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDdEUsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNBcnJheUJ1ZmZlciB9IGZyb20gXCJAYXdzLXNkay9pcy1hcnJheS1idWZmZXJcIjtcbmltcG9ydCB7IEJ1ZmZlciB9IGZyb20gXCJidWZmZXJcIjtcblxuZXhwb3J0IGNvbnN0IGZyb21BcnJheUJ1ZmZlciA9IChpbnB1dDogQXJyYXlCdWZmZXIsIG9mZnNldCA9IDAsIGxlbmd0aDogbnVtYmVyID0gaW5wdXQuYnl0ZUxlbmd0aCAtIG9mZnNldCk6IEJ1ZmZlciA9PiB7XG4gIGlmICghaXNBcnJheUJ1ZmZlcihpbnB1dCkpIHtcbiAgICB0aHJvdyBuZXcgVHlwZUVycm9yKGBUaGUgXCJpbnB1dFwiIGFyZ3VtZW50IG11c3QgYmUgQXJyYXlCdWZmZXIuIFJlY2VpdmVkIHR5cGUgJHt0eXBlb2YgaW5wdXR9ICgke2lucHV0fSlgKTtcbiAgfVxuXG4gIHJldHVybiBCdWZmZXIuZnJvbShpbnB1dCwgb2Zmc2V0LCBsZW5ndGgpO1xufTtcblxuZXhwb3J0IHR5cGUgU3RyaW5nRW5jb2RpbmcgPSBcImFzY2lpXCIgfCBcInV0ZjhcIiB8IFwidXRmMTZsZVwiIHwgXCJ1Y3MyXCIgfCBcImJhc2U2NFwiIHwgXCJsYXRpbjFcIiB8IFwiYmluYXJ5XCIgfCBcImhleFwiO1xuXG5leHBvcnQgY29uc3QgZnJvbVN0cmluZyA9IChpbnB1dDogc3RyaW5nLCBlbmNvZGluZz86IFN0cmluZ0VuY29kaW5nKTogQnVmZmVyID0+IHtcbiAgaWYgKHR5cGVvZiBpbnB1dCAhPT0gXCJzdHJpbmdcIikge1xuICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYFRoZSBcImlucHV0XCIgYXJndW1lbnQgbXVzdCBiZSBvZiB0eXBlIHN0cmluZy4gUmVjZWl2ZWQgdHlwZSAke3R5cGVvZiBpbnB1dH0gKCR7aW5wdXR9KWApO1xuICB9XG5cbiAgcmV0dXJuIGVuY29kaW5nID8gQnVmZmVyLmZyb20oaW5wdXQsIGVuY29kaW5nKSA6IEJ1ZmZlci5mcm9tKGlucHV0KTtcbn07XG4iXX0=