import { buildQueryString } from "@aws-sdk/querystring-builder";
export function formatUrl(request) {
    var port = request.port, query = request.query;
    var protocol = request.protocol, path = request.path, hostname = request.hostname;
    if (protocol && protocol.slice(-1) !== ":") {
        protocol += ":";
    }
    if (port) {
        hostname += ":".concat(port);
    }
    if (path && path.charAt(0) !== "/") {
        path = "/".concat(path);
    }
    var queryString = query ? buildQueryString(query) : "";
    if (queryString && queryString[0] !== "?") {
        queryString = "?".concat(queryString);
    }
    return "".concat(protocol, "//").concat(hostname).concat(path).concat(queryString);
}
