import { buildQueryString } from "@aws-sdk/querystring-builder";
export function formatUrl(request) {
    var port = request.port, query = request.query;
    var protocol = request.protocol, path = request.path, hostname = request.hostname;
    if (protocol && protocol.substr(-1) !== ":") {
        protocol += ":";
    }
    if (port) {
        hostname += ":" + port;
    }
    if (path && path.charAt(0) !== "/") {
        path = "/" + path;
    }
    var queryString = query ? buildQueryString(query) : "";
    if (queryString && queryString[0] !== "?") {
        queryString = "?" + queryString;
    }
    return protocol + "//" + hostname + path + queryString;
}
//# sourceMappingURL=data:application/json;base64,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