/**
 * Validates that waiter options are passed correctly
 * @param options a waiter configuration object
 */
export var validateWaiterOptions = function (options) {
    if (options.maxWaitTime < 1) {
        throw new Error("WaiterConfiguration.maxWaitTime must be greater than 0");
    }
    else if (options.minDelay < 1) {
        throw new Error("WaiterConfiguration.minDelay must be greater than 0");
    }
    else if (options.maxDelay < 1) {
        throw new Error("WaiterConfiguration.maxDelay must be greater than 0");
    }
    else if (options.maxWaitTime <= options.minDelay) {
        throw new Error("WaiterConfiguration.maxWaitTime [" + options.maxWaitTime + "] must be greater than WaiterConfiguration.minDelay [" + options.minDelay + "] for this waiter");
    }
    else if (options.maxDelay < options.minDelay) {
        throw new Error("WaiterConfiguration.maxDelay [" + options.maxDelay + "] must be greater than WaiterConfiguration.minDelay [" + options.minDelay + "] for this waiter");
    }
};
//# sourceMappingURL=data:application/json;base64,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