/// <reference path="axe-core.d.ts" />
var context = document;
var $fixture = {};
// axe.a11yCheck config
axe.a11yCheck(context, {}, function (results) {
    // axe's results object
    console.log(results.passes.length);
    console.log(results.violations.length);
});
// axe.a11yCheck include/exclude
axe.a11yCheck({ include: [['#id1'], ['#id2']] }, {}, function (results) {
    console.log(results);
});
axe.a11yCheck({ exclude: [$fixture[0]] }, {}, function (results) {
    console.log(results);
});
var tagConfigRunOnly = {
    type: 'tag',
    values: ['wcag2a']
};
var tagConfig = {
    runOnly: tagConfigRunOnly
};
axe.a11yCheck(context, tagConfig, function (results) {
    console.log(results);
});
var includeExcludeTagsRunOnly = {
    type: 'tags',
    value: {
        include: ['wcag2a', 'wcag2aa'],
        exclude: ['experimental']
    }
};
var includeExcludeTagsConfig = {
    runOnly: includeExcludeTagsRunOnly
};
axe.a11yCheck(context, includeExcludeTagsConfig, function (results) {
    console.log(results);
});
var someRulesConfig = {
    rules: {
        "color-contrast": { enabled: 'false' },
        "heading-order": { enabled: 'true' }
    }
};
axe.a11yCheck(context, someRulesConfig, function (results) {
    console.log(results);
});
// axe.configure
var spec = {
    branding: {
        brand: 'foo',
        application: 'bar'
    },
    reporter: 'v1',
    checks: [{
            id: 'custom-check',
            evaluate: function () {
                return true;
            }
        }],
    rules: [{
            id: 'custom-rule',
            any: ['custom-check']
        }]
};
axe.configure(spec);
var source = axe.source;
axe.reset();
axe.getRules(['wcag2aa']);
typeof axe.getRules() === 'object';
// Plugins
var pluginSrc = {
    id: 'doStuff',
    run: function (data, callback) {
        callback();
    },
    commands: [{
            id: 'run-doStuff',
            callback: function (data, callback) {
                axe.plugins['doStuff'].run(data, callback);
            }
        }]
};
axe.registerPlugin(pluginSrc);
axe.cleanup();
