import { HttpClient } from "./httpClient";
import { WebResource } from "./webResource";
import { HttpOperationResponse } from "./httpOperationResponse";
import { HttpHeaders } from "./httpHeaders";
export declare abstract class FetchHttpClient implements HttpClient {
    sendRequest(httpRequest: WebResource): Promise<HttpOperationResponse>;
    abstract prepareRequest(httpRequest: WebResource): Promise<Partial<RequestInit>>;
    abstract processRequest(operationResponse: HttpOperationResponse): Promise<void>;
    abstract fetch(input: RequestInfo, init?: RequestInit): Promise<Response>;
}
export declare function parseHeaders(headers: Headers): HttpHeaders;
//# sourceMappingURL=fetchHttpClient.d.ts.map