// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
import * as tslib_1 from "tslib";
import * as tough from "tough-cookie";
import "node-fetch";
import { FetchHttpClient } from "./fetchHttpClient";
import { createProxyAgent } from "./proxyAgent";
var globalWithFetch = global;
if (typeof globalWithFetch.fetch !== "function") {
    var fetch_1 = require("node-fetch");
    globalWithFetch.fetch = fetch_1;
}
var NodeFetchHttpClient = /** @class */ (function (_super) {
    tslib_1.__extends(NodeFetchHttpClient, _super);
    function NodeFetchHttpClient() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cookieJar = new tough.CookieJar();
        return _this;
    }
    NodeFetchHttpClient.prototype.fetch = function (input, init) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, fetch(input, init)];
            });
        });
    };
    NodeFetchHttpClient.prototype.prepareRequest = function (httpRequest) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var requestInit, cookieString, tunnel;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        requestInit = {};
                        if (!(this.cookieJar && !httpRequest.headers.get("Cookie"))) return [3 /*break*/, 2];
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                _this.cookieJar.getCookieString(httpRequest.url, function (err, cookie) {
                                    if (err) {
                                        reject(err);
                                    }
                                    else {
                                        resolve(cookie);
                                    }
                                });
                            })];
                    case 1:
                        cookieString = _a.sent();
                        httpRequest.headers.set("Cookie", cookieString);
                        _a.label = 2;
                    case 2:
                        if (httpRequest.proxySettings) {
                            tunnel = createProxyAgent(httpRequest.url, httpRequest.proxySettings, httpRequest.headers);
                            requestInit.agent = tunnel.agent;
                        }
                        return [2 /*return*/, requestInit];
                }
            });
        });
    };
    NodeFetchHttpClient.prototype.processRequest = function (operationResponse) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var setCookieHeader_1;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.cookieJar) return [3 /*break*/, 2];
                        setCookieHeader_1 = operationResponse.headers.get("Set-Cookie");
                        if (!(setCookieHeader_1 != undefined)) return [3 /*break*/, 2];
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                _this.cookieJar.setCookie(setCookieHeader_1, operationResponse.request.url, function (err) {
                                    if (err) {
                                        reject(err);
                                    }
                                    else {
                                        resolve();
                                    }
                                });
                            })];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    return NodeFetchHttpClient;
}(FetchHttpClient));
export { NodeFetchHttpClient };
//# sourceMappingURL=nodeFetchHttpClient.js.map