/*! @azure/msal-browser v3.19.0 2024-07-12 */
"use strict";!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).msal={})}(this,(function(e){
/*! @azure/msal-common v14.13.0 2024-07-12 */
const t={LIBRARY_NAME:"MSAL.JS",SKU:"msal.js.common",CACHE_PREFIX:"msal",DEFAULT_AUTHORITY:"https://login.microsoftonline.com/common/",DEFAULT_AUTHORITY_HOST:"login.microsoftonline.com",DEFAULT_COMMON_TENANT:"common",ADFS:"adfs",DSTS:"dstsv2",AAD_INSTANCE_DISCOVERY_ENDPT:"https://login.microsoftonline.com/common/discovery/instance?api-version=1.1&authorization_endpoint=",CIAM_AUTH_URL:".ciamlogin.com",AAD_TENANT_DOMAIN_SUFFIX:".onmicrosoft.com",RESOURCE_DELIM:"|",NO_ACCOUNT:"NO_ACCOUNT",CLAIMS:"claims",CONSUMER_UTID:"9188040d-6c67-4c5b-b112-36a304b66dad",OPENID_SCOPE:"openid",PROFILE_SCOPE:"profile",OFFLINE_ACCESS_SCOPE:"offline_access",EMAIL_SCOPE:"email",CODE_RESPONSE_TYPE:"code",CODE_GRANT_TYPE:"authorization_code",RT_GRANT_TYPE:"refresh_token",FRAGMENT_RESPONSE_MODE:"fragment",S256_CODE_CHALLENGE_METHOD:"S256",URL_FORM_CONTENT_TYPE:"application/x-www-form-urlencoded;charset=utf-8",AUTHORIZATION_PENDING:"authorization_pending",NOT_DEFINED:"not_defined",EMPTY_STRING:"",NOT_APPLICABLE:"N/A",NOT_AVAILABLE:"Not Available",FORWARD_SLASH:"/",IMDS_ENDPOINT:"http://169.254.169.254/metadata/instance/compute/location",IMDS_VERSION:"2020-06-01",IMDS_TIMEOUT:2e3,AZURE_REGION_AUTO_DISCOVER_FLAG:"TryAutoDetect",REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX:"login.microsoft.com",KNOWN_PUBLIC_CLOUDS:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"],TOKEN_RESPONSE_TYPE:"token",ID_TOKEN_RESPONSE_TYPE:"id_token",SHR_NONCE_VALIDITY:240,INVALID_INSTANCE:"invalid_instance"},r=400,n=499,o=500,i=599,a=[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE],s=[...a,t.EMAIL_SCOPE],c="Content-Type",l="Retry-After",d="X-AnchorMailbox",h="WWW-Authenticate",u="Authentication-Info",g="x-ms-request-id",p="x-ms-httpver",m="idtoken",f="client.info",C="adal.idtoken",y="error",v="error.description",T="active-account",I="active-account-filters",w="common",A="organizations",k="consumers",S="access_token",E="xms_cc",R={LOGIN:"login",SELECT_ACCOUNT:"select_account",CONSENT:"consent",NONE:"none",CREATE:"create",NO_SESSION:"no_session"},b={PLAIN:"plain",S256:"S256"},_={QUERY:"query",FRAGMENT:"fragment"},P={..._,FORM_POST:"form_post"},M="authorization_code",N="refresh_token",O="MSSTS",q="ADFS",L="Generic",U={CACHE_KEY_SEPARATOR:"-",CLIENT_INFO_SEPARATOR:"."},H={ID_TOKEN:"IdToken",ACCESS_TOKEN:"AccessToken",ACCESS_TOKEN_WITH_AUTH_SCHEME:"AccessToken_With_AuthScheme",REFRESH_TOKEN:"RefreshToken"},B="appmetadata",D="1",x="authority-metadata",F=86400,K="config",z="cache",G="network",$="hardcoded_values",Q={SCHEMA_VERSION:5,MAX_CUR_HEADER_BYTES:80,MAX_LAST_HEADER_BYTES:330,MAX_CACHED_ERRORS:50,CACHE_KEY:"server-telemetry",CATEGORY_SEPARATOR:"|",VALUE_SEPARATOR:",",OVERFLOW_TRUE:"1",OVERFLOW_FALSE:"0",UNKNOWN_ERROR:"unknown_error"},W={BEARER:"Bearer",POP:"pop",SSH:"ssh-cert"},j=60,V=3600,Y="throttling",J="retry-after, h429",X="invalid_grant",Z="client_mismatch",ee="username",te="password",re=200,ne=400,oe="1",ie="3",ae="4",se="2",ce="4",le="5",de="0",he="1",ue="2",ge="3",pe="4",me={Jwt:"JWT",Jwk:"JWK",Pop:"pop"},fe="unexpected_error",Ce="post_request_failed";var ye=Object.freeze({__proto__:null,postRequestFailed:Ce,unexpectedError:fe});
/*! @azure/msal-common v14.13.0 2024-07-12 */const ve={[fe]:"Unexpected error in authentication.",[Ce]:"Post request failed from the network, could be a 4xx/5xx or a network unavailability. Please check the exact error code for details."},Te={unexpectedError:{code:fe,desc:ve[fe]},postRequestFailed:{code:Ce,desc:ve[Ce]}};class Ie extends Error{constructor(e,r,n){super(r?`${e}: ${r}`:e),Object.setPrototypeOf(this,Ie.prototype),this.errorCode=e||t.EMPTY_STRING,this.errorMessage=r||t.EMPTY_STRING,this.subError=n||t.EMPTY_STRING,this.name="AuthError"}setCorrelationId(e){this.correlationId=e}}function we(e,t){return new Ie(e,t?`${ve[e]} ${t}`:ve[e])}
/*! @azure/msal-common v14.13.0 2024-07-12 */const Ae="client_info_decoding_error",ke="client_info_empty_error",Se="token_parsing_error",Ee="null_or_empty_token",Re="endpoints_resolution_error",be="network_error",_e="openid_config_error",Pe="hash_not_deserialized",Me="invalid_state",Ne="state_mismatch",Oe="state_not_found",qe="nonce_mismatch",Le="auth_time_not_found",Ue="max_age_transpired",He="multiple_matching_tokens",Be="multiple_matching_accounts",De="multiple_matching_appMetadata",xe="request_cannot_be_made",Fe="cannot_remove_empty_scope",Ke="cannot_append_scopeset",ze="empty_input_scopeset",Ge="device_code_polling_cancelled",$e="device_code_expired",Qe="device_code_unknown_error",We="no_account_in_silent_request",je="invalid_cache_record",Ve="invalid_cache_environment",Ye="no_account_found",Je="no_crypto_object",Xe="unexpected_credential_type",Ze="invalid_assertion",et="invalid_client_credential",tt="token_refresh_required",rt="user_timeout_reached",nt="token_claims_cnf_required_for_signedjwt",ot="authorization_code_missing_from_server_response",it="binding_key_not_removed",at="end_session_endpoint_not_supported",st="key_id_missing",ct="no_network_connectivity",lt="user_canceled",dt="missing_tenant_id_error",ht="method_not_implemented",ut="nested_app_auth_bridge_disabled";var gt=Object.freeze({__proto__:null,authTimeNotFound:Le,authorizationCodeMissingFromServerResponse:ot,bindingKeyNotRemoved:it,cannotAppendScopeSet:Ke,cannotRemoveEmptyScope:Fe,clientInfoDecodingError:Ae,clientInfoEmptyError:ke,deviceCodeExpired:$e,deviceCodePollingCancelled:Ge,deviceCodeUnknownError:Qe,emptyInputScopeSet:ze,endSessionEndpointNotSupported:at,endpointResolutionError:Re,hashNotDeserialized:Pe,invalidAssertion:Ze,invalidCacheEnvironment:Ve,invalidCacheRecord:je,invalidClientCredential:et,invalidState:Me,keyIdMissing:st,maxAgeTranspired:Ue,methodNotImplemented:ht,missingTenantIdError:dt,multipleMatchingAccounts:Be,multipleMatchingAppMetadata:De,multipleMatchingTokens:He,nestedAppAuthBridgeDisabled:ut,networkError:be,noAccountFound:Ye,noAccountInSilentRequest:We,noCryptoObject:Je,noNetworkConnectivity:ct,nonceMismatch:qe,nullOrEmptyToken:Ee,openIdConfigError:_e,requestCannotBeMade:xe,stateMismatch:Ne,stateNotFound:Oe,tokenClaimsCnfRequiredForSignedJwt:nt,tokenParsingError:Se,tokenRefreshRequired:tt,unexpectedCredentialType:Xe,userCanceled:lt,userTimeoutReached:rt});
/*! @azure/msal-common v14.13.0 2024-07-12 */const pt={[Ae]:"The client info could not be parsed/decoded correctly",[ke]:"The client info was empty",[Se]:"Token cannot be parsed",[Ee]:"The token is null or empty",[Re]:"Endpoints cannot be resolved",[be]:"Network request failed",[_e]:"Could not retrieve endpoints. Check your authority and verify the .well-known/openid-configuration endpoint returns the required endpoints.",[Pe]:"The hash parameters could not be deserialized",[Me]:"State was not the expected format",[Ne]:"State mismatch error",[Oe]:"State not found",[qe]:"Nonce mismatch error",[Le]:"Max Age was requested and the ID token is missing the auth_time variable. auth_time is an optional claim and is not enabled by default - it must be enabled. See https://aka.ms/msaljs/optional-claims for more information.",[Ue]:"Max Age is set to 0, or too much time has elapsed since the last end-user authentication.",[He]:"The cache contains multiple tokens satisfying the requirements. Call AcquireToken again providing more requirements such as authority or account.",[Be]:"The cache contains multiple accounts satisfying the given parameters. Please pass more info to obtain the correct account",[De]:"The cache contains multiple appMetadata satisfying the given parameters. Please pass more info to obtain the correct appMetadata",[xe]:"Token request cannot be made without authorization code or refresh token.",[Fe]:"Cannot remove null or empty scope from ScopeSet",[Ke]:"Cannot append ScopeSet",[ze]:"Empty input ScopeSet cannot be processed",[Ge]:"Caller has cancelled token endpoint polling during device code flow by setting DeviceCodeRequest.cancel = true.",[$e]:"Device code is expired.",[Qe]:"Device code stopped polling for unknown reasons.",[We]:"Please pass an account object, silent flow is not supported without account information",[je]:"Cache record object was null or undefined.",[Ve]:"Invalid environment when attempting to create cache entry",[Ye]:"No account found in cache for given key.",[Je]:"No crypto object detected.",[Xe]:"Unexpected credential type.",[Ze]:"Client assertion must meet requirements described in https://tools.ietf.org/html/rfc7515",[et]:"Client credential (secret, certificate, or assertion) must not be empty when creating a confidential client. An application should at most have one credential",[tt]:"Cannot return token from cache because it must be refreshed. This may be due to one of the following reasons: forceRefresh parameter is set to true, claims have been requested, there is no cached access token or it is expired.",[rt]:"User defined timeout for device code polling reached",[nt]:"Cannot generate a POP jwt if the token_claims are not populated",[ot]:"Server response does not contain an authorization code to proceed",[it]:"Could not remove the credential's binding key from storage.",[at]:"The provided authority does not support logout",[st]:"A keyId value is missing from the requested bound token's cache record and is required to match the token to it's stored binding key.",[ct]:"No network connectivity. Check your internet connection.",[lt]:"User cancelled the flow.",[dt]:"A tenant id - not common, organizations, or consumers - must be specified when using the client_credentials flow.",[ht]:"This method has not been implemented",[ut]:"The nested app auth bridge is disabled"},mt={clientInfoDecodingError:{code:Ae,desc:pt[Ae]},clientInfoEmptyError:{code:ke,desc:pt[ke]},tokenParsingError:{code:Se,desc:pt[Se]},nullOrEmptyToken:{code:Ee,desc:pt[Ee]},endpointResolutionError:{code:Re,desc:pt[Re]},networkError:{code:be,desc:pt[be]},unableToGetOpenidConfigError:{code:_e,desc:pt[_e]},hashNotDeserialized:{code:Pe,desc:pt[Pe]},invalidStateError:{code:Me,desc:pt[Me]},stateMismatchError:{code:Ne,desc:pt[Ne]},stateNotFoundError:{code:Oe,desc:pt[Oe]},nonceMismatchError:{code:qe,desc:pt[qe]},authTimeNotFoundError:{code:Le,desc:pt[Le]},maxAgeTranspired:{code:Ue,desc:pt[Ue]},multipleMatchingTokens:{code:He,desc:pt[He]},multipleMatchingAccounts:{code:Be,desc:pt[Be]},multipleMatchingAppMetadata:{code:De,desc:pt[De]},tokenRequestCannotBeMade:{code:xe,desc:pt[xe]},removeEmptyScopeError:{code:Fe,desc:pt[Fe]},appendScopeSetError:{code:Ke,desc:pt[Ke]},emptyInputScopeSetError:{code:ze,desc:pt[ze]},DeviceCodePollingCancelled:{code:Ge,desc:pt[Ge]},DeviceCodeExpired:{code:$e,desc:pt[$e]},DeviceCodeUnknownError:{code:Qe,desc:pt[Qe]},NoAccountInSilentRequest:{code:We,desc:pt[We]},invalidCacheRecord:{code:je,desc:pt[je]},invalidCacheEnvironment:{code:Ve,desc:pt[Ve]},noAccountFound:{code:Ye,desc:pt[Ye]},noCryptoObj:{code:Je,desc:pt[Je]},unexpectedCredentialType:{code:Xe,desc:pt[Xe]},invalidAssertion:{code:Ze,desc:pt[Ze]},invalidClientCredential:{code:et,desc:pt[et]},tokenRefreshRequired:{code:tt,desc:pt[tt]},userTimeoutReached:{code:rt,desc:pt[rt]},tokenClaimsRequired:{code:nt,desc:pt[nt]},noAuthorizationCodeFromServer:{code:ot,desc:pt[ot]},bindingKeyNotRemovedError:{code:it,desc:pt[it]},logoutNotSupported:{code:at,desc:pt[at]},keyIdMissing:{code:st,desc:pt[st]},noNetworkConnectivity:{code:ct,desc:pt[ct]},userCanceledError:{code:lt,desc:pt[lt]},missingTenantIdError:{code:dt,desc:pt[dt]},nestedAppAuthBridgeDisabled:{code:ut,desc:pt[ut]}};class ft extends Ie{constructor(e,t){super(e,t?`${pt[e]}: ${t}`:pt[e]),this.name="ClientAuthError",Object.setPrototypeOf(this,ft.prototype)}}function Ct(e,t){return new ft(e,t)}
/*! @azure/msal-common v14.13.0 2024-07-12 */function yt(e,t){const r=function(e){if(!e)throw Ct(Ee);const t=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(e);if(!t||t.length<4)throw Ct(Se);return t[2]}(e);try{const e=t(r);return JSON.parse(e)}catch(e){throw Ct(Se)}}function vt(e,t){if(0===t||Date.now()-3e5>e+t)throw Ct(Ue)}
/*! @azure/msal-common v14.13.0 2024-07-12 */const Tt=0,It=1,wt=2,At=3;
/*! @azure/msal-common v14.13.0 2024-07-12 */
/*! @azure/msal-common v14.13.0 2024-07-12 */
const kt="redirect_uri_empty",St="claims_request_parsing_error",Et="authority_uri_insecure",Rt="url_parse_error",bt="empty_url_error",_t="empty_input_scopes_error",Pt="invalid_prompt_value",Mt="invalid_claims",Nt="token_request_empty",Ot="logout_request_empty",qt="invalid_code_challenge_method",Lt="pkce_params_missing",Ut="invalid_cloud_discovery_metadata",Ht="invalid_authority_metadata",Bt="untrusted_authority",Dt="missing_ssh_jwk",xt="missing_ssh_kid",Ft="missing_nonce_authentication_header",Kt="invalid_authentication_header",zt="cannot_set_OIDCOptions",Gt="cannot_allow_native_broker",$t="authority_mismatch";var Qt=Object.freeze({__proto__:null,authorityMismatch:$t,authorityUriInsecure:Et,cannotAllowNativeBroker:Gt,cannotSetOIDCOptions:zt,claimsRequestParsingError:St,emptyInputScopesError:_t,invalidAuthenticationHeader:Kt,invalidAuthorityMetadata:Ht,invalidClaims:Mt,invalidCloudDiscoveryMetadata:Ut,invalidCodeChallengeMethod:qt,invalidPromptValue:Pt,logoutRequestEmpty:Ot,missingNonceAuthenticationHeader:Ft,missingSshJwk:Dt,missingSshKid:xt,pkceParamsMissing:Lt,redirectUriEmpty:kt,tokenRequestEmpty:Nt,untrustedAuthority:Bt,urlEmptyError:bt,urlParseError:Rt});
/*! @azure/msal-common v14.13.0 2024-07-12 */const Wt={[kt]:"A redirect URI is required for all calls, and none has been set.",[St]:"Could not parse the given claims request object.",[Et]:"Authority URIs must use https.  Please see here for valid authority configuration options: https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-js-initializing-client-applications#configuration-options",[Rt]:"URL could not be parsed into appropriate segments.",[bt]:"URL was empty or null.",[_t]:"Scopes cannot be passed as null, undefined or empty array because they are required to obtain an access token.",[Pt]:"Please see here for valid configuration options: https://azuread.github.io/microsoft-authentication-library-for-js/ref/modules/_azure_msal_common.html#commonauthorizationurlrequest",[Mt]:"Given claims parameter must be a stringified JSON object.",[Nt]:"Token request was empty and not found in cache.",[Ot]:"The logout request was null or undefined.",[qt]:'code_challenge_method passed is invalid. Valid values are "plain" and "S256".',[Lt]:"Both params: code_challenge and code_challenge_method are to be passed if to be sent in the request",[Ut]:"Invalid cloudDiscoveryMetadata provided. Must be a stringified JSON object containing tenant_discovery_endpoint and metadata fields",[Ht]:"Invalid authorityMetadata provided. Must by a stringified JSON object containing authorization_endpoint, token_endpoint, issuer fields.",[Bt]:"The provided authority is not a trusted authority. Please include this authority in the knownAuthorities config parameter.",[Dt]:"Missing sshJwk in SSH certificate request. A stringified JSON Web Key is required when using the SSH authentication scheme.",[xt]:"Missing sshKid in SSH certificate request. A string that uniquely identifies the public SSH key is required when using the SSH authentication scheme.",[Ft]:"Unable to find an authentication header containing server nonce. Either the Authentication-Info or WWW-Authenticate headers must be present in order to obtain a server nonce.",[Kt]:"Invalid authentication header provided",[zt]:"Cannot set OIDCOptions parameter. Please change the protocol mode to OIDC or use a non-Microsoft authority.",[Gt]:"Cannot set allowNativeBroker parameter to true when not in AAD protocol mode.",[$t]:"Authority mismatch error. Authority provided in login request or PublicClientApplication config does not match the environment of the provided account. Please use a matching account or make an interactive request to login to this authority."},jt={redirectUriNotSet:{code:kt,desc:Wt[kt]},claimsRequestParsingError:{code:St,desc:Wt[St]},authorityUriInsecure:{code:Et,desc:Wt[Et]},urlParseError:{code:Rt,desc:Wt[Rt]},urlEmptyError:{code:bt,desc:Wt[bt]},emptyScopesError:{code:_t,desc:Wt[_t]},invalidPrompt:{code:Pt,desc:Wt[Pt]},invalidClaimsRequest:{code:Mt,desc:Wt[Mt]},tokenRequestEmptyError:{code:Nt,desc:Wt[Nt]},logoutRequestEmptyError:{code:Ot,desc:Wt[Ot]},invalidCodeChallengeMethod:{code:qt,desc:Wt[qt]},invalidCodeChallengeParams:{code:Lt,desc:Wt[Lt]},invalidCloudDiscoveryMetadata:{code:Ut,desc:Wt[Ut]},invalidAuthorityMetadata:{code:Ht,desc:Wt[Ht]},untrustedAuthority:{code:Bt,desc:Wt[Bt]},missingSshJwk:{code:Dt,desc:Wt[Dt]},missingSshKid:{code:xt,desc:Wt[xt]},missingNonceAuthenticationHeader:{code:Ft,desc:Wt[Ft]},invalidAuthenticationHeader:{code:Kt,desc:Wt[Kt]},cannotSetOIDCOptions:{code:zt,desc:Wt[zt]},cannotAllowNativeBroker:{code:Gt,desc:Wt[Gt]},authorityMismatch:{code:$t,desc:Wt[$t]}};class Vt extends Ie{constructor(e){super(e,Wt[e]),this.name="ClientConfigurationError",Object.setPrototypeOf(this,Vt.prototype)}}function Yt(e){return new Vt(e)}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Jt{static isEmptyObj(e){if(e)try{const t=JSON.parse(e);return 0===Object.keys(t).length}catch(e){}return!0}static startsWith(e,t){return 0===e.indexOf(t)}static endsWith(e,t){return e.length>=t.length&&e.lastIndexOf(t)===e.length-t.length}static queryStringToObject(e){const t={},r=e.split("&"),n=e=>decodeURIComponent(e.replace(/\+/g," "));return r.forEach((e=>{if(e.trim()){const[r,o]=e.split(/=(.+)/g,2);r&&o&&(t[n(r)]=n(o))}})),t}static trimArrayEntries(e){return e.map((e=>e.trim()))}static removeEmptyStringsFromArray(e){return e.filter((e=>!!e))}static jsonParseHelper(e){try{return JSON.parse(e)}catch(e){return null}}static matchPattern(e,t){return new RegExp(e.replace(/\\/g,"\\\\").replace(/\*/g,"[^ ]*").replace(/\?/g,"\\?")).test(t)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */function Xt(e){return e.startsWith("#/")?e.substring(2):e.startsWith("#")||e.startsWith("?")?e.substring(1):e}function Zt(e){if(!e||e.indexOf("=")<0)return null;try{const t=Xt(e),r=Object.fromEntries(new URLSearchParams(t));if(r.code||r.error||r.error_description||r.state)return r}catch(e){throw Ct(Pe)}return null}
/*! @azure/msal-common v14.13.0 2024-07-12 */class er{get urlString(){return this._urlString}constructor(e){if(this._urlString=e,!this._urlString)throw Yt(bt);e.includes("#")||(this._urlString=er.canonicalizeUri(e))}static canonicalizeUri(e){if(e){let t=e.toLowerCase();return Jt.endsWith(t,"?")?t=t.slice(0,-1):Jt.endsWith(t,"?/")&&(t=t.slice(0,-2)),Jt.endsWith(t,"/")||(t+="/"),t}return e}validateAsUri(){let e;try{e=this.getUrlComponents()}catch(e){throw Yt(Rt)}if(!e.HostNameAndPort||!e.PathSegments)throw Yt(Rt);if(!e.Protocol||"https:"!==e.Protocol.toLowerCase())throw Yt(Et)}static appendQueryString(e,t){return t?e.indexOf("?")<0?`${e}?${t}`:`${e}&${t}`:e}static removeHashFromUrl(e){return er.canonicalizeUri(e.split("#")[0])}replaceTenantPath(e){const t=this.getUrlComponents(),r=t.PathSegments;return!e||0===r.length||r[0]!==w&&r[0]!==A||(r[0]=e),er.constructAuthorityUriFromObject(t)}getUrlComponents(){const e=RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?"),t=this.urlString.match(e);if(!t)throw Yt(Rt);const r={Protocol:t[1],HostNameAndPort:t[4],AbsolutePath:t[5],QueryString:t[7]};let n=r.AbsolutePath.split("/");return n=n.filter((e=>e&&e.length>0)),r.PathSegments=n,r.QueryString&&r.QueryString.endsWith("/")&&(r.QueryString=r.QueryString.substring(0,r.QueryString.length-1)),r}static getDomainFromUrl(e){const t=RegExp("^([^:/?#]+://)?([^/?#]*)"),r=e.match(t);if(!r)throw Yt(Rt);return r[2]}static getAbsoluteUrl(e,r){if(e[0]===t.FORWARD_SLASH){const t=new er(r).getUrlComponents();return t.Protocol+"//"+t.HostNameAndPort+e}return e}static constructAuthorityUriFromObject(e){return new er(e.Protocol+"//"+e.HostNameAndPort+"/"+e.PathSegments.join("/"))}static hashContainsKnownProperties(e){return!!Zt(e)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const tr={"login.microsoftonline.com":{token_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.com/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.com/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.com/{tenantid}/oauth2/v2.0/logout"},"login.chinacloudapi.cn":{token_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.chinacloudapi.cn/{tenantid}/discovery/v2.0/keys",issuer:"https://login.partner.microsoftonline.cn/{tenantid}/v2.0",authorization_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.chinacloudapi.cn/{tenantid}/oauth2/v2.0/logout"},"login.microsoftonline.us":{token_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/token",jwks_uri:"https://login.microsoftonline.us/{tenantid}/discovery/v2.0/keys",issuer:"https://login.microsoftonline.us/{tenantid}/v2.0",authorization_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/authorize",end_session_endpoint:"https://login.microsoftonline.us/{tenantid}/oauth2/v2.0/logout"}},rr={tenant_discovery_endpoint:"https://{canonicalAuthority}/v2.0/.well-known/openid-configuration",metadata:[{preferred_network:"login.microsoftonline.com",preferred_cache:"login.windows.net",aliases:["login.microsoftonline.com","login.windows.net","login.microsoft.com","sts.windows.net"]},{preferred_network:"login.partner.microsoftonline.cn",preferred_cache:"login.partner.microsoftonline.cn",aliases:["login.partner.microsoftonline.cn","login.chinacloudapi.cn"]},{preferred_network:"login.microsoftonline.de",preferred_cache:"login.microsoftonline.de",aliases:["login.microsoftonline.de"]},{preferred_network:"login.microsoftonline.us",preferred_cache:"login.microsoftonline.us",aliases:["login.microsoftonline.us","login.usgovcloudapi.net"]},{preferred_network:"login-us.microsoftonline.com",preferred_cache:"login-us.microsoftonline.com",aliases:["login-us.microsoftonline.com"]}]},nr=new Set;function or(e,t,r,n){if(n?.trace(`getAliasesFromMetadata called with source: ${r}`),e&&t){const o=ir(t,e);if(o)return n?.trace(`getAliasesFromMetadata: found cloud discovery metadata in ${r}, returning aliases`),o.aliases;n?.trace(`getAliasesFromMetadata: did not find cloud discovery metadata in ${r}`)}return null}function ir(e,t){for(let r=0;r<e.length;r++){const n=e[r];if(n.aliases.includes(t))return n}return null}
/*! @azure/msal-common v14.13.0 2024-07-12 */rr.metadata.forEach((e=>{e.aliases.forEach((e=>{nr.add(e)}))}));const ar={AAD:"AAD",OIDC:"OIDC"},sr={None:"none",AzurePublic:"https://login.microsoftonline.com",AzurePpe:"https://login.windows-ppe.net",AzureChina:"https://login.chinacloudapi.cn",AzureGermany:"https://login.microsoftonline.de",AzureUsGovernment:"https://login.microsoftonline.us"};
/*! @azure/msal-common v14.13.0 2024-07-12 */
/*! @azure/msal-common v14.13.0 2024-07-12 */
const cr={AcquireTokenByCode:"acquireTokenByCode",AcquireTokenByRefreshToken:"acquireTokenByRefreshToken",AcquireTokenSilent:"acquireTokenSilent",AcquireTokenSilentAsync:"acquireTokenSilentAsync",AcquireTokenPopup:"acquireTokenPopup",AcquireTokenPreRedirect:"acquireTokenPreRedirect",AcquireTokenRedirect:"acquireTokenRedirect",CryptoOptsGetPublicKeyThumbprint:"cryptoOptsGetPublicKeyThumbprint",CryptoOptsSignJwt:"cryptoOptsSignJwt",SilentCacheClientAcquireToken:"silentCacheClientAcquireToken",SilentIframeClientAcquireToken:"silentIframeClientAcquireToken",AwaitConcurrentIframe:"awaitConcurrentIframe",SilentRefreshClientAcquireToken:"silentRefreshClientAcquireToken",SsoSilent:"ssoSilent",StandardInteractionClientGetDiscoveredAuthority:"standardInteractionClientGetDiscoveredAuthority",FetchAccountIdWithNativeBroker:"fetchAccountIdWithNativeBroker",NativeInteractionClientAcquireToken:"nativeInteractionClientAcquireToken",BaseClientCreateTokenRequestHeaders:"baseClientCreateTokenRequestHeaders",RefreshTokenClientExecutePostToTokenEndpoint:"refreshTokenClientExecutePostToTokenEndpoint",AuthorizationCodeClientExecutePostToTokenEndpoint:"authorizationCodeClientExecutePostToTokenEndpoint",BrokerHandhshake:"brokerHandshake",AcquireTokenByRefreshTokenInBroker:"acquireTokenByRefreshTokenInBroker",AcquireTokenByBroker:"acquireTokenByBroker",RefreshTokenClientExecuteTokenRequest:"refreshTokenClientExecuteTokenRequest",RefreshTokenClientAcquireToken:"refreshTokenClientAcquireToken",RefreshTokenClientAcquireTokenWithCachedRefreshToken:"refreshTokenClientAcquireTokenWithCachedRefreshToken",RefreshTokenClientAcquireTokenByRefreshToken:"refreshTokenClientAcquireTokenByRefreshToken",RefreshTokenClientCreateTokenRequestBody:"refreshTokenClientCreateTokenRequestBody",AcquireTokenFromCache:"acquireTokenFromCache",SilentFlowClientAcquireCachedToken:"silentFlowClientAcquireCachedToken",SilentFlowClientGenerateResultFromCacheRecord:"silentFlowClientGenerateResultFromCacheRecord",AcquireTokenBySilentIframe:"acquireTokenBySilentIframe",InitializeBaseRequest:"initializeBaseRequest",InitializeSilentRequest:"initializeSilentRequest",InitializeClientApplication:"initializeClientApplication",SilentIframeClientTokenHelper:"silentIframeClientTokenHelper",SilentHandlerInitiateAuthRequest:"silentHandlerInitiateAuthRequest",SilentHandlerMonitorIframeForHash:"silentHandlerMonitorIframeForHash",SilentHandlerLoadFrame:"silentHandlerLoadFrame",SilentHandlerLoadFrameSync:"silentHandlerLoadFrameSync",StandardInteractionClientCreateAuthCodeClient:"standardInteractionClientCreateAuthCodeClient",StandardInteractionClientGetClientConfiguration:"standardInteractionClientGetClientConfiguration",StandardInteractionClientInitializeAuthorizationRequest:"standardInteractionClientInitializeAuthorizationRequest",StandardInteractionClientInitializeAuthorizationCodeRequest:"standardInteractionClientInitializeAuthorizationCodeRequest",GetAuthCodeUrl:"getAuthCodeUrl",HandleCodeResponseFromServer:"handleCodeResponseFromServer",HandleCodeResponse:"handleCodeResponse",UpdateTokenEndpointAuthority:"updateTokenEndpointAuthority",AuthClientAcquireToken:"authClientAcquireToken",AuthClientExecuteTokenRequest:"authClientExecuteTokenRequest",AuthClientCreateTokenRequestBody:"authClientCreateTokenRequestBody",AuthClientCreateQueryString:"authClientCreateQueryString",PopTokenGenerateCnf:"popTokenGenerateCnf",PopTokenGenerateKid:"popTokenGenerateKid",HandleServerTokenResponse:"handleServerTokenResponse",DeserializeResponse:"deserializeResponse",AuthorityFactoryCreateDiscoveredInstance:"authorityFactoryCreateDiscoveredInstance",AuthorityResolveEndpointsAsync:"authorityResolveEndpointsAsync",AuthorityResolveEndpointsFromLocalSources:"authorityResolveEndpointsFromLocalSources",AuthorityGetCloudDiscoveryMetadataFromNetwork:"authorityGetCloudDiscoveryMetadataFromNetwork",AuthorityUpdateCloudDiscoveryMetadata:"authorityUpdateCloudDiscoveryMetadata",AuthorityGetEndpointMetadataFromNetwork:"authorityGetEndpointMetadataFromNetwork",AuthorityUpdateEndpointMetadata:"authorityUpdateEndpointMetadata",AuthorityUpdateMetadataWithRegionalInformation:"authorityUpdateMetadataWithRegionalInformation",RegionDiscoveryDetectRegion:"regionDiscoveryDetectRegion",RegionDiscoveryGetRegionFromIMDS:"regionDiscoveryGetRegionFromIMDS",RegionDiscoveryGetCurrentVersion:"regionDiscoveryGetCurrentVersion",AcquireTokenByCodeAsync:"acquireTokenByCodeAsync",GetEndpointMetadataFromNetwork:"getEndpointMetadataFromNetwork",GetCloudDiscoveryMetadataFromNetworkMeasurement:"getCloudDiscoveryMetadataFromNetworkMeasurement",HandleRedirectPromiseMeasurement:"handleRedirectPromise",HandleNativeRedirectPromiseMeasurement:"handleNativeRedirectPromise",UpdateCloudDiscoveryMetadataMeasurement:"updateCloudDiscoveryMetadataMeasurement",UsernamePasswordClientAcquireToken:"usernamePasswordClientAcquireToken",NativeMessageHandlerHandshake:"nativeMessageHandlerHandshake",NativeGenerateAuthResult:"nativeGenerateAuthResult",RemoveHiddenIframe:"removeHiddenIframe",ClearTokensAndKeysWithClaims:"clearTokensAndKeysWithClaims",CacheManagerGetRefreshToken:"cacheManagerGetRefreshToken",GeneratePkceCodes:"generatePkceCodes",GenerateCodeVerifier:"generateCodeVerifier",GenerateCodeChallengeFromVerifier:"generateCodeChallengeFromVerifier",Sha256Digest:"sha256Digest",GetRandomValues:"getRandomValues"},lr=new Map([[cr.AcquireTokenByCode,"ATByCode"],[cr.AcquireTokenByRefreshToken,"ATByRT"],[cr.AcquireTokenSilent,"ATS"],[cr.AcquireTokenSilentAsync,"ATSAsync"],[cr.AcquireTokenPopup,"ATPopup"],[cr.AcquireTokenRedirect,"ATRedirect"],[cr.CryptoOptsGetPublicKeyThumbprint,"CryptoGetPKThumb"],[cr.CryptoOptsSignJwt,"CryptoSignJwt"],[cr.SilentCacheClientAcquireToken,"SltCacheClientAT"],[cr.SilentIframeClientAcquireToken,"SltIframeClientAT"],[cr.SilentRefreshClientAcquireToken,"SltRClientAT"],[cr.SsoSilent,"SsoSlt"],[cr.StandardInteractionClientGetDiscoveredAuthority,"StdIntClientGetDiscAuth"],[cr.FetchAccountIdWithNativeBroker,"FetchAccIdWithNtvBroker"],[cr.NativeInteractionClientAcquireToken,"NtvIntClientAT"],[cr.BaseClientCreateTokenRequestHeaders,"BaseClientCreateTReqHead"],[cr.RefreshTokenClientExecutePostToTokenEndpoint,"RTClientExecPost"],[cr.AuthorizationCodeClientExecutePostToTokenEndpoint,"AuthCodeClientExecPost"],[cr.BrokerHandhshake,"BrokerHandshake"],[cr.AcquireTokenByRefreshTokenInBroker,"ATByRTInBroker"],[cr.AcquireTokenByBroker,"ATByBroker"],[cr.RefreshTokenClientExecuteTokenRequest,"RTClientExecTReq"],[cr.RefreshTokenClientAcquireToken,"RTClientAT"],[cr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,"RTClientATWithCachedRT"],[cr.RefreshTokenClientAcquireTokenByRefreshToken,"RTClientATByRT"],[cr.RefreshTokenClientCreateTokenRequestBody,"RTClientCreateTReqBody"],[cr.AcquireTokenFromCache,"ATFromCache"],[cr.SilentFlowClientAcquireCachedToken,"SltFlowClientATCached"],[cr.SilentFlowClientGenerateResultFromCacheRecord,"SltFlowClientGenResFromCache"],[cr.AcquireTokenBySilentIframe,"ATBySltIframe"],[cr.InitializeBaseRequest,"InitBaseReq"],[cr.InitializeSilentRequest,"InitSltReq"],[cr.InitializeClientApplication,"InitClientApplication"],[cr.SilentIframeClientTokenHelper,"SIClientTHelper"],[cr.SilentHandlerInitiateAuthRequest,"SHandlerInitAuthReq"],[cr.SilentHandlerMonitorIframeForHash,"SltHandlerMonitorIframeForHash"],[cr.SilentHandlerLoadFrame,"SHandlerLoadFrame"],[cr.SilentHandlerLoadFrameSync,"SHandlerLoadFrameSync"],[cr.StandardInteractionClientCreateAuthCodeClient,"StdIntClientCreateAuthCodeClient"],[cr.StandardInteractionClientGetClientConfiguration,"StdIntClientGetClientConf"],[cr.StandardInteractionClientInitializeAuthorizationRequest,"StdIntClientInitAuthReq"],[cr.StandardInteractionClientInitializeAuthorizationCodeRequest,"StdIntClientInitAuthCodeReq"],[cr.GetAuthCodeUrl,"GetAuthCodeUrl"],[cr.HandleCodeResponseFromServer,"HandleCodeResFromServer"],[cr.HandleCodeResponse,"HandleCodeResp"],[cr.UpdateTokenEndpointAuthority,"UpdTEndpointAuth"],[cr.AuthClientAcquireToken,"AuthClientAT"],[cr.AuthClientExecuteTokenRequest,"AuthClientExecTReq"],[cr.AuthClientCreateTokenRequestBody,"AuthClientCreateTReqBody"],[cr.AuthClientCreateQueryString,"AuthClientCreateQueryStr"],[cr.PopTokenGenerateCnf,"PopTGenCnf"],[cr.PopTokenGenerateKid,"PopTGenKid"],[cr.HandleServerTokenResponse,"HandleServerTRes"],[cr.DeserializeResponse,"DeserializeRes"],[cr.AuthorityFactoryCreateDiscoveredInstance,"AuthFactCreateDiscInst"],[cr.AuthorityResolveEndpointsAsync,"AuthResolveEndpointsAsync"],[cr.AuthorityResolveEndpointsFromLocalSources,"AuthResolveEndpointsFromLocal"],[cr.AuthorityGetCloudDiscoveryMetadataFromNetwork,"AuthGetCDMetaFromNet"],[cr.AuthorityUpdateCloudDiscoveryMetadata,"AuthUpdCDMeta"],[cr.AuthorityGetEndpointMetadataFromNetwork,"AuthUpdCDMetaFromNet"],[cr.AuthorityUpdateEndpointMetadata,"AuthUpdEndpointMeta"],[cr.AuthorityUpdateMetadataWithRegionalInformation,"AuthUpdMetaWithRegInfo"],[cr.RegionDiscoveryDetectRegion,"RegDiscDetectReg"],[cr.RegionDiscoveryGetRegionFromIMDS,"RegDiscGetRegFromIMDS"],[cr.RegionDiscoveryGetCurrentVersion,"RegDiscGetCurrentVer"],[cr.AcquireTokenByCodeAsync,"ATByCodeAsync"],[cr.GetEndpointMetadataFromNetwork,"GetEndpointMetaFromNet"],[cr.GetCloudDiscoveryMetadataFromNetworkMeasurement,"GetCDMetaFromNet"],[cr.HandleRedirectPromiseMeasurement,"HandleRedirectPromise"],[cr.HandleNativeRedirectPromiseMeasurement,"HandleNtvRedirectPromise"],[cr.UpdateCloudDiscoveryMetadataMeasurement,"UpdateCDMeta"],[cr.UsernamePasswordClientAcquireToken,"UserPassClientAT"],[cr.NativeMessageHandlerHandshake,"NtvMsgHandlerHandshake"],[cr.NativeGenerateAuthResult,"NtvGenAuthRes"],[cr.RemoveHiddenIframe,"RemoveHiddenIframe"],[cr.ClearTokensAndKeysWithClaims,"ClearTAndKeysWithClaims"],[cr.CacheManagerGetRefreshToken,"CacheManagerGetRT"],[cr.GeneratePkceCodes,"GenPkceCodes"],[cr.GenerateCodeVerifier,"GenCodeVerifier"],[cr.GenerateCodeChallengeFromVerifier,"GenCodeChallengeFromVerifier"],[cr.Sha256Digest,"Sha256Digest"],[cr.GetRandomValues,"GetRandomValues"]]),dr=1,hr=2,ur=new Set(["accessTokenSize","durationMs","idTokenSize","matsSilentStatus","matsHttpStatus","refreshTokenSize","queuedTimeMs","startTimeMs","status","multiMatchedAT","multiMatchedID","multiMatchedRT"]),gr=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}try{const n=e(...i);return a?.end({success:!0}),r.trace(`Returning result from ${t}`),n}catch(e){r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}},pr=(e,t,r,n,o)=>(...i)=>{r.trace(`Executing function ${t}`);const a=n?.startMeasurement(t,o);if(o){const e=t+"CallCount";n?.incrementFields({[e]:1},o)}return n?.setPreQueueTime(t,o),e(...i).then((e=>(r.trace(`Returning result from ${t}`),a?.end({success:!0}),e))).catch((e=>{r.trace(`Error occurred in ${t}`);try{r.trace(JSON.stringify(e))}catch(e){r.trace("Unable to print error message.")}throw a?.end({success:!1},e),e}))};
/*! @azure/msal-common v14.13.0 2024-07-12 */
class mr{constructor(e,t,r,n){this.networkInterface=e,this.logger=t,this.performanceClient=r,this.correlationId=n}async detectRegion(e,r){this.performanceClient?.addQueueMeasurement(cr.RegionDiscoveryDetectRegion,this.correlationId);let n=e;if(n)r.region_source=ie;else{const e=mr.IMDS_OPTIONS;try{const o=await pr(this.getRegionFromIMDS.bind(this),cr.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t.IMDS_VERSION,e);if(o.status===re&&(n=o.body,r.region_source=ae),o.status===ne){const t=await pr(this.getCurrentVersion.bind(this),cr.RegionDiscoveryGetCurrentVersion,this.logger,this.performanceClient,this.correlationId)(e);if(!t)return r.region_source=oe,null;const o=await pr(this.getRegionFromIMDS.bind(this),cr.RegionDiscoveryGetRegionFromIMDS,this.logger,this.performanceClient,this.correlationId)(t,e);o.status===re&&(n=o.body,r.region_source=ae)}}catch(e){return r.region_source=oe,null}}return n||(r.region_source=oe),n||null}async getRegionFromIMDS(e,r){return this.performanceClient?.addQueueMeasurement(cr.RegionDiscoveryGetRegionFromIMDS,this.correlationId),this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?api-version=${e}&format=text`,r,t.IMDS_TIMEOUT)}async getCurrentVersion(e){this.performanceClient?.addQueueMeasurement(cr.RegionDiscoveryGetCurrentVersion,this.correlationId);try{const r=await this.networkInterface.sendGetRequestAsync(`${t.IMDS_ENDPOINT}?format=json`,e);return r.status===ne&&r.body&&r.body["newest-versions"]&&r.body["newest-versions"].length>0?r.body["newest-versions"][0]:null}catch(e){return null}}}
/*! @azure/msal-common v14.13.0 2024-07-12 */
function fr(){return Math.round((new Date).getTime()/1e3)}function Cr(e,t){const r=Number(e)||0;return fr()+t>r}function yr(e){return Number(e)>fr()}
/*! @azure/msal-common v14.13.0 2024-07-12 */function vr(e){return[Rr(e),br(e),_r(e),Pr(e),Mr(e)].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function Tr(e,t,r,n,o){return{credentialType:H.ID_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r,realm:o}}function Ir(e,t,r,n,o,i,a,s,c,l,d,h,u,g,p){const m={homeAccountId:e,credentialType:H.ACCESS_TOKEN,secret:r,cachedAt:fr().toString(),expiresOn:a.toString(),extendedExpiresOn:s.toString(),environment:t,clientId:n,realm:o,target:i,tokenType:d||W.BEARER};if(h&&(m.userAssertionHash=h),l&&(m.refreshOn=l.toString()),g&&(m.requestedClaims=g,m.requestedClaimsHash=p),m.tokenType?.toLowerCase()!==W.BEARER.toLowerCase())switch(m.credentialType=H.ACCESS_TOKEN_WITH_AUTH_SCHEME,m.tokenType){case W.POP:const e=yt(r,c);if(!e?.cnf?.kid)throw Ct(nt);m.keyId=e.cnf.kid;break;case W.SSH:m.keyId=u}return m}function wr(e,t,r,n,o,i,a){const s={credentialType:H.REFRESH_TOKEN,homeAccountId:e,environment:t,clientId:n,secret:r};return i&&(s.userAssertionHash=i),o&&(s.familyId=o),a&&(s.expiresOn=a.toString()),s}function Ar(e){return e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("credentialType")&&e.hasOwnProperty("clientId")&&e.hasOwnProperty("secret")}function kr(e){return!!e&&(Ar(e)&&e.hasOwnProperty("realm")&&e.hasOwnProperty("target")&&(e.credentialType===H.ACCESS_TOKEN||e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME))}function Sr(e){return!!e&&(Ar(e)&&e.hasOwnProperty("realm")&&e.credentialType===H.ID_TOKEN)}function Er(e){return!!e&&(Ar(e)&&e.credentialType===H.REFRESH_TOKEN)}function Rr(e){return[e.homeAccountId,e.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function br(e){const t=e.credentialType===H.REFRESH_TOKEN&&e.familyId||e.clientId;return[e.credentialType,t,e.realm||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}function _r(e){return(e.target||"").toLowerCase()}function Pr(e){return(e.requestedClaimsHash||"").toLowerCase()}function Mr(e){return e.tokenType&&e.tokenType.toLowerCase()!==W.BEARER.toLowerCase()?e.tokenType.toLowerCase():""}function Nr(){return fr()+F}function Or(e,t,r){e.authorization_endpoint=t.authorization_endpoint,e.token_endpoint=t.token_endpoint,e.end_session_endpoint=t.end_session_endpoint,e.issuer=t.issuer,e.endpointsFromNetwork=r,e.jwks_uri=t.jwks_uri}function qr(e,t,r){e.aliases=t.aliases,e.preferred_cache=t.preferred_cache,e.preferred_network=t.preferred_network,e.aliasesFromNetwork=r}function Lr(e){return e.expiresAt<=fr()}
/*! @azure/msal-common v14.13.0 2024-07-12 */mr.IMDS_OPTIONS={headers:{Metadata:"true"}};class Ur{constructor(e,t,r,n,o,i,a,s){this.canonicalAuthority=e,this._canonicalAuthority.validateAsUri(),this.networkInterface=t,this.cacheManager=r,this.authorityOptions=n,this.regionDiscoveryMetadata={region_used:void 0,region_source:void 0,region_outcome:void 0},this.logger=o,this.performanceClient=a,this.correlationId=i,this.managedIdentity=s||!1,this.regionDiscovery=new mr(t,this.logger,this.performanceClient,this.correlationId)}getAuthorityType(e){if(e.HostNameAndPort.endsWith(t.CIAM_AUTH_URL))return At;const r=e.PathSegments;if(r.length)switch(r[0].toLowerCase()){case t.ADFS:return It;case t.DSTS:return wt}return Tt}get authorityType(){return this.getAuthorityType(this.canonicalAuthorityUrlComponents)}get protocolMode(){return this.authorityOptions.protocolMode}get options(){return this.authorityOptions}get canonicalAuthority(){return this._canonicalAuthority.urlString}set canonicalAuthority(e){this._canonicalAuthority=new er(e),this._canonicalAuthority.validateAsUri(),this._canonicalAuthorityUrlComponents=null}get canonicalAuthorityUrlComponents(){return this._canonicalAuthorityUrlComponents||(this._canonicalAuthorityUrlComponents=this._canonicalAuthority.getUrlComponents()),this._canonicalAuthorityUrlComponents}get hostnameAndPort(){return this.canonicalAuthorityUrlComponents.HostNameAndPort.toLowerCase()}get tenant(){return this.canonicalAuthorityUrlComponents.PathSegments[0]}get authorizationEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.authorization_endpoint);throw Ct(Re)}get tokenEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint);throw Ct(Re)}get deviceCodeEndpoint(){if(this.discoveryComplete())return this.replacePath(this.metadata.token_endpoint.replace("/token","/devicecode"));throw Ct(Re)}get endSessionEndpoint(){if(this.discoveryComplete()){if(!this.metadata.end_session_endpoint)throw Ct(at);return this.replacePath(this.metadata.end_session_endpoint)}throw Ct(Re)}get selfSignedJwtAudience(){if(this.discoveryComplete())return this.replacePath(this.metadata.issuer);throw Ct(Re)}get jwksUri(){if(this.discoveryComplete())return this.replacePath(this.metadata.jwks_uri);throw Ct(Re)}canReplaceTenant(e){return 1===e.PathSegments.length&&!Ur.reservedTenantDomains.has(e.PathSegments[0])&&this.getAuthorityType(e)===Tt&&this.protocolMode===ar.AAD}replaceTenant(e){return e.replace(/{tenant}|{tenantid}/g,this.tenant)}replacePath(e){let t=e;const r=new er(this.metadata.canonical_authority).getUrlComponents(),n=r.PathSegments;return this.canonicalAuthorityUrlComponents.PathSegments.forEach(((e,o)=>{let i=n[o];if(0===o&&this.canReplaceTenant(r)){const e=new er(this.metadata.authorization_endpoint).getUrlComponents().PathSegments[0];i!==e&&(this.logger.verbose(`Replacing tenant domain name ${i} with id ${e}`),i=e)}e!==i&&(t=t.replace(`/${i}/`,`/${e}/`))})),this.replaceTenant(t)}get defaultOpenIdConfigurationEndpoint(){const e=this.hostnameAndPort;return this.canonicalAuthority.endsWith("v2.0/")||this.authorityType===It||this.protocolMode!==ar.AAD&&!this.isAliasOfKnownMicrosoftAuthority(e)?`${this.canonicalAuthority}.well-known/openid-configuration`:`${this.canonicalAuthority}v2.0/.well-known/openid-configuration`}discoveryComplete(){return!!this.metadata}async resolveEndpointsAsync(){this.performanceClient?.addQueueMeasurement(cr.AuthorityResolveEndpointsAsync,this.correlationId);const e=this.getCurrentMetadataEntity(),t=await pr(this.updateCloudDiscoveryMetadata.bind(this),cr.AuthorityUpdateCloudDiscoveryMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.canonicalAuthority=this.canonicalAuthority.replace(this.hostnameAndPort,e.preferred_network);const r=await pr(this.updateEndpointMetadata.bind(this),cr.AuthorityUpdateEndpointMetadata,this.logger,this.performanceClient,this.correlationId)(e);this.updateCachedMetadata(e,t,{source:r}),this.performanceClient?.addFields({cloudDiscoverySource:t,authorityEndpointSource:r},this.correlationId)}getCurrentMetadataEntity(){let e=this.cacheManager.getAuthorityMetadataByAlias(this.hostnameAndPort);return e||(e={aliases:[],preferred_cache:this.hostnameAndPort,preferred_network:this.hostnameAndPort,canonical_authority:this.canonicalAuthority,authorization_endpoint:"",token_endpoint:"",end_session_endpoint:"",issuer:"",aliasesFromNetwork:!1,endpointsFromNetwork:!1,expiresAt:Nr(),jwks_uri:""}),e}updateCachedMetadata(e,t,r){t!==z&&r?.source!==z&&(e.expiresAt=Nr(),e.canonical_authority=this.canonicalAuthority);const n=this.cacheManager.generateAuthorityMetadataCacheKey(e.preferred_cache);this.cacheManager.setAuthorityMetadata(n,e),this.metadata=e}async updateEndpointMetadata(e){this.performanceClient?.addQueueMeasurement(cr.AuthorityUpdateEndpointMetadata,this.correlationId);const t=this.updateEndpointMetadataFromLocalSources(e);if(t){if(t.source===$&&this.authorityOptions.azureRegionConfiguration?.azureRegion&&t.metadata){Or(e,await pr(this.updateMetadataWithRegionalInformation.bind(this),cr.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(t.metadata),!1),e.canonical_authority=this.canonicalAuthority}return t.source}let r=await pr(this.getEndpointMetadataFromNetwork.bind(this),cr.AuthorityGetEndpointMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return this.authorityOptions.azureRegionConfiguration?.azureRegion&&(r=await pr(this.updateMetadataWithRegionalInformation.bind(this),cr.AuthorityUpdateMetadataWithRegionalInformation,this.logger,this.performanceClient,this.correlationId)(r)),Or(e,r,!0),G;throw Ct(_e,this.defaultOpenIdConfigurationEndpoint)}updateEndpointMetadataFromLocalSources(e){this.logger.verbose("Attempting to get endpoint metadata from authority configuration");const t=this.getEndpointMetadataFromConfig();if(t)return this.logger.verbose("Found endpoint metadata in authority configuration"),Or(e,t,!1),{source:K};if(this.logger.verbose("Did not find endpoint metadata in the config... Attempting to get endpoint metadata from the hardcoded values."),this.authorityOptions.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get endpoint metadata from the network metadata cache.");else{const t=this.getEndpointMetadataFromHardcodedValues();if(t)return Or(e,t,!1),{source:$,metadata:t};this.logger.verbose("Did not find endpoint metadata in hardcoded values... Attempting to get endpoint metadata from the network metadata cache.")}const r=Lr(e);return this.isAuthoritySameType(e)&&e.endpointsFromNetwork&&!r?(this.logger.verbose("Found endpoint metadata in the cache."),{source:z}):(r&&this.logger.verbose("The metadata entity is expired."),null)}isAuthoritySameType(e){return new er(e.canonical_authority).getUrlComponents().PathSegments.length===this.canonicalAuthorityUrlComponents.PathSegments.length}getEndpointMetadataFromConfig(){if(this.authorityOptions.authorityMetadata)try{return JSON.parse(this.authorityOptions.authorityMetadata)}catch(e){throw Yt(Ht)}return null}async getEndpointMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(cr.AuthorityGetEndpointMetadataFromNetwork,this.correlationId);const e={},t=this.defaultOpenIdConfigurationEndpoint;this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: attempting to retrieve OAuth endpoints from ${t}`);try{const r=await this.networkInterface.sendGetRequestAsync(t,e),n=function(e){return e.hasOwnProperty("authorization_endpoint")&&e.hasOwnProperty("token_endpoint")&&e.hasOwnProperty("issuer")&&e.hasOwnProperty("jwks_uri")}(r.body);return n?r.body:(this.logger.verbose("Authority.getEndpointMetadataFromNetwork: could not parse response as OpenID configuration"),null)}catch(e){return this.logger.verbose(`Authority.getEndpointMetadataFromNetwork: ${e}`),null}}getEndpointMetadataFromHardcodedValues(){return this.hostnameAndPort in tr?tr[this.hostnameAndPort]:null}async updateMetadataWithRegionalInformation(e){this.performanceClient?.addQueueMeasurement(cr.AuthorityUpdateMetadataWithRegionalInformation,this.correlationId);const r=this.authorityOptions.azureRegionConfiguration?.azureRegion;if(r){if(r!==t.AZURE_REGION_AUTO_DISCOVER_FLAG)return this.regionDiscoveryMetadata.region_outcome=se,this.regionDiscoveryMetadata.region_used=r,Ur.replaceWithRegionalInformation(e,r);const n=await pr(this.regionDiscovery.detectRegion.bind(this.regionDiscovery),cr.RegionDiscoveryDetectRegion,this.logger,this.performanceClient,this.correlationId)(this.authorityOptions.azureRegionConfiguration?.environmentRegion,this.regionDiscoveryMetadata);if(n)return this.regionDiscoveryMetadata.region_outcome=ce,this.regionDiscoveryMetadata.region_used=n,Ur.replaceWithRegionalInformation(e,n);this.regionDiscoveryMetadata.region_outcome=le}return e}async updateCloudDiscoveryMetadata(e){this.performanceClient?.addQueueMeasurement(cr.AuthorityUpdateCloudDiscoveryMetadata,this.correlationId);const t=this.updateCloudDiscoveryMetadataFromLocalSources(e);if(t)return t;const r=await pr(this.getCloudDiscoveryMetadataFromNetwork.bind(this),cr.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.logger,this.performanceClient,this.correlationId)();if(r)return qr(e,r,!0),G;throw Yt(Bt)}updateCloudDiscoveryMetadataFromLocalSources(e){this.logger.verbose("Attempting to get cloud discovery metadata  from authority configuration"),this.logger.verbosePii(`Known Authorities: ${this.authorityOptions.knownAuthorities||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Authority Metadata: ${this.authorityOptions.authorityMetadata||t.NOT_APPLICABLE}`),this.logger.verbosePii(`Canonical Authority: ${e.canonical_authority||t.NOT_APPLICABLE}`);const r=this.getCloudDiscoveryMetadataFromConfig();if(r)return this.logger.verbose("Found cloud discovery metadata in authority configuration"),qr(e,r,!1),K;if(this.logger.verbose("Did not find cloud discovery metadata in the config... Attempting to get cloud discovery metadata from the hardcoded values."),this.options.skipAuthorityMetadataCache)this.logger.verbose("Skipping hardcoded cloud discovery metadata cache since skipAuthorityMetadataCache is set to true. Attempting to get cloud discovery metadata from the network metadata cache.");else{const t=(n=this.hostnameAndPort,ir(rr.metadata,n));if(t)return this.logger.verbose("Found cloud discovery metadata from hardcoded values."),qr(e,t,!1),$;this.logger.verbose("Did not find cloud discovery metadata in hardcoded values... Attempting to get cloud discovery metadata from the network metadata cache.")}var n;const o=Lr(e);return this.isAuthoritySameType(e)&&e.aliasesFromNetwork&&!o?(this.logger.verbose("Found cloud discovery metadata in the cache."),z):(o&&this.logger.verbose("The metadata entity is expired."),null)}getCloudDiscoveryMetadataFromConfig(){if(this.authorityType===At)return this.logger.verbose("CIAM authorities do not support cloud discovery metadata, generate the aliases from authority host."),Ur.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort);if(this.authorityOptions.cloudDiscoveryMetadata){this.logger.verbose("The cloud discovery metadata has been provided as a network response, in the config.");try{this.logger.verbose("Attempting to parse the cloud discovery metadata.");const e=ir(JSON.parse(this.authorityOptions.cloudDiscoveryMetadata).metadata,this.hostnameAndPort);if(this.logger.verbose("Parsed the cloud discovery metadata."),e)return this.logger.verbose("There is returnable metadata attached to the parsed cloud discovery metadata."),e;this.logger.verbose("There is no metadata attached to the parsed cloud discovery metadata.")}catch(e){throw this.logger.verbose("Unable to parse the cloud discovery metadata. Throwing Invalid Cloud Discovery Metadata Error."),Yt(Ut)}}return this.isInKnownAuthorities()?(this.logger.verbose("The host is included in knownAuthorities. Creating new cloud discovery metadata from the host."),Ur.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)):null}async getCloudDiscoveryMetadataFromNetwork(){this.performanceClient?.addQueueMeasurement(cr.AuthorityGetCloudDiscoveryMetadataFromNetwork,this.correlationId);const e=`${t.AAD_INSTANCE_DISCOVERY_ENDPT}${this.canonicalAuthority}oauth2/v2.0/authorize`,r={};let n=null;try{const o=await this.networkInterface.sendGetRequestAsync(e,r);let i,a;if(
/*! @azure/msal-common v14.13.0 2024-07-12 */
function(e){return e.hasOwnProperty("tenant_discovery_endpoint")&&e.hasOwnProperty("metadata")}
/*! @azure/msal-common v14.13.0 2024-07-12 */(o.body))i=o.body,a=i.metadata,this.logger.verbosePii(`tenant_discovery_endpoint is: ${i.tenant_discovery_endpoint}`);else{if(!function(e){return e.hasOwnProperty("error")&&e.hasOwnProperty("error_description")}(o.body))return this.logger.error("AAD did not return a CloudInstanceDiscoveryResponse or CloudInstanceDiscoveryErrorResponse"),null;if(this.logger.warning(`A CloudInstanceDiscoveryErrorResponse was returned. The cloud instance discovery network request's status code is: ${o.status}`),i=o.body,i.error===t.INVALID_INSTANCE)return this.logger.error("The CloudInstanceDiscoveryErrorResponse error is invalid_instance."),null;this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error is ${i.error}`),this.logger.warning(`The CloudInstanceDiscoveryErrorResponse error description is ${i.error_description}`),this.logger.warning("Setting the value of the CloudInstanceDiscoveryMetadata (returned from the network) to []"),a=[]}this.logger.verbose("Attempting to find a match between the developer's authority and the CloudInstanceDiscoveryMetadata returned from the network request."),n=ir(a,this.hostnameAndPort)}catch(e){if(e instanceof Ie)this.logger.error(`There was a network error while attempting to get the cloud discovery instance metadata.\nError: ${e.errorCode}\nError Description: ${e.errorMessage}`);else{const t=e;this.logger.error(`A non-MSALJS error was thrown while attempting to get the cloud instance discovery metadata.\nError: ${t.name}\nError Description: ${t.message}`)}return null}return n||(this.logger.warning("The developer's authority was not found within the CloudInstanceDiscoveryMetadata returned from the network request."),this.logger.verbose("Creating custom Authority for custom domain scenario."),n=Ur.createCloudDiscoveryMetadataFromHost(this.hostnameAndPort)),n}isInKnownAuthorities(){return this.authorityOptions.knownAuthorities.filter((e=>e&&er.getDomainFromUrl(e).toLowerCase()===this.hostnameAndPort)).length>0}static generateAuthority(e,r){let n;if(r&&r.azureCloudInstance!==sr.None){const e=r.tenant?r.tenant:t.DEFAULT_COMMON_TENANT;n=`${r.azureCloudInstance}/${e}/`}return n||e}static createCloudDiscoveryMetadataFromHost(e){return{preferred_network:e,preferred_cache:e,aliases:[e]}}getPreferredCache(){if(this.managedIdentity)return t.DEFAULT_AUTHORITY_HOST;if(this.discoveryComplete())return this.metadata.preferred_cache;throw Ct(Re)}isAlias(e){return this.metadata.aliases.indexOf(e)>-1}isAliasOfKnownMicrosoftAuthority(e){return nr.has(e)}static isPublicCloudAuthority(e){return t.KNOWN_PUBLIC_CLOUDS.indexOf(e)>=0}static buildRegionalAuthorityString(e,r,n){const o=new er(e);o.validateAsUri();const i=o.getUrlComponents();let a=`${r}.${i.HostNameAndPort}`;this.isPublicCloudAuthority(i.HostNameAndPort)&&(a=`${r}.${t.REGIONAL_AUTH_PUBLIC_CLOUD_SUFFIX}`);const s=er.constructAuthorityUriFromObject({...o.getUrlComponents(),HostNameAndPort:a}).urlString;return n?`${s}?${n}`:s}static replaceWithRegionalInformation(e,t){const r={...e};return r.authorization_endpoint=Ur.buildRegionalAuthorityString(r.authorization_endpoint,t),r.token_endpoint=Ur.buildRegionalAuthorityString(r.token_endpoint,t),r.end_session_endpoint&&(r.end_session_endpoint=Ur.buildRegionalAuthorityString(r.end_session_endpoint,t)),r}static transformCIAMAuthority(e){let r=e;const n=new er(e).getUrlComponents();if(0===n.PathSegments.length&&n.HostNameAndPort.endsWith(t.CIAM_AUTH_URL)){r=`${r}${n.HostNameAndPort.split(".")[0]}${t.AAD_TENANT_DOMAIN_SUFFIX}`}return r}}function Hr(e){return e.endsWith(t.FORWARD_SLASH)?e:`${e}${t.FORWARD_SLASH}`}function Br(e){const t=e.cloudDiscoveryMetadata;let r;if(t)try{r=JSON.parse(t)}catch(e){throw Yt(Ut)}return{canonicalAuthority:e.authority?Hr(e.authority):void 0,knownAuthorities:e.knownAuthorities,cloudDiscoveryMetadata:r}}
/*! @azure/msal-common v14.13.0 2024-07-12 */async function Dr(e,t,r,n,o,i,a){a?.addQueueMeasurement(cr.AuthorityFactoryCreateDiscoveredInstance,i);const s=Ur.transformCIAMAuthority(Hr(e)),c=new Ur(s,t,r,n,o,i,a);try{return await pr(c.resolveEndpointsAsync.bind(c),cr.AuthorityResolveEndpointsAsync,o,a,i)(),c}catch(e){throw Ct(Re)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */async function xr(e,t,r){if("string"==typeof e)return e;return e({clientId:t,tokenEndpoint:r})}
/*! @azure/msal-common v14.13.0 2024-07-12 */Ur.reservedTenantDomains=new Set(["{tenant}","{tenantid}",w,k,A]);const Fr="client_id",Kr="response_type",zr="token_type",Gr="req_cnf",$r="return_spa_code",Qr={createNewGuid:()=>{throw Ct(ht)},base64Decode:()=>{throw Ct(ht)},base64Encode:()=>{throw Ct(ht)},base64UrlEncode:()=>{throw Ct(ht)},encodeKid:()=>{throw Ct(ht)},async getPublicKeyThumbprint(){throw Ct(ht)},async removeTokenBindingKey(){throw Ct(ht)},async clearKeystore(){throw Ct(ht)},async signJwt(){throw Ct(ht)},async hashString(){throw Ct(ht)}};var Wr;
/*! @azure/msal-common v14.13.0 2024-07-12 */
e.LogLevel=void 0,(Wr=e.LogLevel||(e.LogLevel={}))[Wr.Error=0]="Error",Wr[Wr.Warning=1]="Warning",Wr[Wr.Info=2]="Info",Wr[Wr.Verbose=3]="Verbose",Wr[Wr.Trace=4]="Trace";class jr{constructor(r,n,o){this.level=e.LogLevel.Info;const i=r||jr.createDefaultLoggerOptions();this.localCallback=i.loggerCallback||(()=>{}),this.piiLoggingEnabled=i.piiLoggingEnabled||!1,this.level="number"==typeof i.logLevel?i.logLevel:e.LogLevel.Info,this.correlationId=i.correlationId||t.EMPTY_STRING,this.packageName=n||t.EMPTY_STRING,this.packageVersion=o||t.EMPTY_STRING}static createDefaultLoggerOptions(){return{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info}}clone(e,t,r){return new jr({loggerCallback:this.localCallback,piiLoggingEnabled:this.piiLoggingEnabled,logLevel:this.level,correlationId:r||this.correlationId},e,t)}logMessage(t,r){if(r.logLevel>this.level||!this.piiLoggingEnabled&&r.containsPii)return;const n=`${`[${(new Date).toUTCString()}] : [${r.correlationId||this.correlationId||""}]`} : ${this.packageName}@${this.packageVersion} : ${e.LogLevel[r.logLevel]} - ${t}`;this.executeCallback(r.logLevel,n,r.containsPii||!1)}executeCallback(e,t,r){this.localCallback&&this.localCallback(e,t,r)}error(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!1,correlationId:n||t.EMPTY_STRING})}errorPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Error,containsPii:!0,correlationId:n||t.EMPTY_STRING})}warning(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!1,correlationId:n||t.EMPTY_STRING})}warningPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Warning,containsPii:!0,correlationId:n||t.EMPTY_STRING})}info(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!1,correlationId:n||t.EMPTY_STRING})}infoPii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Info,containsPii:!0,correlationId:n||t.EMPTY_STRING})}verbose(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!1,correlationId:n||t.EMPTY_STRING})}verbosePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Verbose,containsPii:!0,correlationId:n||t.EMPTY_STRING})}trace(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!1,correlationId:n||t.EMPTY_STRING})}tracePii(r,n){this.logMessage(r,{logLevel:e.LogLevel.Trace,containsPii:!0,correlationId:n||t.EMPTY_STRING})}isPiiLoggingEnabled(){return this.piiLoggingEnabled||!1}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const Vr="@azure/msal-common",Yr="14.13.0";
/*! @azure/msal-common v14.13.0 2024-07-12 */
class Jr{constructor(e){const t=e?Jt.trimArrayEntries([...e]):[],r=t?Jt.removeEmptyStringsFromArray(t):[];this.validateInputScopes(r),this.scopes=new Set,r.forEach((e=>this.scopes.add(e)))}static fromString(e){const r=(e||t.EMPTY_STRING).split(" ");return new Jr(r)}static createSearchScopes(e){const r=new Jr(e);return r.containsOnlyOIDCScopes()?r.removeScope(t.OFFLINE_ACCESS_SCOPE):r.removeOIDCScopes(),r}validateInputScopes(e){if(!e||e.length<1)throw Yt(_t)}containsScope(e){const t=this.printScopesLowerCase().split(" "),r=new Jr(t);return!!e&&r.scopes.has(e.toLowerCase())}containsScopeSet(e){return!(!e||e.scopes.size<=0)&&(this.scopes.size>=e.scopes.size&&e.asArray().every((e=>this.containsScope(e))))}containsOnlyOIDCScopes(){let e=0;return s.forEach((t=>{this.containsScope(t)&&(e+=1)})),this.scopes.size===e}appendScope(e){e&&this.scopes.add(e.trim())}appendScopes(e){try{e.forEach((e=>this.appendScope(e)))}catch(e){throw Ct(Ke)}}removeScope(e){if(!e)throw Ct(Fe);this.scopes.delete(e.trim())}removeOIDCScopes(){s.forEach((e=>{this.scopes.delete(e)}))}unionScopeSets(e){if(!e)throw Ct(ze);const t=new Set;return e.scopes.forEach((e=>t.add(e.toLowerCase()))),this.scopes.forEach((e=>t.add(e.toLowerCase()))),t}intersectingScopeSets(e){if(!e)throw Ct(ze);e.containsOnlyOIDCScopes()||e.removeOIDCScopes();const t=this.unionScopeSets(e),r=e.getScopeCount(),n=this.getScopeCount();return t.size<n+r}getScopeCount(){return this.scopes.size}asArray(){const e=[];return this.scopes.forEach((t=>e.push(t))),e}printScopes(){if(this.scopes){return this.asArray().join(" ")}return t.EMPTY_STRING}printScopesLowerCase(){return this.printScopes().toLowerCase()}}
/*! @azure/msal-common v14.13.0 2024-07-12 */function Xr(e,t){if(!e)throw Ct(ke);try{const r=t(e);return JSON.parse(r)}catch(e){throw Ct(Ae)}}function Zr(e){if(!e)throw Ct(Ae);const r=e.split(U.CLIENT_INFO_SEPARATOR,2);return{uid:r[0],utid:r.length<2?t.EMPTY_STRING:r[1]}}
/*! @azure/msal-common v14.13.0 2024-07-12 */function en(e,t){return!!e&&!!t&&e===t.split(".")[1]}function tn(e,t){const{oid:r,sub:n,tid:o,name:i,tfp:a,acr:s}=t,c=o||a||s||"";return{tenantId:c,localAccountId:r||n||"",name:i,isHomeTenant:en(c,e)}}function rn(e,t,r,n){let o=e;if(t){const{isHomeTenant:r,...n}=t;o={...e,...n}}if(r){const{isHomeTenant:t,...i}=tn(e.homeAccountId,r);return o={...o,...i,idTokenClaims:r,idToken:n},o}return o}
/*! @azure/msal-common v14.13.0 2024-07-12 */function nn(e){if(e){return e.tid||e.tfp||e.acr||null}return null}
/*! @azure/msal-common v14.13.0 2024-07-12 */class on{generateAccountId(){return[this.homeAccountId,this.environment].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}generateAccountKey(){return on.generateAccountCacheKey({homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId})}getAccountInfo(){return{homeAccountId:this.homeAccountId,environment:this.environment,tenantId:this.realm,username:this.username,localAccountId:this.localAccountId,name:this.name,nativeAccountId:this.nativeAccountId,authorityType:this.authorityType,tenantProfiles:new Map((this.tenantProfiles||[]).map((e=>[e.tenantId,e])))}}isSingleTenant(){return!this.tenantProfiles}static generateAccountCacheKey(e){const t=e.homeAccountId.split(".")[1];return[e.homeAccountId,e.environment||"",t||e.tenantId||""].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}static createAccount(e,t,r){const n=new on;let o;t.authorityType===It?n.authorityType=q:t.protocolMode===ar.AAD?n.authorityType=O:n.authorityType=L,e.clientInfo&&r&&(o=Xr(e.clientInfo,r)),n.clientInfo=e.clientInfo,n.homeAccountId=e.homeAccountId,n.nativeAccountId=e.nativeAccountId;const i=e.environment||t&&t.getPreferredCache();if(!i)throw Ct(Ve);n.environment=i,n.realm=o?.utid||nn(e.idTokenClaims)||"",n.localAccountId=o?.uid||e.idTokenClaims?.oid||e.idTokenClaims?.sub||"";const a=e.idTokenClaims?.preferred_username||e.idTokenClaims?.upn,s=e.idTokenClaims?.emails?e.idTokenClaims.emails[0]:null;if(n.username=a||s||"",n.name=e.idTokenClaims?.name||"",n.cloudGraphHostName=e.cloudGraphHostName,n.msGraphHost=e.msGraphHost,e.tenantProfiles)n.tenantProfiles=e.tenantProfiles;else{const t=[];if(e.idTokenClaims){const r=tn(e.homeAccountId,e.idTokenClaims);t.push(r)}n.tenantProfiles=t}return n}static createFromAccountInfo(e,t,r){const n=new on;return n.authorityType=e.authorityType||L,n.homeAccountId=e.homeAccountId,n.localAccountId=e.localAccountId,n.nativeAccountId=e.nativeAccountId,n.realm=e.tenantId,n.environment=e.environment,n.username=e.username,n.name=e.name,n.cloudGraphHostName=t,n.msGraphHost=r,n.tenantProfiles=Array.from(e.tenantProfiles?.values()||[]),n}static generateHomeAccountId(e,t,r,n,o){if(t!==It&&t!==wt){if(e)try{const t=Xr(e,n.base64Decode);if(t.uid&&t.utid)return`${t.uid}.${t.utid}`}catch(e){}r.warning("No client info in response")}return o?.sub||""}static isAccountEntity(e){return!!e&&(e.hasOwnProperty("homeAccountId")&&e.hasOwnProperty("environment")&&e.hasOwnProperty("realm")&&e.hasOwnProperty("localAccountId")&&e.hasOwnProperty("username")&&e.hasOwnProperty("authorityType"))}static accountInfoIsEqual(e,t,r){if(!e||!t)return!1;let n=!0;if(r){const r=e.idTokenClaims||{},o=t.idTokenClaims||{};n=r.iat===o.iat&&r.nonce===o.nonce}return e.homeAccountId===t.homeAccountId&&e.localAccountId===t.localAccountId&&e.username===t.username&&e.tenantId===t.tenantId&&e.environment===t.environment&&e.nativeAccountId===t.nativeAccountId&&n}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const an="cache_quota_exceeded",sn="cache_error_unknown",cn={[an]:"Exceeded cache storage capacity.",[sn]:"Unexpected error occurred when using cache storage."};class ln extends Error{constructor(e,t){const r=t||(cn[e]?cn[e]:cn[sn]);super(`${e}: ${r}`),Object.setPrototypeOf(this,ln.prototype),this.name="CacheError",this.errorCode=e,this.errorMessage=r}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class dn{constructor(e,t,r,n){this.clientId=e,this.cryptoImpl=t,this.commonLogger=r.clone(Vr,Yr),this.staticAuthorityOptions=n}getAllAccounts(e){return this.buildTenantProfiles(this.getAccountsFilteredBy(e||{}),e)}getAccountInfoFilteredBy(e){const t=this.getAllAccounts(e);if(t.length>1){return t.sort((e=>e.idTokenClaims?-1:1))[0]}return 1===t.length?t[0]:null}getBaseAccountInfo(e){const t=this.getAccountsFilteredBy(e);return t.length>0?t[0].getAccountInfo():null}buildTenantProfiles(e,t){return e.flatMap((e=>this.getAccountInfoForTenantProfiles(e,t)))}getAccountInfoForTenantProfiles(e,t){return this.getTenantProfilesFromAccountEntity(e,t?.tenantId,t)}getTenantedAccountInfoByFilter(e,t,r,n){let o,i=null;if(n&&!this.tenantProfileMatchesFilter(r,n))return null;const a=this.getIdToken(e,t,r.tenantId);return a&&(o=yt(a.secret,this.cryptoImpl.base64Decode),!this.idTokenClaimsMatchTenantProfileFilter(o,n))?null:(i=rn(e,r,o,a?.secret),i)}getTenantProfilesFromAccountEntity(e,t,r){const n=e.getAccountInfo();let o=n.tenantProfiles||new Map;const i=this.getTokenKeys();if(t){const e=o.get(t);if(!e)return[];o=new Map([[t,e]])}const a=[];return o.forEach((e=>{const t=this.getTenantedAccountInfoByFilter(n,i,e,r);t&&a.push(t)})),a}tenantProfileMatchesFilter(e,t){return!(t.localAccountId&&!this.matchLocalAccountIdFromTenantProfile(e,t.localAccountId))&&((!t.name||e.name===t.name)&&(void 0===t.isHomeTenant||e.isHomeTenant===t.isHomeTenant))}idTokenClaimsMatchTenantProfileFilter(e,t){if(t){if(t.localAccountId&&!this.matchLocalAccountIdFromTokenClaims(e,t.localAccountId))return!1;if(t.loginHint&&!this.matchLoginHintFromTokenClaims(e,t.loginHint))return!1;if(t.username&&!this.matchUsername(e.preferred_username,t.username))return!1;if(t.name&&!this.matchName(e,t.name))return!1;if(t.sid&&!this.matchSid(e,t.sid))return!1}return!0}async saveCacheRecord(e,t,r){if(!e)throw Ct(je);try{e.account&&this.setAccount(e.account),e.idToken&&!1!==t?.idToken&&this.setIdTokenCredential(e.idToken),e.accessToken&&!1!==t?.accessToken&&await this.saveAccessToken(e.accessToken),e.refreshToken&&!1!==t?.refreshToken&&this.setRefreshTokenCredential(e.refreshToken),e.appMetadata&&this.setAppMetadata(e.appMetadata)}catch(e){throw this.commonLogger?.error("CacheManager.saveCacheRecord: failed"),e instanceof Error?(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e.message}`,r),"QuotaExceededError"===e.name||"NS_ERROR_DOM_QUOTA_REACHED"===e.name||e.message.includes("exceeded the quota")?(this.commonLogger?.error("CacheManager.saveCacheRecord: exceeded storage quota",r),new ln(an)):new ln(e.name,e.message)):(this.commonLogger?.errorPii(`CacheManager.saveCacheRecord: ${e}`,r),new ln(sn))}}async saveAccessToken(e){const t={clientId:e.clientId,credentialType:e.credentialType,environment:e.environment,homeAccountId:e.homeAccountId,realm:e.realm,tokenType:e.tokenType,requestedClaimsHash:e.requestedClaimsHash},r=this.getTokenKeys(),n=Jr.fromString(e.target),o=[];r.accessToken.forEach((e=>{if(!this.accessTokenKeyMatchesFilter(e,t,!1))return;const r=this.getAccessTokenCredential(e);if(r&&this.credentialMatchesFilter(r,t)){Jr.fromString(r.target).intersectingScopeSets(n)&&o.push(this.removeAccessToken(e))}})),await Promise.all(o),this.setAccessTokenCredential(e)}getAccountsFilteredBy(e){const t=this.getAccountKeys(),r=[];return t.forEach((t=>{if(!this.isAccountKey(t,e.homeAccountId))return;const n=this.getAccount(t,this.commonLogger);if(!n)return;if(e.homeAccountId&&!this.matchHomeAccountId(n,e.homeAccountId))return;if(e.username&&!this.matchUsername(n.username,e.username))return;if(e.environment&&!this.matchEnvironment(n,e.environment))return;if(e.realm&&!this.matchRealm(n,e.realm))return;if(e.nativeAccountId&&!this.matchNativeAccountId(n,e.nativeAccountId))return;if(e.authorityType&&!this.matchAuthorityType(n,e.authorityType))return;const o={localAccountId:e?.localAccountId,name:e?.name},i=n.tenantProfiles?.filter((e=>this.tenantProfileMatchesFilter(e,o)));i&&0===i.length||r.push(n)})),r}isAccountKey(e,t,r){return!(e.split(U.CACHE_KEY_SEPARATOR).length<3)&&(!(t&&!e.toLowerCase().includes(t.toLowerCase()))&&!(r&&!e.toLowerCase().includes(r.toLowerCase())))}isCredentialKey(e){if(e.split(U.CACHE_KEY_SEPARATOR).length<6)return!1;const t=e.toLowerCase();if(-1===t.indexOf(H.ID_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN.toLowerCase())&&-1===t.indexOf(H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase())&&-1===t.indexOf(H.REFRESH_TOKEN.toLowerCase()))return!1;if(t.indexOf(H.REFRESH_TOKEN.toLowerCase())>-1){const e=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${this.clientId}${U.CACHE_KEY_SEPARATOR}`,r=`${H.REFRESH_TOKEN}${U.CACHE_KEY_SEPARATOR}${D}${U.CACHE_KEY_SEPARATOR}`;if(-1===t.indexOf(e.toLowerCase())&&-1===t.indexOf(r.toLowerCase()))return!1}else if(-1===t.indexOf(this.clientId.toLowerCase()))return!1;return!0}credentialMatchesFilter(e,t){if(t.clientId&&!this.matchClientId(e,t.clientId))return!1;if(t.userAssertionHash&&!this.matchUserAssertionHash(e,t.userAssertionHash))return!1;if("string"==typeof t.homeAccountId&&!this.matchHomeAccountId(e,t.homeAccountId))return!1;if(t.environment&&!this.matchEnvironment(e,t.environment))return!1;if(t.realm&&!this.matchRealm(e,t.realm))return!1;if(t.credentialType&&!this.matchCredentialType(e,t.credentialType))return!1;if(t.familyId&&!this.matchFamilyId(e,t.familyId))return!1;if(t.target&&!this.matchTarget(e,t.target))return!1;if((t.requestedClaimsHash||e.requestedClaimsHash)&&e.requestedClaimsHash!==t.requestedClaimsHash)return!1;if(e.credentialType===H.ACCESS_TOKEN_WITH_AUTH_SCHEME){if(t.tokenType&&!this.matchTokenType(e,t.tokenType))return!1;if(t.tokenType===W.SSH&&t.keyId&&!this.matchKeyId(e,t.keyId))return!1}return!0}getAppMetadataFilteredBy(e){const t=this.getKeys(),r={};return t.forEach((t=>{if(!this.isAppMetadata(t))return;const n=this.getAppMetadata(t);n&&(e.environment&&!this.matchEnvironment(n,e.environment)||e.clientId&&!this.matchClientId(n,e.clientId)||(r[t]=n))})),r}getAuthorityMetadataByAlias(e){const t=this.getAuthorityMetadataKeys();let r=null;return t.forEach((t=>{if(!this.isAuthorityMetadata(t)||-1===t.indexOf(this.clientId))return;const n=this.getAuthorityMetadata(t);n&&-1!==n.aliases.indexOf(e)&&(r=n)})),r}async removeAllAccounts(){const e=this.getAccountKeys(),t=[];e.forEach((e=>{t.push(this.removeAccount(e))})),await Promise.all(t)}async removeAccount(e){const t=this.getAccount(e,this.commonLogger);t&&(await this.removeAccountContext(t),this.removeItem(e))}async removeAccountContext(e){const t=this.getTokenKeys(),r=e.generateAccountId(),n=[];t.idToken.forEach((e=>{0===e.indexOf(r)&&this.removeIdToken(e)})),t.accessToken.forEach((e=>{0===e.indexOf(r)&&n.push(this.removeAccessToken(e))})),t.refreshToken.forEach((e=>{0===e.indexOf(r)&&this.removeRefreshToken(e)})),await Promise.all(n)}updateOutdatedCachedAccount(e,t,r){if(t&&t.isSingleTenant()){this.commonLogger?.verbose("updateOutdatedCachedAccount: Found a single-tenant (outdated) account entity in the cache, migrating to multi-tenant account entity");const n=this.getAccountKeys().filter((e=>e.startsWith(t.homeAccountId))),o=[];n.forEach((e=>{const t=this.getCachedAccountEntity(e);t&&o.push(t)}));const i=o.find((e=>en(e.realm,e.homeAccountId)))||o[0];i.tenantProfiles=o.map((e=>({tenantId:e.realm,localAccountId:e.localAccountId,name:e.name,isHomeTenant:en(e.realm,e.homeAccountId)})));const a=dn.toObject(new on,{...i}),s=a.generateAccountKey();return n.forEach((t=>{t!==s&&this.removeOutdatedAccount(e)})),this.setAccount(a),r?.verbose("Updated an outdated account entity in the cache"),a}return t}async removeAccessToken(e){const t=this.getAccessTokenCredential(e);if(t){if(t.credentialType.toLowerCase()===H.ACCESS_TOKEN_WITH_AUTH_SCHEME.toLowerCase()&&t.tokenType===W.POP){const e=t.keyId;if(e)try{await this.cryptoImpl.removeTokenBindingKey(e)}catch(e){throw Ct(it)}}return this.removeItem(e)}}removeAppMetadata(){return this.getKeys().forEach((e=>{this.isAppMetadata(e)&&this.removeItem(e)})),!0}readAccountFromCache(e){const t=on.generateAccountCacheKey(e);return this.getAccount(t,this.commonLogger)}getIdToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getIdToken called");const i={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.ID_TOKEN,clientId:this.clientId,realm:r},a=this.getIdTokensByFilter(i,t),s=a.size;if(s<1)return this.commonLogger.info("CacheManager:getIdToken - No token found"),null;if(s>1){let t=a;if(!r){const r=new Map;a.forEach(((t,n)=>{t.realm===e.tenantId&&r.set(n,t)}));const n=r.size;if(n<1)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account but none match account entity tenant id, returning first result"),a.values().next().value;if(1===n)return this.commonLogger.info("CacheManager:getIdToken - Multiple ID tokens found for account, defaulting to home tenant profile"),r.values().next().value;t=r}return this.commonLogger.info("CacheManager:getIdToken - Multiple matching ID tokens found, clearing them"),t.forEach(((e,t)=>{this.removeIdToken(t)})),n&&o&&n.addFields({multiMatchedID:a.size},o),null}return this.commonLogger.info("CacheManager:getIdToken - Returning ID token"),a.values().next().value}getIdTokensByFilter(e,t){const r=t&&t.idToken||this.getTokenKeys().idToken,n=new Map;return r.forEach((t=>{if(!this.idTokenKeyMatchesFilter(t,{clientId:this.clientId,...e}))return;const r=this.getIdTokenCredential(t);r&&this.credentialMatchesFilter(r,e)&&n.set(t,r)})),n}idTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.clientId||-1!==r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase()))}removeIdToken(e){this.removeItem(e)}removeRefreshToken(e){this.removeItem(e)}getAccessToken(e,t,r,n,o,i){this.commonLogger.trace("CacheManager - getAccessToken called");const a=Jr.createSearchScopes(t.scopes),s=t.authenticationScheme||W.BEARER,c=s&&s.toLowerCase()!==W.BEARER.toLowerCase()?H.ACCESS_TOKEN_WITH_AUTH_SCHEME:H.ACCESS_TOKEN,l={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:c,clientId:this.clientId,realm:n||e.tenantId,target:a,tokenType:s,keyId:t.sshKid,requestedClaimsHash:t.requestedClaimsHash},d=r&&r.accessToken||this.getTokenKeys().accessToken,h=[];d.forEach((e=>{if(this.accessTokenKeyMatchesFilter(e,l,!0)){const t=this.getAccessTokenCredential(e);t&&this.credentialMatchesFilter(t,l)&&h.push(t)}}));const u=h.length;return u<1?(this.commonLogger.info("CacheManager:getAccessToken - No token found"),null):u>1?(this.commonLogger.info("CacheManager:getAccessToken - Multiple access tokens found, clearing them"),h.forEach((e=>{this.removeAccessToken(vr(e))})),o&&i&&o.addFields({multiMatchedAT:h.length},i),null):(this.commonLogger.info("CacheManager:getAccessToken - Returning access token"),h[0])}accessTokenKeyMatchesFilter(e,t,r){const n=e.toLowerCase();if(t.clientId&&-1===n.indexOf(t.clientId.toLowerCase()))return!1;if(t.homeAccountId&&-1===n.indexOf(t.homeAccountId.toLowerCase()))return!1;if(t.realm&&-1===n.indexOf(t.realm.toLowerCase()))return!1;if(t.requestedClaimsHash&&-1===n.indexOf(t.requestedClaimsHash.toLowerCase()))return!1;if(t.target){const e=t.target.asArray();for(let t=0;t<e.length;t++){if(r&&!n.includes(e[t].toLowerCase()))return!1;if(!r&&n.includes(e[t].toLowerCase()))return!0}}return!0}getAccessTokensByFilter(e){const t=this.getTokenKeys(),r=[];return t.accessToken.forEach((t=>{if(!this.accessTokenKeyMatchesFilter(t,e,!0))return;const n=this.getAccessTokenCredential(t);n&&this.credentialMatchesFilter(n,e)&&r.push(n)})),r}getRefreshToken(e,t,r,n,o){this.commonLogger.trace("CacheManager - getRefreshToken called");const i=t?D:void 0,a={homeAccountId:e.homeAccountId,environment:e.environment,credentialType:H.REFRESH_TOKEN,clientId:this.clientId,familyId:i},s=r&&r.refreshToken||this.getTokenKeys().refreshToken,c=[];s.forEach((e=>{if(this.refreshTokenKeyMatchesFilter(e,a)){const t=this.getRefreshTokenCredential(e);t&&this.credentialMatchesFilter(t,a)&&c.push(t)}}));const l=c.length;return l<1?(this.commonLogger.info("CacheManager:getRefreshToken - No refresh token found."),null):(l>1&&n&&o&&n.addFields({multiMatchedRT:l},o),this.commonLogger.info("CacheManager:getRefreshToken - returning refresh token"),c[0])}refreshTokenKeyMatchesFilter(e,t){const r=e.toLowerCase();return(!t.familyId||-1!==r.indexOf(t.familyId.toLowerCase()))&&(!(!t.familyId&&t.clientId&&-1===r.indexOf(t.clientId.toLowerCase()))&&(!t.homeAccountId||-1!==r.indexOf(t.homeAccountId.toLowerCase())))}readAppMetadataFromCache(e){const t={environment:e,clientId:this.clientId},r=this.getAppMetadataFilteredBy(t),n=Object.keys(r).map((e=>r[e])),o=n.length;if(o<1)return null;if(o>1)throw Ct(De);return n[0]}isAppMetadataFOCI(e){const t=this.readAppMetadataFromCache(e);return!(!t||t.familyId!==D)}matchHomeAccountId(e,t){return!("string"!=typeof e.homeAccountId||t!==e.homeAccountId)}matchLocalAccountIdFromTokenClaims(e,t){return t===(e.oid||e.sub)}matchLocalAccountIdFromTenantProfile(e,t){return e.localAccountId===t}matchName(e,t){return!(t.toLowerCase()!==e.name?.toLowerCase())}matchUsername(e,t){return!(!e||"string"!=typeof e||t?.toLowerCase()!==e.toLowerCase())}matchUserAssertionHash(e,t){return!(!e.userAssertionHash||t!==e.userAssertionHash)}matchEnvironment(e,t){if(this.staticAuthorityOptions){const r=function(e,t){let r;const n=e.canonicalAuthority;if(n){const o=new er(n).getUrlComponents().HostNameAndPort;r=or(o,e.cloudDiscoveryMetadata?.metadata,K,t)||or(o,rr.metadata,$,t)||e.knownAuthorities}return r||[]}(this.staticAuthorityOptions,this.commonLogger);if(r.includes(t)&&r.includes(e.environment))return!0}const r=this.getAuthorityMetadataByAlias(t);return!!(r&&r.aliases.indexOf(e.environment)>-1)}matchCredentialType(e,t){return e.credentialType&&t.toLowerCase()===e.credentialType.toLowerCase()}matchClientId(e,t){return!(!e.clientId||t!==e.clientId)}matchFamilyId(e,t){return!(!e.familyId||t!==e.familyId)}matchRealm(e,t){return!(e.realm?.toLowerCase()!==t.toLowerCase())}matchNativeAccountId(e,t){return!(!e.nativeAccountId||t!==e.nativeAccountId)}matchLoginHintFromTokenClaims(e,t){return e.login_hint===t||(e.preferred_username===t||e.upn===t)}matchSid(e,t){return e.sid===t}matchAuthorityType(e,t){return!(!e.authorityType||t.toLowerCase()!==e.authorityType.toLowerCase())}matchTarget(e,t){if(e.credentialType!==H.ACCESS_TOKEN&&e.credentialType!==H.ACCESS_TOKEN_WITH_AUTH_SCHEME||!e.target)return!1;return Jr.fromString(e.target).containsScopeSet(t)}matchTokenType(e,t){return!(!e.tokenType||e.tokenType!==t)}matchKeyId(e,t){return!(!e.keyId||e.keyId!==t)}isAppMetadata(e){return-1!==e.indexOf(B)}isAuthorityMetadata(e){return-1!==e.indexOf(x)}generateAuthorityMetadataCacheKey(e){return`${x}-${this.clientId}-${e}`}static toObject(e,t){for(const r in t)e[r]=t[r];return e}}class hn extends dn{setAccount(){throw Ct(ht)}getAccount(){throw Ct(ht)}getCachedAccountEntity(){throw Ct(ht)}setIdTokenCredential(){throw Ct(ht)}getIdTokenCredential(){throw Ct(ht)}setAccessTokenCredential(){throw Ct(ht)}getAccessTokenCredential(){throw Ct(ht)}setRefreshTokenCredential(){throw Ct(ht)}getRefreshTokenCredential(){throw Ct(ht)}setAppMetadata(){throw Ct(ht)}getAppMetadata(){throw Ct(ht)}setServerTelemetry(){throw Ct(ht)}getServerTelemetry(){throw Ct(ht)}setAuthorityMetadata(){throw Ct(ht)}getAuthorityMetadata(){throw Ct(ht)}getAuthorityMetadataKeys(){throw Ct(ht)}setThrottlingCache(){throw Ct(ht)}getThrottlingCache(){throw Ct(ht)}removeItem(){throw Ct(ht)}getKeys(){throw Ct(ht)}getAccountKeys(){throw Ct(ht)}getTokenKeys(){throw Ct(ht)}async clear(){throw Ct(ht)}updateCredentialCacheKey(){throw Ct(ht)}removeOutdatedAccount(){throw Ct(ht)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const un={tokenRenewalOffsetSeconds:300,preventCorsPreflight:!1},gn={loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:e.LogLevel.Info,correlationId:t.EMPTY_STRING},pn={claimsBasedCachingEnabled:!1},mn={async sendGetRequestAsync(){throw Ct(ht)},async sendPostRequestAsync(){throw Ct(ht)}},fn={sku:t.SKU,version:Yr,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},Cn={clientSecret:t.EMPTY_STRING,clientAssertion:void 0},yn={azureCloudInstance:sr.None,tenant:`${t.DEFAULT_COMMON_TENANT}`},vn={application:{appName:"",appVersion:""}};function Tn(e){return e.authOptions.authority.options.protocolMode===ar.OIDC}
/*! @azure/msal-common v14.13.0 2024-07-12 */class In extends Ie{constructor(e,t,r,n,o){super(e,t,r),this.name="ServerError",this.errorNo=n,this.status=o,Object.setPrototypeOf(this,In.prototype)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class wn{static generateThrottlingStorageKey(e){return`${Y}.${JSON.stringify(e)}`}static preProcess(e,r){const n=wn.generateThrottlingStorageKey(r),o=e.getThrottlingCache(n);if(o){if(o.throttleTime<Date.now())return void e.removeItem(n);throw new In(o.errorCodes?.join(" ")||t.EMPTY_STRING,o.errorMessage,o.subError)}}static postProcess(e,t,r){if(wn.checkResponseStatus(r)||wn.checkResponseForRetryAfter(r)){const n={throttleTime:wn.calculateThrottleTime(parseInt(r.headers[l])),error:r.body.error,errorCodes:r.body.error_codes,errorMessage:r.body.error_description,subError:r.body.suberror};e.setThrottlingCache(wn.generateThrottlingStorageKey(t),n)}}static checkResponseStatus(e){return 429===e.status||e.status>=500&&e.status<600}static checkResponseForRetryAfter(e){return!!e.headers&&(e.headers.hasOwnProperty(l)&&(e.status<200||e.status>=300))}static calculateThrottleTime(e){const t=e<=0?0:e,r=Date.now()/1e3;return Math.floor(1e3*Math.min(r+(t||j),r+V))}static removeThrottle(e,t,r,n){const o={clientId:t,authority:r.authority,scopes:r.scopes,homeAccountIdentifier:n,claims:r.claims,authenticationScheme:r.authenticationScheme,resourceRequestMethod:r.resourceRequestMethod,resourceRequestUri:r.resourceRequestUri,shrClaims:r.shrClaims,sshKid:r.sshKid},i=this.generateThrottlingStorageKey(o);e.removeItem(i)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class An{constructor(e,t){this.networkClient=e,this.cacheManager=t}async sendPostRequest(e,t,r){let n;wn.preProcess(this.cacheManager,e);try{n=await this.networkClient.sendPostRequestAsync(t,r)}catch(e){throw e instanceof Ie?e:Ct(be)}return wn.postProcess(this.cacheManager,e,n),n}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const kn="home_account_id",Sn="UPN";
/*! @azure/msal-common v14.13.0 2024-07-12 */class En{static validateRedirectUri(e){if(!e)throw Yt(kt)}static validatePrompt(e){const t=[];for(const e in R)t.push(R[e]);if(t.indexOf(e)<0)throw Yt(Pt)}static validateClaims(e){try{JSON.parse(e)}catch(e){throw Yt(Mt)}}static validateCodeChallengeParams(e,t){if(!e||!t)throw Yt(Lt);this.validateCodeChallengeMethod(t)}static validateCodeChallengeMethod(e){if([b.PLAIN,b.S256].indexOf(e)<0)throw Yt(qt)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Rn{constructor(){this.parameters=new Map}addResponseTypeCode(){this.parameters.set(Kr,encodeURIComponent(t.CODE_RESPONSE_TYPE))}addResponseTypeForTokenAndIdToken(){this.parameters.set(Kr,encodeURIComponent(`${t.TOKEN_RESPONSE_TYPE} ${t.ID_TOKEN_RESPONSE_TYPE}`))}addResponseMode(e){this.parameters.set("response_mode",encodeURIComponent(e||P.QUERY))}addNativeBroker(){this.parameters.set("nativebroker",encodeURIComponent("1"))}addScopes(e,t=!0,r=a){!t||r.includes("openid")||e.includes("openid")||r.push("openid");const n=t?[...e||[],...r]:e||[],o=new Jr(n);this.parameters.set("scope",encodeURIComponent(o.printScopes()))}addClientId(e){this.parameters.set(Fr,encodeURIComponent(e))}addRedirectUri(e){En.validateRedirectUri(e),this.parameters.set("redirect_uri",encodeURIComponent(e))}addPostLogoutRedirectUri(e){En.validateRedirectUri(e),this.parameters.set("post_logout_redirect_uri",encodeURIComponent(e))}addIdTokenHint(e){this.parameters.set("id_token_hint",encodeURIComponent(e))}addDomainHint(e){this.parameters.set("domain_hint",encodeURIComponent(e))}addLoginHint(e){this.parameters.set("login_hint",encodeURIComponent(e))}addCcsUpn(e){this.parameters.set(d,encodeURIComponent(`UPN:${e}`))}addCcsOid(e){this.parameters.set(d,encodeURIComponent(`Oid:${e.uid}@${e.utid}`))}addSid(e){this.parameters.set("sid",encodeURIComponent(e))}addClaims(e,t){const r=this.addClientCapabilitiesToClaims(e,t);En.validateClaims(r),this.parameters.set("claims",encodeURIComponent(r))}addCorrelationId(e){this.parameters.set("client-request-id",encodeURIComponent(e))}addLibraryInfo(e){this.parameters.set("x-client-SKU",e.sku),this.parameters.set("x-client-VER",e.version),e.os&&this.parameters.set("x-client-OS",e.os),e.cpu&&this.parameters.set("x-client-CPU",e.cpu)}addApplicationTelemetry(e){e?.appName&&this.parameters.set("x-app-name",e.appName),e?.appVersion&&this.parameters.set("x-app-ver",e.appVersion)}addPrompt(e){En.validatePrompt(e),this.parameters.set("prompt",encodeURIComponent(e))}addState(e){e&&this.parameters.set("state",encodeURIComponent(e))}addNonce(e){this.parameters.set("nonce",encodeURIComponent(e))}addCodeChallengeParams(e,t){if(En.validateCodeChallengeParams(e,t),!e||!t)throw Yt(Lt);this.parameters.set("code_challenge",encodeURIComponent(e)),this.parameters.set("code_challenge_method",encodeURIComponent(t))}addAuthorizationCode(e){this.parameters.set("code",encodeURIComponent(e))}addDeviceCode(e){this.parameters.set("device_code",encodeURIComponent(e))}addRefreshToken(e){this.parameters.set("refresh_token",encodeURIComponent(e))}addCodeVerifier(e){this.parameters.set("code_verifier",encodeURIComponent(e))}addClientSecret(e){this.parameters.set("client_secret",encodeURIComponent(e))}addClientAssertion(e){e&&this.parameters.set("client_assertion",encodeURIComponent(e))}addClientAssertionType(e){e&&this.parameters.set("client_assertion_type",encodeURIComponent(e))}addOboAssertion(e){this.parameters.set("assertion",encodeURIComponent(e))}addRequestTokenUse(e){this.parameters.set("requested_token_use",encodeURIComponent(e))}addGrantType(e){this.parameters.set("grant_type",encodeURIComponent(e))}addClientInfo(){this.parameters.set("client_info","1")}addExtraQueryParameters(e){Object.entries(e).forEach((([e,t])=>{!this.parameters.has(e)&&t&&this.parameters.set(e,t)}))}addClientCapabilitiesToClaims(e,t){let r;if(e)try{r=JSON.parse(e)}catch(e){throw Yt(Mt)}else r={};return t&&t.length>0&&(r.hasOwnProperty(S)||(r[S]={}),r[S][E]={values:t}),JSON.stringify(r)}addUsername(e){this.parameters.set(ee,encodeURIComponent(e))}addPassword(e){this.parameters.set(te,encodeURIComponent(e))}addPopToken(e){e&&(this.parameters.set(zr,W.POP),this.parameters.set(Gr,encodeURIComponent(e)))}addSshJwk(e){e&&(this.parameters.set(zr,W.SSH),this.parameters.set(Gr,encodeURIComponent(e)))}addServerTelemetry(e){this.parameters.set("x-client-current-telemetry",e.generateCurrentRequestHeaderValue()),this.parameters.set("x-client-last-telemetry",e.generateLastRequestHeaderValue())}addThrottling(){this.parameters.set("x-ms-lib-capability",J)}addLogoutHint(e){this.parameters.set("logout_hint",encodeURIComponent(e))}createQueryString(){const e=new Array;return this.parameters.forEach(((t,r)=>{e.push(`${r}=${t}`)})),e.join("&")}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class bn{constructor(e,t){this.config=function({authOptions:e,systemOptions:t,loggerOptions:r,cacheOptions:n,storageInterface:o,networkInterface:i,cryptoInterface:a,clientCredentials:s,libraryInfo:c,telemetry:l,serverTelemetryManager:d,persistencePlugin:h,serializableCache:u}){const g={...gn,...r};return{authOptions:(p=e,{clientCapabilities:[],azureCloudOptions:yn,skipAuthorityMetadataCache:!1,...p}),systemOptions:{...un,...t},loggerOptions:g,cacheOptions:{...pn,...n},storageInterface:o||new hn(e.clientId,Qr,new jr(g)),networkInterface:i||mn,cryptoInterface:a||Qr,clientCredentials:s||Cn,libraryInfo:{...fn,...c},telemetry:{...vn,...l},serverTelemetryManager:d||null,persistencePlugin:h||null,serializableCache:u||null};var p}(e),this.logger=new jr(this.config.loggerOptions,Vr,Yr),this.cryptoUtils=this.config.cryptoInterface,this.cacheManager=this.config.storageInterface,this.networkClient=this.config.networkInterface,this.networkManager=new An(this.networkClient,this.cacheManager),this.serverTelemetryManager=this.config.serverTelemetryManager,this.authority=this.config.authOptions.authority,this.performanceClient=t}createTokenRequestHeaders(e){const r={};if(r[c]=t.URL_FORM_CONTENT_TYPE,!this.config.systemOptions.preventCorsPreflight&&e)switch(e.type){case kn:try{const t=Zr(e.credential);r[d]=`Oid:${t.uid}@${t.utid}`}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Sn:r[d]=`UPN: ${e.credential}`}return r}async executePostToTokenEndpoint(e,t,r,n,o,i){i&&this.performanceClient?.addQueueMeasurement(i,o);const a=await this.networkManager.sendPostRequest(n,e,{body:t,headers:r});return this.performanceClient?.addFields({refreshTokenSize:a.body.refresh_token?.length||0,httpVerToken:a.headers?.[p]||""},o),this.config.serverTelemetryManager&&a.status<500&&429!==a.status&&this.config.serverTelemetryManager.clearTelemetryCache(),a}async updateAuthority(e,t){this.performanceClient?.addQueueMeasurement(cr.UpdateTokenEndpointAuthority,t);const r=`https://${e}/${this.authority.tenant}/`,n=await Dr(r,this.networkClient,this.cacheManager,this.authority.options,this.logger,t,this.performanceClient);this.authority=n}createTokenQueryParameters(e){const t=new Rn;return e.tokenQueryParameters&&t.addExtraQueryParameters(e.tokenQueryParameters),t.createQueryString()}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const _n="no_tokens_found",Pn="native_account_unavailable",Mn="refresh_token_expired",Nn="interaction_required",On="consent_required",qn="login_required",Ln="bad_token";var Un=Object.freeze({__proto__:null,badToken:Ln,consentRequired:On,interactionRequired:Nn,loginRequired:qn,nativeAccountUnavailable:Pn,noTokensFound:_n,refreshTokenExpired:Mn});
/*! @azure/msal-common v14.13.0 2024-07-12 */const Hn=[Nn,On,qn,Ln],Bn=["message_only","additional_action","basic_action","user_password_expired","consent_required","bad_token"],Dn={[_n]:"No refresh token found in the cache. Please sign-in.",[Pn]:"The requested account is not available in the native broker. It may have been deleted or logged out. Please sign-in again using an interactive API.",[Mn]:"Refresh token has expired.",[Ln]:"Identity provider returned bad_token due to an expired or invalid refresh token. Please invoke an interactive API to resolve."},xn={noTokensFoundError:{code:_n,desc:Dn[_n]},native_account_unavailable:{code:Pn,desc:Dn[Pn]},bad_token:{code:Ln,desc:Dn[Ln]}};class Fn extends Ie{constructor(e,r,n,o,i,a,s,c){super(e,r,n),Object.setPrototypeOf(this,Fn.prototype),this.timestamp=o||t.EMPTY_STRING,this.traceId=i||t.EMPTY_STRING,this.correlationId=a||t.EMPTY_STRING,this.claims=s||t.EMPTY_STRING,this.name="InteractionRequiredAuthError",this.errorNo=c}}function Kn(e,t,r){const n=!!e&&Hn.indexOf(e)>-1,o=!!r&&Bn.indexOf(r)>-1,i=!!t&&Hn.some((e=>t.indexOf(e)>-1));return n||i||o}function zn(e){return new Fn(e,Dn[e])}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Gn{static setRequestState(e,r,n){const o=Gn.generateLibraryState(e,n);return r?`${o}${t.RESOURCE_DELIM}${r}`:o}static generateLibraryState(e,t){if(!e)throw Ct(Je);const r={id:e.createNewGuid()};t&&(r.meta=t);const n=JSON.stringify(r);return e.base64Encode(n)}static parseRequestState(e,r){if(!e)throw Ct(Je);if(!r)throw Ct(Me);try{const n=r.split(t.RESOURCE_DELIM),o=n[0],i=n.length>1?n.slice(1).join(t.RESOURCE_DELIM):t.EMPTY_STRING,a=e.base64Decode(o),s=JSON.parse(a);return{userRequestState:i||t.EMPTY_STRING,libraryState:s}}catch(e){throw Ct(Me)}}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const $n="sw";class Qn{constructor(e,t){this.cryptoUtils=e,this.performanceClient=t}async generateCnf(e,t){this.performanceClient?.addQueueMeasurement(cr.PopTokenGenerateCnf,e.correlationId);const r=await pr(this.generateKid.bind(this),cr.PopTokenGenerateCnf,t,this.performanceClient,e.correlationId)(e),n=this.cryptoUtils.base64UrlEncode(JSON.stringify(r));return{kid:r.kid,reqCnfString:n}}async generateKid(e){this.performanceClient?.addQueueMeasurement(cr.PopTokenGenerateKid,e.correlationId);return{kid:await this.cryptoUtils.getPublicKeyThumbprint(e),xms_ksl:$n}}async signPopToken(e,t,r){return this.signPayload(e,t,r)}async signPayload(e,t,r,n){const{resourceRequestMethod:o,resourceRequestUri:i,shrClaims:a,shrNonce:s,shrOptions:c}=r,l=i?new er(i):void 0,d=l?.getUrlComponents();return this.cryptoUtils.signJwt({at:e,ts:fr(),m:o?.toUpperCase(),u:d?.HostNameAndPort,nonce:s||this.cryptoUtils.createNewGuid(),p:d?.AbsolutePath,q:d?.QueryString?[[],d.QueryString]:void 0,client_claims:a||void 0,...n},t,c,r.correlationId)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Wn{constructor(e,t){this.cache=e,this.hasChanged=t}get cacheHasChanged(){return this.hasChanged}get tokenCache(){return this.cache}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class jn{constructor(e,t,r,n,o,i,a){this.clientId=e,this.cacheStorage=t,this.cryptoObj=r,this.logger=n,this.serializableCache=o,this.persistencePlugin=i,this.performanceClient=a}validateServerAuthorizationCodeResponse(e,t){if(!e.state||!t)throw e.state?Ct(Oe,"Cached State"):Ct(Oe,"Server State");let r,n;try{r=decodeURIComponent(e.state)}catch(t){throw Ct(Me,e.state)}try{n=decodeURIComponent(t)}catch(t){throw Ct(Me,e.state)}if(r!==n)throw Ct(Ne);if(e.error||e.error_description||e.suberror){const t=function(e){const t="code=",r=e.error_uri?.lastIndexOf(t);return r&&r>=0?e.error_uri?.substring(r+5):void 0}(e);if(Kn(e.error,e.error_description,e.suberror))throw new Fn(e.error||"",e.error_description,e.suberror,e.timestamp||"",e.trace_id||"",e.correlation_id||"",e.claims||"",t);throw new In(e.error||"",e.error_description,e.suberror,t)}}validateTokenResponse(e,a){if(e.error||e.error_description||e.suberror){const s=`Error(s): ${e.error_codes||t.NOT_AVAILABLE} - Timestamp: ${e.timestamp||t.NOT_AVAILABLE} - Description: ${e.error_description||t.NOT_AVAILABLE} - Correlation ID: ${e.correlation_id||t.NOT_AVAILABLE} - Trace ID: ${e.trace_id||t.NOT_AVAILABLE}`,c=e.error_codes?.length?e.error_codes[0]:void 0,l=new In(e.error,s,e.suberror,c,e.status);if(a&&e.status&&e.status>=o&&e.status<=i)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently unavailable and the access token is unable to be refreshed.\n${l}`);if(a&&e.status&&e.status>=r&&e.status<=n)return void this.logger.warning(`executeTokenRequest:validateTokenResponse - AAD is currently available but is unable to refresh the access token.\n${l}`);if(Kn(e.error,e.error_description,e.suberror))throw new Fn(e.error,e.error_description,e.suberror,e.timestamp||t.EMPTY_STRING,e.trace_id||t.EMPTY_STRING,e.correlation_id||t.EMPTY_STRING,e.claims||t.EMPTY_STRING,c);throw l}}async handleServerTokenResponse(e,r,n,o,i,a,s,c,l){let d,h;if(this.performanceClient?.addQueueMeasurement(cr.HandleServerTokenResponse,e.correlation_id),e.id_token){if(d=yt(e.id_token||t.EMPTY_STRING,this.cryptoObj.base64Decode),i&&i.nonce&&d.nonce!==i.nonce)throw Ct(qe);if(o.maxAge||0===o.maxAge){const e=d.auth_time;if(!e)throw Ct(Le);vt(e,o.maxAge)}}this.homeAccountIdentifier=on.generateHomeAccountId(e.client_info||t.EMPTY_STRING,r.authorityType,this.logger,this.cryptoObj,d),i&&i.state&&(h=Gn.parseRequestState(this.cryptoObj,i.state)),e.key_id=e.key_id||o.sshKid||void 0;const u=this.generateCacheRecord(e,r,n,o,d,a,i);let g;try{if(this.persistencePlugin&&this.serializableCache&&(this.logger.verbose("Persistence enabled, calling beforeCacheAccess"),g=new Wn(this.serializableCache,!0),await this.persistencePlugin.beforeCacheAccess(g)),s&&!c&&u.account){const e=u.account.generateAccountKey();if(!this.cacheStorage.getAccount(e,this.logger))return this.logger.warning("Account used to refresh tokens not in persistence, refreshed tokens will not be stored in the cache"),await jn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,d,h,void 0,l)}await this.cacheStorage.saveCacheRecord(u,o.storeInCache,o.correlationId)}finally{this.persistencePlugin&&this.serializableCache&&g&&(this.logger.verbose("Persistence enabled, calling afterCacheAccess"),await this.persistencePlugin.afterCacheAccess(g))}return jn.generateAuthenticationResult(this.cryptoObj,r,u,!1,o,d,h,e,l)}generateCacheRecord(e,t,r,n,o,i,a){const s=t.getPreferredCache();if(!s)throw Ct(Ve);const c=nn(o);let l,d;e.id_token&&o&&(l=Tr(this.homeAccountIdentifier,s,e.id_token,this.clientId,c||""),d=Vn(this.cacheStorage,t,this.homeAccountIdentifier,this.cryptoObj.base64Decode,o,e.client_info,s,c,a,void 0,this.logger));let h=null;if(e.access_token){const o=e.scope?Jr.fromString(e.scope):new Jr(n.scopes||[]),a=("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0,l=("string"==typeof e.ext_expires_in?parseInt(e.ext_expires_in,10):e.ext_expires_in)||0,d=("string"==typeof e.refresh_in?parseInt(e.refresh_in,10):e.refresh_in)||void 0,u=r+a,g=u+l,p=d&&d>0?r+d:void 0;h=Ir(this.homeAccountIdentifier,s,e.access_token,this.clientId,c||t.tenant||"",o.printScopes(),u,g,this.cryptoObj.base64Decode,p,e.token_type,i,e.key_id,n.claims,n.requestedClaimsHash)}let u=null;if(e.refresh_token){let t;if(e.refresh_token_expires_in){t=r+("string"==typeof e.refresh_token_expires_in?parseInt(e.refresh_token_expires_in,10):e.refresh_token_expires_in)}u=wr(this.homeAccountIdentifier,s,e.refresh_token,this.clientId,e.foci,i,t)}let g=null;return e.foci&&(g={clientId:this.clientId,environment:s,familyId:e.foci}),{account:d,idToken:l,accessToken:h,refreshToken:u,appMetadata:g}}static async generateAuthenticationResult(e,r,n,o,i,a,s,c,l){let d,h,u=t.EMPTY_STRING,g=[],p=null,m=t.EMPTY_STRING;if(n.accessToken){if(n.accessToken.tokenType!==W.POP||i.popKid)u=n.accessToken.secret;else{const t=new Qn(e),{secret:r,keyId:o}=n.accessToken;if(!o)throw Ct(st);u=await t.signPopToken(r,o,i)}g=Jr.fromString(n.accessToken.target).asArray(),p=new Date(1e3*Number(n.accessToken.expiresOn)),d=new Date(1e3*Number(n.accessToken.extendedExpiresOn)),n.accessToken.refreshOn&&(h=new Date(1e3*Number(n.accessToken.refreshOn)))}n.appMetadata&&(m=n.appMetadata.familyId===D?D:"");const f=a?.oid||a?.sub||"",C=a?.tid||"";c?.spa_accountid&&n.account&&(n.account.nativeAccountId=c?.spa_accountid);const y=n.account?rn(n.account.getAccountInfo(),void 0,a,n.idToken?.secret):null;return{authority:r.canonicalAuthority,uniqueId:f,tenantId:C,scopes:g,account:y,idToken:n?.idToken?.secret||"",idTokenClaims:a||{},accessToken:u,fromCache:o,expiresOn:p,extExpiresOn:d,refreshOn:h,correlationId:i.correlationId,requestId:l||t.EMPTY_STRING,familyId:m,tokenType:n.accessToken?.tokenType||t.EMPTY_STRING,state:s?s.userRequestState:t.EMPTY_STRING,cloudGraphHostName:n.account?.cloudGraphHostName||t.EMPTY_STRING,msGraphHost:n.account?.msGraphHost||t.EMPTY_STRING,code:c?.spa_code,fromNativeBroker:!1}}}function Vn(e,t,r,n,o,i,a,s,c,l,d){d?.verbose("setCachedAccount called");const h=e.getAccountKeys().find((e=>e.startsWith(r)));let u=null;h&&(u=e.getAccount(h,d));const g=u||on.createAccount({homeAccountId:r,idTokenClaims:o,clientInfo:i,environment:a,cloudGraphHostName:c?.cloud_graph_host_name,msGraphHost:c?.msgraph_host,nativeAccountId:l},t,n),p=g.tenantProfiles||[];if(s&&o&&!p.find((e=>e.tenantId===s))){const e=tn(r,o);p.push(e)}return g.tenantProfiles=p,g}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Yn extends bn{constructor(e,t){super(e,t),this.includeRedirectUri=!0,this.oidcDefaultScopes=this.config.authOptions.authority.options.OIDCOptions?.defaultScopes}async getAuthCodeUrl(e){this.performanceClient?.addQueueMeasurement(cr.GetAuthCodeUrl,e.correlationId);const t=await pr(this.createAuthCodeUrlQueryString.bind(this),cr.AuthClientCreateQueryString,this.logger,this.performanceClient,e.correlationId)(e);return er.appendQueryString(this.authority.authorizationEndpoint,t)}async acquireToken(e,t){if(this.performanceClient?.addQueueMeasurement(cr.AuthClientAcquireToken,e.correlationId),!e.code)throw Ct(xe);const r=fr(),n=await pr(this.executeTokenRequest.bind(this),cr.AuthClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(this.authority,e),o=n.headers?.[g],i=new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin,this.performanceClient);return i.validateTokenResponse(n.body),pr(i.handleServerTokenResponse.bind(i),cr.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(n.body,this.authority,r,e,t,void 0,void 0,void 0,o)}handleFragmentResponse(e,t){if(new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,null,null).validateServerAuthorizationCodeResponse(e,t),!e.code)throw Ct(ot);return e}getLogoutUri(e){if(!e)throw Yt(Ot);const t=this.createLogoutUrlQueryString(e);return er.appendQueryString(this.authority.endSessionEndpoint,t)}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(cr.AuthClientExecuteTokenRequest,t.correlationId);const r=this.createTokenQueryParameters(t),n=er.appendQueryString(e.tokenEndpoint,r),o=await pr(this.createTokenRequestBody.bind(this),cr.AuthClientCreateTokenRequestBody,this.logger,this.performanceClient,t.correlationId)(t);let i;if(t.clientInfo)try{const e=Xr(t.clientInfo,this.cryptoUtils.base64Decode);i={credential:`${e.uid}${U.CLIENT_INFO_SEPARATOR}${e.utid}`,type:kn}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}const a=this.createTokenRequestHeaders(i||t.ccsCredential),s={clientId:t.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:e.canonicalAuthority,scopes:t.scopes,claims:t.claims,authenticationScheme:t.authenticationScheme,resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,sshKid:t.sshKid};return pr(this.executePostToTokenEndpoint.bind(this),cr.AuthorizationCodeClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,t.correlationId)(n,o,a,s,t.correlationId,cr.AuthorizationCodeClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(cr.AuthClientCreateTokenRequestBody,e.correlationId);const t=new Rn;if(t.addClientId(e.tokenBodyParameters?.[Fr]||this.config.authOptions.clientId),this.includeRedirectUri?t.addRedirectUri(e.redirectUri):En.validateRedirectUri(e.redirectUri),t.addScopes(e.scopes,!0,this.oidcDefaultScopes),t.addAuthorizationCode(e.code),t.addLibraryInfo(this.config.libraryInfo),t.addApplicationTelemetry(this.config.telemetry.application),t.addThrottling(),this.serverTelemetryManager&&!Tn(this.config)&&t.addServerTelemetry(this.serverTelemetryManager),e.codeVerifier&&t.addCodeVerifier(e.codeVerifier),this.config.clientCredentials.clientSecret&&t.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const r=this.config.clientCredentials.clientAssertion;t.addClientAssertion(await xr(r.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),t.addClientAssertionType(r.assertionType)}if(t.addGrantType(M),t.addClientInfo(),e.authenticationScheme===W.POP){const r=new Qn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await pr(r.generateCnf.bind(r),cr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}t.addPopToken(n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw Yt(Dt);t.addSshJwk(e.sshJwk)}const r=e.correlationId||this.config.cryptoInterface.createNewGuid();let n;if(t.addCorrelationId(r),(!Jt.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.clientInfo)try{const t=Xr(e.clientInfo,this.cryptoUtils.base64Decode);n={credential:`${t.uid}${U.CLIENT_INFO_SEPARATOR}${t.utid}`,type:kn}}catch(e){this.logger.verbose("Could not parse client info for CCS Header: "+e)}else n=e.ccsCredential;if(this.config.systemOptions.preventCorsPreflight&&n)switch(n.type){case kn:try{const e=Zr(n.credential);t.addCcsOid(e)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Sn:t.addCcsUpn(n.credential)}return e.tokenBodyParameters&&t.addExtraQueryParameters(e.tokenBodyParameters),!e.enableSpaAuthorizationCode||e.tokenBodyParameters&&e.tokenBodyParameters[$r]||t.addExtraQueryParameters({[$r]:"1"}),t.createQueryString()}async createAuthCodeUrlQueryString(e){this.performanceClient?.addQueueMeasurement(cr.AuthClientCreateQueryString,e.correlationId);const t=new Rn;t.addClientId(e.extraQueryParameters?.[Fr]||this.config.authOptions.clientId);const r=[...e.scopes||[],...e.extraScopesToConsent||[]];t.addScopes(r,!0,this.oidcDefaultScopes),t.addRedirectUri(e.redirectUri);const n=e.correlationId||this.config.cryptoInterface.createNewGuid();if(t.addCorrelationId(n),t.addResponseMode(e.responseMode),t.addResponseTypeCode(),t.addLibraryInfo(this.config.libraryInfo),Tn(this.config)||t.addApplicationTelemetry(this.config.telemetry.application),t.addClientInfo(),e.codeChallenge&&e.codeChallengeMethod&&t.addCodeChallengeParams(e.codeChallenge,e.codeChallengeMethod),e.prompt&&t.addPrompt(e.prompt),e.domainHint&&t.addDomainHint(e.domainHint),e.prompt!==R.SELECT_ACCOUNT)if(e.sid&&e.prompt===R.NONE)this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from request"),t.addSid(e.sid);else if(e.account){const r=this.extractAccountSid(e.account);let n=this.extractLoginHint(e.account);if(n&&e.domainHint&&(this.logger.warning('AuthorizationCodeClient.createAuthCodeUrlQueryString: "domainHint" param is set, skipping opaque "login_hint" claim. Please consider not passing domainHint'),n=null),n){this.logger.verbose("createAuthCodeUrlQueryString: login_hint claim present on account"),t.addLoginHint(n);try{const r=Zr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(r&&e.prompt===R.NONE){this.logger.verbose("createAuthCodeUrlQueryString: Prompt is none, adding sid from account"),t.addSid(r);try{const r=Zr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}else if(e.loginHint)this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint);else if(e.account.username){this.logger.verbose("createAuthCodeUrlQueryString: Adding login_hint from account"),t.addLoginHint(e.account.username);try{const r=Zr(e.account.homeAccountId);t.addCcsOid(r)}catch(e){this.logger.verbose("createAuthCodeUrlQueryString: Could not parse home account ID for CCS Header")}}}else e.loginHint&&(this.logger.verbose("createAuthCodeUrlQueryString: No account, adding login_hint from request"),t.addLoginHint(e.loginHint),t.addCcsUpn(e.loginHint));else this.logger.verbose("createAuthCodeUrlQueryString: Prompt is select_account, ignoring account hints");if(e.nonce&&t.addNonce(e.nonce),e.state&&t.addState(e.state),(e.claims||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&t.addClaims(e.claims,this.config.authOptions.clientCapabilities),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters),e.nativeBroker&&(t.addNativeBroker(),e.authenticationScheme===W.POP)){const r=new Qn(this.cryptoUtils);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await pr(r.generateCnf.bind(r),cr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}t.addPopToken(n)}return t.createQueryString()}createLogoutUrlQueryString(e){const t=new Rn;return e.postLogoutRedirectUri&&t.addPostLogoutRedirectUri(e.postLogoutRedirectUri),e.correlationId&&t.addCorrelationId(e.correlationId),e.idTokenHint&&t.addIdTokenHint(e.idTokenHint),e.state&&t.addState(e.state),e.logoutHint&&t.addLogoutHint(e.logoutHint),e.extraQueryParameters&&t.addExtraQueryParameters(e.extraQueryParameters),t.createQueryString()}extractAccountSid(e){return e.idTokenClaims?.sid||null}extractLoginHint(e){return e.idTokenClaims?.login_hint||null}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Jn extends bn{constructor(e,t){super(e,t)}async acquireToken(e){this.performanceClient?.addQueueMeasurement(cr.RefreshTokenClientAcquireToken,e.correlationId);const t=fr(),r=await pr(this.executeTokenRequest.bind(this),cr.RefreshTokenClientExecuteTokenRequest,this.logger,this.performanceClient,e.correlationId)(e,this.authority),n=r.headers?.[g],o=new jn(this.config.authOptions.clientId,this.cacheManager,this.cryptoUtils,this.logger,this.config.serializableCache,this.config.persistencePlugin);return o.validateTokenResponse(r.body),pr(o.handleServerTokenResponse.bind(o),cr.HandleServerTokenResponse,this.logger,this.performanceClient,e.correlationId)(r.body,this.authority,t,e,void 0,void 0,!0,e.forceCache,n)}async acquireTokenByRefreshToken(e){if(!e)throw Yt(Nt);if(this.performanceClient?.addQueueMeasurement(cr.RefreshTokenClientAcquireTokenByRefreshToken,e.correlationId),!e.account)throw Ct(We);if(this.cacheManager.isAppMetadataFOCI(e.account.environment))try{return await pr(this.acquireTokenWithCachedRefreshToken.bind(this),cr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!0)}catch(t){const r=t instanceof Fn&&t.errorCode===_n,n=t instanceof In&&t.errorCode===X&&t.subError===Z;if(r||n)return pr(this.acquireTokenWithCachedRefreshToken.bind(this),cr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1);throw t}return pr(this.acquireTokenWithCachedRefreshToken.bind(this),cr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,this.logger,this.performanceClient,e.correlationId)(e,!1)}async acquireTokenWithCachedRefreshToken(e,t){this.performanceClient?.addQueueMeasurement(cr.RefreshTokenClientAcquireTokenWithCachedRefreshToken,e.correlationId);const r=gr(this.cacheManager.getRefreshToken.bind(this.cacheManager),cr.CacheManagerGetRefreshToken,this.logger,this.performanceClient,e.correlationId)(e.account,t,void 0,this.performanceClient,e.correlationId);if(!r)throw zn(_n);if(r.expiresOn&&Cr(r.expiresOn,e.refreshTokenExpirationOffsetSeconds||300))throw zn(Mn);const n={...e,refreshToken:r.secret,authenticationScheme:e.authenticationScheme||W.BEARER,ccsCredential:{credential:e.account.homeAccountId,type:kn}};try{return await pr(this.acquireToken.bind(this),cr.RefreshTokenClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(n)}catch(e){if(e instanceof Fn&&e.subError===Ln){this.logger.verbose("acquireTokenWithRefreshToken: bad refresh token, removing from cache");const e=vr(r);this.cacheManager.removeRefreshToken(e)}throw e}}async executeTokenRequest(e,t){this.performanceClient?.addQueueMeasurement(cr.RefreshTokenClientExecuteTokenRequest,e.correlationId);const r=this.createTokenQueryParameters(e),n=er.appendQueryString(t.tokenEndpoint,r),o=await pr(this.createTokenRequestBody.bind(this),cr.RefreshTokenClientCreateTokenRequestBody,this.logger,this.performanceClient,e.correlationId)(e),i=this.createTokenRequestHeaders(e.ccsCredential),a={clientId:e.tokenBodyParameters?.clientId||this.config.authOptions.clientId,authority:t.canonicalAuthority,scopes:e.scopes,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid};return pr(this.executePostToTokenEndpoint.bind(this),cr.RefreshTokenClientExecutePostToTokenEndpoint,this.logger,this.performanceClient,e.correlationId)(n,o,i,a,e.correlationId,cr.RefreshTokenClientExecutePostToTokenEndpoint)}async createTokenRequestBody(e){this.performanceClient?.addQueueMeasurement(cr.RefreshTokenClientCreateTokenRequestBody,e.correlationId);const t=e.correlationId,r=new Rn;if(r.addClientId(e.tokenBodyParameters?.[Fr]||this.config.authOptions.clientId),e.redirectUri&&r.addRedirectUri(e.redirectUri),r.addScopes(e.scopes,!0,this.config.authOptions.authority.options.OIDCOptions?.defaultScopes),r.addGrantType(N),r.addClientInfo(),r.addLibraryInfo(this.config.libraryInfo),r.addApplicationTelemetry(this.config.telemetry.application),r.addThrottling(),this.serverTelemetryManager&&!Tn(this.config)&&r.addServerTelemetry(this.serverTelemetryManager),r.addCorrelationId(t),r.addRefreshToken(e.refreshToken),this.config.clientCredentials.clientSecret&&r.addClientSecret(this.config.clientCredentials.clientSecret),this.config.clientCredentials.clientAssertion){const t=this.config.clientCredentials.clientAssertion;r.addClientAssertion(await xr(t.assertion,this.config.authOptions.clientId,e.resourceRequestUri)),r.addClientAssertionType(t.assertionType)}if(e.authenticationScheme===W.POP){const t=new Qn(this.cryptoUtils,this.performanceClient);let n;if(e.popKid)n=this.cryptoUtils.encodeKid(e.popKid);else{n=(await pr(t.generateCnf.bind(t),cr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(e,this.logger)).reqCnfString}r.addPopToken(n)}else if(e.authenticationScheme===W.SSH){if(!e.sshJwk)throw Yt(Dt);r.addSshJwk(e.sshJwk)}if((!Jt.isEmptyObj(e.claims)||this.config.authOptions.clientCapabilities&&this.config.authOptions.clientCapabilities.length>0)&&r.addClaims(e.claims,this.config.authOptions.clientCapabilities),this.config.systemOptions.preventCorsPreflight&&e.ccsCredential)switch(e.ccsCredential.type){case kn:try{const t=Zr(e.ccsCredential.credential);r.addCcsOid(t)}catch(e){this.logger.verbose("Could not parse home account ID for CCS Header: "+e)}break;case Sn:r.addCcsUpn(e.ccsCredential.credential)}return e.tokenBodyParameters&&r.addExtraQueryParameters(e.tokenBodyParameters),r.createQueryString()}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class Xn extends bn{constructor(e,t){super(e,t)}async acquireToken(e){try{const[t,r]=await this.acquireCachedToken({...e,scopes:e.scopes?.length?e.scopes:[...a]});if(r===pe){this.logger.info("SilentFlowClient:acquireCachedToken - Cached access token's refreshOn property has been exceeded'. It's not expired, but must be refreshed.");new Jn(this.config,this.performanceClient).acquireTokenByRefreshToken(e).catch((()=>{}))}return t}catch(t){if(t instanceof ft&&t.errorCode===tt){return new Jn(this.config,this.performanceClient).acquireTokenByRefreshToken(e)}throw t}}async acquireCachedToken(e){this.performanceClient?.addQueueMeasurement(cr.SilentFlowClientAcquireCachedToken,e.correlationId);let t=de;if(e.forceRefresh||!this.config.cacheOptions.claimsBasedCachingEnabled&&!Jt.isEmptyObj(e.claims))throw this.setCacheOutcome(he,e.correlationId),Ct(tt);if(!e.account)throw Ct(We);const r=e.account.tenantId||function(e){const t=new er(e).getUrlComponents(),r=t.PathSegments.slice(-1)[0]?.toLowerCase();switch(r){case w:case A:case k:return;default:return r}}(e.authority),n=this.cacheManager.getTokenKeys(),o=this.cacheManager.getAccessToken(e.account,e,n,r,this.performanceClient,e.correlationId);if(!o)throw this.setCacheOutcome(ue,e.correlationId),Ct(tt);if(yr(o.cachedAt)||Cr(o.expiresOn,this.config.systemOptions.tokenRenewalOffsetSeconds))throw this.setCacheOutcome(ge,e.correlationId),Ct(tt);o.refreshOn&&Cr(o.refreshOn,0)&&(t=pe);const i=e.authority||this.authority.getPreferredCache(),a={account:this.cacheManager.readAccountFromCache(e.account),accessToken:o,idToken:this.cacheManager.getIdToken(e.account,n,r,this.performanceClient,e.correlationId),refreshToken:null,appMetadata:this.cacheManager.readAppMetadataFromCache(i)};return this.setCacheOutcome(t,e.correlationId),this.config.serverTelemetryManager&&this.config.serverTelemetryManager.incrementCacheHits(),[await pr(this.generateResultFromCacheRecord.bind(this),cr.SilentFlowClientGenerateResultFromCacheRecord,this.logger,this.performanceClient,e.correlationId)(a,e),t]}setCacheOutcome(e,t){this.serverTelemetryManager?.setCacheOutcome(e),this.performanceClient?.addFields({cacheOutcome:e},t),e!==de&&this.logger.info(`Token refresh is required due to cache outcome: ${e}`)}async generateResultFromCacheRecord(e,t){let r;if(this.performanceClient?.addQueueMeasurement(cr.SilentFlowClientGenerateResultFromCacheRecord,t.correlationId),e.idToken&&(r=yt(e.idToken.secret,this.config.cryptoInterface.base64Decode)),t.maxAge||0===t.maxAge){const e=r?.auth_time;if(!e)throw Ct(Le);vt(e,t.maxAge)}return jn.generateAuthenticationResult(this.cryptoUtils,this.authority,e,!0,t,r)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */const Zn={sendGetRequestAsync:()=>Promise.reject(Ct(ht)),sendPostRequestAsync:()=>Promise.reject(Ct(ht))},eo="missing_kid_error",to="missing_alg_error",ro={[eo]:"The JOSE Header for the requested JWT, JWS or JWK object requires a keyId to be configured as the 'kid' header claim. No 'kid' value was provided.",[to]:"The JOSE Header for the requested JWT, JWS or JWK object requires an algorithm to be specified as the 'alg' header claim. No 'alg' value was provided."};
/*! @azure/msal-common v14.13.0 2024-07-12 */class no extends Ie{constructor(e,t){super(e,t),this.name="JoseHeaderError",Object.setPrototypeOf(this,no.prototype)}}function oo(e){return new no(e,ro[e])}
/*! @azure/msal-common v14.13.0 2024-07-12 */class io{constructor(e){this.typ=e.typ,this.alg=e.alg,this.kid=e.kid}static getShrHeaderString(e){if(!e.kid)throw oo(eo);if(!e.alg)throw oo(to);const t=new io({typ:e.typ||me.Pop,kid:e.kid,alg:e.alg});return JSON.stringify(t)}}
/*! @azure/msal-common v14.13.0 2024-07-12 */
/*! @azure/msal-common v14.13.0 2024-07-12 */
class ao{constructor(e,r){this.cacheOutcome=de,this.cacheManager=r,this.apiId=e.apiId,this.correlationId=e.correlationId,this.wrapperSKU=e.wrapperSKU||t.EMPTY_STRING,this.wrapperVer=e.wrapperVer||t.EMPTY_STRING,this.telemetryCacheKey=Q.CACHE_KEY+U.CACHE_KEY_SEPARATOR+e.clientId}generateCurrentRequestHeaderValue(){const e=`${this.apiId}${Q.VALUE_SEPARATOR}${this.cacheOutcome}`,t=[this.wrapperSKU,this.wrapperVer].join(Q.VALUE_SEPARATOR),r=[e,this.getRegionDiscoveryFields()].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,r,t].join(Q.CATEGORY_SEPARATOR)}generateLastRequestHeaderValue(){const e=this.getLastRequests(),t=ao.maxErrorsToSend(e),r=e.failedRequests.slice(0,2*t).join(Q.VALUE_SEPARATOR),n=e.errors.slice(0,t).join(Q.VALUE_SEPARATOR),o=e.errors.length,i=[o,t<o?Q.OVERFLOW_TRUE:Q.OVERFLOW_FALSE].join(Q.VALUE_SEPARATOR);return[Q.SCHEMA_VERSION,e.cacheHits,r,n,i].join(Q.CATEGORY_SEPARATOR)}cacheFailedRequest(e){const t=this.getLastRequests();t.errors.length>=Q.MAX_CACHED_ERRORS&&(t.failedRequests.shift(),t.failedRequests.shift(),t.errors.shift()),t.failedRequests.push(this.apiId,this.correlationId),e instanceof Error&&e&&e.toString()?e instanceof Ie?e.subError?t.errors.push(e.subError):e.errorCode?t.errors.push(e.errorCode):t.errors.push(e.toString()):t.errors.push(e.toString()):t.errors.push(Q.UNKNOWN_ERROR),this.cacheManager.setServerTelemetry(this.telemetryCacheKey,t)}incrementCacheHits(){const e=this.getLastRequests();return e.cacheHits+=1,this.cacheManager.setServerTelemetry(this.telemetryCacheKey,e),e.cacheHits}getLastRequests(){return this.cacheManager.getServerTelemetry(this.telemetryCacheKey)||{failedRequests:[],errors:[],cacheHits:0}}clearTelemetryCache(){const e=this.getLastRequests(),t=ao.maxErrorsToSend(e);if(t===e.errors.length)this.cacheManager.removeItem(this.telemetryCacheKey);else{const r={failedRequests:e.failedRequests.slice(2*t),errors:e.errors.slice(t),cacheHits:0};this.cacheManager.setServerTelemetry(this.telemetryCacheKey,r)}}static maxErrorsToSend(e){let r,n=0,o=0;const i=e.errors.length;for(r=0;r<i;r++){const i=e.failedRequests[2*r]||t.EMPTY_STRING,a=e.failedRequests[2*r+1]||t.EMPTY_STRING,s=e.errors[r]||t.EMPTY_STRING;if(o+=i.toString().length+a.toString().length+s.length+3,!(o<Q.MAX_LAST_HEADER_BYTES))break;n+=1}return n}getRegionDiscoveryFields(){const e=[];return e.push(this.regionUsed||t.EMPTY_STRING),e.push(this.regionSource||t.EMPTY_STRING),e.push(this.regionOutcome||t.EMPTY_STRING),e.join(",")}updateRegionDiscoveryMetadata(e){this.regionUsed=e.region_used,this.regionSource=e.region_source,this.regionOutcome=e.region_outcome}setCacheOutcome(e){this.cacheOutcome=e}}
/*! @azure/msal-common v14.13.0 2024-07-12 */class so{startMeasurement(){}endMeasurement(){}flushMeasurement(){return null}}class co{generateId(){return"callback-id"}startMeasurement(e,t){return{end:()=>null,discard:()=>{},add:()=>{},increment:()=>{},event:{eventId:this.generateId(),status:dr,authority:"",libraryName:"",libraryVersion:"",clientId:"",name:e,startTimeMs:Date.now(),correlationId:t||""},measurement:new so}}startPerformanceMeasurement(){return new so}calculateQueuedTime(){return 0}addQueueMeasurement(){}setPreQueueTime(){}endMeasurement(){return null}discardMeasurements(){}removePerformanceCallback(){return!0}addPerformanceCallback(){return""}emitEvents(){}addFields(){}incrementFields(){}cacheEventByCorrelationId(){}}
/*! @azure/msal-common v14.13.0 2024-07-12 */function lo(e,t,r,n=5){if(e instanceof Error)return e instanceof Ie?(r.errorCode=e.errorCode,r.subErrorCode=e.subError,void((e instanceof In||e instanceof Fn)&&(r.serverErrorNo=e.errorNo))):void(e instanceof ln?r.errorCode=e.errorCode:r.errorStack?.length?t.trace("PerformanceClient.addErrorStack: Stack already exist",r.correlationId):e.stack?.length?(e.stack&&(r.errorStack=function(e,t){if(t<0)return[];const r=e.split("\n")||[];if(r.length<2)return[];const n=[];for(let e=Math.max(r.length-t-1,1);e<r.length;e++){const o=r[e];if(n.length>=t)break;n.push(ho(o))}return n}(e.stack,n)),r.errorName=e.name):t.trace("PerformanceClient.addErrorStack: Input stack is empty",r.correlationId));t.trace("PerformanceClient.addErrorStack: Input error is not instance of Error",r.correlationId)}function ho(e){const t=e.lastIndexOf(" ")+1;if(t<1)return e;const r=e.substring(t);let n=r.lastIndexOf("/");return n=n<0?r.lastIndexOf("\\"):n,n>=0?(e.substring(0,t)+"("+r.substring(n+1)+(")"===r.charAt(r.length-1)?"":")")).trimStart():e.trimStart()}class uo{constructor(e,t,r,n,o,i,a,s){this.authority=t,this.libraryName=n,this.libraryVersion=o,this.applicationTelemetry=i,this.clientId=e,this.logger=r,this.callbacks=new Map,this.eventsByCorrelationId=new Map,this.eventStack=new Map,this.queueMeasurements=new Map,this.preQueueTimeByCorrelationId=new Map,this.intFields=a||new Set;for(const e of ur)this.intFields.add(e);this.abbreviations=s||new Map;for(const[e,t]of lr)this.abbreviations.set(e,t)}startPerformanceMeasurement(e,t){return{}}getPreQueueTime(e,t){const r=this.preQueueTimeByCorrelationId.get(t);if(r){if(r.name===e)return r.time;this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue time found for ${e}, unable to add queue measurement`)}else this.logger.trace(`PerformanceClient.getPreQueueTime: no pre-queue times found for correlationId: ${t}, unable to add queue measurement`)}calculateQueuedTime(e,t){return e<1?(this.logger.trace(`PerformanceClient: preQueueTime should be a positive integer and not ${e}`),0):t<1?(this.logger.trace(`PerformanceClient: currentTime should be a positive integer and not ${t}`),0):t<e?(this.logger.trace("PerformanceClient: currentTime is less than preQueueTime, check how time is being retrieved"),0):t-e}addQueueMeasurement(e,t,r,n){if(!t)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: correlationId not provided for ${e}, cannot add queue measurement`);if(0===r)this.logger.trace(`PerformanceClient.addQueueMeasurement: queue time provided for ${e} is ${r}`);else if(!r)return void this.logger.trace(`PerformanceClient.addQueueMeasurement: no queue time provided for ${e}`);const o={eventName:e,queueTime:n?0:r,manuallyCompleted:n},i=this.queueMeasurements.get(t);if(i)i.push(o),this.queueMeasurements.set(t,i);else{this.logger.trace(`PerformanceClient.addQueueMeasurement: adding correlationId ${t} to queue measurements`);const e=[o];this.queueMeasurements.set(t,e)}this.preQueueTimeByCorrelationId.delete(t)}startMeasurement(e,t){const r=t||this.generateId();t||this.logger.info(`PerformanceClient: No correlation id provided for ${e}, generating`,r),this.logger.trace(`PerformanceClient: Performance measurement started for ${e}`,r);const n={eventId:this.generateId(),status:dr,authority:this.authority,libraryName:this.libraryName,libraryVersion:this.libraryVersion,clientId:this.clientId,name:e,startTimeMs:Date.now(),correlationId:r,appName:this.applicationTelemetry?.appName,appVersion:this.applicationTelemetry?.appVersion};var o,i,a;return this.cacheEventByCorrelationId(n),o=n,i=this.abbreviations,(a=this.eventStack.get(r))&&a.push({name:i.get(o.name)||o.name}),{end:(e,t)=>this.endMeasurement({...n,...e},t),discard:()=>this.discardMeasurements(n.correlationId),add:e=>this.addFields(e,n.correlationId),increment:e=>this.incrementFields(e,n.correlationId),event:n,measurement:new so}}endMeasurement(e,t){const r=this.eventsByCorrelationId.get(e.correlationId);if(!r)return this.logger.trace(`PerformanceClient: Measurement not found for ${e.eventId}`,e.correlationId),null;const n=e.eventId===r.eventId;let o={totalQueueTime:0,totalQueueCount:0,manuallyCompletedCount:0};e.durationMs=Math.round(e.durationMs||this.getDurationMs(e.startTimeMs));const i=JSON.stringify(function(e,t,r,n){if(!r?.length)return;const o=e=>e.length?e[e.length-1]:void 0,i=t.get(e.name)||e.name,a=o(r);if(a?.name!==i)return;const s=r?.pop();if(!s)return;const c=n instanceof Ie?n.errorCode:n instanceof Error?n.name:void 0,l=n instanceof Ie?n.subError:void 0;c&&s.childErr!==c&&(s.err=c,l&&(s.subErr=l)),delete s.name,delete s.childErr;const d={...s,dur:e.durationMs};e.success||(d.fail=1);const h=o(r);if(!h)return{[i]:d};let u;if(c&&(h.childErr=c),h[i]){const e=Object.keys(h).filter((e=>e.startsWith(i))).length;u=`${i}_${e+1}`}else u=i;return h[u]=d,h}(e,this.abbreviations,this.eventStack.get(r.correlationId),t));if(n?(o=this.getQueueInfo(e.correlationId),this.discardMeasurements(r.correlationId)):r.incompleteSubMeasurements?.delete(e.eventId),this.logger.trace(`PerformanceClient: Performance measurement ended for ${e.name}: ${e.durationMs} ms`,e.correlationId),!n)return r[e.name+"DurationMs"]=Math.floor(e.durationMs),{...r};t&&lo(t,this.logger,r);let a={...r,...e},s=0;return a.incompleteSubMeasurements?.forEach((t=>{this.logger.trace(`PerformanceClient: Incomplete submeasurement ${t.name} found for ${e.name}`,a.correlationId),s++})),a.incompleteSubMeasurements=void 0,a={...a,queuedTimeMs:o.totalQueueTime,queuedCount:o.totalQueueCount,queuedManuallyCompletedCount:o.manuallyCompletedCount,status:hr,incompleteSubsCount:s,context:i},this.truncateIntegralFields(a),this.emitEvents([a],e.correlationId),a}addFields(e,t){this.logger.trace("PerformanceClient: Updating static fields");const r=this.eventsByCorrelationId.get(t);r?this.eventsByCorrelationId.set(t,{...r,...e}):this.logger.trace("PerformanceClient: Event not found for",t)}incrementFields(e,t){this.logger.trace("PerformanceClient: Updating counters");const r=this.eventsByCorrelationId.get(t);if(r)for(const t in e){if(r.hasOwnProperty(t)){if(isNaN(Number(r[t])))return}else r[t]=0;r[t]+=e[t]}else this.logger.trace("PerformanceClient: Event not found for",t)}cacheEventByCorrelationId(e){const t=this.eventsByCorrelationId.get(e.correlationId);t?(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} added/updated`,e.correlationId),t.incompleteSubMeasurements=t.incompleteSubMeasurements||new Map,t.incompleteSubMeasurements.set(e.eventId,{name:e.name,startTimeMs:e.startTimeMs})):(this.logger.trace(`PerformanceClient: Performance measurement for ${e.name} started`,e.correlationId),this.eventsByCorrelationId.set(e.correlationId,{...e}),this.eventStack.set(e.correlationId,[]))}getQueueInfo(e){const t=this.queueMeasurements.get(e);t||this.logger.trace(`PerformanceClient: no queue measurements found for for correlationId: ${e}`);let r=0,n=0,o=0;return t?.forEach((e=>{r+=e.queueTime,n++,o+=e.manuallyCompleted?1:0})),{totalQueueTime:r,totalQueueCount:n,manuallyCompletedCount:o}}discardMeasurements(e){this.logger.trace("PerformanceClient: Performance measurements discarded",e),this.eventsByCorrelationId.delete(e),this.logger.trace("PerformanceClient: QueueMeasurements discarded",e),this.queueMeasurements.delete(e),this.logger.trace("PerformanceClient: Pre-queue times discarded",e),this.preQueueTimeByCorrelationId.delete(e),this.logger.trace("PerformanceClient: Event stack discarded",e),this.eventStack.delete(e)}addPerformanceCallback(e){for(const[t,r]of this.callbacks)if(r.toString()===e.toString())return this.logger.warning(`PerformanceClient: Performance callback is already registered with id: ${t}`),t;const t=this.generateId();return this.callbacks.set(t,e),this.logger.verbose(`PerformanceClient: Performance callback registered with id: ${t}`),t}removePerformanceCallback(e){const t=this.callbacks.delete(e);return t?this.logger.verbose(`PerformanceClient: Performance callback ${e} removed.`):this.logger.verbose(`PerformanceClient: Performance callback ${e} not removed.`),t}emitEvents(e,t){this.logger.verbose("PerformanceClient: Emitting performance events",t),this.callbacks.forEach(((r,n)=>{this.logger.trace(`PerformanceClient: Emitting event to callback ${n}`,t),r.apply(null,[e])}))}truncateIntegralFields(e){this.intFields.forEach((t=>{t in e&&"number"==typeof e[t]&&(e[t]=Math.floor(e[t]))}))}getDurationMs(e){const t=Date.now()-e;return t<0?t:0}}const go="pkce_not_created",po="crypto_nonexistent",mo="empty_navigate_uri",fo="hash_empty_error",Co="no_state_in_hash",yo="hash_does_not_contain_known_properties",vo="unable_to_parse_state",To="state_interaction_type_mismatch",Io="interaction_in_progress",wo="popup_window_error",Ao="empty_window_error",ko="user_cancelled",So="monitor_popup_timeout",Eo="monitor_window_timeout",Ro="redirect_in_iframe",bo="block_iframe_reload",_o="block_nested_popups",Po="iframe_closed_prematurely",Mo="silent_logout_unsupported",No="no_account_error",Oo="silent_prompt_value_error",qo="no_token_request_cache_error",Lo="unable_to_parse_token_request_cache_error",Uo="no_cached_authority_error",Ho="auth_request_not_set_error",Bo="invalid_cache_type",Do="non_browser_environment",xo="database_not_open",Fo="no_network_connectivity",Ko="post_request_failed",zo="get_request_failed",Go="failed_to_parse_response",$o="unable_to_load_token",Qo="crypto_key_not_found",Wo="auth_code_required",jo="auth_code_or_nativeAccountId_required",Vo="spa_code_and_nativeAccountId_present",Yo="database_unavailable",Jo="unable_to_acquire_token_from_native_platform",Xo="native_handshake_timeout",Zo="native_extension_not_installed",ei="native_connection_not_established",ti="uninitialized_public_client_application",ri="native_prompt_not_supported",ni="invalid_base64_string",oi="invalid_pop_token_request";var ii=Object.freeze({__proto__:null,authCodeOrNativeAccountIdRequired:jo,authCodeRequired:Wo,authRequestNotSetError:Ho,blockIframeReload:bo,blockNestedPopups:_o,cryptoKeyNotFound:Qo,cryptoNonExistent:po,databaseNotOpen:xo,databaseUnavailable:Yo,emptyNavigateUri:mo,emptyWindowError:Ao,failedToParseResponse:Go,getRequestFailed:zo,hashDoesNotContainKnownProperties:yo,hashEmptyError:fo,iframeClosedPrematurely:Po,interactionInProgress:Io,invalidBase64String:ni,invalidCacheType:Bo,invalidPopTokenRequest:oi,monitorPopupTimeout:So,monitorWindowTimeout:Eo,nativeConnectionNotEstablished:ei,nativeExtensionNotInstalled:Zo,nativeHandshakeTimeout:Xo,nativePromptNotSupported:ri,noAccountError:No,noCachedAuthorityError:Uo,noNetworkConnectivity:Fo,noStateInHash:Co,noTokenRequestCacheError:qo,nonBrowserEnvironment:Do,pkceNotCreated:go,popupWindowError:wo,postRequestFailed:Ko,redirectInIframe:Ro,silentLogoutUnsupported:Mo,silentPromptValueError:Oo,spaCodeAndNativeAccountIdPresent:Vo,stateInteractionTypeMismatch:To,unableToAcquireTokenFromNativePlatform:Jo,unableToLoadToken:$o,unableToParseState:vo,unableToParseTokenRequestCacheError:Lo,uninitializedPublicClientApplication:ti,userCancelled:ko});const ai="For more visit: aka.ms/msaljs/browser-errors",si={[go]:"The PKCE code challenge and verifier could not be generated.",[po]:"The crypto object or function is not available.",[mo]:"Navigation URI is empty. Please check stack trace for more info.",[fo]:`Hash value cannot be processed because it is empty. Please verify that your redirectUri is not clearing the hash. ${ai}`,[Co]:"Hash does not contain state. Please verify that the request originated from msal.",[yo]:`Hash does not contain known properites. Please verify that your redirectUri is not changing the hash.  ${ai}`,[vo]:"Unable to parse state. Please verify that the request originated from msal.",[To]:"Hash contains state but the interaction type does not match the caller.",[Io]:`Interaction is currently in progress. Please ensure that this interaction has been completed before calling an interactive API.   ${ai}`,[wo]:"Error opening popup window. This can happen if you are using IE or if popups are blocked in the browser.",[Ao]:"window.open returned null or undefined window object.",[ko]:"User cancelled the flow.",[So]:`Token acquisition in popup failed due to timeout.  ${ai}`,[Eo]:`Token acquisition in iframe failed due to timeout.  ${ai}`,[Ro]:"Redirects are not supported for iframed or brokered applications. Please ensure you are using MSAL.js in a top frame of the window if using the redirect APIs, or use the popup APIs.",[bo]:`Request was blocked inside an iframe because MSAL detected an authentication response.  ${ai}`,[_o]:"Request was blocked inside a popup because MSAL detected it was running in a popup.",[Po]:"The iframe being monitored was closed prematurely.",[Mo]:"Silent logout not supported. Please call logoutRedirect or logoutPopup instead.",[No]:"No account object provided to acquireTokenSilent and no active account has been set. Please call setActiveAccount or provide an account on the request.",[Oo]:"The value given for the prompt value is not valid for silent requests - must be set to 'none' or 'no_session'.",[qo]:"No token request found in cache.",[Lo]:"The cached token request could not be parsed.",[Uo]:"No cached authority found.",[Ho]:"Auth Request not set. Please ensure initiateAuthRequest was called from the InteractionHandler",[Bo]:"Invalid cache type",[Do]:"Login and token requests are not supported in non-browser environments.",[xo]:"Database is not open!",[Fo]:"No network connectivity. Check your internet connection.",[Ko]:"Network request failed: If the browser threw a CORS error, check that the redirectUri is registered in the Azure App Portal as type 'SPA'",[zo]:"Network request failed. Please check the network trace to determine root cause.",[Go]:"Failed to parse network response. Check network trace.",[$o]:"Error loading token to cache.",[Qo]:"Cryptographic Key or Keypair not found in browser storage.",[Wo]:"An authorization code must be provided (as the `code` property on the request) to this flow.",[jo]:"An authorization code or nativeAccountId must be provided to this flow.",[Vo]:"Request cannot contain both spa code and native account id.",[Yo]:"IndexedDB, which is required for persistent cryptographic key storage, is unavailable. This may be caused by browser privacy features which block persistent storage in third-party contexts.",[Jo]:`Unable to acquire token from native platform.  ${ai}`,[Xo]:"Timed out while attempting to establish connection to browser extension",[Zo]:"Native extension is not installed. If you think this is a mistake call the initialize function.",[ei]:`Connection to native platform has not been established. Please install a compatible browser extension and run initialize().  ${ai}`,[ti]:`You must call and await the initialize function before attempting to call any other MSAL API.  ${ai}`,[ri]:"The provided prompt is not supported by the native platform. This request should be routed to the web based flow.",[ni]:"Invalid base64 encoded string.",[oi]:"Invalid PoP token request. The request should not have both a popKid value and signPopToken set to true."},ci={pkceNotGenerated:{code:go,desc:si[go]},cryptoDoesNotExist:{code:po,desc:si[po]},emptyNavigateUriError:{code:mo,desc:si[mo]},hashEmptyError:{code:fo,desc:si[fo]},hashDoesNotContainStateError:{code:Co,desc:si[Co]},hashDoesNotContainKnownPropertiesError:{code:yo,desc:si[yo]},unableToParseStateError:{code:vo,desc:si[vo]},stateInteractionTypeMismatchError:{code:To,desc:si[To]},interactionInProgress:{code:Io,desc:si[Io]},popupWindowError:{code:wo,desc:si[wo]},emptyWindowError:{code:Ao,desc:si[Ao]},userCancelledError:{code:ko,desc:si[ko]},monitorPopupTimeoutError:{code:So,desc:si[So]},monitorIframeTimeoutError:{code:Eo,desc:si[Eo]},redirectInIframeError:{code:Ro,desc:si[Ro]},blockTokenRequestsInHiddenIframeError:{code:bo,desc:si[bo]},blockAcquireTokenInPopupsError:{code:_o,desc:si[_o]},iframeClosedPrematurelyError:{code:Po,desc:si[Po]},silentLogoutUnsupportedError:{code:Mo,desc:si[Mo]},noAccountError:{code:No,desc:si[No]},silentPromptValueError:{code:Oo,desc:si[Oo]},noTokenRequestCacheError:{code:qo,desc:si[qo]},unableToParseTokenRequestCacheError:{code:Lo,desc:si[Lo]},noCachedAuthorityError:{code:Uo,desc:si[Uo]},authRequestNotSet:{code:Ho,desc:si[Ho]},invalidCacheType:{code:Bo,desc:si[Bo]},notInBrowserEnvironment:{code:Do,desc:si[Do]},databaseNotOpen:{code:xo,desc:si[xo]},noNetworkConnectivity:{code:Fo,desc:si[Fo]},postRequestFailed:{code:Ko,desc:si[Ko]},getRequestFailed:{code:zo,desc:si[zo]},failedToParseNetworkResponse:{code:Go,desc:si[Go]},unableToLoadTokenError:{code:$o,desc:si[$o]},signingKeyNotFoundInStorage:{code:Qo,desc:si[Qo]},authCodeRequired:{code:Wo,desc:si[Wo]},authCodeOrNativeAccountRequired:{code:jo,desc:si[jo]},spaCodeAndNativeAccountPresent:{code:Vo,desc:si[Vo]},databaseUnavailable:{code:Yo,desc:si[Yo]},unableToAcquireTokenFromNativePlatform:{code:Jo,desc:si[Jo]},nativeHandshakeTimeout:{code:Xo,desc:si[Xo]},nativeExtensionNotInstalled:{code:Zo,desc:si[Zo]},nativeConnectionNotEstablished:{code:ei,desc:si[ei]},uninitializedPublicClientApplication:{code:ti,desc:si[ti]},nativePromptNotSupported:{code:ri,desc:si[ri]},invalidBase64StringError:{code:ni,desc:si[ni]},invalidPopTokenRequest:{code:oi,desc:si[oi]}};class li extends Ie{constructor(e){super(e,si[e]),Object.setPrototypeOf(this,li.prototype),this.name="BrowserAuthError"}}function di(e){return new li(e)}const hi={INTERACTION_IN_PROGRESS_VALUE:"interaction_in_progress",INVALID_GRANT_ERROR:"invalid_grant",POPUP_WIDTH:483,POPUP_HEIGHT:600,POPUP_NAME_PREFIX:"msal",DEFAULT_POLL_INTERVAL_MS:30,MSAL_SKU:"msal.js.browser"},ui="53ee284d-920a-4b59-9d30-a60315b26836",gi="ppnbnpeolgkicgegkbkbjmhlideopiji",pi="MATS",mi="Handshake",fi="HandshakeResponse",Ci="GetToken",yi="Response",vi={LocalStorage:"localStorage",SessionStorage:"sessionStorage",MemoryStorage:"memoryStorage"},Ti="GET",Ii="POST",wi="authority",Ai="request.state",ki="nonce.id_token",Si="request.origin",Ei="urlHash",Ri="request.params",bi="interaction.status",_i="ccs.credential",Pi="request.correlationId",Mi="request.native",Ni="msal.account.keys",Oi="msal.token.keys",qi="wrapper.sku",Li="wrapper.version",Ui={acquireTokenRedirect:861,acquireTokenPopup:862,ssoSilent:863,acquireTokenSilent_authCode:864,handleRedirectPromise:865,acquireTokenByCode:866,acquireTokenSilent_silentFlow:61,logout:961,logoutPopup:962};var Hi;e.InteractionType=void 0,(Hi=e.InteractionType||(e.InteractionType={})).Redirect="redirect",Hi.Popup="popup",Hi.Silent="silent",Hi.None="none";const Bi={Startup:"startup",Login:"login",Logout:"logout",AcquireToken:"acquireToken",SsoSilent:"ssoSilent",HandleRedirect:"handleRedirect",None:"none"},Di={scopes:a},xi="msal.db",Fi=`${xi}.keys`,Ki={Default:0,AccessToken:1,AccessTokenAndRefreshToken:2,RefreshToken:3,RefreshTokenAndNetwork:4,Skip:5},zi=[Ki.Default,Ki.Skip,Ki.RefreshTokenAndNetwork];function Gi(e){return encodeURIComponent(Qi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_"))}function $i(e){return Wi(e).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function Qi(e){return Wi((new TextEncoder).encode(e))}function Wi(e){const t=Array.from(e,(e=>String.fromCodePoint(e))).join("");return btoa(t)}const ji="SHA-256",Vi=new Uint8Array([1,0,1]),Yi="0123456789abcdef",Ji=new Uint32Array(1),Xi={name:"RSASSA-PKCS1-v1_5",hash:ji,modulusLength:2048,publicExponent:Vi};async function Zi(e,t,r){t?.addQueueMeasurement(cr.Sha256Digest,r);const n=(new TextEncoder).encode(e);return window.crypto.subtle.digest(ji,n)}function ea(e){return window.crypto.getRandomValues(e)}function ta(){return window.crypto.getRandomValues(Ji),Ji[0]}function ra(){const e=Date.now(),t=1024*ta()+(1023&ta()),r=new Uint8Array(16),n=Math.trunc(t/2**30),o=t&2**30-1,i=ta();r[0]=e/2**40,r[1]=e/2**32,r[2]=e/2**24,r[3]=e/65536,r[4]=e/256,r[5]=e,r[6]=112|n>>>8,r[7]=n,r[8]=128|o>>>24,r[9]=o>>>16,r[10]=o>>>8,r[11]=o,r[12]=i>>>24,r[13]=i>>>16,r[14]=i>>>8,r[15]=i;let a="";for(let e=0;e<r.length;e++)a+=Yi.charAt(r[e]>>>4),a+=Yi.charAt(15&r[e]),3!==e&&5!==e&&7!==e&&9!==e||(a+="-");return a}async function na(e){return window.crypto.subtle.exportKey("jwk",e)}async function oa(e){const t=await Zi(e);return $i(new Uint8Array(t))}const ia="storage_not_supported",aa="stubbed_public_client_application_called",sa="in_mem_redirect_unavailable";var ca=Object.freeze({__proto__:null,inMemRedirectUnavailable:sa,storageNotSupported:ia,stubbedPublicClientApplicationCalled:aa});const la={[ia]:"Given storage configuration option was not supported.",[aa]:"Stub instance of Public Client Application was called. If using msal-react, please ensure context is not used without a provider. For more visit: aka.ms/msaljs/browser-errors",[sa]:"Redirect cannot be supported. In-memory storage was selected and storeAuthStateInCookie=false, which would cause the library to be unable to handle the incoming hash. If you would like to use the redirect API, please use session/localStorage or set storeAuthStateInCookie=true."},da={storageNotSupportedError:{code:ia,desc:la[ia]},stubPcaInstanceCalled:{code:aa,desc:la[aa]},inMemRedirectUnavailable:{code:sa,desc:la[sa]}};class ha extends Ie{constructor(e,t){super(e,t),this.name="BrowserConfigurationAuthError",Object.setPrototypeOf(this,ha.prototype)}}function ua(e){return new ha(e,la[e])}function ga(e){e.location.hash="","function"==typeof e.history.replaceState&&e.history.replaceState(null,"",`${e.location.origin}${e.location.pathname}${e.location.search}`)}function pa(e){const t=e.split("#");t.shift(),window.location.hash=t.length>0?t.join("#"):""}function ma(){return window.parent!==window}function fa(){return"undefined"!=typeof window&&!!window.opener&&window.opener!==window&&"string"==typeof window.name&&0===window.name.indexOf(`${hi.POPUP_NAME_PREFIX}.`)}function Ca(){return window.location.href.split("?")[0].split("#")[0]}function ya(){const e=new er(window.location.href).getUrlComponents();return`${e.Protocol}//${e.HostNameAndPort}/`}function va(){if(er.hashContainsKnownProperties(window.location.hash)&&ma())throw di(bo)}function Ta(e){if(ma()&&!e)throw di(Ro)}function Ia(){if(fa())throw di(_o)}function wa(){if("undefined"==typeof window)throw di(Do)}function Aa(e){if(!e)throw di(ti)}function ka(e){wa(),va(),Ia(),Aa(e)}function Sa(e,t){if(ka(e),Ta(t.system.allowRedirectInIframe),t.cache.cacheLocation===vi.MemoryStorage&&!t.cache.storeAuthStateInCookie)throw ua(sa)}function Ea(e){const t=document.createElement("link");t.rel="preconnect",t.href=new URL(e).origin,t.crossOrigin="anonymous",document.head.appendChild(t),window.setTimeout((()=>{try{document.head.removeChild(t)}catch{}}),1e4)}var Ra=Object.freeze({__proto__:null,blockAPICallsBeforeInitialize:Aa,blockAcquireTokenInPopups:Ia,blockNonBrowserEnvironment:wa,blockRedirectInIframe:Ta,blockReloadInHiddenIframes:va,clearHash:ga,createGuid:function(){return ra()},getCurrentUri:Ca,getHomepage:ya,invoke:gr,invokeAsync:pr,isInIframe:ma,isInPopup:fa,preconnect:Ea,preflightCheck:ka,redirectPreflightCheck:Sa,replaceHash:pa});class ba{navigateInternal(e,t){return ba.defaultNavigateWindow(e,t)}navigateExternal(e,t){return ba.defaultNavigateWindow(e,t)}static defaultNavigateWindow(e,t){return t.noHistory?window.location.replace(e):window.location.assign(e),new Promise((e=>{setTimeout((()=>{e(!0)}),t.timeout)}))}}class _a{async sendGetRequestAsync(e,t){let r;try{r=await fetch(e,{method:Ti,headers:this.getFetchHeaders(t)})}catch(e){throw window.navigator.onLine?di(zo):di(Fo)}try{return{headers:this.getHeaderDict(r.headers),body:await r.json(),status:r.status}}catch(e){throw di(Go)}}async sendPostRequestAsync(e,r){const n=r&&r.body||t.EMPTY_STRING;let o;try{o=await fetch(e,{method:Ii,headers:this.getFetchHeaders(r),body:n})}catch(e){throw window.navigator.onLine?di(Ko):di(Fo)}try{return{headers:this.getHeaderDict(o.headers),body:await o.json(),status:o.status}}catch(e){throw di(Go)}}getFetchHeaders(e){const t=new Headers;if(!e||!e.headers)return t;const r=e.headers;return Object.keys(r).forEach((e=>{t.append(e,r[e])})),t}getHeaderDict(e){const t={};return e.forEach(((e,r)=>{t[r]=e})),t}}const Pa=1e4;const Ma="@azure/msal-browser",Na="3.19.0";class Oa{static loggerCallback(t,r){switch(t){case e.LogLevel.Error:return void console.error(r);case e.LogLevel.Info:return void console.info(r);case e.LogLevel.Verbose:return void console.debug(r);case e.LogLevel.Warning:return void console.warn(r);default:return void console.log(r)}}constructor(r){let n;this.browserEnvironment="undefined"!=typeof window,this.config=function({auth:r,cache:n,system:o,telemetry:i},a){const s={clientId:t.EMPTY_STRING,authority:`${t.DEFAULT_AUTHORITY}`,knownAuthorities:[],cloudDiscoveryMetadata:t.EMPTY_STRING,authorityMetadata:t.EMPTY_STRING,redirectUri:t.EMPTY_STRING,postLogoutRedirectUri:t.EMPTY_STRING,navigateToLoginRequestUrl:!0,clientCapabilities:[],protocolMode:ar.AAD,OIDCOptions:{serverResponseType:_.FRAGMENT,defaultScopes:[t.OPENID_SCOPE,t.PROFILE_SCOPE,t.OFFLINE_ACCESS_SCOPE]},azureCloudOptions:{azureCloudInstance:sr.None,tenant:t.EMPTY_STRING},skipAuthorityMetadataCache:!1,supportsNestedAppAuth:!1},c={cacheLocation:vi.SessionStorage,temporaryCacheLocation:vi.SessionStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!(!n||n.cacheLocation!==vi.LocalStorage),claimsBasedCachingEnabled:!1},l={loggerCallback:()=>{},logLevel:e.LogLevel.Info,piiLoggingEnabled:!1},d={...{...un,loggerOptions:l,networkClient:a?new _a:Zn,navigationClient:new ba,loadFrameTimeout:0,windowHashTimeout:o?.loadFrameTimeout||6e4,iframeHashTimeout:o?.loadFrameTimeout||Pa,navigateFrameWait:0,redirectNavigationTimeout:3e4,asyncPopups:!1,allowRedirectInIframe:!1,allowNativeBroker:!1,nativeBrokerHandshakeTimeout:o?.nativeBrokerHandshakeTimeout||2e3,pollIntervalMilliseconds:hi.DEFAULT_POLL_INTERVAL_MS},...o,loggerOptions:o?.loggerOptions||l},h={application:{appName:t.EMPTY_STRING,appVersion:t.EMPTY_STRING},client:new co};r?.protocolMode!==ar.OIDC&&r?.OIDCOptions&&new jr(d.loggerOptions).warning(JSON.stringify(Yt(zt)));if(r?.protocolMode&&r.protocolMode!==ar.AAD&&d?.allowNativeBroker)throw Yt(Gt);return{auth:{...s,...r,OIDCOptions:{...s.OIDCOptions,...r?.OIDCOptions}},cache:{...c,...n},system:d,telemetry:{...h,...i}}}(r,this.browserEnvironment);try{n=window[vi.SessionStorage]}catch(e){}const o=n?.getItem("msal.browser.log.level"),i=n?.getItem("msal.browser.log.pii")?.toLowerCase(),a="true"===i||"false"!==i&&void 0,s={...this.config.system.loggerOptions},c=o&&Object.keys(e.LogLevel).includes(o)?e.LogLevel[o]:void 0;c&&(s.loggerCallback=Oa.loggerCallback,s.logLevel=c),void 0!==a&&(s.piiLoggingEnabled=a),this.logger=new jr(s,Ma,Na),this.available=!1}getConfig(){return this.config}getLogger(){return this.logger}isAvailable(){return this.available}isBrowserEnvironment(){return this.browserEnvironment}}const qa="USER_INTERACTION_REQUIRED",La="USER_CANCEL",Ua="NO_NETWORK",Ha="TRANSIENT_ERROR",Ba="PERSISTENT_ERROR",Da="DISABLED",xa="ACCOUNT_UNAVAILABLE",Fa="NESTED_APP_AUTH_UNAVAILABLE";class Ka{static async initializeNestedAppAuthBridge(){if(void 0===window)throw new Error("window is undefined");if(void 0===window.nestedAppAuthBridge)throw new Error("window.nestedAppAuthBridge is undefined");try{window.nestedAppAuthBridge.addEventListener("message",(e=>{const t="string"==typeof e?e:e.data,r=JSON.parse(t),n=Ka.bridgeRequests.find((e=>e.requestId===r.requestId));void 0!==n&&(Ka.bridgeRequests.splice(Ka.bridgeRequests.indexOf(n),1),r.success?n.resolve(r):n.reject(r.error))}));const e=await new Promise(((e,t)=>{const r={messageType:"NestedAppAuthRequest",method:"GetInitContext",requestId:ra(),sendTime:Date.now()},n={requestId:r.requestId,method:r.method,resolve:e,reject:t};Ka.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}));return Ka.validateBridgeResultOrThrow(e.initContext)}catch(e){throw window.console.log(e),e}}getTokenInteractive(e){return this.getToken("GetTokenPopup",e)}getTokenSilent(e){return this.getToken("GetToken",e)}async getToken(e,t){const r=await this.sendRequest(e,{tokenParams:t});return{token:Ka.validateBridgeResultOrThrow(r.token),account:Ka.validateBridgeResultOrThrow(r.account)}}getHostCapabilities(){return this.capabilities??null}getAccountContext(){return this.accountContext?this.accountContext:null}sendRequest(e,t){const r={messageType:"NestedAppAuthRequest",method:e,requestId:ra(),sendTime:Date.now(),...t};return new Promise(((e,t)=>{const n={requestId:r.requestId,method:r.method,resolve:e,reject:t};Ka.bridgeRequests.push(n),window.nestedAppAuthBridge.postMessage(JSON.stringify(r))}))}static validateBridgeResultOrThrow(e){if(void 0===e){throw{status:Fa}}return e}constructor(e,t,r,n){this.sdkName=e,this.sdkVersion=t,this.accountContext=r,this.capabilities=n}static async create(){const e=await Ka.initializeNestedAppAuthBridge();return new Ka(e.sdkName,e.sdkVersion,e.accountContext,e.capabilities)}}Ka.bridgeRequests=[];class za extends Oa{constructor(){super(...arguments),this.bridgeProxy=void 0,this.accountContext=null}getModuleName(){return za.MODULE_NAME}getId(){return za.ID}getBridgeProxy(){return this.bridgeProxy}async initialize(){try{if("undefined"!=typeof window){const e=await Ka.create();this.accountContext=e.getAccountContext(),this.bridgeProxy=e,this.available=void 0!==e}}catch(e){this.logger.infoPii(`Could not initialize Nested App Auth bridge (${e})`)}return this.logger.info(`Nested App Auth Bridge available: ${this.available}`),this.available}}za.MODULE_NAME="",za.ID="NestedAppOperatingContext";class Ga extends Oa{getModuleName(){return Ga.MODULE_NAME}getId(){return Ga.ID}async initialize(){return this.available="undefined"!=typeof window,this.available}}function $a(e){return(new TextDecoder).decode(function(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");switch(t.length%4){case 0:break;case 2:t+="==";break;case 3:t+="=";break;default:throw di(ni)}const r=atob(t);return Uint8Array.from(r,(e=>e.codePointAt(0)||0))}(e))}Ga.MODULE_NAME="",Ga.ID="StandardOperatingContext";class Qa{constructor(){this.dbName=xi,this.version=1,this.tableName=Fi,this.dbOpen=!1}async open(){return new Promise(((e,t)=>{const r=window.indexedDB.open(this.dbName,this.version);r.addEventListener("upgradeneeded",(e=>{e.target.result.createObjectStore(this.tableName)})),r.addEventListener("success",(t=>{const r=t;this.db=r.target.result,this.dbOpen=!0,e()})),r.addEventListener("error",(()=>t(di(Yo))))}))}closeConnection(){const e=this.db;e&&this.dbOpen&&(e.close(),this.dbOpen=!1)}async validateDbIsOpen(){if(!this.dbOpen)return this.open()}async getItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(di(xo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).get(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async setItem(e,t){return await this.validateDbIsOpen(),new Promise(((r,n)=>{if(!this.db)return n(di(xo));const o=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).put(t,e);o.addEventListener("success",(()=>{this.closeConnection(),r()})),o.addEventListener("error",(e=>{this.closeConnection(),n(e)}))}))}async removeItem(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(di(xo));const n=this.db.transaction([this.tableName],"readwrite").objectStore(this.tableName).delete(e);n.addEventListener("success",(()=>{this.closeConnection(),t()})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async getKeys(){return await this.validateDbIsOpen(),new Promise(((e,t)=>{if(!this.db)return t(di(xo));const r=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).getAllKeys();r.addEventListener("success",(t=>{const r=t;this.closeConnection(),e(r.target.result)})),r.addEventListener("error",(e=>{this.closeConnection(),t(e)}))}))}async containsKey(e){return await this.validateDbIsOpen(),new Promise(((t,r)=>{if(!this.db)return r(di(xo));const n=this.db.transaction([this.tableName],"readonly").objectStore(this.tableName).count(e);n.addEventListener("success",(e=>{const r=e;this.closeConnection(),t(1===r.target.result)})),n.addEventListener("error",(e=>{this.closeConnection(),r(e)}))}))}async deleteDatabase(){return this.db&&this.dbOpen&&this.closeConnection(),new Promise(((e,t)=>{const r=window.indexedDB.deleteDatabase(xi),n=setTimeout((()=>t(!1)),200);r.addEventListener("success",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("blocked",(()=>(clearTimeout(n),e(!0)))),r.addEventListener("error",(()=>(clearTimeout(n),t(!1))))}))}}class Wa{constructor(){this.cache=new Map}getItem(e){return this.cache.get(e)||null}setItem(e,t){this.cache.set(e,t)}removeItem(e){this.cache.delete(e)}getKeys(){const e=[];return this.cache.forEach(((t,r)=>{e.push(r)})),e}containsKey(e){return this.cache.has(e)}clear(){this.cache.clear()}}class ja{constructor(e){this.inMemoryCache=new Wa,this.indexedDBCache=new Qa,this.logger=e}handleDatabaseAccessError(e){if(!(e instanceof li&&e.errorCode===Yo))throw e;this.logger.error("Could not access persistent storage. This may be caused by browser privacy features which block persistent storage in third-party contexts.")}async getItem(e){const t=this.inMemoryCache.getItem(e);if(!t)try{return this.logger.verbose("Queried item not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.getItem(e)}catch(e){this.handleDatabaseAccessError(e)}return t}async setItem(e,t){this.inMemoryCache.setItem(e,t);try{await this.indexedDBCache.setItem(e,t)}catch(e){this.handleDatabaseAccessError(e)}}async removeItem(e){this.inMemoryCache.removeItem(e);try{await this.indexedDBCache.removeItem(e)}catch(e){this.handleDatabaseAccessError(e)}}async getKeys(){const e=this.inMemoryCache.getKeys();if(0===e.length)try{return this.logger.verbose("In-memory cache is empty, now querying persistent storage."),await this.indexedDBCache.getKeys()}catch(e){this.handleDatabaseAccessError(e)}return e}async containsKey(e){const t=this.inMemoryCache.containsKey(e);if(!t)try{return this.logger.verbose("Key not found in in-memory cache, now querying persistent storage."),await this.indexedDBCache.containsKey(e)}catch(e){this.handleDatabaseAccessError(e)}return t}clearInMemory(){this.logger.verbose("Deleting in-memory keystore"),this.inMemoryCache.clear(),this.logger.verbose("In-memory keystore deleted")}async clearPersistent(){try{this.logger.verbose("Deleting persistent keystore");const e=await this.indexedDBCache.deleteDatabase();return e&&this.logger.verbose("Persistent keystore deleted"),e}catch(e){return this.handleDatabaseAccessError(e),!1}}}class Va{constructor(e,t){this.logger=e,function(e){if(!("crypto"in window))throw e.error("BrowserCrypto: crypto interface is unavailable"),di(po);e.verbose("BrowserCrypto: modern crypto interface available")}(e),this.cache=new ja(this.logger),this.performanceClient=t}createNewGuid(){return ra()}base64Encode(e){return Qi(e)}base64Decode(e){return $a(e)}base64UrlEncode(e){return Gi(e)}encodeKid(e){return this.base64UrlEncode(JSON.stringify({kid:e}))}async getPublicKeyThumbprint(e){const t=this.performanceClient?.startMeasurement(cr.CryptoOptsGetPublicKeyThumbprint,e.correlationId),r=await async function(e,t){return window.crypto.subtle.generateKey(Xi,e,t)}(Va.EXTRACTABLE,Va.POP_KEY_USAGES),n=await na(r.publicKey),o=Ya({e:n.e,kty:n.kty,n:n.n}),i=await this.hashString(o),a=await na(r.privateKey),s=await async function(e,t,r){return window.crypto.subtle.importKey("jwk",e,Xi,t,r)}(a,!1,["sign"]);return await this.cache.setItem(i,{privateKey:s,publicKey:r.publicKey,requestMethod:e.resourceRequestMethod,requestUri:e.resourceRequestUri}),t&&t.end({success:!0}),i}async removeTokenBindingKey(e){await this.cache.removeItem(e);return!await this.cache.containsKey(e)}async clearKeystore(){this.cache.clearInMemory();try{return await this.cache.clearPersistent(),!0}catch(e){return e instanceof Error?this.logger.error(`Clearing keystore failed with error: ${e.message}`):this.logger.error("Clearing keystore failed with unknown error"),!1}}async signJwt(e,t,r,n){const o=this.performanceClient?.startMeasurement(cr.CryptoOptsSignJwt,n),i=await this.cache.getItem(t);if(!i)throw di(Qo);const a=await na(i.publicKey),s=Ya(a),c=Gi(JSON.stringify({kid:t})),l=Gi(io.getShrHeaderString({...r?.header,alg:a.alg,kid:c}));e.cnf={jwk:JSON.parse(s)};const d=`${l}.${Gi(JSON.stringify(e))}`,h=(new TextEncoder).encode(d),u=await async function(e,t){return window.crypto.subtle.sign(Xi,e,t)}(i.privateKey,h),g=`${d}.${$i(new Uint8Array(u))}`;return o&&o.end({success:!0}),g}async hashString(e){return oa(e)}}function Ya(e){return JSON.stringify(e,Object.keys(e).sort())}Va.POP_KEY_USAGES=["sign","verify"],Va.EXTRACTABLE=!0;class Ja{constructor(e){this.validateWindowStorage(e),this.windowStorage=window[e]}validateWindowStorage(e){if(e!==vi.LocalStorage&&e!==vi.SessionStorage||!window[e])throw ua(ia)}getItem(e){return this.windowStorage.getItem(e)}setItem(e,t){this.windowStorage.setItem(e,t)}removeItem(e){this.windowStorage.removeItem(e)}getKeys(){return Object.keys(this.windowStorage)}containsKey(e){return this.windowStorage.hasOwnProperty(e)}}function Xa(e,t){if(!t)return null;try{return Gn.parseRequestState(e,t).libraryState.meta}catch(e){throw Ct(Me)}}class Za extends dn{constructor(e,t,r,n,o,i){super(e,r,n,o),this.COOKIE_LIFE_MULTIPLIER=864e5,this.cacheConfig=t,this.logger=n,this.internalStorage=new Wa,this.browserStorage=this.setupBrowserStorage(this.cacheConfig.cacheLocation),this.temporaryCacheStorage=this.setupTemporaryCacheStorage(this.cacheConfig.temporaryCacheLocation,this.cacheConfig.cacheLocation),t.cacheMigrationEnabled&&(this.migrateCacheEntries(),this.createKeyMaps()),this.performanceClient=i}setupBrowserStorage(e){switch(e){case vi.LocalStorage:case vi.SessionStorage:try{return new Ja(e)}catch(e){this.logger.verbose(e);break}}return this.cacheConfig.cacheLocation=vi.MemoryStorage,new Wa}setupTemporaryCacheStorage(e,t){switch(t){case vi.LocalStorage:case vi.SessionStorage:try{return new Ja(e||vi.SessionStorage)}catch(e){return this.logger.verbose(e),this.internalStorage}default:return this.internalStorage}}migrateCacheEntries(){const e=`${t.CACHE_PREFIX}.${m}`,r=`${t.CACHE_PREFIX}.${f}`,n=`${t.CACHE_PREFIX}.${y}`,o=`${t.CACHE_PREFIX}.${v}`,i=[this.browserStorage.getItem(e),this.browserStorage.getItem(r),this.browserStorage.getItem(n),this.browserStorage.getItem(o)];[m,f,y,v].forEach(((e,t)=>{const r=i[t];r&&this.setTemporaryCache(e,r,!0)}))}createKeyMaps(){this.logger.trace("BrowserCacheManager - createKeyMaps called.");const e=this.getItem(Ni),t=this.getItem(`${Oi}.${this.clientId}`);if(e&&t)return void this.logger.verbose("BrowserCacheManager:createKeyMaps - account and token key maps already exist, skipping migration.");this.browserStorage.getKeys().forEach((e=>{if(this.isCredentialKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);if(r&&r.hasOwnProperty("credentialType"))switch(r.credentialType){case H.ID_TOKEN:if(Sr(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - idToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - idToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ID_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching idToken schema with value containing idToken credentialType field but value failed IdTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed idToken validation on key: ${e}`);break;case H.ACCESS_TOKEN:case H.ACCESS_TOKEN_WITH_AUTH_SCHEME:if(kr(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - accessToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - accessToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.ACCESS_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching accessToken schema with value containing accessToken credentialType field but value failed AccessTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed accessToken validation on key: ${e}`);break;case H.REFRESH_TOKEN:if(Er(r)){this.logger.trace("BrowserCacheManager:createKeyMaps - refreshToken found, saving key to token key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - refreshToken with key: ${e} found, saving key to token key map`);const t=r,n=this.updateCredentialCacheKey(e,t);return void this.addTokenKey(n,H.REFRESH_TOKEN)}this.logger.trace("BrowserCacheManager:createKeyMaps - key found matching refreshToken schema with value containing refreshToken credentialType field but value failed RefreshTokenEntity validation, skipping."),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - failed refreshToken validation on key: ${e}`)}}}if(this.isAccountKey(e)){const t=this.getItem(e);if(t){const r=this.validateAndParseJson(t);r&&on.isAccountEntity(r)&&(this.logger.trace("BrowserCacheManager:createKeyMaps - account found, saving key to account key map"),this.logger.tracePii(`BrowserCacheManager:createKeyMaps - account with key: ${e} found, saving key to account key map`),this.addAccountKeyToMap(e))}}}))}validateAndParseJson(e){try{const t=JSON.parse(e);return t&&"object"==typeof t?t:null}catch(e){return null}}getItem(e){return this.browserStorage.getItem(e)}setItem(e,t){this.browserStorage.setItem(e,t)}getAccount(e,t){this.logger.trace("BrowserCacheManager.getAccount called");const r=this.getCachedAccountEntity(e);return this.updateOutdatedCachedAccount(e,r,t)}getCachedAccountEntity(e){const t=this.getItem(e);if(!t)return this.removeAccountKeyFromMap(e),null;const r=this.validateAndParseJson(t);return r&&on.isAccountEntity(r)?dn.toObject(new on,r):(this.removeAccountKeyFromMap(e),null)}setAccount(e){this.logger.trace("BrowserCacheManager.setAccount called");const t=e.generateAccountKey();this.setItem(t,JSON.stringify(e)),this.addAccountKeyToMap(t)}getAccountKeys(){this.logger.trace("BrowserCacheManager.getAccountKeys called");const e=this.getItem(Ni);return e?JSON.parse(e):(this.logger.verbose("BrowserCacheManager.getAccountKeys - No account keys found"),[])}addAccountKeyToMap(e){this.logger.trace("BrowserCacheManager.addAccountKeyToMap called"),this.logger.tracePii(`BrowserCacheManager.addAccountKeyToMap called with key: ${e}`);const t=this.getAccountKeys();-1===t.indexOf(e)?(t.push(e),this.setItem(Ni,JSON.stringify(t)),this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key added")):this.logger.verbose("BrowserCacheManager.addAccountKeyToMap account key already exists in map")}removeAccountKeyFromMap(e){this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap called"),this.logger.tracePii(`BrowserCacheManager.removeAccountKeyFromMap called with key: ${e}`);const t=this.getAccountKeys(),r=t.indexOf(e);r>-1?(t.splice(r,1),this.setItem(Ni,JSON.stringify(t)),this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap account key removed")):this.logger.trace("BrowserCacheManager.removeAccountKeyFromMap key not found in existing map")}async removeAccount(e){super.removeAccount(e),this.removeAccountKeyFromMap(e)}removeOutdatedAccount(e){this.removeItem(e),this.removeAccountKeyFromMap(e)}removeIdToken(e){super.removeIdToken(e),this.removeTokenKey(e,H.ID_TOKEN)}async removeAccessToken(e){super.removeAccessToken(e),this.removeTokenKey(e,H.ACCESS_TOKEN)}removeRefreshToken(e){super.removeRefreshToken(e),this.removeTokenKey(e,H.REFRESH_TOKEN)}getTokenKeys(){this.logger.trace("BrowserCacheManager.getTokenKeys called");const e=this.getItem(`${Oi}.${this.clientId}`);if(e){const t=this.validateAndParseJson(e);if(t&&t.hasOwnProperty("idToken")&&t.hasOwnProperty("accessToken")&&t.hasOwnProperty("refreshToken"))return t;this.logger.error("BrowserCacheManager.getTokenKeys - Token keys found but in an unknown format. Returning empty key map.")}else this.logger.verbose("BrowserCacheManager.getTokenKeys - No token keys found");return{idToken:[],accessToken:[],refreshToken:[]}}addTokenKey(e,t){this.logger.trace("BrowserCacheManager addTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:-1===r.idToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - idToken added to map"),r.idToken.push(e));break;case H.ACCESS_TOKEN:-1===r.accessToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - accessToken added to map"),r.accessToken.push(e));break;case H.REFRESH_TOKEN:-1===r.refreshToken.indexOf(e)&&(this.logger.info("BrowserCacheManager: addTokenKey - refreshToken added to map"),r.refreshToken.push(e));break;default:throw this.logger.error(`BrowserCacheManager:addTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${Oi}.${this.clientId}`,JSON.stringify(r))}removeTokenKey(e,t){this.logger.trace("BrowserCacheManager removeTokenKey called");const r=this.getTokenKeys();switch(t){case H.ID_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove idToken with key: ${e} from map`);const n=r.idToken.indexOf(e);n>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - idToken removed from map"),r.idToken.splice(n,1)):this.logger.info("BrowserCacheManager: removeTokenKey - idToken does not exist in map. Either it was previously removed or it was never added.");break;case H.ACCESS_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove accessToken with key: ${e} from map`);const o=r.accessToken.indexOf(e);o>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - accessToken removed from map"),r.accessToken.splice(o,1)):this.logger.info("BrowserCacheManager: removeTokenKey - accessToken does not exist in map. Either it was previously removed or it was never added.");break;case H.REFRESH_TOKEN:this.logger.infoPii(`BrowserCacheManager: removeTokenKey - attempting to remove refreshToken with key: ${e} from map`);const i=r.refreshToken.indexOf(e);i>-1?(this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken removed from map"),r.refreshToken.splice(i,1)):this.logger.info("BrowserCacheManager: removeTokenKey - refreshToken does not exist in map. Either it was previously removed or it was never added.");break;default:throw this.logger.error(`BrowserCacheManager:removeTokenKey - CredentialType provided invalid. CredentialType: ${t}`),Ct(Xe)}this.setItem(`${Oi}.${this.clientId}`,JSON.stringify(r))}getIdTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Sr(r)?(this.logger.trace("BrowserCacheManager.getIdTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getIdTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ID_TOKEN),null)}setIdTokenCredential(e){this.logger.trace("BrowserCacheManager.setIdTokenCredential called");const t=vr(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ID_TOKEN)}getAccessTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null;const r=this.validateAndParseJson(t);return r&&kr(r)?(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAccessTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.ACCESS_TOKEN),null)}setAccessTokenCredential(e){this.logger.trace("BrowserCacheManager.setAccessTokenCredential called");const t=vr(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.ACCESS_TOKEN)}getRefreshTokenCredential(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null;const r=this.validateAndParseJson(t);return r&&Er(r)?(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: cache hit"),r):(this.logger.trace("BrowserCacheManager.getRefreshTokenCredential: called, no cache hit"),this.removeTokenKey(e,H.REFRESH_TOKEN),null)}setRefreshTokenCredential(e){this.logger.trace("BrowserCacheManager.setRefreshTokenCredential called");const t=vr(e);this.setItem(t,JSON.stringify(e)),this.addTokenKey(t,H.REFRESH_TOKEN)}getAppMetadata(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&(n=e,(o=r)&&0===n.indexOf(B)&&o.hasOwnProperty("clientId")&&o.hasOwnProperty("environment"))?(this.logger.trace("BrowserCacheManager.getAppMetadata: cache hit"),r):(this.logger.trace("BrowserCacheManager.getAppMetadata: called, no cache hit"),null);var n,o}setAppMetadata(e){this.logger.trace("BrowserCacheManager.setAppMetadata called");const t=function({environment:e,clientId:t}){return[B,e,t].join(U.CACHE_KEY_SEPARATOR).toLowerCase()}(e);this.setItem(t,JSON.stringify(e))}getServerTelemetry(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){const r=0===e.indexOf(Q.CACHE_KEY);let n=!0;return t&&(n=t.hasOwnProperty("failedRequests")&&t.hasOwnProperty("errors")&&t.hasOwnProperty("cacheHits")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getServerTelemetry: cache hit"),r):(this.logger.trace("BrowserCacheManager.getServerTelemetry: called, no cache hit"),null)}setServerTelemetry(e,t){this.logger.trace("BrowserCacheManager.setServerTelemetry called"),this.setItem(e,JSON.stringify(t))}getAuthorityMetadata(e){const t=this.internalStorage.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getAuthorityMetadata: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){return!!t&&0===e.indexOf(x)&&t.hasOwnProperty("aliases")&&t.hasOwnProperty("preferred_cache")&&t.hasOwnProperty("preferred_network")&&t.hasOwnProperty("canonical_authority")&&t.hasOwnProperty("authorization_endpoint")&&t.hasOwnProperty("token_endpoint")&&t.hasOwnProperty("issuer")&&t.hasOwnProperty("aliasesFromNetwork")&&t.hasOwnProperty("endpointsFromNetwork")&&t.hasOwnProperty("expiresAt")&&t.hasOwnProperty("jwks_uri")}(e,r)?(this.logger.trace("BrowserCacheManager.getAuthorityMetadata: cache hit"),r):null}getAuthorityMetadataKeys(){return this.internalStorage.getKeys().filter((e=>this.isAuthorityMetadata(e)))}setWrapperMetadata(e,t){this.internalStorage.setItem(qi,e),this.internalStorage.setItem(Li,t)}getWrapperMetadata(){return[this.internalStorage.getItem(qi)||t.EMPTY_STRING,this.internalStorage.getItem(Li)||t.EMPTY_STRING]}setAuthorityMetadata(e,t){this.logger.trace("BrowserCacheManager.setAuthorityMetadata called"),this.internalStorage.setItem(e,JSON.stringify(t))}getActiveAccount(){const e=this.generateCacheKey(I),t=this.getItem(e);if(!t){this.logger.trace("BrowserCacheManager.getActiveAccount: No active account filters cache schema found, looking for legacy schema");const e=this.generateCacheKey(T),t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null;const r=this.getAccountInfoFilteredBy({localAccountId:t});return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Legacy active account cache schema found"),this.logger.trace("BrowserCacheManager.getActiveAccount: Adding active account filters cache schema"),this.setActiveAccount(r),r):null}const r=this.validateAndParseJson(t);return r?(this.logger.trace("BrowserCacheManager.getActiveAccount: Active account filters schema found"),this.getAccountInfoFilteredBy({homeAccountId:r.homeAccountId,localAccountId:r.localAccountId,tenantId:r.tenantId})):(this.logger.trace("BrowserCacheManager.getActiveAccount: No active account found"),null)}setActiveAccount(e){const t=this.generateCacheKey(I),r=this.generateCacheKey(T);if(e){this.logger.verbose("setActiveAccount: Active account set");const n={homeAccountId:e.homeAccountId,localAccountId:e.localAccountId,tenantId:e.tenantId};this.browserStorage.setItem(t,JSON.stringify(n)),this.browserStorage.setItem(r,e.localAccountId)}else this.logger.verbose("setActiveAccount: No account passed, active account not set"),this.browserStorage.removeItem(t),this.browserStorage.removeItem(r)}getThrottlingCache(e){const t=this.getItem(e);if(!t)return this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null;const r=this.validateAndParseJson(t);return r&&function(e,t){let r=!1;e&&(r=0===e.indexOf(Y));let n=!0;return t&&(n=t.hasOwnProperty("throttleTime")),r&&n}(e,r)?(this.logger.trace("BrowserCacheManager.getThrottlingCache: cache hit"),r):(this.logger.trace("BrowserCacheManager.getThrottlingCache: called, no cache hit"),null)}setThrottlingCache(e,t){this.logger.trace("BrowserCacheManager.setThrottlingCache called"),this.setItem(e,JSON.stringify(t))}getTemporaryCache(e,t){const r=t?this.generateCacheKey(e):e;if(this.cacheConfig.storeAuthStateInCookie){const e=this.getItemCookie(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: storeAuthStateInCookies set to true, retrieving from cookies"),e}const n=this.temporaryCacheStorage.getItem(r);if(!n){if(this.cacheConfig.cacheLocation===vi.LocalStorage){const e=this.browserStorage.getItem(r);if(e)return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item found in local storage"),e}return this.logger.trace("BrowserCacheManager.getTemporaryCache: No cache item found in local storage"),null}return this.logger.trace("BrowserCacheManager.getTemporaryCache: Temporary cache item returned"),n}setTemporaryCache(e,t,r){const n=r?this.generateCacheKey(e):e;this.temporaryCacheStorage.setItem(n,t),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.setTemporaryCache: storeAuthStateInCookie set to true, setting item cookie"),this.setItemCookie(n,t))}removeItem(e){this.browserStorage.removeItem(e)}removeTemporaryItem(e){this.temporaryCacheStorage.removeItem(e),this.cacheConfig.storeAuthStateInCookie&&(this.logger.trace("BrowserCacheManager.removeItem: storeAuthStateInCookie is true, clearing item cookie"),this.clearItemCookie(e))}getKeys(){return this.browserStorage.getKeys()}async clear(){await this.removeAllAccounts(),this.removeAppMetadata(),this.temporaryCacheStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.removeTemporaryItem(e)})),this.browserStorage.getKeys().forEach((e=>{-1===e.indexOf(t.CACHE_PREFIX)&&-1===e.indexOf(this.clientId)||this.browserStorage.removeItem(e)})),this.internalStorage.clear()}async clearTokensAndKeysWithClaims(e,t){e.addQueueMeasurement(cr.ClearTokensAndKeysWithClaims,t);const r=this.getTokenKeys(),n=[];r.accessToken.forEach((e=>{const t=this.getAccessTokenCredential(e);t?.requestedClaimsHash&&e.includes(t.requestedClaimsHash.toLowerCase())&&n.push(this.removeAccessToken(e))})),await Promise.all(n),n.length>0&&this.logger.warning(`${n.length} access tokens with claims in the cache keys have been removed from the cache.`)}setItemCookie(e,t,r){let n=`${encodeURIComponent(e)}=${encodeURIComponent(t)};path=/;SameSite=Lax;`;if(r){n+=`expires=${this.getCookieExpirationTime(r)};`}this.cacheConfig.secureCookies&&(n+="Secure;"),document.cookie=n}getItemCookie(e){const r=`${encodeURIComponent(e)}=`,n=document.cookie.split(";");for(let e=0;e<n.length;e++){let t=n[e];for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(r))return decodeURIComponent(t.substring(r.length,t.length))}return t.EMPTY_STRING}clearMsalCookies(){const e=`${t.CACHE_PREFIX}.${this.clientId}`;document.cookie.split(";").forEach((t=>{for(;" "===t.charAt(0);)t=t.substring(1);if(0===t.indexOf(e)){const e=t.split("=")[0];this.clearItemCookie(e)}}))}clearItemCookie(e){this.setItemCookie(e,t.EMPTY_STRING,-1)}getCookieExpirationTime(e){const t=new Date;return new Date(t.getTime()+e*this.COOKIE_LIFE_MULTIPLIER).toUTCString()}generateCacheKey(e){return this.validateAndParseJson(e)?JSON.stringify(e):Jt.startsWith(e,t.CACHE_PREFIX)||Jt.startsWith(e,C)?e:`${t.CACHE_PREFIX}.${this.clientId}.${e}`}generateAuthorityKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${wi}.${t}`)}generateNonceKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${ki}.${t}`)}generateStateKey(e){const{libraryState:{id:t}}=Gn.parseRequestState(this.cryptoImpl,e);return this.generateCacheKey(`${Ai}.${t}`)}getCachedAuthority(e){const t=this.generateStateKey(e),r=this.getTemporaryCache(t);if(!r)return null;const n=this.generateAuthorityKey(r);return this.getTemporaryCache(n)}updateCacheEntries(e,t,r,n,o){this.logger.trace("BrowserCacheManager.updateCacheEntries called");const i=this.generateStateKey(e);this.setTemporaryCache(i,e,!1);const a=this.generateNonceKey(e);this.setTemporaryCache(a,t,!1);const s=this.generateAuthorityKey(e);if(this.setTemporaryCache(s,r,!1),o){const e={credential:o.homeAccountId,type:kn};this.setTemporaryCache(_i,JSON.stringify(e),!0)}else if(n){const e={credential:n,type:Sn};this.setTemporaryCache(_i,JSON.stringify(e),!0)}}resetRequestCache(e){this.logger.trace("BrowserCacheManager.resetRequestCache called"),e&&(this.temporaryCacheStorage.getKeys().forEach((t=>{-1!==t.indexOf(e)&&this.removeTemporaryItem(t)})),this.removeTemporaryItem(this.generateStateKey(e)),this.removeTemporaryItem(this.generateNonceKey(e)),this.removeTemporaryItem(this.generateAuthorityKey(e))),this.removeTemporaryItem(this.generateCacheKey(Ri)),this.removeTemporaryItem(this.generateCacheKey(Si)),this.removeTemporaryItem(this.generateCacheKey(Ei)),this.removeTemporaryItem(this.generateCacheKey(Pi)),this.removeTemporaryItem(this.generateCacheKey(_i)),this.removeTemporaryItem(this.generateCacheKey(Mi)),this.setInteractionInProgress(!1)}cleanRequestByState(e){if(this.logger.trace("BrowserCacheManager.cleanRequestByState called"),e){const r=this.generateStateKey(e),n=this.temporaryCacheStorage.getItem(r);this.logger.infoPii(`BrowserCacheManager.cleanRequestByState: Removing temporary cache items for state: ${n}`),this.resetRequestCache(n||t.EMPTY_STRING)}this.clearMsalCookies()}cleanRequestByInteractionType(e){this.logger.trace("BrowserCacheManager.cleanRequestByInteractionType called"),this.temporaryCacheStorage.getKeys().forEach((t=>{if(-1===t.indexOf(Ai))return;const r=this.temporaryCacheStorage.getItem(t);if(!r)return;const n=Xa(this.cryptoImpl,r);n&&n.interactionType===e&&(this.logger.infoPii(`BrowserCacheManager.cleanRequestByInteractionType: Removing temporary cache items for state: ${r}`),this.resetRequestCache(r))})),this.clearMsalCookies(),this.setInteractionInProgress(!1)}cacheCodeRequest(e){this.logger.trace("BrowserCacheManager.cacheCodeRequest called");const t=Qi(JSON.stringify(e));this.setTemporaryCache(Ri,t,!0)}getCachedRequest(e){this.logger.trace("BrowserCacheManager.getCachedRequest called");const t=this.getTemporaryCache(Ri,!0);if(!t)throw di(qo);let r;try{r=JSON.parse($a(t))}catch(e){throw this.logger.errorPii(`Attempted to parse: ${t}`),this.logger.error(`Parsing cached token request threw with error: ${e}`),di(Lo)}if(this.removeTemporaryItem(this.generateCacheKey(Ri)),!r.authority){const t=this.generateAuthorityKey(e),n=this.getTemporaryCache(t);if(!n)throw di(Uo);r.authority=n}return r}getCachedNativeRequest(){this.logger.trace("BrowserCacheManager.getCachedNativeRequest called");const e=this.getTemporaryCache(Mi,!0);if(!e)return this.logger.trace("BrowserCacheManager.getCachedNativeRequest: No cached native request found"),null;const t=this.validateAndParseJson(e);return t||(this.logger.error("BrowserCacheManager.getCachedNativeRequest: Unable to parse native request"),null)}isInteractionInProgress(e){const t=this.getInteractionInProgress();return e?t===this.clientId:!!t}getInteractionInProgress(){const e=`${t.CACHE_PREFIX}.${bi}`;return this.getTemporaryCache(e,!1)}setInteractionInProgress(e){const r=`${t.CACHE_PREFIX}.${bi}`;if(e){if(this.getInteractionInProgress())throw di(Io);this.setTemporaryCache(r,this.clientId,!1)}else e||this.getInteractionInProgress()!==this.clientId||this.removeTemporaryItem(r)}getLegacyLoginHint(){const e=this.getTemporaryCache(C);e&&(this.browserStorage.removeItem(C),this.logger.verbose("Cached ADAL id token retrieved."));const t=this.getTemporaryCache(m,!0);t&&(this.browserStorage.removeItem(this.generateCacheKey(m)),this.logger.verbose("Cached MSAL.js v1 id token retrieved"));const r=t||e;if(r){const e=yt(r,$a);if(e.preferred_username)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 preferred_username as loginHint"),e.preferred_username;if(e.upn)return this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, setting ADAL/MSAL v1 upn as loginHint"),e.upn;this.logger.verbose("No SSO params used and ADAL/MSAL v1 token retrieved, however, no account hint claim found. Enable preferred_username or upn id token claim to get SSO.")}return null}updateCredentialCacheKey(e,t){const r=vr(t);if(e!==r){const n=this.getItem(e);if(n)return this.browserStorage.removeItem(e),this.setItem(r,n),this.logger.verbose(`Updated an outdated ${t.credentialType} cache key`),r;this.logger.error(`Attempted to update an outdated ${t.credentialType} cache key but no item matching the outdated key was found in storage`)}return e}async hydrateCache(e,t){const r=Tr(e.account?.homeAccountId,e.account?.environment,e.idToken,this.clientId,e.tenantId);let n;t.claims&&(n=await this.cryptoImpl.hashString(t.claims));const o={idToken:r,accessToken:Ir(e.account?.homeAccountId,e.account.environment,e.accessToken,this.clientId,e.tenantId,e.scopes.join(" "),e.expiresOn?e.expiresOn.getTime()/1e3:0,e.extExpiresOn?e.extExpiresOn.getTime()/1e3:0,$a,void 0,e.tokenType,void 0,t.sshKid,t.claims,n)};return this.saveCacheRecord(o)}async saveCacheRecord(e,t,r){try{await super.saveCacheRecord(e,t,r)}catch(e){if(e instanceof ln&&this.performanceClient&&r)try{const e=this.getTokenKeys();this.performanceClient.addFields({cacheRtCount:e.refreshToken.length,cacheIdCount:e.idToken.length,cacheAtCount:e.accessToken.length},r)}catch(e){}throw e}}}const es=(e,t)=>new Za(e,{cacheLocation:vi.MemoryStorage,temporaryCacheLocation:vi.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1},Qr,t);function ts(e,t,r,n){return e.verbose("getAllAccounts called"),r?t.getAllAccounts(n):[]}function rs(e,t,r){if(t.trace("getAccount called"),0===Object.keys(e).length)return t.warning("getAccount: No accountFilter provided"),null;const n=r.getAccountInfoFilteredBy(e);return n?(t.verbose("getAccount: Account matching provided filter found, returning"),n):(t.verbose("getAccount: No matching account found, returning null"),null)}function ns(e,t,r){if(t.trace("getAccountByUsername called"),!e)return t.warning("getAccountByUsername: No username provided"),null;const n=r.getAccountInfoFilteredBy({username:e});return n?(t.verbose("getAccountByUsername: Account matching username found, returning"),t.verbosePii(`getAccountByUsername: Returning signed-in accounts matching username: ${e}`),n):(t.verbose("getAccountByUsername: No matching account found, returning null"),null)}function os(e,t,r){if(t.trace("getAccountByHomeId called"),!e)return t.warning("getAccountByHomeId: No homeAccountId provided"),null;const n=r.getAccountInfoFilteredBy({homeAccountId:e});return n?(t.verbose("getAccountByHomeId: Account matching homeAccountId found, returning"),t.verbosePii(`getAccountByHomeId: Returning signed-in accounts matching homeAccountId: ${e}`),n):(t.verbose("getAccountByHomeId: No matching account found, returning null"),null)}function is(e,t,r){if(t.trace("getAccountByLocalId called"),!e)return t.warning("getAccountByLocalId: No localAccountId provided"),null;const n=r.getAccountInfoFilteredBy({localAccountId:e});return n?(t.verbose("getAccountByLocalId: Account matching localAccountId found, returning"),t.verbosePii(`getAccountByLocalId: Returning signed-in accounts matching localAccountId: ${e}`),n):(t.verbose("getAccountByLocalId: No matching account found, returning null"),null)}function as(e,t){t.setActiveAccount(e)}function ss(e){return e.getActiveAccount()}const cs={INITIALIZE_START:"msal:initializeStart",INITIALIZE_END:"msal:initializeEnd",ACCOUNT_ADDED:"msal:accountAdded",ACCOUNT_REMOVED:"msal:accountRemoved",ACTIVE_ACCOUNT_CHANGED:"msal:activeAccountChanged",LOGIN_START:"msal:loginStart",LOGIN_SUCCESS:"msal:loginSuccess",LOGIN_FAILURE:"msal:loginFailure",ACQUIRE_TOKEN_START:"msal:acquireTokenStart",ACQUIRE_TOKEN_SUCCESS:"msal:acquireTokenSuccess",ACQUIRE_TOKEN_FAILURE:"msal:acquireTokenFailure",ACQUIRE_TOKEN_NETWORK_START:"msal:acquireTokenFromNetworkStart",SSO_SILENT_START:"msal:ssoSilentStart",SSO_SILENT_SUCCESS:"msal:ssoSilentSuccess",SSO_SILENT_FAILURE:"msal:ssoSilentFailure",ACQUIRE_TOKEN_BY_CODE_START:"msal:acquireTokenByCodeStart",ACQUIRE_TOKEN_BY_CODE_SUCCESS:"msal:acquireTokenByCodeSuccess",ACQUIRE_TOKEN_BY_CODE_FAILURE:"msal:acquireTokenByCodeFailure",HANDLE_REDIRECT_START:"msal:handleRedirectStart",HANDLE_REDIRECT_END:"msal:handleRedirectEnd",POPUP_OPENED:"msal:popupOpened",LOGOUT_START:"msal:logoutStart",LOGOUT_SUCCESS:"msal:logoutSuccess",LOGOUT_FAILURE:"msal:logoutFailure",LOGOUT_END:"msal:logoutEnd",RESTORE_FROM_BFCACHE:"msal:restoreFromBFCache"};class ls{constructor(e,t){this.eventCallbacks=new Map,this.logger=e,this.browserCrypto=t,this.listeningToStorageEvents=!1,this.handleAccountCacheChange=this.handleAccountCacheChange.bind(this)}addEventCallback(e){if("undefined"!=typeof window){const t=ra();return this.eventCallbacks.set(t,e),this.logger.verbose(`Event callback registered with id: ${t}`),t}return null}removeEventCallback(e){this.eventCallbacks.delete(e),this.logger.verbose(`Event callback ${e} removed.`)}enableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?this.logger.verbose("Account storage listener already registered."):(this.logger.verbose("Adding account storage listener."),this.listeningToStorageEvents=!0,window.addEventListener("storage",this.handleAccountCacheChange)))}disableAccountStorageEvents(){"undefined"!=typeof window&&(this.listeningToStorageEvents?(this.logger.verbose("Removing account storage listener."),window.removeEventListener("storage",this.handleAccountCacheChange),this.listeningToStorageEvents=!1):this.logger.verbose("No account storage listener registered."))}emitEvent(e,t,r,n){if("undefined"!=typeof window){const o={eventType:e,interactionType:t||null,payload:r||null,error:n||null,timestamp:Date.now()};this.logger.info(`Emitting event: ${e}`),this.eventCallbacks.forEach(((t,r)=>{this.logger.verbose(`Emitting event to callback ${r}: ${e}`),t.apply(null,[o])}))}}handleAccountCacheChange(e){try{e.key?.includes(I)&&this.emitEvent(cs.ACTIVE_ACCOUNT_CHANGED);const t=e.newValue||e.oldValue;if(!t)return;const r=JSON.parse(t);if("object"!=typeof r||!on.isAccountEntity(r))return;const n=dn.toObject(new on,r).getAccountInfo();!e.oldValue&&e.newValue?(this.logger.info("Account was added to cache in a different window"),this.emitEvent(cs.ACCOUNT_ADDED,void 0,n)):!e.newValue&&e.oldValue&&(this.logger.info("Account was removed from cache in a different window"),this.emitEvent(cs.ACCOUNT_REMOVED,void 0,n))}catch(e){return}}}class ds{constructor(e,t,r,n,o,i,a,s,c){this.config=e,this.browserStorage=t,this.browserCrypto=r,this.networkClient=this.config.system.networkClient,this.eventHandler=o,this.navigationClient=i,this.nativeMessageHandler=s,this.correlationId=c||ra(),this.logger=n.clone(hi.MSAL_SKU,Na,this.correlationId),this.performanceClient=a}async clearCacheOnLogout(e){if(e){on.accountInfoIsEqual(e,this.browserStorage.getActiveAccount(),!1)&&(this.logger.verbose("Setting active account to null"),this.browserStorage.setActiveAccount(null));try{await this.browserStorage.removeAccount(on.generateAccountCacheKey(e)),this.logger.verbose("Cleared cache items belonging to the account provided in the logout request.")}catch(e){this.logger.error("Account provided in logout request was not found. Local cache unchanged.")}}else try{this.logger.verbose("No account provided in logout request, clearing all cache items.",this.correlationId),await this.browserStorage.clear(),await this.browserCrypto.clearKeystore()}catch(e){this.logger.error("Attempted to clear all MSAL cache items and failed. Local cache unchanged.")}}getRedirectUri(e){this.logger.verbose("getRedirectUri called");const t=e||this.config.auth.redirectUri||Ca();return er.getAbsoluteUrl(t,Ca())}initializeServerTelemetryManager(e,t){this.logger.verbose("initializeServerTelemetryManager called");const r={clientId:this.config.auth.clientId,correlationId:this.correlationId,apiId:e,forceRefresh:t||!1,wrapperSKU:this.browserStorage.getWrapperMetadata()[0],wrapperVer:this.browserStorage.getWrapperMetadata()[1]};return new ao(r,this.browserStorage)}async getDiscoveredAuthority(e,t,r){this.performanceClient.addQueueMeasurement(cr.StandardInteractionClientGetDiscoveredAuthority,this.correlationId);const n={protocolMode:this.config.auth.protocolMode,OIDCOptions:this.config.auth.OIDCOptions,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},o=e||this.config.auth.authority,i=Ur.generateAuthority(o,t||this.config.auth.azureCloudOptions),a=await pr(Dr,cr.AuthorityFactoryCreateDiscoveredInstance,this.logger,this.performanceClient,this.correlationId)(i,this.config.system.networkClient,this.browserStorage,n,this.logger,this.correlationId,this.performanceClient);if(r&&!a.isAlias(r.environment))throw Yt($t);return a}}const hs=32;async function us(e,t,r){e.addQueueMeasurement(cr.GeneratePkceCodes,r);const n=gr(gs,cr.GenerateCodeVerifier,t,e,r)(e,t,r);return{verifier:n,challenge:await pr(ps,cr.GenerateCodeChallengeFromVerifier,t,e,r)(n,e,t,r)}}function gs(e,t,r){try{const n=new Uint8Array(hs);gr(ea,cr.GetRandomValues,t,e,r)(n);return $i(n)}catch(e){throw di(go)}}async function ps(e,t,r,n){t.addQueueMeasurement(cr.GenerateCodeChallengeFromVerifier,n);try{const o=await pr(Zi,cr.Sha256Digest,r,t,n)(e,t,n);return $i(new Uint8Array(o))}catch(e){throw di(go)}}async function ms(e,t,r,n){r.addQueueMeasurement(cr.InitializeBaseRequest,e.correlationId);const o=e.authority||t.auth.authority,i=[...e&&e.scopes||[]],a={...e,correlationId:e.correlationId,authority:o,scopes:i};if(a.authenticationScheme){if(a.authenticationScheme===W.SSH){if(!e.sshJwk)throw Yt(Dt);if(!e.sshKid)throw Yt(xt)}n.verbose(`Authentication Scheme set to "${a.authenticationScheme}" as configured in Auth request`)}else a.authenticationScheme=W.BEARER,n.verbose('Authentication Scheme wasn\'t explicitly set in request, defaulting to "Bearer" request');return t.cache.claimsBasedCachingEnabled&&e.claims&&!Jt.isEmptyObj(e.claims)&&(a.requestedClaimsHash=await oa(e.claims)),a}async function fs(e,t,r,n,o){n.addQueueMeasurement(cr.InitializeSilentRequest,e.correlationId);const i=await pr(ms,cr.InitializeBaseRequest,o,n,e.correlationId)(e,r,n,o);return{...e,...i,account:t,forceRefresh:e.forceRefresh||!1}}class Cs extends ds{async initializeAuthorizationCodeRequest(e){this.performanceClient.addQueueMeasurement(cr.StandardInteractionClientInitializeAuthorizationCodeRequest,this.correlationId);const r=await pr(us,cr.GeneratePkceCodes,this.logger,this.performanceClient,this.correlationId)(this.performanceClient,this.logger,this.correlationId),n={...e,redirectUri:e.redirectUri,code:t.EMPTY_STRING,codeVerifier:r.verifier};return e.codeChallenge=r.challenge,e.codeChallengeMethod=t.S256_CODE_CHALLENGE_METHOD,n}initializeLogoutRequest(e){this.logger.verbose("initializeLogoutRequest called",e?.correlationId);const t={correlationId:this.correlationId||ra(),...e};if(e)if(e.logoutHint)this.logger.verbose("logoutHint has already been set in logoutRequest");else if(e.account){const r=this.getLogoutHintFromIdTokenClaims(e.account);r&&(this.logger.verbose("Setting logoutHint to login_hint ID Token Claim value for the account provided"),t.logoutHint=r)}else this.logger.verbose("logoutHint was not set and account was not passed into logout request, logoutHint will not be set");else this.logger.verbose("logoutHint will not be set since no logout request was configured");return e&&null===e.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri passed as null, not setting post logout redirect uri",t.correlationId):e&&e.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to uri set on logout request",t.correlationId),t.postLogoutRedirectUri=er.getAbsoluteUrl(e.postLogoutRedirectUri,Ca())):null===this.config.auth.postLogoutRedirectUri?this.logger.verbose("postLogoutRedirectUri configured as null and no uri set on request, not passing post logout redirect",t.correlationId):this.config.auth.postLogoutRedirectUri?(this.logger.verbose("Setting postLogoutRedirectUri to configured uri",t.correlationId),t.postLogoutRedirectUri=er.getAbsoluteUrl(this.config.auth.postLogoutRedirectUri,Ca())):(this.logger.verbose("Setting postLogoutRedirectUri to current page",t.correlationId),t.postLogoutRedirectUri=er.getAbsoluteUrl(Ca(),Ca())),t}getLogoutHintFromIdTokenClaims(e){const t=e.idTokenClaims;if(t){if(t.login_hint)return t.login_hint;this.logger.verbose("The ID Token Claims tied to the provided account do not contain a login_hint claim, logoutHint will not be added to logout request")}else this.logger.verbose("The provided account does not contain ID Token Claims, logoutHint will not be added to logout request");return null}async createAuthCodeClient(e,t,r,n){this.performanceClient.addQueueMeasurement(cr.StandardInteractionClientCreateAuthCodeClient,this.correlationId);const o=await pr(this.getClientConfiguration.bind(this),cr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e,t,r,n);return new Yn(o,this.performanceClient)}async getClientConfiguration(e,r,n,o){this.performanceClient.addQueueMeasurement(cr.StandardInteractionClientGetClientConfiguration,this.correlationId);const i=await pr(this.getDiscoveredAuthority.bind(this),cr.StandardInteractionClientGetDiscoveredAuthority,this.logger,this.performanceClient,this.correlationId)(r,n,o),a=this.config.system.loggerOptions;return{authOptions:{clientId:this.config.auth.clientId,authority:i,clientCapabilities:this.config.auth.clientCapabilities},systemOptions:{tokenRenewalOffsetSeconds:this.config.system.tokenRenewalOffsetSeconds,preventCorsPreflight:!0},loggerOptions:{loggerCallback:a.loggerCallback,piiLoggingEnabled:a.piiLoggingEnabled,logLevel:a.logLevel,correlationId:this.correlationId},cacheOptions:{claimsBasedCachingEnabled:this.config.cache.claimsBasedCachingEnabled},cryptoInterface:this.browserCrypto,networkInterface:this.networkClient,storageInterface:this.browserStorage,serverTelemetryManager:e,libraryInfo:{sku:hi.MSAL_SKU,version:Na,cpu:t.EMPTY_STRING,os:t.EMPTY_STRING},telemetry:this.config.telemetry}}async initializeAuthorizationRequest(e,r){this.performanceClient.addQueueMeasurement(cr.StandardInteractionClientInitializeAuthorizationRequest,this.correlationId);const n=this.getRedirectUri(e.redirectUri),o={interactionType:r},i=Gn.setRequestState(this.browserCrypto,e&&e.state||t.EMPTY_STRING,o),a={...await pr(ms,cr.InitializeBaseRequest,this.logger,this.performanceClient,this.correlationId)({...e,correlationId:this.correlationId},this.config,this.performanceClient,this.logger),redirectUri:n,state:i,nonce:e.nonce||ra(),responseMode:this.config.auth.OIDCOptions.serverResponseType},s=e.account||this.browserStorage.getActiveAccount();if(s&&(this.logger.verbose("Setting validated request account",this.correlationId),this.logger.verbosePii(`Setting validated request account: ${s.homeAccountId}`,this.correlationId),a.account=s),!a.loginHint&&!s){const e=this.browserStorage.getLegacyLoginHint();e&&(a.loginHint=e)}return a}}const ys="user_switch",vs={[ys]:"User attempted to switch accounts in the native broker, which is not allowed. All new accounts must sign-in through the standard web flow first, please try again."};class Ts extends Ie{constructor(e,t,r){super(e,t),Object.setPrototypeOf(this,Ts.prototype),this.name="NativeAuthError",this.ext=r}}function Is(e){return!(!e.ext||!e.ext.status||"PERSISTENT_ERROR"!==e.ext.status&&"DISABLED"!==e.ext.status)||(!(!e.ext||!e.ext.error||-2147186943!==e.ext.error)||"ContentError"===e.errorCode)}function ws(e,t,r){if(r&&r.status)switch(r.status){case"ACCOUNT_UNAVAILABLE":return zn(Pn);case"USER_INTERACTION_REQUIRED":return new Fn(e,t);case"USER_CANCEL":return di(ko);case"NO_NETWORK":return di(Fo)}return new Ts(e,vs[e]||t,r)}class As extends Cs{async acquireToken(e){this.performanceClient.addQueueMeasurement(cr.SilentCacheClientAcquireToken,e.correlationId);const t=this.initializeServerTelemetryManager(Ui.acquireTokenSilent_silentFlow),r=await pr(this.getClientConfiguration.bind(this),cr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(t,e.authority,e.azureCloudOptions,e.account),n=new Xn(r,this.performanceClient);this.logger.verbose("Silent auth client created");try{const t=(await pr(n.acquireCachedToken.bind(n),cr.SilentFlowClientAcquireCachedToken,this.logger,this.performanceClient,e.correlationId)(e))[0];return this.performanceClient.addFields({fromCache:!0},e.correlationId),t}catch(e){throw e instanceof li&&e.errorCode===Qo&&this.logger.verbose("Signing keypair for bound access token not found. Refreshing bound access token and generating a new crypto keypair."),e}}logout(e){this.logger.verbose("logoutRedirect called");const t=this.initializeLogoutRequest(e);return this.clearCacheOnLogout(t?.account)}}const ks="brk_client_id",Ss="brk_redirect_uri";class Es extends ds{constructor(e,t,r,n,o,i,a,s,c,l,d,h){super(e,t,r,n,o,i,s,c,h),this.apiId=a,this.accountId=l,this.nativeMessageHandler=c,this.nativeStorageManager=d,this.silentCacheClient=new As(e,this.nativeStorageManager,r,n,o,i,s,c,h)}async acquireToken(e){this.performanceClient.addQueueMeasurement(cr.NativeInteractionClientAcquireToken,e.correlationId),this.logger.trace("NativeInteractionClient - acquireToken called.");const t=this.performanceClient.startMeasurement(cr.NativeInteractionClientAcquireToken,e.correlationId),r=fr(),n=await this.initializeNativeRequest(e);try{const e=await this.acquireTokensFromCache(this.accountId,n);return t.end({success:!0,isNativeBroker:!1,fromCache:!0}),e}catch(e){this.logger.info("MSAL internal Cache does not contain tokens, proceed to make a native call")}const{...o}=n,i={method:Ci,request:o},a=await this.nativeMessageHandler.sendMessage(i),s=this.validateNativeResponse(a);return this.handleNativeResponse(s,n,r).then((e=>(t.end({success:!0,isNativeBroker:!0,requestId:e.requestId}),e))).catch((e=>{throw t.end({success:!1,errorCode:e.errorCode,subErrorCode:e.subError,isNativeBroker:!0}),e}))}createSilentCacheRequest(e,t){return{authority:e.authority,correlationId:this.correlationId,scopes:Jr.fromString(e.scope).asArray(),account:t,forceRefresh:!1}}async acquireTokensFromCache(e,t){if(!e)throw this.logger.warning("NativeInteractionClient:acquireTokensFromCache - No nativeAccountId provided"),Ct(Ye);const r=this.browserStorage.getBaseAccountInfo({nativeAccountId:e});if(!r)throw Ct(Ye);try{const e=this.createSilentCacheRequest(t,r),n=await this.silentCacheClient.acquireToken(e),o={...r,idTokenClaims:n?.idTokenClaims,idToken:n?.idToken};return{...n,account:o}}catch(e){throw e}}async acquireTokenRedirect(e,t){this.logger.trace("NativeInteractionClient - acquireTokenRedirect called.");const{...r}=e;delete r.onRedirectNavigate;const n=await this.initializeNativeRequest(r),o={method:Ci,request:n};try{const e=await this.nativeMessageHandler.sendMessage(o);this.validateNativeResponse(e)}catch(e){if(e instanceof Ts&&Is(e))throw e}this.browserStorage.setTemporaryCache(Mi,JSON.stringify(n),!0);const i={apiId:Ui.acquireTokenRedirect,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},a=this.config.auth.navigateToLoginRequestUrl?window.location.href:this.getRedirectUri(e.redirectUri);t.end({success:!0}),await this.navigationClient.navigateExternal(a,i)}async handleRedirectPromise(e,t){if(this.logger.trace("NativeInteractionClient - handleRedirectPromise called."),!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const r=this.browserStorage.getCachedNativeRequest();if(!r)return this.logger.verbose("NativeInteractionClient - handleRedirectPromise called but there is no cached request, returning null."),e&&t&&e?.addFields({errorCode:"no_cached_request"},t),null;const{prompt:n,...o}=r;n&&this.logger.verbose("NativeInteractionClient - handleRedirectPromise called and prompt was included in the original request, removing prompt from cached request to prevent second interaction with native broker window."),this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Mi));const i={method:Ci,request:o},a=fr();try{this.logger.verbose("NativeInteractionClient - handleRedirectPromise sending message to native broker.");const e=await this.nativeMessageHandler.sendMessage(i);this.validateNativeResponse(e);const t=this.handleNativeResponse(e,o,a);return this.browserStorage.setInteractionInProgress(!1),await t}catch(e){throw this.browserStorage.setInteractionInProgress(!1),e}}logout(){return this.logger.trace("NativeInteractionClient - logout called."),Promise.reject("Logout not implemented yet")}async handleNativeResponse(e,t,r){this.logger.trace("NativeInteractionClient - handleNativeResponse called.");const n=yt(e.id_token,$a),o=this.createHomeAccountIdentifier(e,n),i=this.browserStorage.getAccountInfoFilteredBy({nativeAccountId:t.accountId})?.homeAccountId;if(o!==i&&e.account.id!==t.accountId)throw ws(ys);const a=await this.getDiscoveredAuthority(t.authority),s=Vn(this.browserStorage,a,o,$a,n,e.client_info,void 0,n.tid,void 0,e.account.id,this.logger),c=await this.generateAuthenticationResult(e,t,n,s,a.canonicalAuthority,r);return this.cacheAccount(s),this.cacheNativeTokens(e,t,o,n,e.access_token,c.tenantId,r),c}createHomeAccountIdentifier(e,r){return on.generateHomeAccountId(e.client_info||t.EMPTY_STRING,Tt,this.logger,this.browserCrypto,r)}generateScopes(e,t){return e.scope?Jr.fromString(e.scope):Jr.fromString(t.scope)}async generatePopAccessToken(e,t){if(t.tokenType===W.POP&&t.signPopToken){if(e.shr)return this.logger.trace("handleNativeServerResponse: SHR is enabled in native layer"),e.shr;const r=new Qn(this.browserCrypto),n={resourceRequestMethod:t.resourceRequestMethod,resourceRequestUri:t.resourceRequestUri,shrClaims:t.shrClaims,shrNonce:t.shrNonce};if(!t.keyId)throw Ct(st);return r.signPopToken(e.access_token,t.keyId,n)}return e.access_token}async generateAuthenticationResult(e,r,n,o,i,a){const s=this.addTelemetryFromNativeResponse(e),c=e.scope?Jr.fromString(e.scope):Jr.fromString(r.scope),l=e.account.properties||{},d=l.UID||n.oid||n.sub||t.EMPTY_STRING,h=l.TenantId||n.tid||t.EMPTY_STRING,u=rn(o.getAccountInfo(),void 0,n,e.id_token);u.nativeAccountId!==e.account.id&&(u.nativeAccountId=e.account.id);const g=await this.generatePopAccessToken(e,r),p=r.tokenType===W.POP?W.POP:W.BEARER;return{authority:i,uniqueId:d,tenantId:h,scopes:c.asArray(),account:u,idToken:e.id_token,idTokenClaims:n,accessToken:g,fromCache:!!s&&this.isResponseFromCache(s),expiresOn:new Date(1e3*Number(a+e.expires_in)),tokenType:p,correlationId:this.correlationId,state:e.state,fromNativeBroker:!0}}cacheAccount(e){this.browserStorage.setAccount(e),this.browserStorage.removeAccountContext(e).catch((e=>{this.logger.error(`Error occurred while removing account context from browser storage. ${e}`)}))}cacheNativeTokens(e,r,n,o,i,a,s){const c=Tr(n,r.authority,e.id_token||"",r.clientId,o.tid||""),l=s+(r.tokenType===W.POP?t.SHR_NONCE_VALIDITY:("string"==typeof e.expires_in?parseInt(e.expires_in,10):e.expires_in)||0),d=this.generateScopes(e,r),h={idToken:c,accessToken:Ir(n,r.authority,i,r.clientId,o.tid||a,d.printScopes(),l,0,$a,void 0,r.tokenType,void 0,r.keyId)};this.nativeStorageManager.saveCacheRecord(h,r.storeInCache)}addTelemetryFromNativeResponse(e){const t=this.getMATSFromResponse(e);return t?(this.performanceClient.addFields({extensionId:this.nativeMessageHandler.getExtensionId(),extensionVersion:this.nativeMessageHandler.getExtensionVersion(),matsBrokerVersion:t.broker_version,matsAccountJoinOnStart:t.account_join_on_start,matsAccountJoinOnEnd:t.account_join_on_end,matsDeviceJoin:t.device_join,matsPromptBehavior:t.prompt_behavior,matsApiErrorCode:t.api_error_code,matsUiVisible:t.ui_visible,matsSilentCode:t.silent_code,matsSilentBiSubCode:t.silent_bi_sub_code,matsSilentMessage:t.silent_message,matsSilentStatus:t.silent_status,matsHttpStatus:t.http_status,matsHttpEventCount:t.http_event_count},this.correlationId),t):null}validateNativeResponse(e){if(e.hasOwnProperty("access_token")&&e.hasOwnProperty("id_token")&&e.hasOwnProperty("client_info")&&e.hasOwnProperty("account")&&e.hasOwnProperty("scope")&&e.hasOwnProperty("expires_in"))return e;throw we(fe,"Response missing expected properties.")}getMATSFromResponse(e){if(e.properties.MATS)try{return JSON.parse(e.properties.MATS)}catch(e){this.logger.error("NativeInteractionClient - Error parsing MATS telemetry, returning null instead")}return null}isResponseFromCache(e){return void 0===e.is_cached?(this.logger.verbose("NativeInteractionClient - MATS telemetry does not contain field indicating if response was served from cache. Returning false."),!1):!!e.is_cached}async initializeNativeRequest(e){this.logger.trace("NativeInteractionClient - initializeNativeRequest called");const t=e.authority||this.config.auth.authority;e.account&&await this.getDiscoveredAuthority(t,e.azureCloudOptions,e.account);const r=new er(t);r.validateAsUri();const{scopes:n,...o}=e,i=new Jr(n||[]);i.appendScopes(a);const s={...o,accountId:this.accountId,clientId:this.config.auth.clientId,authority:r.urlString,scope:i.printScopes(),redirectUri:this.getRedirectUri(e.redirectUri),prompt:(()=>{switch(this.apiId){case Ui.ssoSilent:case Ui.acquireTokenSilent_silentFlow:return this.logger.trace("initializeNativeRequest: silent request sets prompt to none"),R.NONE}if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:return this.logger.trace("initializeNativeRequest: prompt is compatible with native flow"),e.prompt;default:throw this.logger.trace(`initializeNativeRequest: prompt = ${e.prompt} is not compatible with native flow`),di(ri)}else this.logger.trace("initializeNativeRequest: prompt was not provided")})(),correlationId:this.correlationId,tokenType:e.authenticationScheme,windowTitleSubstring:document.title,extraParameters:{...e.extraQueryParameters,...e.tokenQueryParameters},extendedExpiryToken:!1,keyId:e.popKid};if(s.signPopToken&&e.popKid)throw di(oi);if(this.handleExtraBrokerParams(s),s.extraParameters=s.extraParameters||{},s.extraParameters.telemetry=pi,e.authenticationScheme===W.POP){const t={resourceRequestUri:e.resourceRequestUri,resourceRequestMethod:e.resourceRequestMethod,shrClaims:e.shrClaims,shrNonce:e.shrNonce},r=new Qn(this.browserCrypto);let n;if(s.keyId)n=this.browserCrypto.base64UrlEncode(JSON.stringify({kid:s.keyId})),s.signPopToken=!1;else{const o=await pr(r.generateCnf.bind(r),cr.PopTokenGenerateCnf,this.logger,this.performanceClient,e.correlationId)(t,this.logger);n=o.reqCnfString,s.keyId=o.kid,s.signPopToken=!0}s.reqCnf=n}return s}handleExtraBrokerParams(e){if(e.extraParameters&&e.extraParameters.hasOwnProperty(ks)&&e.extraParameters.hasOwnProperty(Ss)&&e.extraParameters.hasOwnProperty(Fr)){const t=e.extraParameters[Fr],r=e.redirectUri,n=e.extraParameters[Ss];e.extraParameters={child_client_id:t,child_redirect_uri:r},e.redirectUri=n}}}class Rs{constructor(e,t,r,n){this.logger=e,this.handshakeTimeoutMs=t,this.extensionId=n,this.resolvers=new Map,this.handshakeResolvers=new Map,this.messageChannel=new MessageChannel,this.windowListener=this.onWindowMessage.bind(this),this.performanceClient=r,this.handshakeEvent=r.startMeasurement(cr.NativeMessageHandlerHandshake)}async sendMessage(e){this.logger.trace("NativeMessageHandler - sendMessage called.");const t={channel:ui,extensionId:this.extensionId,responseId:ra(),body:e};return this.logger.trace("NativeMessageHandler - Sending request to browser extension"),this.logger.tracePii(`NativeMessageHandler - Sending request to browser extension: ${JSON.stringify(t)}`),this.messageChannel.port1.postMessage(t),new Promise(((e,r)=>{this.resolvers.set(t.responseId,{resolve:e,reject:r})}))}static async createProvider(e,t,r){e.trace("NativeMessageHandler - createProvider called.");try{const n=new Rs(e,t,r,gi);return await n.sendHandshakeRequest(),n}catch(n){const o=new Rs(e,t,r);return await o.sendHandshakeRequest(),o}}async sendHandshakeRequest(){this.logger.trace("NativeMessageHandler - sendHandshakeRequest called."),window.addEventListener("message",this.windowListener,!1);const e={channel:ui,extensionId:this.extensionId,responseId:ra(),body:{method:mi}};return this.handshakeEvent.add({extensionId:this.extensionId,extensionHandshakeTimeoutMs:this.handshakeTimeoutMs}),this.messageChannel.port1.onmessage=e=>{this.onChannelMessage(e)},window.postMessage(e,window.origin,[this.messageChannel.port2]),new Promise(((t,r)=>{this.handshakeResolvers.set(e.responseId,{resolve:t,reject:r}),this.timeoutId=window.setTimeout((()=>{window.removeEventListener("message",this.windowListener,!1),this.messageChannel.port1.close(),this.messageChannel.port2.close(),this.handshakeEvent.end({extensionHandshakeTimedOut:!0,success:!1}),r(di(Xo)),this.handshakeResolvers.delete(e.responseId)}),this.handshakeTimeoutMs)}))}onWindowMessage(e){if(this.logger.trace("NativeMessageHandler - onWindowMessage called"),e.source!==window)return;const t=e.data;if(t.channel&&t.channel===ui&&(!t.extensionId||t.extensionId===this.extensionId)&&t.body.method===mi){const e=this.handshakeResolvers.get(t.responseId);if(!e)return void this.logger.trace(`NativeMessageHandler.onWindowMessage - resolver can't be found for request ${t.responseId}`);this.logger.verbose(t.extensionId?`Extension with id: ${t.extensionId} not installed`:"No extension installed"),clearTimeout(this.timeoutId),this.messageChannel.port1.close(),this.messageChannel.port2.close(),window.removeEventListener("message",this.windowListener,!1),this.handshakeEvent.end({success:!1,extensionInstalled:!1}),e.reject(di(Zo))}}onChannelMessage(e){this.logger.trace("NativeMessageHandler - onChannelMessage called.");const t=e.data,r=this.resolvers.get(t.responseId),n=this.handshakeResolvers.get(t.responseId);try{const e=t.body.method;if(e===yi){if(!r)return;const e=t.body.response;if(this.logger.trace("NativeMessageHandler - Received response from browser extension"),this.logger.tracePii(`NativeMessageHandler - Received response from browser extension: ${JSON.stringify(e)}`),"Success"!==e.status)r.reject(ws(e.code,e.description,e.ext));else{if(!e.result)throw we(fe,"Event does not contain result.");e.result.code&&e.result.description?r.reject(ws(e.result.code,e.result.description,e.result.ext)):r.resolve(e.result)}this.resolvers.delete(t.responseId)}else if(e===fi){if(!n)return void this.logger.trace(`NativeMessageHandler.onChannelMessage - resolver can't be found for request ${t.responseId}`);clearTimeout(this.timeoutId),window.removeEventListener("message",this.windowListener,!1),this.extensionId=t.extensionId,this.extensionVersion=t.body.version,this.logger.verbose(`NativeMessageHandler - Received HandshakeResponse from extension: ${this.extensionId}`),this.handshakeEvent.end({extensionInstalled:!0,success:!0}),n.resolve(),this.handshakeResolvers.delete(t.responseId)}}catch(t){this.logger.error("Error parsing response from WAM Extension"),this.logger.errorPii(`Error parsing response from WAM Extension: ${t}`),this.logger.errorPii(`Unable to parse ${e}`),r?r.reject(t):n&&n.reject(t)}}getExtensionId(){return this.extensionId}getExtensionVersion(){return this.extensionVersion}static isNativeAvailable(e,t,r,n){if(t.trace("isNativeAvailable called"),!e.system.allowNativeBroker)return t.trace("isNativeAvailable: allowNativeBroker is not enabled, returning false"),!1;if(!r)return t.trace("isNativeAvailable: WAM extension provider is not initialized, returning false"),!1;if(n)switch(n){case W.BEARER:case W.POP:return t.trace("isNativeAvailable: authenticationScheme is supported, returning true"),!0;default:return t.trace("isNativeAvailable: authenticationScheme is not supported, returning false"),!1}return!0}}class bs{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async handleCodeResponse(e,t){let r;this.performanceClient.addQueueMeasurement(cr.HandleCodeResponse,t.correlationId);try{r=this.authModule.handleFragmentResponse(e,t.state)}catch(e){throw e instanceof In&&e.subError===ko?di(ko):e}return pr(this.handleCodeResponseFromServer.bind(this),cr.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)(r,t)}async handleCodeResponseFromServer(e,t,r=!0){if(this.performanceClient.addQueueMeasurement(cr.HandleCodeResponseFromServer,t.correlationId),this.logger.trace("InteractionHandler.handleCodeResponseFromServer called"),this.authCodeRequest.code=e.code,e.cloud_instance_host_name&&await pr(this.authModule.updateAuthority.bind(this.authModule),cr.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,t.correlationId)(e.cloud_instance_host_name,t.correlationId),r&&(e.nonce=t.nonce||void 0),e.state=t.state,e.client_info)this.authCodeRequest.clientInfo=e.client_info;else{const e=this.createCcsCredentials(t);e&&(this.authCodeRequest.ccsCredential=e)}return await pr(this.authModule.acquireToken.bind(this.authModule),cr.AuthClientAcquireToken,this.logger,this.performanceClient,t.correlationId)(this.authCodeRequest,e)}createCcsCredentials(e){return e.account?{credential:e.account.homeAccountId,type:kn}:e.loginHint?{credential:e.loginHint,type:Sn}:null}}function _s(e,t,r){const n=Zt(e);if(!n)throw Xt(e)?(r.error(`A ${t} is present in the iframe but it does not contain known properties. It's likely that the ${t} has been replaced by code running on the redirectUri page.`),r.errorPii(`The ${t} detected is: ${e}`),di(yo)):(r.error(`The request has returned to the redirectUri but a ${t} is not present. It's likely that the ${t} has been removed or the page has been redirected by code running on the redirectUri page.`),di(fo));return n}class Ps extends Cs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.unloadWindow=this.unloadWindow.bind(this),this.nativeStorage=s}acquireToken(e){try{const t=this.generatePopupName(e.scopes||a,e.authority||this.config.auth.authority),r=e.popupWindowAttributes||{};if(this.config.system.asyncPopups)return this.logger.verbose("asyncPopups set to true, acquiring token"),this.acquireTokenPopupAsync(e,t,r);{this.logger.verbose("asyncPopup set to false, opening popup before acquiring token");const n=this.openSizedPopup("about:blank",t,r);return this.acquireTokenPopupAsync(e,t,r,n)}}catch(e){return Promise.reject(e)}}logout(e){try{this.logger.verbose("logoutPopup called");const t=this.initializeLogoutRequest(e),r=this.generateLogoutPopupName(t),n=e&&e.authority,o=e&&e.mainWindowRedirectUri,i=e?.popupWindowAttributes||{};if(this.config.system.asyncPopups)return this.logger.verbose("asyncPopups set to true"),this.logoutPopupAsync(t,r,i,n,void 0,o);{this.logger.verbose("asyncPopup set to false, opening popup");const e=this.openSizedPopup("about:blank",r,i);return this.logoutPopupAsync(t,r,i,n,e,o)}}catch(e){return Promise.reject(e)}}async acquireTokenPopupAsync(t,r,n,o){this.logger.verbose("acquireTokenPopupAsync called");const i=this.initializeServerTelemetryManager(Ui.acquireTokenPopup),a=await pr(this.initializeAuthorizationRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Popup);Ea(a.authority);try{const s=await pr(this.initializeAuthorizationCodeRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(a),c=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(i,a.authority,a.azureCloudOptions,a.account),l=Rs.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme);let d;l&&(d=this.performanceClient.startMeasurement(cr.FetchAccountIdWithNativeBroker,t.correlationId));const h=await c.getAuthCodeUrl({...a,nativeBroker:l}),u=new bs(c,this.browserStorage,s,this.logger,this.performanceClient),g={popup:o,popupName:r,popupWindowAttributes:n},p=this.initiateAuthRequest(h,g);this.eventHandler.emitEvent(cs.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:p},null);const m=await this.monitorPopupForHash(p),f=gr(_s,cr.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(m,this.config.auth.OIDCOptions.serverResponseType,this.logger);if(wn.removeThrottle(this.browserStorage,this.config.auth.clientId,s),f.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),d&&d.end({success:!0,isNativeBroker:!0}),!this.nativeMessageHandler)throw di(ei);const e=new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,f.accountId,this.nativeStorage,a.correlationId),{userRequestState:t}=Gn.parseRequestState(this.browserCrypto,a.state);return await e.acquireToken({...a,state:t,prompt:void 0})}return await u.handleCodeResponse(f,a)}catch(e){throw o&&o.close(),e instanceof Ie&&(e.setCorrelationId(this.correlationId),i.cacheFailedRequest(e)),e}}async logoutPopupAsync(t,r,n,o,i,a){this.logger.verbose("logoutPopupAsync called"),this.eventHandler.emitEvent(cs.LOGOUT_START,e.InteractionType.Popup,t);const s=this.initializeServerTelemetryManager(Ui.logoutPopup);try{await this.clearCacheOnLogout(t.account);const c=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(s,o,void 0,t.account||void 0);try{c.authority.endSessionEndpoint}catch{if(t.account?.homeAccountId&&t.postLogoutRedirectUri&&c.authority.protocolMode===ar.OIDC){if(this.browserStorage.removeAccount(t.account?.homeAccountId),this.eventHandler.emitEvent(cs.LOGOUT_SUCCESS,e.InteractionType.Popup,t),a){const e={apiId:Ui.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=er.getAbsoluteUrl(a,Ca());await this.navigationClient.navigateInternal(t,e)}return void(i&&i.close())}}const l=c.getLogoutUri(t);this.eventHandler.emitEvent(cs.LOGOUT_SUCCESS,e.InteractionType.Popup,t);const d=this.openPopup(l,{popupName:r,popupWindowAttributes:n,popup:i});if(this.eventHandler.emitEvent(cs.POPUP_OPENED,e.InteractionType.Popup,{popupWindow:d},null),await this.monitorPopupForHash(d).catch((()=>{})),a){const e={apiId:Ui.logoutPopup,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},t=er.getAbsoluteUrl(a,Ca());this.logger.verbose("Redirecting main window to url specified in the request"),this.logger.verbosePii(`Redirecting main window to: ${t}`),await this.navigationClient.navigateInternal(t,e)}else this.logger.verbose("No main window navigation requested")}catch(t){throw i&&i.close(),t instanceof Ie&&(t.setCorrelationId(this.correlationId),s.cacheFailedRequest(t)),this.browserStorage.setInteractionInProgress(!1),this.eventHandler.emitEvent(cs.LOGOUT_FAILURE,e.InteractionType.Popup,null,t),this.eventHandler.emitEvent(cs.LOGOUT_END,e.InteractionType.Popup),t}this.eventHandler.emitEvent(cs.LOGOUT_END,e.InteractionType.Popup)}initiateAuthRequest(e,t){if(e)return this.logger.infoPii(`Navigate to: ${e}`),this.openPopup(e,t);throw this.logger.error("Navigate url is empty"),di(mo)}monitorPopupForHash(e){return new Promise(((t,r)=>{this.logger.verbose("PopupHandler.monitorPopupForHash - polling started");const n=setInterval((()=>{if(e.closed)return this.logger.error("PopupHandler.monitorPopupForHash - window closed"),clearInterval(n),void r(di(ko));let o="";try{o=e.location.href}catch(e){}if(!o||"about:blank"===o)return;clearInterval(n);let i="";const a=this.config.auth.OIDCOptions.serverResponseType;e&&(i=a===_.QUERY?e.location.search:e.location.hash),this.logger.verbose("PopupHandler.monitorPopupForHash - popup window is on same origin as caller"),t(i)}),this.config.system.pollIntervalMilliseconds)})).finally((()=>{this.cleanPopup(e)}))}openPopup(e,t){try{let r;if(t.popup?(r=t.popup,this.logger.verbosePii(`Navigating popup window to: ${e}`),r.location.assign(e)):void 0===t.popup&&(this.logger.verbosePii(`Opening popup window to: ${e}`),r=this.openSizedPopup(e,t.popupName,t.popupWindowAttributes)),!r)throw di(Ao);return r.focus&&r.focus(),this.currentWindow=r,window.addEventListener("beforeunload",this.unloadWindow),r}catch(e){throw this.logger.error("error opening popup "+e.message),this.browserStorage.setInteractionInProgress(!1),di(wo)}}openSizedPopup(e,t,r){const n=window.screenLeft?window.screenLeft:window.screenX,o=window.screenTop?window.screenTop:window.screenY,i=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,a=window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;let s=r.popupSize?.width,c=r.popupSize?.height,l=r.popupPosition?.top,d=r.popupPosition?.left;return(!s||s<0||s>i)&&(this.logger.verbose("Default popup window width used. Window width not configured or invalid."),s=hi.POPUP_WIDTH),(!c||c<0||c>a)&&(this.logger.verbose("Default popup window height used. Window height not configured or invalid."),c=hi.POPUP_HEIGHT),(!l||l<0||l>a)&&(this.logger.verbose("Default popup window top position used. Window top not configured or invalid."),l=Math.max(0,a/2-hi.POPUP_HEIGHT/2+o)),(!d||d<0||d>i)&&(this.logger.verbose("Default popup window left position used. Window left not configured or invalid."),d=Math.max(0,i/2-hi.POPUP_WIDTH/2+n)),window.open(e,t,`width=${s}, height=${c}, top=${l}, left=${d}, scrollbars=yes`)}unloadWindow(t){this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Popup),this.currentWindow&&this.currentWindow.close(),t.preventDefault()}cleanPopup(e){e&&e.close(),window.removeEventListener("beforeunload",this.unloadWindow),this.browserStorage.setInteractionInProgress(!1)}generatePopupName(e,t){return`${hi.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${e.join("-")}.${t}.${this.correlationId}`}generateLogoutPopupName(e){const t=e.account&&e.account.homeAccountId;return`${hi.POPUP_NAME_PREFIX}.${this.config.auth.clientId}.${t}.${this.correlationId}`}}class Ms{constructor(e,t,r,n,o){this.authModule=e,this.browserStorage=t,this.authCodeRequest=r,this.logger=n,this.performanceClient=o}async initiateAuthRequest(e,t){if(this.logger.verbose("RedirectHandler.initiateAuthRequest called"),e){t.redirectStartPage&&(this.logger.verbose("RedirectHandler.initiateAuthRequest: redirectStartPage set, caching start page"),this.browserStorage.setTemporaryCache(Si,t.redirectStartPage,!0)),this.browserStorage.setTemporaryCache(Pi,this.authCodeRequest.correlationId,!0),this.browserStorage.cacheCodeRequest(this.authCodeRequest),this.logger.infoPii(`RedirectHandler.initiateAuthRequest: Navigate to: ${e}`);const r={apiId:Ui.acquireTokenRedirect,timeout:t.redirectTimeout,noHistory:!1};if("function"==typeof t.onRedirectNavigate){this.logger.verbose("RedirectHandler.initiateAuthRequest: Invoking onRedirectNavigate callback");return!1!==t.onRedirectNavigate(e)?(this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate did not return false, navigating"),void await t.navigationClient.navigateExternal(e,r)):void this.logger.verbose("RedirectHandler.initiateAuthRequest: onRedirectNavigate returned false, stopping navigation")}return this.logger.verbose("RedirectHandler.initiateAuthRequest: Navigating window to navigate url"),void await t.navigationClient.navigateExternal(e,r)}throw this.logger.info("RedirectHandler.initiateAuthRequest: Navigate url is empty"),di(mo)}async handleCodeResponse(e,t){this.logger.verbose("RedirectHandler.handleCodeResponse called"),this.browserStorage.setInteractionInProgress(!1);const r=this.browserStorage.generateStateKey(t),n=this.browserStorage.getTemporaryCache(r);if(!n)throw Ct(Oe,"Cached State");let o;try{o=this.authModule.handleFragmentResponse(e,n)}catch(e){throw e instanceof In&&e.subError===ko?di(ko):e}const i=this.browserStorage.generateNonceKey(n),a=this.browserStorage.getTemporaryCache(i);if(this.authCodeRequest.code=o.code,o.cloud_instance_host_name&&await pr(this.authModule.updateAuthority.bind(this.authModule),cr.UpdateTokenEndpointAuthority,this.logger,this.performanceClient,this.authCodeRequest.correlationId)(o.cloud_instance_host_name,this.authCodeRequest.correlationId),o.nonce=a||void 0,o.state=n,o.client_info)this.authCodeRequest.clientInfo=o.client_info;else{const e=this.checkCcsCredentials();e&&(this.authCodeRequest.ccsCredential=e)}const s=await this.authModule.acquireToken(this.authCodeRequest,o);return this.browserStorage.cleanRequestByState(t),s}checkCcsCredentials(){const e=this.browserStorage.getTemporaryCache(_i,!0);if(e)try{return JSON.parse(e)}catch(t){this.authModule.logger.error("Cache credential could not be parsed"),this.authModule.logger.errorPii(`Cache credential could not be parsed: ${e}`)}return null}}class Ns extends Cs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,a,c,l),this.nativeStorage=s}async acquireToken(t){const r=await pr(this.initializeAuthorizationRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,this.correlationId)(t,e.InteractionType.Redirect);this.browserStorage.updateCacheEntries(r.state,r.nonce,r.authority,r.loginHint||"",r.account||null);const n=this.initializeServerTelemetryManager(Ui.acquireTokenRedirect),o=t=>{t.persisted&&(this.logger.verbose("Page was restored from back/forward cache. Clearing temporary cache."),this.browserStorage.cleanRequestByState(r.state),this.eventHandler.emitEvent(cs.RESTORE_FROM_BFCACHE,e.InteractionType.Redirect))};try{const e=await pr(this.initializeAuthorizationCodeRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,this.correlationId)(r),i=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(n,r.authority,r.azureCloudOptions,r.account),a=new Ms(i,this.browserStorage,e,this.logger,this.performanceClient),s=await i.getAuthCodeUrl({...r,nativeBroker:Rs.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),c=this.getRedirectStartPage(t.redirectStartPage);return this.logger.verbosePii(`Redirect start page: ${c}`),window.addEventListener("pageshow",o),await a.initiateAuthRequest(s,{navigationClient:this.navigationClient,redirectTimeout:this.config.system.redirectNavigationTimeout,redirectStartPage:c,onRedirectNavigate:t.onRedirectNavigate})}catch(e){throw e instanceof Ie&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),window.removeEventListener("pageshow",o),this.browserStorage.cleanRequestByState(r.state),e}}async handleRedirectPromise(r="",n){const o=this.initializeServerTelemetryManager(Ui.handleRedirectPromise);try{if(!this.browserStorage.isInteractionInProgress(!0))return this.logger.info("handleRedirectPromise called but there is no interaction in progress, returning null."),null;const[i,a]=this.getRedirectResponse(r||"");if(!i)return this.logger.info("handleRedirectPromise did not detect a response as a result of a redirect. Cleaning temporary cache."),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),n.event.errorCode="no_server_response",null;const s=this.browserStorage.getTemporaryCache(Si,!0)||t.EMPTY_STRING,c=er.removeHashFromUrl(s);if(c===er.removeHashFromUrl(window.location.href)&&this.config.auth.navigateToLoginRequestUrl){this.logger.verbose("Current page is loginRequestUrl, handling response"),s.indexOf("#")>-1&&pa(s);return await this.handleResponse(i,o)}if(!this.config.auth.navigateToLoginRequestUrl)return this.logger.verbose("NavigateToLoginRequestUrl set to false, handling response"),await this.handleResponse(i,o);if(!ma()||this.config.system.allowRedirectInIframe){this.browserStorage.setTemporaryCache(Ei,a,!0);const e={apiId:Ui.handleRedirectPromise,timeout:this.config.system.redirectNavigationTimeout,noHistory:!0};let t=!0;if(s&&"null"!==s)this.logger.verbose(`Navigating to loginRequestUrl: ${s}`),t=await this.navigationClient.navigateInternal(s,e);else{const r=ya();this.browserStorage.setTemporaryCache(Si,r,!0),this.logger.warning("Unable to get valid login request url from cache, redirecting to home page"),t=await this.navigationClient.navigateInternal(r,e)}if(!t)return await this.handleResponse(i,o)}return null}catch(t){throw t instanceof Ie&&(t.setCorrelationId(this.correlationId),o.cacheFailedRequest(t)),this.browserStorage.cleanRequestByInteractionType(e.InteractionType.Redirect),t}}getRedirectResponse(t){this.logger.verbose("getRedirectResponseHash called");let r=t;r||(r=this.config.auth.OIDCOptions.serverResponseType===_.QUERY?window.location.search:window.location.hash);let n=Zt(r);if(n){try{!function(e,t,r){if(!e.state)throw di(Co);const n=Xa(t,e.state);if(!n)throw di(vo);if(n.interactionType!==r)throw di(To)}(n,this.browserCrypto,e.InteractionType.Redirect)}catch(e){return e instanceof Ie&&this.logger.error(`Interaction type validation failed due to ${e.errorCode}: ${e.errorMessage}`),[null,""]}return ga(window),this.logger.verbose("Hash contains known properties, returning response hash"),[n,r]}const o=this.browserStorage.getTemporaryCache(Ei,!0);return this.browserStorage.removeItem(this.browserStorage.generateCacheKey(Ei)),o&&(n=Zt(o),n)?(this.logger.verbose("Hash does not contain known properties, returning cached hash"),[n,o]):[null,""]}async handleResponse(e,t){const r=e.state;if(!r)throw di(Co);const n=this.browserStorage.getCachedRequest(r);if(this.logger.verbose("handleResponse called, retrieved cached request"),e.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw di(ei);const t=new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.acquireTokenPopup,this.performanceClient,this.nativeMessageHandler,e.accountId,this.nativeStorage,n.correlationId),{userRequestState:o}=Gn.parseRequestState(this.browserCrypto,r);return t.acquireToken({...n,state:o,prompt:void 0}).finally((()=>{this.browserStorage.cleanRequestByState(r)}))}const o=this.browserStorage.getCachedAuthority(r);if(!o)throw di(Uo);const i=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(t,o);wn.removeThrottle(this.browserStorage,this.config.auth.clientId,n);return new Ms(i,this.browserStorage,n,this.logger,this.performanceClient).handleCodeResponse(e,r)}async logout(t){this.logger.verbose("logoutRedirect called");const r=this.initializeLogoutRequest(t),n=this.initializeServerTelemetryManager(Ui.logout);try{this.eventHandler.emitEvent(cs.LOGOUT_START,e.InteractionType.Redirect,t),await this.clearCacheOnLogout(r.account);const o={apiId:Ui.logout,timeout:this.config.system.redirectNavigationTimeout,noHistory:!1},i=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,this.correlationId)(n,t&&t.authority,void 0,t&&t.account||void 0);if(i.authority.protocolMode===ar.OIDC)try{i.authority.endSessionEndpoint}catch{if(r.account?.homeAccountId)return this.browserStorage.removeAccount(r.account?.homeAccountId),void this.eventHandler.emitEvent(cs.LOGOUT_SUCCESS,e.InteractionType.Redirect,r)}const a=i.getLogoutUri(r);if(this.eventHandler.emitEvent(cs.LOGOUT_SUCCESS,e.InteractionType.Redirect,r),!t||"function"!=typeof t.onRedirectNavigate)return this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);if(!1!==t.onRedirectNavigate(a))return this.logger.verbose("Logout onRedirectNavigate did not return false, navigating"),this.browserStorage.getInteractionInProgress()||this.browserStorage.setInteractionInProgress(!0),void await this.navigationClient.navigateExternal(a,o);this.browserStorage.setInteractionInProgress(!1),this.logger.verbose("Logout onRedirectNavigate returned false, stopping navigation")}catch(t){throw t instanceof Ie&&(t.setCorrelationId(this.correlationId),n.cacheFailedRequest(t)),this.eventHandler.emitEvent(cs.LOGOUT_FAILURE,e.InteractionType.Redirect,null,t),this.eventHandler.emitEvent(cs.LOGOUT_END,e.InteractionType.Redirect),t}this.eventHandler.emitEvent(cs.LOGOUT_END,e.InteractionType.Redirect)}getRedirectStartPage(e){const t=e||window.location.href;return er.getAbsoluteUrl(t,Ca())}}async function Os(e,t,r,n,o){if(t.addQueueMeasurement(cr.SilentHandlerInitiateAuthRequest,n),!e)throw r.info("Navigate url is empty"),di(mo);return o?pr(Ls,cr.SilentHandlerLoadFrame,r,t,n)(e,o,t,n):gr(Us,cr.SilentHandlerLoadFrameSync,r,t,n)(e)}async function qs(e,t,r,n,o,i,a){return n.addQueueMeasurement(cr.SilentHandlerMonitorIframeForHash,i),new Promise(((n,i)=>{t<Pa&&o.warning(`system.loadFrameTimeout or system.iframeHashTimeout set to lower (${t}ms) than the default (10000ms). This may result in timeouts.`);const s=window.setTimeout((()=>{window.clearInterval(c),i(di(Eo))}),t),c=window.setInterval((()=>{let t="";const r=e.contentWindow;try{t=r?r.location.href:""}catch(e){}if(!t||"about:blank"===t)return;let o="";r&&(o=a===_.QUERY?r.location.search:r.location.hash),window.clearTimeout(s),window.clearInterval(c),n(o)}),r)})).finally((()=>{gr(Bs,cr.RemoveHiddenIframe,o,n,i)(e)}))}function Ls(e,t,r,n){return r.addQueueMeasurement(cr.SilentHandlerLoadFrame,n),new Promise(((r,n)=>{const o=Hs();window.setTimeout((()=>{o?(o.src=e,r(o)):n("Unable to load iframe")}),t)}))}function Us(e){const t=Hs();return t.src=e,t}function Hs(){const e=document.createElement("iframe");return e.className="msalSilentIframe",e.style.visibility="hidden",e.style.position="absolute",e.style.width=e.style.height="0",e.style.border="0",e.setAttribute("sandbox","allow-scripts allow-same-origin allow-forms"),document.body.appendChild(e),e}function Bs(e){document.body===e.parentNode&&document.body.removeChild(e)}class Ds extends Cs{constructor(e,t,r,n,o,i,a,s,c,l,d){super(e,t,r,n,o,i,s,l,d),this.apiId=a,this.nativeStorage=c}async acquireToken(t){this.performanceClient.addQueueMeasurement(cr.SilentIframeClientAcquireToken,t.correlationId),t.loginHint||t.sid||t.account&&t.account.username||this.logger.warning("No user hint provided. The authorization server may need more information to complete this request.");const r={...t};r.prompt?r.prompt!==R.NONE&&r.prompt!==R.NO_SESSION&&(this.logger.warning(`SilentIframeClient. Replacing invalid prompt ${r.prompt} with ${R.NONE}`),r.prompt=R.NONE):r.prompt=R.NONE;const n=await pr(this.initializeAuthorizationRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(r,e.InteractionType.Silent);Ea(n.authority);const o=this.initializeServerTelemetryManager(this.apiId);try{const e=await pr(this.createAuthCodeClient.bind(this),cr.StandardInteractionClientCreateAuthCodeClient,this.logger,this.performanceClient,t.correlationId)(o,n.authority,n.azureCloudOptions,n.account);return await pr(this.silentTokenHelper.bind(this),cr.SilentIframeClientTokenHelper,this.logger,this.performanceClient,t.correlationId)(e,n)}catch(e){throw e instanceof Ie&&(e.setCorrelationId(this.correlationId),o.cacheFailedRequest(e)),e}}logout(){return Promise.reject(di(Mo))}async silentTokenHelper(e,t){const r=t.correlationId;this.performanceClient.addQueueMeasurement(cr.SilentIframeClientTokenHelper,r);const n=await pr(this.initializeAuthorizationCodeRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationCodeRequest,this.logger,this.performanceClient,r)(t),o=await pr(e.getAuthCodeUrl.bind(e),cr.GetAuthCodeUrl,this.logger,this.performanceClient,r)({...t,nativeBroker:Rs.isNativeAvailable(this.config,this.logger,this.nativeMessageHandler,t.authenticationScheme)}),i=new bs(e,this.browserStorage,n,this.logger,this.performanceClient),a=await pr(Os,cr.SilentHandlerInitiateAuthRequest,this.logger,this.performanceClient,r)(o,this.performanceClient,this.logger,r,this.config.system.navigateFrameWait),s=this.config.auth.OIDCOptions.serverResponseType,c=await pr(qs,cr.SilentHandlerMonitorIframeForHash,this.logger,this.performanceClient,r)(a,this.config.system.iframeHashTimeout,this.config.system.pollIntervalMilliseconds,this.performanceClient,this.logger,r,s),l=gr(_s,cr.DeserializeResponse,this.logger,this.performanceClient,this.correlationId)(c,s,this.logger);if(l.accountId){if(this.logger.verbose("Account id found in hash, calling WAM for token"),!this.nativeMessageHandler)throw di(ei);const e=new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.apiId,this.performanceClient,this.nativeMessageHandler,l.accountId,this.browserStorage,r),{userRequestState:n}=Gn.parseRequestState(this.browserCrypto,t.state);return pr(e.acquireToken.bind(e),cr.NativeInteractionClientAcquireToken,this.logger,this.performanceClient,r)({...t,state:n,prompt:t.prompt||R.NONE})}return pr(i.handleCodeResponse.bind(i),cr.HandleCodeResponse,this.logger,this.performanceClient,r)(l,t)}}class xs extends Cs{async acquireToken(e){this.performanceClient.addQueueMeasurement(cr.SilentRefreshClientAcquireToken,e.correlationId);const t=await pr(ms,cr.InitializeBaseRequest,this.logger,this.performanceClient,e.correlationId)(e,this.config,this.performanceClient,this.logger),r={...e,...t};e.redirectUri&&(r.redirectUri=this.getRedirectUri(e.redirectUri));const n=this.initializeServerTelemetryManager(Ui.acquireTokenSilent_silentFlow),o=await this.createRefreshTokenClient(n,r.authority,r.azureCloudOptions,r.account);return pr(o.acquireTokenByRefreshToken.bind(o),cr.RefreshTokenClientAcquireTokenByRefreshToken,this.logger,this.performanceClient,e.correlationId)(r).catch((e=>{throw e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e),e}))}logout(){return Promise.reject(di(Mo))}async createRefreshTokenClient(e,t,r,n){const o=await pr(this.getClientConfiguration.bind(this),cr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,this.correlationId)(e,t,r,n);return new Jn(o,this.performanceClient)}}class Fs{constructor(e,t,r,n){this.isBrowserEnvironment="undefined"!=typeof window,this.config=e,this.storage=t,this.logger=r,this.cryptoObj=n}loadExternalTokens(e,t,r){if(!this.isBrowserEnvironment)throw di(Do);const n=t.id_token?yt(t.id_token,$a):void 0,o={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,skipAuthorityMetadataCache:this.config.auth.skipAuthorityMetadataCache},i=e.authority?new Ur(Ur.generateAuthority(e.authority,e.azureCloudOptions),this.config.system.networkClient,this.storage,o,this.logger,e.correlationId||ra()):void 0,a=this.loadAccount(e,r.clientInfo||t.client_info||"",n,i),s=this.loadIdToken(t,a.homeAccountId,a.environment,a.realm),c=this.loadAccessToken(e,t,a.homeAccountId,a.environment,a.realm,r),l=this.loadRefreshToken(t,a.homeAccountId,a.environment);return this.generateAuthenticationResult(e,{account:a,idToken:s,accessToken:c,refreshToken:l},n,i)}loadAccount(e,t,r,n){if(this.logger.verbose("TokenCache - loading account"),e.account){const t=on.createFromAccountInfo(e.account);return this.storage.setAccount(t),t}if(!n||!t&&!r)throw this.logger.error("TokenCache - if an account is not provided on the request, authority and either clientInfo or idToken must be provided instead."),di($o);const o=on.generateHomeAccountId(t,n.authorityType,this.logger,this.cryptoObj,r),i=r?.tid,a=Vn(this.storage,n,o,$a,r,t,n.hostnameAndPort,i,void 0,void 0,this.logger);return this.storage.setAccount(a),a}loadIdToken(e,t,r,n){if(!e.id_token)return this.logger.verbose("TokenCache - no id token found in response"),null;this.logger.verbose("TokenCache - loading id token");const o=Tr(t,r,e.id_token,this.config.auth.clientId,n);return this.storage.setIdTokenCredential(o),o}loadAccessToken(e,t,r,n,o,i){if(!t.access_token)return this.logger.verbose("TokenCache - no access token found in response"),null;if(!t.expires_in)return this.logger.error("TokenCache - no expiration set on the access token. Cannot add it to the cache."),null;if(!(t.scope||e.scopes&&e.scopes.length))return this.logger.error("TokenCache - scopes not specified in the request or response. Cannot add token to the cache."),null;this.logger.verbose("TokenCache - loading access token");const a=t.scope?Jr.fromString(t.scope):new Jr(e.scopes),s=i.expiresOn||t.expires_in+(new Date).getTime()/1e3,c=i.extendedExpiresOn||(t.ext_expires_in||t.expires_in)+(new Date).getTime()/1e3,l=Ir(r,n,t.access_token,this.config.auth.clientId,o,a.printScopes(),s,c,$a);return this.storage.setAccessTokenCredential(l),l}loadRefreshToken(e,t,r){if(!e.refresh_token)return this.logger.verbose("TokenCache - no refresh token found in response"),null;this.logger.verbose("TokenCache - loading refresh token");const n=wr(t,r,e.refresh_token,this.config.auth.clientId,e.foci,void 0,e.refresh_token_expires_in);return this.storage.setRefreshTokenCredential(n),n}generateAuthenticationResult(e,t,r,n){let o,i="",a=[],s=null;t?.accessToken&&(i=t.accessToken.secret,a=Jr.fromString(t.accessToken.target).asArray(),s=new Date(1e3*Number(t.accessToken.expiresOn)),o=new Date(1e3*Number(t.accessToken.extendedExpiresOn)));const c=t.account;return{authority:n?n.canonicalAuthority:"",uniqueId:t.account.localAccountId,tenantId:t.account.realm,scopes:a,account:c.getAccountInfo(),idToken:t.idToken?.secret||"",idTokenClaims:r||{},accessToken:i,fromCache:!0,expiresOn:s,correlationId:e.correlationId||"",requestId:"",extExpiresOn:o,familyId:t.refreshToken?.familyId||"",tokenType:t?.accessToken?.tokenType||"",state:e.state||"",cloudGraphHostName:c.cloudGraphHostName||"",msGraphHost:c.msGraphHost||"",fromNativeBroker:!1}}}class Ks extends Yn{constructor(e){super(e),this.includeRedirectUri=!1}}class zs extends Cs{constructor(e,t,r,n,o,i,a,s,c,l){super(e,t,r,n,o,i,s,c,l),this.apiId=a}async acquireToken(t){if(!t.code)throw di(Wo);const r=await pr(this.initializeAuthorizationRequest.bind(this),cr.StandardInteractionClientInitializeAuthorizationRequest,this.logger,this.performanceClient,t.correlationId)(t,e.InteractionType.Silent),n=this.initializeServerTelemetryManager(this.apiId);try{const e={...r,code:t.code},o=await pr(this.getClientConfiguration.bind(this),cr.StandardInteractionClientGetClientConfiguration,this.logger,this.performanceClient,t.correlationId)(n,r.authority,r.azureCloudOptions,r.account),i=new Ks(o);this.logger.verbose("Auth code client created");const a=new bs(i,this.browserStorage,e,this.logger,this.performanceClient);return await pr(a.handleCodeResponseFromServer.bind(a),cr.HandleCodeResponseFromServer,this.logger,this.performanceClient,t.correlationId)({code:t.code,msgraph_host:t.msGraphHost,cloud_graph_host_name:t.cloudGraphHostName,cloud_instance_host_name:t.cloudInstanceHostName},r,!1)}catch(e){throw e instanceof Ie&&(e.setCorrelationId(this.correlationId),n.cacheFailedRequest(e)),e}}logout(){return Promise.reject(di(Mo))}}function Gs(e){const t=e?.idTokenClaims;return t?.tfp||t?.acr?"B2C":t?.tid?"9188040d-6c67-4c5b-b112-36a304b66dad"===t?.tid?"MSA":"AAD":void 0}function $s(e,t){try{ka(e)}catch(e){throw t.end({success:!1},e),e}}class Qs{constructor(e){this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.initialized=!1,this.logger=this.operatingContext.getLogger(),this.networkClient=this.config.system.networkClient,this.navigationClient=this.config.system.navigationClient,this.redirectResponse=new Map,this.hybridAuthCodeResponses=new Map,this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Va(this.logger,this.performanceClient):Qr,this.eventHandler=new ls(this.logger,this.browserCrypto),this.browserStorage=this.isBrowserEnvironment?new Za(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,Br(this.config.auth),this.performanceClient):es(this.config.auth.clientId,this.logger);const t={cacheLocation:vi.MemoryStorage,temporaryCacheLocation:vi.MemoryStorage,storeAuthStateInCookie:!1,secureCookies:!1,cacheMigrationEnabled:!1,claimsBasedCachingEnabled:!1};this.nativeInternalStorage=new Za(this.config.auth.clientId,t,this.browserCrypto,this.logger,void 0,this.performanceClient),this.tokenCache=new Fs(this.config,this.browserStorage,this.logger,this.browserCrypto),this.activeSilentTokenRequests=new Map,this.trackPageVisibility=this.trackPageVisibility.bind(this),this.trackPageVisibilityWithMeasurement=this.trackPageVisibilityWithMeasurement.bind(this)}static async createController(e,t){const r=new Qs(e);return await r.initialize(t),r}trackPageVisibility(e){e&&(this.logger.info("Perf: Visibility change detected"),this.performanceClient.incrementFields({visibilityChangeCount:1},e))}async initialize(e){if(this.logger.trace("initialize called"),this.initialized)return void this.logger.info("initialize has already been called, exiting early.");const t=e?.correlationId||this.getRequestCorrelationId(),r=this.config.system.allowNativeBroker,n=this.performanceClient.startMeasurement(cr.InitializeClientApplication,t);if(this.eventHandler.emitEvent(cs.INITIALIZE_START),r)try{this.nativeExtensionProvider=await Rs.createProvider(this.logger,this.config.system.nativeBrokerHandshakeTimeout,this.performanceClient)}catch(e){this.logger.verbose(e)}this.config.cache.claimsBasedCachingEnabled||(this.logger.verbose("Claims-based caching is disabled. Clearing the previous cache with claims"),await pr(this.browserStorage.clearTokensAndKeysWithClaims.bind(this.browserStorage),cr.ClearTokensAndKeysWithClaims,this.logger,this.performanceClient,t)(this.performanceClient,t)),this.initialized=!0,this.eventHandler.emitEvent(cs.INITIALIZE_END),n.end({allowNativeBroker:r,success:!0})}async handleRedirectPromise(e){if(this.logger.verbose("handleRedirectPromise called"),Aa(this.initialized),this.isBrowserEnvironment){const t=e||"";let r=this.redirectResponse.get(t);return void 0===r?(r=this.handleRedirectPromiseInternal(e),this.redirectResponse.set(t,r),this.logger.verbose("handleRedirectPromise has been called for the first time, storing the promise")):this.logger.verbose("handleRedirectPromise has been called previously, returning the result from the first call"),r}return this.logger.verbose("handleRedirectPromise returns null, not browser environment"),null}async handleRedirectPromiseInternal(t){const r=this.getAllAccounts(),n=this.browserStorage.getCachedNativeRequest(),o=n&&Rs.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider)&&this.nativeExtensionProvider&&!t,i=o?n?.correlationId:this.browserStorage.getTemporaryCache(Pi,!0)||"",a=this.performanceClient.startMeasurement(cr.AcquireTokenRedirect,i);let s;if(this.eventHandler.emitEvent(cs.HANDLE_REDIRECT_START,e.InteractionType.Redirect),o&&this.nativeExtensionProvider){this.logger.trace("handleRedirectPromise - acquiring token from native platform");const e=new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.handleRedirectPromise,this.performanceClient,this.nativeExtensionProvider,n.accountId,this.nativeInternalStorage,n.correlationId);s=pr(e.handleRedirectPromise.bind(e),cr.HandleNativeRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(this.performanceClient,a.event.correlationId)}else{this.logger.trace("handleRedirectPromise - acquiring token from web flow");const e=this.createRedirectClient(i);s=pr(e.handleRedirectPromise.bind(e),cr.HandleRedirectPromiseMeasurement,this.logger,this.performanceClient,a.event.correlationId)(t,a)}return s.then((t=>{if(t){r.length<this.getAllAccounts().length?(this.eventHandler.emitEvent(cs.LOGIN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, login success")):(this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Redirect,t),this.logger.verbose("handleRedirectResponse returned result, acquire token success")),a.end({success:!0,accountType:Gs(t.account)})}else a.event.errorCode?a.end({success:!1}):a.discard();return this.eventHandler.emitEvent(cs.HANDLE_REDIRECT_END,e.InteractionType.Redirect),t})).catch((t=>{const n=t;throw r.length>0?this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,n):this.eventHandler.emitEvent(cs.LOGIN_FAILURE,e.InteractionType.Redirect,null,n),this.eventHandler.emitEvent(cs.HANDLE_REDIRECT_END,e.InteractionType.Redirect),a.end({success:!1},n),t}))}async acquireTokenRedirect(t){const r=this.getRequestCorrelationId(t);this.logger.verbose("acquireTokenRedirect called",r);const n=this.performanceClient.startMeasurement(cr.AcquireTokenPreRedirect,r);n.add({accountType:Gs(t.account),scenarioId:t.scenarioId});const o=t.onRedirectNavigate;t.onRedirectNavigate=e=>{const t="function"==typeof o?o(e):void 0;return!1!==t?n.end({success:!0}):n.discard(),t};const i=this.getAllAccounts().length>0;try{let o;if(Sa(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0),i?this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_START,e.InteractionType.Redirect,t):this.eventHandler.emitEvent(cs.LOGIN_START,e.InteractionType.Redirect,t),this.nativeExtensionProvider&&this.canUseNative(t)){o=new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.acquireTokenRedirect,this.performanceClient,this.nativeExtensionProvider,this.getNativeAccountId(t),this.nativeInternalStorage,r).acquireTokenRedirect(t,n).catch((e=>{if(e instanceof Ts&&Is(e)){this.nativeExtensionProvider=void 0;return this.createRedirectClient(r).acquireToken(t)}if(e instanceof Fn){this.logger.verbose("acquireTokenRedirect - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createRedirectClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}))}else{o=this.createRedirectClient(r).acquireToken(t)}return await o}catch(t){throw n.end({success:!1},t),i?this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Redirect,null,t):this.eventHandler.emitEvent(cs.LOGIN_FAILURE,e.InteractionType.Redirect,null,t),t}}acquireTokenPopup(t){const r=this.getRequestCorrelationId(t),n=this.performanceClient.startMeasurement(cr.AcquireTokenPopup,r);n.add({scenarioId:t.scenarioId,accountType:Gs(t.account)});try{this.logger.verbose("acquireTokenPopup called",r),$s(this.initialized,n),this.browserStorage.setInteractionInProgress(!0)}catch(e){return Promise.reject(e)}const o=this.getAllAccounts();let i;if(o.length>0?this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_START,e.InteractionType.Popup,t):this.eventHandler.emitEvent(cs.LOGIN_START,e.InteractionType.Popup,t),this.canUseNative(t))i=this.acquireTokenNative({...t,correlationId:r},Ui.acquireTokenPopup).then((e=>(this.browserStorage.setInteractionInProgress(!1),n.end({success:!0,isNativeBroker:!0,requestId:e.requestId,accountType:Gs(e.account)}),e))).catch((e=>{if(e instanceof Ts&&Is(e)){this.nativeExtensionProvider=void 0;return this.createPopupClient(r).acquireToken(t)}if(e instanceof Fn){this.logger.verbose("acquireTokenPopup - Resolving interaction required error thrown by native broker by falling back to web flow");return this.createPopupClient(r).acquireToken(t)}throw this.browserStorage.setInteractionInProgress(!1),e}));else{i=this.createPopupClient(r).acquireToken(t)}return i.then((t=>(o.length<this.getAllAccounts().length?this.eventHandler.emitEvent(cs.LOGIN_SUCCESS,e.InteractionType.Popup,t):this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,t),n.end({success:!0,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Gs(t.account)}),t))).catch((t=>(o.length>0?this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t):this.eventHandler.emitEvent(cs.LOGIN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),Promise.reject(t))))}trackPageVisibilityWithMeasurement(){const e=this.ssoSilentMeasurement||this.acquireTokenByCodeAsyncMeasurement;e&&(this.logger.info("Perf: Visibility change detected in ",e.event.name),e.increment({visibilityChangeCount:1}))}async ssoSilent(t){const r=this.getRequestCorrelationId(t),n={...t,prompt:t.prompt,correlationId:r};let o;if(this.ssoSilentMeasurement=this.performanceClient.startMeasurement(cr.SsoSilent,r),this.ssoSilentMeasurement?.add({scenarioId:t.scenarioId,accountType:Gs(t.account)}),$s(this.initialized,this.ssoSilentMeasurement),this.ssoSilentMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement),this.logger.verbose("ssoSilent called",r),this.eventHandler.emitEvent(cs.SSO_SILENT_START,e.InteractionType.Silent,n),this.canUseNative(n))o=this.acquireTokenNative(n,Ui.ssoSilent).catch((e=>{if(e instanceof Ts&&Is(e)){this.nativeExtensionProvider=void 0;return this.createSilentIframeClient(n.correlationId).acquireToken(n)}throw e}));else{o=this.createSilentIframeClient(n.correlationId).acquireToken(n)}return o.then((t=>(this.eventHandler.emitEvent(cs.SSO_SILENT_SUCCESS,e.InteractionType.Silent,t),this.ssoSilentMeasurement?.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Gs(t.account)}),t))).catch((t=>{throw this.eventHandler.emitEvent(cs.SSO_SILENT_FAILURE,e.InteractionType.Silent,null,t),this.ssoSilentMeasurement?.end({success:!1},t),t})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenByCode(t){const r=this.getRequestCorrelationId(t);this.logger.trace("acquireTokenByCode called",r);const n=this.performanceClient.startMeasurement(cr.AcquireTokenByCode,r);$s(this.initialized,n),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_BY_CODE_START,e.InteractionType.Silent,t),n.add({scenarioId:t.scenarioId});try{if(t.code&&t.nativeAccountId)throw di(Vo);if(t.code){const o=t.code;let i=this.hybridAuthCodeResponses.get(o);return i?(this.logger.verbose("Existing acquireTokenByCode request found",r),n.discard()):(this.logger.verbose("Initiating new acquireTokenByCode request",r),i=this.acquireTokenByCodeAsync({...t,correlationId:r}).then((t=>(this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_BY_CODE_SUCCESS,e.InteractionType.Silent,t),this.hybridAuthCodeResponses.delete(o),n.end({success:!0,isNativeBroker:t.fromNativeBroker,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length,accountType:Gs(t.account)}),t))).catch((t=>{throw this.hybridAuthCodeResponses.delete(o),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t})),this.hybridAuthCodeResponses.set(o,i)),await i}if(t.nativeAccountId){if(this.canUseNative(t,t.nativeAccountId)){const e=await this.acquireTokenNative({...t,correlationId:r},Ui.acquireTokenByCode,t.nativeAccountId).catch((e=>{throw e instanceof Ts&&Is(e)&&(this.nativeExtensionProvider=void 0),e}));return n.end({accountType:Gs(e.account),success:!0}),e}throw di(Jo)}throw di(jo)}catch(t){throw this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_BY_CODE_FAILURE,e.InteractionType.Silent,null,t),n.end({success:!1},t),t}}async acquireTokenByCodeAsync(e){this.logger.trace("acquireTokenByCodeAsync called",e.correlationId),this.acquireTokenByCodeAsyncMeasurement=this.performanceClient.startMeasurement(cr.AcquireTokenByCodeAsync,e.correlationId),this.acquireTokenByCodeAsyncMeasurement?.increment({visibilityChangeCount:0}),document.addEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement);const t=this.createSilentAuthCodeClient(e.correlationId);return await t.acquireToken(e).then((e=>(this.acquireTokenByCodeAsyncMeasurement?.end({success:!0,fromCache:e.fromCache,isNativeBroker:e.fromNativeBroker,requestId:e.requestId}),e))).catch((e=>{throw this.acquireTokenByCodeAsyncMeasurement?.end({success:!1},e),e})).finally((()=>{document.removeEventListener("visibilitychange",this.trackPageVisibilityWithMeasurement)}))}async acquireTokenFromCache(e,t){switch(this.performanceClient.addQueueMeasurement(cr.AcquireTokenFromCache,e.correlationId),t){case Ki.Default:case Ki.AccessToken:case Ki.AccessTokenAndRefreshToken:const t=this.createSilentCacheClient(e.correlationId);return pr(t.acquireToken.bind(t),cr.SilentCacheClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw Ct(tt)}}async acquireTokenByRefreshToken(e,t){switch(this.performanceClient.addQueueMeasurement(cr.AcquireTokenByRefreshToken,e.correlationId),t){case Ki.Default:case Ki.AccessTokenAndRefreshToken:case Ki.RefreshToken:case Ki.RefreshTokenAndNetwork:const t=this.createSilentRefreshClient(e.correlationId);return pr(t.acquireToken.bind(t),cr.SilentRefreshClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e);default:throw Ct(tt)}}async acquireTokenBySilentIframe(e){this.performanceClient.addQueueMeasurement(cr.AcquireTokenBySilentIframe,e.correlationId);const t=this.createSilentIframeClient(e.correlationId);return pr(t.acquireToken.bind(t),cr.SilentIframeClientAcquireToken,this.logger,this.performanceClient,e.correlationId)(e)}async logout(e){const t=this.getRequestCorrelationId(e);return this.logger.warning("logout API is deprecated and will be removed in msal-browser v3.0.0. Use logoutRedirect instead.",t),this.logoutRedirect({correlationId:t,...e})}async logoutRedirect(e){const t=this.getRequestCorrelationId(e);Sa(this.initialized,this.config),this.browserStorage.setInteractionInProgress(!0);return this.createRedirectClient(t).logout(e)}logoutPopup(e){try{const t=this.getRequestCorrelationId(e);ka(this.initialized),this.browserStorage.setInteractionInProgress(!0);return this.createPopupClient(t).logout(e)}catch(e){return Promise.reject(e)}}async clearCache(e){const t=this.getRequestCorrelationId(e);return this.createSilentCacheClient(t).logout(e)}getAllAccounts(e){return ts(this.logger,this.browserStorage,this.isBrowserEnvironment,e)}getAccount(e){return rs(e,this.logger,this.browserStorage)}getAccountByUsername(e){return ns(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return os(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return is(e,this.logger,this.browserStorage)}setActiveAccount(e){as(e,this.browserStorage)}getActiveAccount(){return ss(this.browserStorage)}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=on.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(r),e.fromNativeBroker?(this.logger.verbose("Response was from native broker, storing in-memory"),this.nativeInternalStorage.hydrateCache(e,t)):this.browserStorage.hydrateCache(e,t)}async acquireTokenNative(e,t,r){if(this.logger.trace("acquireTokenNative called"),!this.nativeExtensionProvider)throw di(ei);return new Es(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,t,this.performanceClient,this.nativeExtensionProvider,r||this.getNativeAccountId(e),this.nativeInternalStorage,e.correlationId).acquireToken(e)}canUseNative(e,t){if(this.logger.trace("canUseNative called"),!Rs.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,e.authenticationScheme))return this.logger.trace("canUseNative: isNativeAvailable returned false, returning false"),!1;if(e.prompt)switch(e.prompt){case R.NONE:case R.CONSENT:case R.LOGIN:this.logger.trace("canUseNative: prompt is compatible with native flow");break;default:return this.logger.trace(`canUseNative: prompt = ${e.prompt} is not compatible with native flow, returning false`),!1}return!(!t&&!this.getNativeAccountId(e))||(this.logger.trace("canUseNative: nativeAccountId is not available, returning false"),!1)}getNativeAccountId(e){const t=e.account||this.getAccount({loginHint:e.loginHint,sid:e.sid})||this.getActiveAccount();return t&&t.nativeAccountId||""}createPopupClient(e){return new Ps(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createRedirectClient(e){return new Ns(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentIframeClient(e){return new Ds(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.ssoSilent,this.performanceClient,this.nativeInternalStorage,this.nativeExtensionProvider,e)}createSilentCacheClient(e){return new As(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentRefreshClient(e){return new xs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,this.performanceClient,this.nativeExtensionProvider,e)}createSilentAuthCodeClient(e){return new zs(this.config,this.browserStorage,this.browserCrypto,this.logger,this.eventHandler,this.navigationClient,Ui.acquireTokenByCode,this.performanceClient,this.nativeExtensionProvider,e)}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return this.performanceClient.addPerformanceCallback(e)}removePerformanceCallback(e){return this.performanceClient.removePerformanceCallback(e)}enableAccountStorageEvents(){this.eventHandler.enableAccountStorageEvents()}disableAccountStorageEvents(){this.eventHandler.disableAccountStorageEvents()}getTokenCache(){return this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){this.navigationClient=e}getConfiguration(){return this.config}getPerformanceClient(){return this.performanceClient}isBrowserEnv(){return this.isBrowserEnvironment}getEventHandler(){return this.eventHandler}getRequestCorrelationId(e){return e?.correlationId?e.correlationId:this.isBrowserEnvironment?ra():t.EMPTY_STRING}async loginRedirect(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginRedirect called",t),this.acquireTokenRedirect({correlationId:t,...e||Di})}loginPopup(e){const t=this.getRequestCorrelationId(e);return this.logger.verbose("loginPopup called",t),this.acquireTokenPopup({correlationId:t,...e||Di})}async acquireTokenSilent(e){const r=this.getRequestCorrelationId(e),n=this.performanceClient.startMeasurement(cr.AcquireTokenSilent,r);n.add({cacheLookupPolicy:e.cacheLookupPolicy,scenarioId:e.scenarioId}),$s(this.initialized,n),this.logger.verbose("acquireTokenSilent called",r);const o=e.account||this.getActiveAccount();if(!o)throw di(No);n.add({accountType:Gs(o)});const i={clientId:this.config.auth.clientId,authority:e.authority||t.EMPTY_STRING,scopes:e.scopes,homeAccountIdentifier:o.homeAccountId,claims:e.claims,authenticationScheme:e.authenticationScheme,resourceRequestMethod:e.resourceRequestMethod,resourceRequestUri:e.resourceRequestUri,shrClaims:e.shrClaims,sshKid:e.sshKid,shrOptions:e.shrOptions},a=JSON.stringify(i),s=this.activeSilentTokenRequests.get(a);if(void 0===s){this.logger.verbose("acquireTokenSilent called for the first time, storing active request",r);const t=pr(this.acquireTokenSilentAsync.bind(this),cr.AcquireTokenSilentAsync,this.logger,this.performanceClient,r)({...e,correlationId:r},o).then((t=>(this.activeSilentTokenRequests.delete(a),n.end({success:!0,fromCache:t.fromCache,isNativeBroker:t.fromNativeBroker,cacheLookupPolicy:e.cacheLookupPolicy,requestId:t.requestId,accessTokenSize:t.accessToken.length,idTokenSize:t.idToken.length}),t))).catch((e=>{throw this.activeSilentTokenRequests.delete(a),n.end({success:!1},e),e}));return this.activeSilentTokenRequests.set(a,t),{...await t,state:e.state}}return this.logger.verbose("acquireTokenSilent has been called previously, returning the result from the first call",r),n.discard(),{...await s,state:e.state}}async acquireTokenSilentAsync(t,r){const n=()=>this.trackPageVisibility(t.correlationId);this.performanceClient.addQueueMeasurement(cr.AcquireTokenSilentAsync,t.correlationId),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_START,e.InteractionType.Silent,t),t.correlationId&&this.performanceClient.incrementFields({visibilityChangeCount:0},t.correlationId),document.addEventListener("visibilitychange",n);const o=await pr(fs,cr.InitializeSilentRequest,this.logger,this.performanceClient,t.correlationId)(t,r,this.config,this.performanceClient,this.logger),i=t.cacheLookupPolicy||Ki.Default;return this.acquireTokenSilentNoIframe(o,i).catch((async e=>{const t=function(e,t){const r=!(e instanceof Fn&&e.subError!==Ln),n=e.errorCode===hi.INVALID_GRANT_ERROR||e.errorCode===tt,o=r&&n||e.errorCode===_n||e.errorCode===Mn,i=zi.includes(t);return o&&i}(e,i);if(t){if(this.activeIframeRequest){if(i!==Ki.Skip){const[t,r]=this.activeIframeRequest;this.logger.verbose(`Iframe request is already in progress, awaiting resolution for request with correlationId: ${r}`,o.correlationId);const n=this.performanceClient.startMeasurement(cr.AwaitConcurrentIframe,o.correlationId);n.add({awaitIframeCorrelationId:r});const a=await t;if(n.end({success:a}),a)return this.logger.verbose(`Parallel iframe request with correlationId: ${r} succeeded. Retrying cache and/or RT redemption`,o.correlationId),this.acquireTokenSilentNoIframe(o,i);throw this.logger.info(`Iframe request with correlationId: ${r} failed. Interaction is required.`),e}return this.logger.warning("Another iframe request is currently in progress and CacheLookupPolicy is set to Skip. This may result in degraded performance and/or reliability for both calls. Please consider changing the CacheLookupPolicy to take advantage of request queuing and token cache.",o.correlationId),pr(this.acquireTokenBySilentIframe.bind(this),cr.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o)}{let e;return this.activeIframeRequest=[new Promise((t=>{e=t})),o.correlationId],this.logger.verbose("Refresh token expired/invalid or CacheLookupPolicy is set to Skip, attempting acquire token by iframe.",o.correlationId),pr(this.acquireTokenBySilentIframe.bind(this),cr.AcquireTokenBySilentIframe,this.logger,this.performanceClient,o.correlationId)(o).then((t=>(e(!0),t))).catch((t=>{throw e(!1),t})).finally((()=>{this.activeIframeRequest=void 0}))}}throw e})).then((r=>(this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,r),t.correlationId&&this.performanceClient.addFields({fromCache:r.fromCache,isNativeBroker:r.fromNativeBroker,requestId:r.requestId},t.correlationId),r))).catch((t=>{throw this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),t})).finally((()=>{document.removeEventListener("visibilitychange",n)}))}async acquireTokenSilentNoIframe(t,r){return Rs.isNativeAvailable(this.config,this.logger,this.nativeExtensionProvider,t.authenticationScheme)&&t.account.nativeAccountId?(this.logger.verbose("acquireTokenSilent - attempting to acquire token from native platform"),this.acquireTokenNative(t,Ui.acquireTokenSilent_silentFlow).catch((async e=>{if(e instanceof Ts&&Is(e))throw this.logger.verbose("acquireTokenSilent - native platform unavailable, falling back to web flow"),this.nativeExtensionProvider=void 0,Ct(tt);throw e}))):(this.logger.verbose("acquireTokenSilent - attempting to acquire token from web flow"),pr(this.acquireTokenFromCache.bind(this),cr.AcquireTokenFromCache,this.logger,this.performanceClient,t.correlationId)(t,r).catch((n=>{if(r===Ki.AccessToken)throw n;return this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_NETWORK_START,e.InteractionType.Silent,t),pr(this.acquireTokenByRefreshToken.bind(this),cr.AcquireTokenByRefreshToken,this.logger,this.performanceClient,t.correlationId)(t,r)})))}}class Ws{constructor(e,t,r,n){this.clientId=e,this.clientCapabilities=t,this.crypto=r,this.logger=n}toNaaTokenRequest(e){let t;t=void 0===e.extraQueryParameters?new Map:new Map(Object.entries(e.extraQueryParameters));const r=(new Rn).addClientCapabilitiesToClaims(e.claims,this.clientCapabilities),n=e.scopes||a;return{platformBrokerId:e.account?.homeAccountId,clientId:this.clientId,authority:e.authority,scope:n.join(" "),correlationId:void 0!==e.correlationId?e.correlationId:this.crypto.createNewGuid(),claims:Jt.isEmptyObj(r)?void 0:r,state:e.state,authenticationScheme:e.authenticationScheme||W.BEARER,extraParameters:t}}fromNaaTokenResponse(e,t,r){if(!t.token.id_token||!t.token.access_token)throw Ct(Ee);const n=new Date(1e3*(r+(t.token.expires_in||0))),o=yt(t.token.id_token,this.crypto.base64Decode),i=this.fromNaaAccountInfo(t.account,t.token.id_token,o),a=t.token.scope||e.scope;return{authority:t.token.authority||i.environment,uniqueId:i.localAccountId,tenantId:i.tenantId,scopes:a.split(" "),account:i,idToken:t.token.id_token,idTokenClaims:o,accessToken:t.token.access_token,fromCache:!1,expiresOn:n,tokenType:e.authenticationScheme||W.BEARER,correlationId:e.correlationId,extExpiresOn:n,state:e.state}}fromNaaAccountInfo(e,t,r){const n=r||e.idTokenClaims,o=e.localAccountId||n?.oid||n?.sub||"",i=e.tenantId||n?.tid||"",a=e.homeAccountId||`${o}.${i}`,s=e.username||n?.preferred_username||"",c=e.name||n?.name,l=new Map,d=tn(a,n);l.set(i,d);return{homeAccountId:a,environment:e.environment,tenantId:i,username:s,localAccountId:o,name:c,idToken:t,idTokenClaims:n,tenantProfiles:l}}fromBridgeError(e){if(!function(e){return void 0!==e.status}(e))return new Ie("unknown_error","An unknown error occurred");switch(e.status){case La:return new ft(lt);case Ua:return new ft(ct);case xa:return new ft(Ye);case Da:return new ft(ut);case Fa:return new ft(e.code||ut,e.description);case Ha:case Ba:return new In(e.code,e.description);case qa:return new Fn(e.code,e.description);default:return new Ie(e.code,e.description)}}toAuthenticationResultFromCache(e,t,r,n,o){if(!t||!r)throw Ct(Ee);const i=yt(t.secret,this.crypto.base64Decode),a=r.target||n.scopes.join(" ");return{authority:r.environment||e.environment,uniqueId:e.localAccountId,tenantId:e.tenantId,scopes:a.split(" "),account:e,idToken:t.secret,idTokenClaims:i||{},accessToken:r.secret,fromCache:!0,expiresOn:new Date(1e3*Number(r.expiresOn)),tokenType:n.authenticationScheme||W.BEARER,correlationId:o,extExpiresOn:new Date(1e3*Number(r.extendedExpiresOn)),state:n.state}}}const js={code:"unsupported_method",desc:"This method is not supported in nested app environment."};class Vs extends Ie{constructor(e,t){super(e,t),Object.setPrototypeOf(this,Vs.prototype),this.name="NestedAppAuthError"}static createUnsupportedError(){return new Vs(js.code,js.desc)}}class Ys{constructor(e){this.operatingContext=e;const t=this.operatingContext.getBridgeProxy();if(void 0===t)throw new Error("unexpected: bridgeProxy is undefined");this.bridgeProxy=t,this.config=e.getConfig(),this.logger=this.operatingContext.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=e.isBrowserEnvironment()?new Va(this.logger,this.performanceClient):Qr,this.browserStorage=this.operatingContext.isBrowserEnvironment()?new Za(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,Br(this.config.auth)):es(this.config.auth.clientId,this.logger),this.eventHandler=new ls(this.logger,this.browserCrypto),this.nestedAppAuthAdapter=new Ws(this.config.auth.clientId,this.config.auth.clientCapabilities,this.browserCrypto,this.logger);const r=this.bridgeProxy.getAccountContext();if(r){as(rs(r,this.logger,this.browserStorage),this.browserStorage)}}getEventHandler(){return this.eventHandler}static async createController(e){const t=new Ys(e);return Promise.resolve(t)}initialize(){return Promise.resolve()}ensureValidRequest(e){return e?.correlationId?e:{...e,correlationId:this.browserCrypto.createNewGuid()}}async acquireTokenInteractive(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_START,e.InteractionType.Popup,r);const n=this.performanceClient.startMeasurement(cr.AcquireTokenPopup,r.correlationId);n?.add({nestedAppAuthRequest:!0});try{const o=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=fr(),a=await this.bridgeProxy.getTokenInteractive(o),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(o,a,i);return await this.hydrateCache(s,t),this.browserStorage.setActiveAccount(s.account),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Popup,s),n.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),n.end({success:!0,requestId:s.requestId}),s}catch(t){const r=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Popup,null,t),n.end({success:!1},t),r}}async acquireTokenSilentInternal(t){const r=this.ensureValidRequest(t);this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_START,e.InteractionType.Silent,r);const n=await this.acquireTokenFromCache(r);if(n)return this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),n;const o=this.performanceClient.startMeasurement(cr.SsoSilent,r.correlationId);o?.increment({visibilityChangeCount:0}),o?.add({nestedAppAuthRequest:!0});try{const n=this.nestedAppAuthAdapter.toNaaTokenRequest(r),i=fr(),a=await this.bridgeProxy.getTokenSilent(n),s=this.nestedAppAuthAdapter.fromNaaTokenResponse(n,a,i);return await this.hydrateCache(s,t),this.browserStorage.setActiveAccount(s.account),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,s),o?.add({accessTokenSize:s.accessToken.length,idTokenSize:s.idToken.length}),o?.end({success:!0,requestId:s.requestId}),s}catch(t){const r=this.nestedAppAuthAdapter.fromBridgeError(t);throw this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null,t),o?.end({success:!1},t),r}}async acquireTokenFromCache(t){const r=this.performanceClient.startMeasurement(cr.AcquireTokenSilent,t.correlationId);r?.add({nestedAppAuthRequest:!0});const n=await this.acquireTokenFromCacheInternal(t);return n?(this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_SUCCESS,e.InteractionType.Silent,n),r?.add({accessTokenSize:n?.accessToken.length,idTokenSize:n?.idToken.length}),r?.end({success:!0}),n):(this.logger.error("Cached tokens are not found for the account, proceeding with silent token request."),this.eventHandler.emitEvent(cs.ACQUIRE_TOKEN_FAILURE,e.InteractionType.Silent,null),r?.end({success:!1}),null)}async acquireTokenFromCacheInternal(e){const t=this.bridgeProxy.getAccountContext();let r=null;if(t){r=rs(t,this.logger,this.browserStorage)||e.account}if(!r)return this.logger.verbose("No active account found, falling back to the host"),Promise.resolve(null);this.logger.verbose("active account found, attempting to acquire token silently");const n={...e,correlationId:e.correlationId||this.browserCrypto.createNewGuid(),authority:e.authority||r.environment,scopes:e.scopes?.length?e.scopes:[...a]},o=this.browserStorage.getTokenKeys(),i=this.browserStorage.getAccessToken(r,n,o,r.tenantId,this.performanceClient,n.correlationId);if(!i)return this.logger.verbose("No cached access token found"),Promise.resolve(null);if(yr(i.cachedAt)||Cr(i.expiresOn,this.config.system.tokenRenewalOffsetSeconds)){this.logger.verbose("Cached access token has expired, deleting all related tokens from cache");const e=on.createFromAccountInfo(r);return await this.browserStorage.removeAccountContext(e),Promise.resolve(null)}const s=this.browserStorage.getIdToken(r,o,r.tenantId,this.performanceClient,n.correlationId);return s?this.nestedAppAuthAdapter.toAuthenticationResultFromCache(r,s,i,n,n.correlationId):(this.logger.verbose("No cached id token found"),Promise.resolve(null))}async acquireTokenPopup(e){return this.acquireTokenInteractive(e)}acquireTokenRedirect(e){throw Vs.createUnsupportedError()}async acquireTokenSilent(e){return this.acquireTokenSilentInternal(e)}acquireTokenByCode(e){throw Vs.createUnsupportedError()}acquireTokenNative(e,t,r){throw Vs.createUnsupportedError()}acquireTokenByRefreshToken(e,t){throw Vs.createUnsupportedError()}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){throw Vs.createUnsupportedError()}removePerformanceCallback(e){throw Vs.createUnsupportedError()}enableAccountStorageEvents(){throw Vs.createUnsupportedError()}disableAccountStorageEvents(){throw Vs.createUnsupportedError()}getAllAccounts(e){return ts(this.logger,this.browserStorage,this.isBrowserEnv(),e)}getAccount(e){return rs(e,this.logger,this.browserStorage)}getAccountByUsername(e){return ns(e,this.logger,this.browserStorage)}getAccountByHomeId(e){return os(e,this.logger,this.browserStorage)}getAccountByLocalId(e){return is(e,this.logger,this.browserStorage)}setActiveAccount(e){return as(e,this.browserStorage)}getActiveAccount(){return ss(this.browserStorage)}handleRedirectPromise(e){return Promise.resolve(null)}loginPopup(e){return this.acquireTokenInteractive(e||Di)}loginRedirect(e){throw Vs.createUnsupportedError()}logout(e){throw Vs.createUnsupportedError()}logoutRedirect(e){throw Vs.createUnsupportedError()}logoutPopup(e){throw Vs.createUnsupportedError()}ssoSilent(e){return this.acquireTokenSilentInternal(e)}getTokenCache(){throw Vs.createUnsupportedError()}getLogger(){return this.logger}setLogger(e){this.logger=e}initializeWrapperLibrary(e,t){}setNavigationClient(e){this.logger.warning("setNavigationClient is not supported in nested app auth")}getConfiguration(){return this.config}isBrowserEnv(){return this.operatingContext.isBrowserEnvironment()}getBrowserCrypto(){return this.browserCrypto}getPerformanceClient(){throw Vs.createUnsupportedError()}getRedirectResponse(){throw Vs.createUnsupportedError()}async clearCache(e){throw Vs.createUnsupportedError()}async hydrateCache(e,t){this.logger.verbose("hydrateCache called");const r=on.createFromAccountInfo(e.account,e.cloudGraphHostName,e.msGraphHost);return this.browserStorage.setAccount(r),this.browserStorage.hydrateCache(e,t)}}async function Js(e){const t=new Ga(e),r=new za(e),n=[t.initialize(),r.initialize()];return await Promise.all(n),r.isAvailable()&&e.auth.supportsNestedAppAuth?Ys.createController(r):t.isAvailable()?Qs.createController(t):null}class Xs{static async createPublicClientApplication(e){const t=await async function(e,t){const r=new Ga(e);return await r.initialize(),Qs.createController(r,t)}(e);return new Xs(e,t)}constructor(e,t){this.controller=t||new Qs(new Ga(e))}async initialize(e){return this.controller.initialize(e)}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e){return this.controller.addEventCallback(e)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}async function Zs(e){const t=new Xs(e);return await t.initialize(),t}class ec{constructor(e){this.initialized=!1,this.operatingContext=e,this.isBrowserEnvironment=this.operatingContext.isBrowserEnvironment(),this.config=e.getConfig(),this.logger=e.getLogger(),this.performanceClient=this.config.telemetry.client,this.browserCrypto=this.isBrowserEnvironment?new Va(this.logger,this.performanceClient):Qr,this.browserStorage=this.isBrowserEnvironment?new Za(this.config.auth.clientId,this.config.cache,this.browserCrypto,this.logger,void 0,this.performanceClient):es(this.config.auth.clientId,this.logger),this.eventHandler=new ls(this.logger,this.browserCrypto)}getBrowserStorage(){return this.browserStorage}getEventHandler(){return this.eventHandler}getAccount(e){return null}getAccountByHomeId(e){return null}getAccountByLocalId(e){return null}getAccountByUsername(e){return null}getAllAccounts(){return[]}initialize(){return this.initialized=!0,Promise.resolve()}acquireTokenPopup(e){return Aa(this.initialized),wa(),{}}acquireTokenRedirect(e){return Aa(this.initialized),wa(),Promise.resolve()}acquireTokenSilent(e){return Aa(this.initialized),wa(),{}}acquireTokenByCode(e){return Aa(this.initialized),wa(),{}}acquireTokenNative(e,t,r){return Aa(this.initialized),wa(),{}}acquireTokenByRefreshToken(e,t){return Aa(this.initialized),wa(),{}}addEventCallback(e){return this.eventHandler.addEventCallback(e)}removeEventCallback(e){this.eventHandler.removeEventCallback(e)}addPerformanceCallback(e){return Aa(this.initialized),wa(),""}removePerformanceCallback(e){return Aa(this.initialized),wa(),!0}enableAccountStorageEvents(){Aa(this.initialized),wa()}disableAccountStorageEvents(){Aa(this.initialized),wa()}handleRedirectPromise(e){return Aa(this.initialized),Promise.resolve(null)}loginPopup(e){return Aa(this.initialized),wa(),{}}loginRedirect(e){return Aa(this.initialized),wa(),{}}logout(e){return Aa(this.initialized),wa(),{}}logoutRedirect(e){return Aa(this.initialized),wa(),{}}logoutPopup(e){return Aa(this.initialized),wa(),{}}ssoSilent(e){return Aa(this.initialized),wa(),{}}getTokenCache(){return Aa(this.initialized),wa(),{}}getLogger(){return this.logger}setLogger(e){Aa(this.initialized),wa()}setActiveAccount(e){Aa(this.initialized),wa()}getActiveAccount(){return Aa(this.initialized),wa(),null}initializeWrapperLibrary(e,t){this.browserStorage.setWrapperMetadata(e,t)}setNavigationClient(e){Aa(this.initialized),wa()}getConfiguration(){return this.config}isBrowserEnv(){return Aa(this.initialized),wa(),!0}getBrowserCrypto(){return Aa(this.initialized),wa(),{}}getPerformanceClient(){return Aa(this.initialized),wa(),{}}getRedirectResponse(){return Aa(this.initialized),wa(),{}}async clearCache(e){Aa(this.initialized),wa()}async hydrateCache(e,t){Aa(this.initialized),wa()}}class tc extends Oa{getId(){return tc.ID}getModuleName(){return tc.MODULE_NAME}async initialize(){return!0}}tc.MODULE_NAME="",tc.ID="UnknownOperatingContext";class rc{static async createPublicClientApplication(e){const t=await Js(e);let r;return r=null!==t?new rc(e,t):new rc(e),r}constructor(e,t){if(this.configuration=e,t)this.controller=t;else{const t=new tc(e);this.controller=new ec(t)}}async initialize(){if(this.controller instanceof ec){const e=await Js(this.configuration);return null!==e&&(this.controller=e),this.controller.initialize()}return Promise.resolve()}async acquireTokenPopup(e){return this.controller.acquireTokenPopup(e)}acquireTokenRedirect(e){return this.controller.acquireTokenRedirect(e)}acquireTokenSilent(e){return this.controller.acquireTokenSilent(e)}acquireTokenByCode(e){return this.controller.acquireTokenByCode(e)}addEventCallback(e){return this.controller.addEventCallback(e)}removeEventCallback(e){return this.controller.removeEventCallback(e)}addPerformanceCallback(e){return this.controller.addPerformanceCallback(e)}removePerformanceCallback(e){return this.controller.removePerformanceCallback(e)}enableAccountStorageEvents(){this.controller.enableAccountStorageEvents()}disableAccountStorageEvents(){this.controller.disableAccountStorageEvents()}getAccount(e){return this.controller.getAccount(e)}getAccountByHomeId(e){return this.controller.getAccountByHomeId(e)}getAccountByLocalId(e){return this.controller.getAccountByLocalId(e)}getAccountByUsername(e){return this.controller.getAccountByUsername(e)}getAllAccounts(e){return this.controller.getAllAccounts(e)}handleRedirectPromise(e){return this.controller.handleRedirectPromise(e)}loginPopup(e){return this.controller.loginPopup(e)}loginRedirect(e){return this.controller.loginRedirect(e)}logout(e){return this.controller.logout(e)}logoutRedirect(e){return this.controller.logoutRedirect(e)}logoutPopup(e){return this.controller.logoutPopup(e)}ssoSilent(e){return this.controller.ssoSilent(e)}getTokenCache(){return this.controller.getTokenCache()}getLogger(){return this.controller.getLogger()}setLogger(e){this.controller.setLogger(e)}setActiveAccount(e){this.controller.setActiveAccount(e)}getActiveAccount(){return this.controller.getActiveAccount()}initializeWrapperLibrary(e,t){return this.controller.initializeWrapperLibrary(e,t)}setNavigationClient(e){this.controller.setNavigationClient(e)}getConfiguration(){return this.controller.getConfiguration()}async hydrateCache(e,t){return this.controller.hydrateCache(e,t)}clearCache(e){return this.controller.clearCache(e)}}const nc={initialize:()=>Promise.reject(ua(aa)),acquireTokenPopup:()=>Promise.reject(ua(aa)),acquireTokenRedirect:()=>Promise.reject(ua(aa)),acquireTokenSilent:()=>Promise.reject(ua(aa)),acquireTokenByCode:()=>Promise.reject(ua(aa)),getAllAccounts:()=>[],getAccount:()=>null,getAccountByHomeId:()=>null,getAccountByUsername:()=>null,getAccountByLocalId:()=>null,handleRedirectPromise:()=>Promise.reject(ua(aa)),loginPopup:()=>Promise.reject(ua(aa)),loginRedirect:()=>Promise.reject(ua(aa)),logout:()=>Promise.reject(ua(aa)),logoutRedirect:()=>Promise.reject(ua(aa)),logoutPopup:()=>Promise.reject(ua(aa)),ssoSilent:()=>Promise.reject(ua(aa)),addEventCallback:()=>null,removeEventCallback:()=>{},addPerformanceCallback:()=>"",removePerformanceCallback:()=>!1,enableAccountStorageEvents:()=>{},disableAccountStorageEvents:()=>{},getTokenCache:()=>{throw ua(aa)},getLogger:()=>{throw ua(aa)},setLogger:()=>{},setActiveAccount:()=>{},getActiveAccount:()=>null,initializeWrapperLibrary:()=>{},setNavigationClient:()=>{},getConfiguration:()=>{throw ua(aa)},hydrateCache:()=>Promise.reject(ua(aa)),clearCache:()=>Promise.reject(ua(aa))};function oc(){let e;try{e=window[vi.SessionStorage];const t=e?.getItem("msal.browser.performance.enabled");if(1===Number(t))return Promise.resolve().then((function(){return cc}))}catch(e){}}function ic(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.now}function ac(e){if(e&&ic())return Math.round(window.performance.now()-e)}class sc{constructor(e,t){this.correlationId=t,this.measureName=sc.makeMeasureName(e,t),this.startMark=sc.makeStartMark(e,t),this.endMark=sc.makeEndMark(e,t)}static makeMeasureName(e,t){return`msal.measure.${e}.${t}`}static makeStartMark(e,t){return`msal.start.${e}.${t}`}static makeEndMark(e,t){return`msal.end.${e}.${t}`}static supportsBrowserPerformance(){return"undefined"!=typeof window&&void 0!==window.performance&&"function"==typeof window.performance.mark&&"function"==typeof window.performance.measure&&"function"==typeof window.performance.clearMarks&&"function"==typeof window.performance.clearMeasures&&"function"==typeof window.performance.getEntriesByName}static flushMeasurements(e,t){if(sc.supportsBrowserPerformance())try{t.forEach((t=>{const r=sc.makeMeasureName(t.name,e);window.performance.getEntriesByName(r,"measure").length>0&&(window.performance.clearMeasures(r),window.performance.clearMarks(sc.makeStartMark(r,e)),window.performance.clearMarks(sc.makeEndMark(r,e)))}))}catch(e){}}startMeasurement(){if(sc.supportsBrowserPerformance())try{window.performance.mark(this.startMark)}catch(e){}}endMeasurement(){if(sc.supportsBrowserPerformance())try{window.performance.mark(this.endMark),window.performance.measure(this.measureName,this.startMark,this.endMark)}catch(e){}}flushMeasurement(){if(sc.supportsBrowserPerformance())try{const e=window.performance.getEntriesByName(this.measureName,"measure");if(e.length>0){const t=e[0].duration;return window.performance.clearMeasures(this.measureName),window.performance.clearMarks(this.startMark),window.performance.clearMarks(this.endMark),t}}catch(e){}return null}}var cc=Object.freeze({__proto__:null,BrowserPerformanceMeasurement:sc});e.AccountEntity=on,e.ApiId=Ui,e.AuthError=Ie,e.AuthErrorCodes=ye,e.AuthErrorMessage=Te,e.AuthenticationHeaderParser=class{constructor(e){this.headers=e}getShrNonce(){const e=this.headers[u];if(e){const t=this.parseChallenges(e);if(t.nextnonce)return t.nextnonce;throw Yt(Kt)}const t=this.headers[h];if(t){const e=this.parseChallenges(t);if(e.nonce)return e.nonce;throw Yt(Kt)}throw Yt(Ft)}parseChallenges(e){const r=e.indexOf(" "),n=e.substr(r+1).split(","),o={};return n.forEach((e=>{const[r,n]=e.split("=");o[r]=unescape(n.replace(/['"]+/g,t.EMPTY_STRING))})),o}},e.AuthenticationScheme=W,e.AzureCloudInstance=sr,e.BrowserAuthError=li,e.BrowserAuthErrorCodes=ii,e.BrowserAuthErrorMessage=ci,e.BrowserCacheLocation=vi,e.BrowserConfigurationAuthError=ha,e.BrowserConfigurationAuthErrorCodes=ca,e.BrowserConfigurationAuthErrorMessage=da,e.BrowserPerformanceClient=class extends uo{constructor(e,r,n){super(e.auth.clientId,e.auth.authority||`${t.DEFAULT_AUTHORITY}`,new jr(e.system?.loggerOptions||{},Ma,Na),Ma,Na,e.telemetry?.application||{appName:"",appVersion:""},r,n)}generateId(){return ra()}getPageVisibility(){return document.visibilityState?.toString()||null}deleteIncompleteSubMeasurements(e){oc()?.then((t=>{const r=this.eventsByCorrelationId.get(e.event.correlationId),n=r&&r.eventId===e.event.eventId,o=[];n&&r?.incompleteSubMeasurements&&r.incompleteSubMeasurements.forEach((e=>{o.push({...e})})),t.BrowserPerformanceMeasurement.flushMeasurements(e.event.correlationId,o)}))}startMeasurement(e,t){const r=this.getPageVisibility(),n=super.startMeasurement(e,t),o=ic()?window.performance.now():void 0,i=oc()?.then((t=>new t.BrowserPerformanceMeasurement(e,n.event.correlationId)));return i?.then((e=>e.startMeasurement())),{...n,end:(e,t)=>{const a=n.end({...e,startPageVisibility:r,endPageVisibility:this.getPageVisibility(),durationMs:ac(o)},t);return i?.then((e=>e.endMeasurement())),this.deleteIncompleteSubMeasurements(n),a},discard:()=>{n.discard(),i?.then((e=>e.flushMeasurement())),this.deleteIncompleteSubMeasurements(n)}}}setPreQueueTime(e,t){if(!ic())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to set telemetry queue time for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to set telemetry queue time`);const r=this.preQueueTimeByCorrelationId.get(t);r&&(this.logger.trace(`BrowserPerformanceClient: Incomplete pre-queue ${r.name} found`,t),this.addQueueMeasurement(r.name,t,void 0,!0)),this.preQueueTimeByCorrelationId.set(t,{name:e,time:window.performance.now()})}addQueueMeasurement(e,t,r,n){if(!ic())return void this.logger.trace(`BrowserPerformanceClient: window performance API not available, unable to add queue measurement for ${e}`);if(!t)return void this.logger.trace(`BrowserPerformanceClient: correlationId for ${e} not provided, unable to add queue measurement`);const o=super.getPreQueueTime(e,t);if(!o)return;const i=window.performance.now(),a=r||super.calculateQueuedTime(o,i);return super.addQueueMeasurement(e,t,a,n)}},e.BrowserPerformanceMeasurement=sc,e.BrowserStorage=Ja,e.BrowserUtils=Ra,e.CacheLookupPolicy=Ki,e.ClientAuthError=ft,e.ClientAuthErrorCodes=gt,e.ClientAuthErrorMessage=mt,e.ClientConfigurationError=Vt,e.ClientConfigurationErrorCodes=Qt,e.ClientConfigurationErrorMessage=jt,e.DEFAULT_IFRAME_TIMEOUT_MS=Pa,e.EventMessageUtils=class{static getInteractionStatusFromEvent(t,r){switch(t.eventType){case cs.LOGIN_START:return Bi.Login;case cs.SSO_SILENT_START:return Bi.SsoSilent;case cs.ACQUIRE_TOKEN_START:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup)return Bi.AcquireToken;break;case cs.HANDLE_REDIRECT_START:return Bi.HandleRedirect;case cs.LOGOUT_START:return Bi.Logout;case cs.SSO_SILENT_SUCCESS:case cs.SSO_SILENT_FAILURE:if(r&&r!==Bi.SsoSilent)break;return Bi.None;case cs.LOGOUT_END:if(r&&r!==Bi.Logout)break;return Bi.None;case cs.HANDLE_REDIRECT_END:if(r&&r!==Bi.HandleRedirect)break;return Bi.None;case cs.LOGIN_SUCCESS:case cs.LOGIN_FAILURE:case cs.ACQUIRE_TOKEN_SUCCESS:case cs.ACQUIRE_TOKEN_FAILURE:case cs.RESTORE_FROM_BFCACHE:if(t.interactionType===e.InteractionType.Redirect||t.interactionType===e.InteractionType.Popup){if(r&&r!==Bi.Login&&r!==Bi.AcquireToken)break;return Bi.None}}return null}},e.EventType=cs,e.InteractionRequiredAuthError=Fn,e.InteractionRequiredAuthErrorCodes=Un,e.InteractionRequiredAuthErrorMessage=xn,e.InteractionStatus=Bi,e.JsonWebTokenTypes=me,e.Logger=jr,e.MemoryStorage=Wa,e.NavigationClient=ba,e.OIDC_DEFAULT_SCOPES=a,e.PerformanceEvents=cr,e.PromptValue=R,e.ProtocolMode=ar,e.PublicClientApplication=Xs,e.PublicClientNext=rc,e.ServerError=In,e.ServerResponseType=_,e.SignedHttpRequest=class{constructor(e,t){const r=t&&t.loggerOptions||{};this.logger=new jr(r,Ma,Na),this.cryptoOps=new Va(this.logger),this.popTokenGenerator=new Qn(this.cryptoOps),this.shrParameters=e}async generatePublicKeyThumbprint(){const{kid:e}=await this.popTokenGenerator.generateKid(this.shrParameters);return e}async signRequest(e,t,r){return this.popTokenGenerator.signPayload(e,t,this.shrParameters,r)}async removeKeys(e){return this.cryptoOps.removeTokenBindingKey(e)}},e.StringUtils=Jt,e.StubPerformanceClient=co,e.UrlString=er,e.WrapperSKU={React:"@azure/msal-react",Angular:"@azure/msal-angular"},e.createNestablePublicClientApplication=async function(e){const t=new za(e);if(await t.initialize(),t.isAvailable()){const r=new Ys(t);return new Xs(e,r)}return Zs(e)},e.createStandardPublicClientApplication=Zs,e.stubbedPublicClientApplication=nc,e.version=Na}));
