import { DecodedAuthToken } from "../account/DecodedAuthToken";
/**
 * @hidden
 */
export declare class StringUtils {
    /**
     * decode a JWT
     *
     * @param authToken
     */
    static decodeAuthToken(authToken: string): DecodedAuthToken;
    /**
     * Check if a string is empty.
     *
     * @param str
     */
    static isEmpty(str?: string): boolean;
    static startsWith(str: string, search: string): boolean;
    static endsWith(str: string, search: string): boolean;
    /**
     * Parses string into an object.
     *
     * @param query
     */
    static queryStringToObject<T>(query: string): T;
    /**
     * Trims entries in an array.
     *
     * @param arr
     */
    static trimArrayEntries(arr: Array<string>): Array<string>;
    /**
     * Removes empty strings from array
     * @param arr
     */
    static removeEmptyStringsFromArray(arr: Array<string>): Array<string>;
    /**
     * Attempts to parse a string into JSON
     * @param str
     */
    static jsonParseHelper<T>(str: string): T | null;
    /**
     * Tests if a given string matches a given pattern, with support for wildcards.
     * @param pattern Wildcard pattern to string match. Supports "*" for wildcards
     * @param input String to match against
     */
    static matchPattern(pattern: string, input: string): boolean;
}
