"use strict";function e(e){return e&&"object"==typeof e&&"default"in e?e.default:e}Object.defineProperty(exports,"__esModule",{value:!0});var t,r=require("@azure/msal-common"),i=e(require("axios")),n=require("uuid"),o=e(require("crypto")),a=require("jsonwebtoken");!function(e){e.GET="get",e.POST="post"}(t||(t={}));const s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~";var c;!function(e){e[e.acquireTokenSilent=62]="acquireTokenSilent",e[e.acquireTokenByUsernamePassword=371]="acquireTokenByUsernamePassword",e[e.acquireTokenByDeviceCode=671]="acquireTokenByDeviceCode",e[e.acquireTokenByClientCredential=771]="acquireTokenByClientCredential",e[e.acquireTokenByCode=871]="acquireTokenByCode",e[e.acquireTokenByRefreshToken=872]="acquireTokenByRefreshToken"}(c||(c={}));class l{async sendGetRequestAsync(e,r){const n={method:t.GET,url:e,headers:r&&r.headers,validateStatus:()=>!0},o=await i(n);return{headers:o.headers,body:o.data,status:o.status}}async sendPostRequestAsync(e,r,n){const o={method:t.POST,url:e,data:r&&r.body||"",timeout:n,headers:r&&r.headers,validateStatus:()=>!0},a=await i(o);return{headers:a.headers,body:a.data,status:a.status}}}const h={clientId:"",authority:r.Constants.DEFAULT_AUTHORITY,clientSecret:"",clientAssertion:"",clientCertificate:{thumbprint:"",privateKey:"",x5c:""},knownAuthorities:[],cloudDiscoveryMetadata:"",authorityMetadata:"",clientCapabilities:[],protocolMode:r.ProtocolMode.AAD},u={},d={loggerOptions:{loggerCallback:()=>{},piiLoggingEnabled:!1,logLevel:r.LogLevel.Info},networkClient:class{static getNetworkClient(){return new l}}.getNetworkClient()};function g({auth:e,cache:t,system:r}){return{auth:{...h,...e},cache:{...u,...t},system:{...d,...r}}}class p{static base64Encode(e,t){return Buffer.from(e,t).toString("base64")}static base64EncodeUrl(e,t){return p.base64Encode(e,t).replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}static base64Decode(e){return Buffer.from(e,"base64").toString("utf8")}static base64DecodeUrl(e){let t=e.replace(/-/g,"+").replace(/_/g,"/");for(;t.length%4;)t+="=";return p.base64Decode(t)}}class y{async generatePkceCodes(){const e=this.generateCodeVerifier();return{verifier:e,challenge:this.generateCodeChallengeFromVerifier(e)}}generateCodeVerifier(){const e=[],t=256-256%s.length;for(;e.length<=32;){const r=o.randomBytes(1)[0];r>=t||e.push(s[r%s.length])}const r=e.join("");return p.base64EncodeUrl(r)}generateCodeChallengeFromVerifier(e){return p.base64EncodeUrl(this.sha256(e).toString("base64"),"base64")}sha256(e){return o.createHash("sha256").update(e).digest()}}class m{constructor(){this.pkceGenerator=new y}createNewGuid(){return class{static generateGuid(){return n.v4()}static isGuid(e){return/^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(e)}}.generateGuid()}base64Encode(e){return p.base64Encode(e)}base64Decode(e){return p.base64Decode(e)}generatePkceCodes(){return this.pkceGenerator.generatePkceCodes()}getPublicKeyThumbprint(){throw new Error("Method not implemented.")}removeTokenBindingKey(){throw new Error("Method not implemented.")}clearKeystore(){throw new Error("Method not implemented.")}signJwt(){throw new Error("Method not implemented.")}hashString(){throw new Error("Method not implemented.")}}class f{static deserializeJSONBlob(e){return r.StringUtils.isEmpty(e)?{}:JSON.parse(e)}static deserializeAccounts(e){const t={};return e&&Object.keys(e).map((function(i){const n=e[i],o={homeAccountId:n.home_account_id,environment:n.environment,realm:n.realm,localAccountId:n.local_account_id,username:n.username,authorityType:n.authority_type,name:n.name,clientInfo:n.client_info,lastModificationTime:n.last_modification_time,lastModificationApp:n.last_modification_app},a=new r.AccountEntity;r.CacheManager.toObject(a,o),t[i]=a})),t}static deserializeIdTokens(e){const t={};return e&&Object.keys(e).map((function(i){const n=e[i],o={homeAccountId:n.home_account_id,environment:n.environment,credentialType:n.credential_type,clientId:n.client_id,secret:n.secret,realm:n.realm},a=new r.IdTokenEntity;r.CacheManager.toObject(a,o),t[i]=a})),t}static deserializeAccessTokens(e){const t={};return e&&Object.keys(e).map((function(i){const n=e[i],o={homeAccountId:n.home_account_id,environment:n.environment,credentialType:n.credential_type,clientId:n.client_id,secret:n.secret,realm:n.realm,target:n.target,cachedAt:n.cached_at,expiresOn:n.expires_on,extendedExpiresOn:n.extended_expires_on,refreshOn:n.refresh_on,keyId:n.key_id,tokenType:n.token_type},a=new r.AccessTokenEntity;r.CacheManager.toObject(a,o),t[i]=a})),t}static deserializeRefreshTokens(e){const t={};return e&&Object.keys(e).map((function(i){const n=e[i],o={homeAccountId:n.home_account_id,environment:n.environment,credentialType:n.credential_type,clientId:n.client_id,secret:n.secret,familyId:n.family_id,target:n.target,realm:n.realm},a=new r.RefreshTokenEntity;r.CacheManager.toObject(a,o),t[i]=a})),t}static deserializeAppMetadata(e){const t={};return e&&Object.keys(e).map((function(i){const n=e[i],o={clientId:n.client_id,environment:n.environment,familyId:n.family_id},a=new r.AppMetadataEntity;r.CacheManager.toObject(a,o),t[i]=a})),t}static deserializeAllCache(e){return{accounts:e.Account?this.deserializeAccounts(e.Account):{},idTokens:e.IdToken?this.deserializeIdTokens(e.IdToken):{},accessTokens:e.AccessToken?this.deserializeAccessTokens(e.AccessToken):{},refreshTokens:e.RefreshToken?this.deserializeRefreshTokens(e.RefreshToken):{},appMetadata:e.AppMetadata?this.deserializeAppMetadata(e.AppMetadata):{}}}}class C{static serializeJSONBlob(e){return JSON.stringify(e)}static serializeAccounts(e){const t={};return Object.keys(e).map((function(r){const i=e[r];t[r]={home_account_id:i.homeAccountId,environment:i.environment,realm:i.realm,local_account_id:i.localAccountId,username:i.username,authority_type:i.authorityType,name:i.name,client_info:i.clientInfo,last_modification_time:i.lastModificationTime,last_modification_app:i.lastModificationApp}})),t}static serializeIdTokens(e){const t={};return Object.keys(e).map((function(r){const i=e[r];t[r]={home_account_id:i.homeAccountId,environment:i.environment,credential_type:i.credentialType,client_id:i.clientId,secret:i.secret,realm:i.realm}})),t}static serializeAccessTokens(e){const t={};return Object.keys(e).map((function(r){const i=e[r];t[r]={home_account_id:i.homeAccountId,environment:i.environment,credential_type:i.credentialType,client_id:i.clientId,secret:i.secret,realm:i.realm,target:i.target,cached_at:i.cachedAt,expires_on:i.expiresOn,extended_expires_on:i.extendedExpiresOn,refresh_on:i.refreshOn,key_id:i.keyId,token_type:i.tokenType}})),t}static serializeRefreshTokens(e){const t={};return Object.keys(e).map((function(r){const i=e[r];t[r]={home_account_id:i.homeAccountId,environment:i.environment,credential_type:i.credentialType,client_id:i.clientId,secret:i.secret,family_id:i.familyId,target:i.target,realm:i.realm}})),t}static serializeAppMetadata(e){const t={};return Object.keys(e).map((function(r){const i=e[r];t[r]={client_id:i.clientId,environment:i.environment,family_id:i.familyId}})),t}static serializeAllCache(e){return{Account:this.serializeAccounts(e.accounts),IdToken:this.serializeIdTokens(e.idTokens),AccessToken:this.serializeAccessTokens(e.accessTokens),RefreshToken:this.serializeRefreshTokens(e.refreshTokens),AppMetadata:this.serializeAppMetadata(e.appMetadata)}}}class A extends r.CacheManager{constructor(e,t,r){super(t,r),this.cache={},this.changeEmitters=[],this.logger=e}registerChangeEmitter(e){this.changeEmitters.push(e)}emitChange(){this.changeEmitters.forEach(e=>e.call(null))}cacheToInMemoryCache(e){const t={accounts:{},idTokens:{},accessTokens:{},refreshTokens:{},appMetadata:{}};for(const i in e)if(e[i]instanceof r.AccountEntity)t.accounts[i]=e[i];else if(e[i]instanceof r.IdTokenEntity)t.idTokens[i]=e[i];else if(e[i]instanceof r.AccessTokenEntity)t.accessTokens[i]=e[i];else if(e[i]instanceof r.RefreshTokenEntity)t.refreshTokens[i]=e[i];else{if(!(e[i]instanceof r.AppMetadataEntity))continue;t.appMetadata[i]=e[i]}return t}inMemoryCacheToCache(e){let t=this.getCache();return t={...e.accounts,...e.idTokens,...e.accessTokens,...e.refreshTokens,...e.appMetadata},t}getInMemoryCache(){return this.logger.trace("Getting in-memory cache"),this.cacheToInMemoryCache(this.getCache())}setInMemoryCache(e){this.logger.trace("Setting in-memory cache");const t=this.inMemoryCacheToCache(e);this.setCache(t),this.emitChange()}getCache(){return this.logger.trace("Getting cache key-value store"),this.cache}setCache(e){this.logger.trace("Setting cache key value store"),this.cache=e,this.emitChange()}getItem(e){return this.logger.tracePii("Item key: "+e),this.getCache()[e]}setItem(e,t){this.logger.tracePii("Item key: "+e);const r=this.getCache();r[e]=t,this.setCache(r)}getAccount(e){const t=this.getItem(e);return r.AccountEntity.isAccountEntity(t)?t:null}setAccount(e){const t=e.generateAccountKey();this.setItem(t,e)}getIdTokenCredential(e){const t=this.getItem(e);return r.IdTokenEntity.isIdTokenEntity(t)?t:null}setIdTokenCredential(e){const t=e.generateCredentialKey();this.setItem(t,e)}getAccessTokenCredential(e){const t=this.getItem(e);return r.AccessTokenEntity.isAccessTokenEntity(t)?t:null}setAccessTokenCredential(e){const t=e.generateCredentialKey();this.setItem(t,e)}getRefreshTokenCredential(e){const t=this.getItem(e);return r.RefreshTokenEntity.isRefreshTokenEntity(t)?t:null}setRefreshTokenCredential(e){const t=e.generateCredentialKey();this.setItem(t,e)}getAppMetadata(e){const t=this.getItem(e);return r.AppMetadataEntity.isAppMetadataEntity(e,t)?t:null}setAppMetadata(e){const t=e.generateAppMetadataKey();this.setItem(t,e)}getServerTelemetry(e){const t=this.getItem(e);return t&&r.ServerTelemetryEntity.isServerTelemetryEntity(e,t)?t:null}setServerTelemetry(e,t){this.setItem(e,t)}getAuthorityMetadata(e){const t=this.getItem(e);return t&&r.AuthorityMetadataEntity.isAuthorityMetadataEntity(e,t)?t:null}getAuthorityMetadataKeys(){return this.getKeys().filter(e=>this.isAuthorityMetadata(e))}setAuthorityMetadata(e,t){this.setItem(e,t)}getThrottlingCache(e){const t=this.getItem(e);return t&&r.ThrottlingEntity.isThrottlingEntity(e,t)?t:null}setThrottlingCache(e,t){this.setItem(e,t)}removeItem(e){this.logger.tracePii("Item key: "+e);let t=!1;const r=this.getCache();return r[e]&&(delete r[e],t=!0),t&&(this.setCache(r),this.emitChange()),t}containsKey(e){return this.getKeys().includes(e)}getKeys(){this.logger.trace("Retrieving all cache keys");const e=this.getCache();return[...Object.keys(e)]}async clear(){this.logger.trace("Clearing cache entries created by MSAL"),this.getKeys().forEach(e=>{this.removeItem(e)}),this.emitChange()}static generateInMemoryCache(e){return f.deserializeAllCache(f.deserializeJSONBlob(e))}static generateJsonCache(e){return C.serializeAllCache(e)}updateCredentialCacheKey(e,t){const r=t.generateCredentialKey();if(e!==r){const i=this.getItem(e);if(i)return this.removeItem(e),this.setItem(r,i),this.logger.verbose(`Updated an outdated ${t.credentialType} cache key`),r;this.logger.error(`Attempted to update an outdated ${t.credentialType} cache key but no item matching the outdated key was found in storage`)}return e}}const k={},T={},I={},b={},v={};class E{constructor(e,t,r){this.cacheHasChanged=!1,this.storage=e,this.storage.registerChangeEmitter(this.handleChangeEvent.bind(this)),r&&(this.persistence=r),this.logger=t}hasChanged(){return this.cacheHasChanged}serialize(){this.logger.trace("Serializing in-memory cache");let e=C.serializeAllCache(this.storage.getInMemoryCache());return r.StringUtils.isEmpty(this.cacheSnapshot)?this.logger.trace("No cache snapshot to merge"):(this.logger.trace("Reading cache snapshot from disk"),e=this.mergeState(JSON.parse(this.cacheSnapshot),e)),this.cacheHasChanged=!1,JSON.stringify(e)}deserialize(e){if(this.logger.trace("Deserializing JSON to in-memory cache"),this.cacheSnapshot=e,r.StringUtils.isEmpty(this.cacheSnapshot))this.logger.trace("No cache snapshot to deserialize");else{this.logger.trace("Reading cache snapshot from disk");const e=f.deserializeAllCache(this.overlayDefaults(JSON.parse(this.cacheSnapshot)));this.storage.setInMemoryCache(e)}}getKVStore(){return this.storage.getCache()}async getAllAccounts(){let e;this.logger.trace("getAllAccounts called");try{return this.persistence&&(e=new r.TokenCacheContext(this,!1),await this.persistence.beforeCacheAccess(e)),this.storage.getAllAccounts()}finally{this.persistence&&e&&await this.persistence.afterCacheAccess(e)}}async getAccountByHomeId(e){const t=await this.getAllAccounts();return!r.StringUtils.isEmpty(e)&&t&&t.length&&t.filter(t=>t.homeAccountId===e)[0]||null}async getAccountByLocalId(e){const t=await this.getAllAccounts();return!r.StringUtils.isEmpty(e)&&t&&t.length&&t.filter(t=>t.localAccountId===e)[0]||null}async removeAccount(e){let t;this.logger.trace("removeAccount called");try{this.persistence&&(t=new r.TokenCacheContext(this,!0),await this.persistence.beforeCacheAccess(t)),await this.storage.removeAccount(r.AccountEntity.generateAccountCacheKey(e))}finally{this.persistence&&t&&await this.persistence.afterCacheAccess(t)}}handleChangeEvent(){this.cacheHasChanged=!0}mergeState(e,t){this.logger.trace("Merging in-memory cache with cache snapshot");const r=this.mergeRemovals(e,t);return this.mergeUpdates(r,t)}mergeUpdates(e,t){return Object.keys(t).forEach(r=>{const i=t[r];if(e.hasOwnProperty(r)){const t=null!==i,n="object"==typeof i,o=!Array.isArray(i),a=null!=e[r];t&&n&&o&&a?this.mergeUpdates(e[r],i):e[r]=i}else null!==i&&(e[r]=i)}),e}mergeRemovals(e,t){this.logger.trace("Remove updated entries in cache");const r=e.Account?this.mergeRemovalsDict(e.Account,t.Account):e.Account,i=e.AccessToken?this.mergeRemovalsDict(e.AccessToken,t.AccessToken):e.AccessToken,n=e.RefreshToken?this.mergeRemovalsDict(e.RefreshToken,t.RefreshToken):e.RefreshToken,o=e.IdToken?this.mergeRemovalsDict(e.IdToken,t.IdToken):e.IdToken,a=e.AppMetadata?this.mergeRemovalsDict(e.AppMetadata,t.AppMetadata):e.AppMetadata;return{...e,Account:r,AccessToken:i,RefreshToken:n,IdToken:o,AppMetadata:a}}mergeRemovalsDict(e,t){const r={...e};return Object.keys(e).forEach(e=>{t&&t.hasOwnProperty(e)||delete r[e]}),r}overlayDefaults(e){return this.logger.trace("Overlaying input cache with the default cache"),{Account:{...k,...e.Account},IdToken:{...T,...e.IdToken},AccessToken:{...I,...e.AccessToken},RefreshToken:{...b,...e.RefreshToken},AppMetadata:{...v,...e.AppMetadata}}}}class w{constructor(e){this.config=g(e),this.cryptoProvider=new m,this.logger=new r.Logger(this.config.system.loggerOptions,"@azure/msal-node","1.5.0"),this.storage=new A(this.logger,this.config.auth.clientId,this.cryptoProvider),this.tokenCache=new E(this.storage,this.logger,this.config.cache.cachePlugin)}async getAuthCodeUrl(e){this.logger.info("getAuthCodeUrl called",e.correlationId);const t={...e,...this.initializeBaseRequest(e),responseMode:e.responseMode||r.ResponseMode.QUERY,authenticationScheme:r.AuthenticationScheme.BEARER},i=await this.buildOauthClientConfiguration(t.authority,t.correlationId),n=new r.AuthorizationCodeClient(i);return this.logger.verbose("Auth code client created",t.correlationId),n.getAuthCodeUrl(t)}async acquireTokenByCode(e){this.logger.info("acquireTokenByCode called",e.correlationId);const t={...e,...this.initializeBaseRequest(e),authenticationScheme:r.AuthenticationScheme.BEARER},i=this.initializeServerTelemetryManager(c.acquireTokenByCode,t.correlationId);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,i),n=new r.AuthorizationCodeClient(e);return this.logger.verbose("Auth code client created",t.correlationId),n.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),i.cacheFailedRequest(e),e}}async acquireTokenByRefreshToken(e){this.logger.info("acquireTokenByRefreshToken called",e.correlationId);const t={...e,...this.initializeBaseRequest(e),authenticationScheme:r.AuthenticationScheme.BEARER},i=this.initializeServerTelemetryManager(c.acquireTokenByRefreshToken,t.correlationId);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,i),n=new r.RefreshTokenClient(e);return this.logger.verbose("Refresh token client created",t.correlationId),n.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),i.cacheFailedRequest(e),e}}async acquireTokenSilent(e){const t={...e,...this.initializeBaseRequest(e),forceRefresh:e.forceRefresh||!1},i=this.initializeServerTelemetryManager(c.acquireTokenSilent,t.correlationId,t.forceRefresh);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,i),n=new r.SilentFlowClient(e);return this.logger.verbose("Silent flow client created",t.correlationId),n.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),i.cacheFailedRequest(e),e}}async acquireTokenByUsernamePassword(e){this.logger.info("acquireTokenByUsernamePassword called",e.correlationId);const t={...e,...this.initializeBaseRequest(e)},i=this.initializeServerTelemetryManager(c.acquireTokenByUsernamePassword,t.correlationId);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,i),n=new r.UsernamePasswordClient(e);return this.logger.verbose("Username password client created",t.correlationId),n.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),i.cacheFailedRequest(e),e}}getTokenCache(){return this.logger.info("getTokenCache called"),this.tokenCache}getLogger(){return this.logger}setLogger(e){this.logger=e}async buildOauthClientConfiguration(e,t,r,i){this.logger.verbose("buildOauthClientConfiguration called",t),this.logger.verbose("building oauth client configuration with the authority: "+e,t);const n=await this.createAuthority(e,i,t);return null==r||r.updateRegionDiscoveryMetadata(n.regionDiscoveryMetadata),{authOptions:{clientId:this.config.auth.clientId,authority:n,clientCapabilities:this.config.auth.clientCapabilities},loggerOptions:{logLevel:this.config.system.loggerOptions.logLevel,loggerCallback:this.config.system.loggerOptions.loggerCallback,piiLoggingEnabled:this.config.system.loggerOptions.piiLoggingEnabled,correlationId:t},cryptoInterface:this.cryptoProvider,networkInterface:this.config.system.networkClient,storageInterface:this.storage,serverTelemetryManager:r,clientCredentials:{clientSecret:this.clientSecret,clientAssertion:this.clientAssertion?this.getClientAssertion(n):void 0},libraryInfo:{sku:"msal.js.node",version:"1.5.0",cpu:process.arch||"",os:process.platform||""},persistencePlugin:this.config.cache.cachePlugin,serializableCache:this.tokenCache}}getClientAssertion(e){return{assertion:this.clientAssertion.getJwt(this.cryptoProvider,this.config.auth.clientId,e.tokenEndpoint),assertionType:"urn:ietf:params:oauth:client-assertion-type:jwt-bearer"}}initializeBaseRequest(e){return this.logger.verbose("initializeRequestScopes called",e.correlationId),e.authenticationScheme&&e.authenticationScheme===r.AuthenticationScheme.POP&&this.logger.verbose("Authentication Scheme 'pop' is not supported yet, setting Authentication Scheme to 'Bearer' for request",e.correlationId),e.authenticationScheme=r.AuthenticationScheme.BEARER,{...e,scopes:[...e&&e.scopes||[],...r.OIDC_DEFAULT_SCOPES],correlationId:e&&e.correlationId||this.cryptoProvider.createNewGuid(),authority:e.authority||this.config.auth.authority}}initializeServerTelemetryManager(e,t,i){return new r.ServerTelemetryManager({clientId:this.config.auth.clientId,correlationId:t,apiId:e,forceRefresh:i||!1},this.storage)}async createAuthority(e,t,i){this.logger.verbose("createAuthority called",i);const n={protocolMode:this.config.auth.protocolMode,knownAuthorities:this.config.auth.knownAuthorities,cloudDiscoveryMetadata:this.config.auth.cloudDiscoveryMetadata,authorityMetadata:this.config.auth.authorityMetadata,azureRegionConfiguration:t};return await r.AuthorityFactory.createDiscoveredInstance(e,this.config.system.networkClient,this.storage,n)}}class M{static fromAssertion(e){const t=new M;return t.jwt=e,t}static fromCertificate(e,t,r){const i=new M;return i.privateKey=t,i.thumbprint=e,r&&(i.publicCertificate=this.parseCertificate(r)),i}getJwt(e,t,i){if(this.privateKey&&this.thumbprint)return this.jwt&&!this.isExpired()&&t===this.issuer&&i===this.jwtAudience?this.jwt:this.createJwt(e,t,i);if(this.jwt)return this.jwt;throw r.ClientAuthError.createInvalidAssertionError()}createJwt(e,t,i){this.issuer=t,this.jwtAudience=i;const n=r.TimeUtils.nowSeconds();this.expirationTime=n+600;const o={alg:"RS256",x5t:p.base64EncodeUrl(this.thumbprint,"hex")};this.publicCertificate&&Object.assign(o,{x5c:this.publicCertificate});const s={aud:this.jwtAudience,exp:this.expirationTime,iss:this.issuer,sub:this.issuer,nbf:n,jti:e.createNewGuid()};return this.jwt=a.sign(s,this.privateKey,{header:o}),this.jwt}isExpired(){return this.expirationTime<r.TimeUtils.nowSeconds()}static parseCertificate(e){const t=/-----BEGIN CERTIFICATE-----\n(.+?)\n-----END CERTIFICATE-----/gs,r=[];let i;for(;null!==(i=t.exec(e));)r.push(i[1].replace(/\n/,""));return r}}Object.defineProperty(exports,"AuthError",{enumerable:!0,get:function(){return r.AuthError}}),Object.defineProperty(exports,"AuthErrorMessage",{enumerable:!0,get:function(){return r.AuthErrorMessage}}),Object.defineProperty(exports,"ClientAuthError",{enumerable:!0,get:function(){return r.ClientAuthError}}),Object.defineProperty(exports,"ClientAuthErrorMessage",{enumerable:!0,get:function(){return r.ClientAuthErrorMessage}}),Object.defineProperty(exports,"ClientConfigurationError",{enumerable:!0,get:function(){return r.ClientConfigurationError}}),Object.defineProperty(exports,"ClientConfigurationErrorMessage",{enumerable:!0,get:function(){return r.ClientConfigurationErrorMessage}}),Object.defineProperty(exports,"InteractionRequiredAuthError",{enumerable:!0,get:function(){return r.InteractionRequiredAuthError}}),Object.defineProperty(exports,"InteractionRequiredAuthErrorMessage",{enumerable:!0,get:function(){return r.InteractionRequiredAuthErrorMessage}}),Object.defineProperty(exports,"LogLevel",{enumerable:!0,get:function(){return r.LogLevel}}),Object.defineProperty(exports,"Logger",{enumerable:!0,get:function(){return r.Logger}}),Object.defineProperty(exports,"PromptValue",{enumerable:!0,get:function(){return r.PromptValue}}),Object.defineProperty(exports,"ProtocolMode",{enumerable:!0,get:function(){return r.ProtocolMode}}),Object.defineProperty(exports,"ResponseMode",{enumerable:!0,get:function(){return r.ResponseMode}}),Object.defineProperty(exports,"ServerError",{enumerable:!0,get:function(){return r.ServerError}}),Object.defineProperty(exports,"TokenCacheContext",{enumerable:!0,get:function(){return r.TokenCacheContext}}),exports.ClientApplication=w,exports.ClientAssertion=M,exports.ConfidentialClientApplication=class extends w{constructor(e){super(e),this.setClientCredential(this.config)}async acquireTokenByClientCredential(e){this.logger.info("acquireTokenByClientCredential called",e.correlationId);const t={...e,...this.initializeBaseRequest(e)},i={azureRegion:t.azureRegion,environmentRegion:process.env.REGION_NAME},n=this.initializeServerTelemetryManager(c.acquireTokenByClientCredential,t.correlationId,t.skipCache);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,n,i),o=new r.ClientCredentialClient(e);return this.logger.verbose("Client credential client created",t.correlationId),o.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),n.cacheFailedRequest(e),e}}async acquireTokenOnBehalfOf(e){this.logger.info("acquireTokenOnBehalfOf called",e.correlationId);const t={...e,...this.initializeBaseRequest(e)};try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId),i=new r.OnBehalfOfClient(e);return this.logger.verbose("On behalf of client created",t.correlationId),i.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),e}}setClientCredential(e){const t=!r.StringUtils.isEmpty(e.auth.clientSecret),i=!r.StringUtils.isEmpty(e.auth.clientAssertion),n=e.auth.clientCertificate||{thumbprint:"",privateKey:""},o=!r.StringUtils.isEmpty(n.thumbprint)||!r.StringUtils.isEmpty(n.privateKey);if(t&&i||i&&o||t&&o)throw r.ClientAuthError.createInvalidCredentialError();if(e.auth.clientSecret)this.clientSecret=e.auth.clientSecret;else if(e.auth.clientAssertion)this.clientAssertion=M.fromAssertion(e.auth.clientAssertion);else{if(!o)throw r.ClientAuthError.createInvalidCredentialError();var a;this.clientAssertion=M.fromCertificate(n.thumbprint,n.privateKey,null==(a=e.auth.clientCertificate)?void 0:a.x5c)}}},exports.CryptoProvider=m,exports.NodeStorage=A,exports.PublicClientApplication=class extends w{constructor(e){super(e)}async acquireTokenByDeviceCode(e){this.logger.info("acquireTokenByDeviceCode called",e.correlationId);const t=Object.assign(e,this.initializeBaseRequest(e)),i=this.initializeServerTelemetryManager(c.acquireTokenByDeviceCode,t.correlationId);try{const e=await this.buildOauthClientConfiguration(t.authority,t.correlationId,i),n=new r.DeviceCodeClient(e);return this.logger.verbose("Device code client created",t.correlationId),n.acquireToken(t)}catch(e){throw e instanceof r.AuthError&&e.setCorrelationId(t.correlationId),i.cacheFailedRequest(e),e}}},exports.TokenCache=E,exports.buildAppConfiguration=g,exports.version="1.5.0";
//# sourceMappingURL=msal-node.cjs.production.min.js.map
