/*!
 * Azure Storage SDK for JavaScript - Blob, 10.5.0
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).azblob={})}(this,function(e){"use strict";function t(e){return e.toLowerCase()}var r=function(){function e(e){if(this._headersMap={},e)for(var t in e)this.set(t,e[t])}return e.prototype.set=function(e,r){this._headersMap[t(e)]={name:e,value:r.toString()}},e.prototype.get=function(e){var r=this._headersMap[t(e)];return r?r.value:void 0},e.prototype.contains=function(e){return!!this._headersMap[t(e)]},e.prototype.remove=function(e){var r=this.contains(e);return delete this._headersMap[t(e)],r},e.prototype.rawHeaders=function(){var e={};for(var t in this._headersMap){var r=this._headersMap[t];e[r.name.toLowerCase()]=r.value}return e},e.prototype.headersArray=function(){var e=[];for(var t in this._headersMap)e.push(this._headersMap[t]);return e},e.prototype.headerNames=function(){for(var e=[],t=this.headersArray(),r=0;r<t.length;++r)e.push(t[r].name);return e},e.prototype.headerValues=function(){for(var e=[],t=this.headersArray(),r=0;r<t.length;++r)e.push(t[r].value);return e},e.prototype.toJson=function(){return this.rawHeaders()},e.prototype.toString=function(){return JSON.stringify(this.toJson())},e.prototype.clone=function(){return new e(this.rawHeaders())},e}();function i(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return btoa(t)}function n(e){for(var t=atob(e),r=new Uint8Array(t.length),i=0;i<t.length;i++)r[i]=t.charCodeAt(i);return r}for(var a=function(e,t){return e(t={exports:{}},t.exports),t.exports}(function(e){var t="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof window.msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto);if(t){var r=new Uint8Array(16);e.exports=function(){return t(r),r}}else{var i=new Array(16);e.exports=function(){for(var e,t=0;t<16;t++)0==(3&t)&&(e=4294967296*Math.random()),i[t]=e>>>((3&t)<<3)&255;return i}}}),s=[],o=0;o<256;++o)s[o]=(o+256).toString(16).substr(1);var m=function(e,t){var r=t||0,i=s;return[i[e[r++]],i[e[r++]],i[e[r++]],i[e[r++]],"-",i[e[r++]],i[e[r++]],"-",i[e[r++]],i[e[r++]],"-",i[e[r++]],i[e[r++]],"-",i[e[r++]],i[e[r++]],i[e[r++]],i[e[r++]],i[e[r++]],i[e[r++]]].join("")};var d=function(e,t,r){var i=t&&r||0;"string"==typeof e&&(t="binary"===e?new Array(16):null,e=null);var n=(e=e||{}).random||(e.rng||a)();if(n[6]=15&n[6]|64,n[8]=63&n[8]|128,t)for(var s=0;s<16;++s)t[i+s]=n[s];return t||m(n)},l={msRestVersion:"2.0.4",HTTP:"http:",HTTPS:"https:",HTTP_PROXY:"HTTP_PROXY",HTTPS_PROXY:"HTTPS_PROXY",HttpConstants:{HttpVerbs:{PUT:"PUT",GET:"GET",DELETE:"DELETE",POST:"POST",MERGE:"MERGE",HEAD:"HEAD",PATCH:"PATCH"},StatusCodes:{TooManyRequests:429}},HeaderConstants:{AUTHORIZATION:"authorization",AUTHORIZATION_SCHEME:"Bearer",RETRY_AFTER:"Retry-After",USER_AGENT:"User-Agent"}},c="undefined"!=typeof process&&!!process.version&&!!process.versions&&!!process.versions.node;function p(e){var t={};return t.body=e.bodyAsText,t.headers=e.headers,t.status=e.status,t}function u(e){var t=e.clone();return t.headers&&t.headers.remove("authorization"),t}function y(){return d()}function h(e,t){return new Promise(function(r){return setTimeout(function(){return r(t)},e)})}var f=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function g(e,t,r){return e&&t?e.split(t).join(r||""):e}var N=function(){function e(e,t){void 0===e&&(e={}),this.modelMappers=e,this.isXML=t}return e.prototype.validateConstraints=function(e,t,r){var i=function(e,i){throw new Error('"'+r+'" with value "'+t+'" should satisfy the constraint "'+e+'": '+i+".")};if(e.constraints&&null!=t){var n=e.constraints,a=n.ExclusiveMaximum,s=n.ExclusiveMinimum,o=n.InclusiveMaximum,m=n.InclusiveMinimum,d=n.MaxItems,l=n.MaxLength,c=n.MinItems,p=n.MinLength,u=n.MultipleOf,y=n.Pattern,h=n.UniqueItems;if(null!=a&&t>=a&&i("ExclusiveMaximum",a),null!=s&&t<=s&&i("ExclusiveMinimum",s),null!=o&&t>o&&i("InclusiveMaximum",o),null!=m&&t<m&&i("InclusiveMinimum",m),null!=d&&t.length>d&&i("MaxItems",d),null!=l&&t.length>l&&i("MaxLength",l),null!=c&&t.length<c&&i("MinItems",c),null!=p&&t.length<p&&i("MinLength",p),null!=u&&t%u!=0&&i("MultipleOf",u),y){var f="string"==typeof y?new RegExp(y):y;"string"==typeof t&&null!==t.match(f)||i("Pattern",y)}h&&t.some(function(e,t,r){return r.indexOf(e)!==t})&&i("UniqueItems",h)}},e.prototype.serialize=function(e,t,r){var n={},a=e.type.name;r||(r=e.serializedName),null!==a.match(/^Sequence$/gi)&&(n=[]),e.isConstant&&(t=e.defaultValue);var s=e.required,o=e.nullable;if(s&&o&&void 0===t)throw new Error(r+" cannot be undefined.");if(s&&!o&&null==t)throw new Error(r+" cannot be null or undefined.");if(!s&&!1===o&&null===t)throw new Error(r+" cannot be null.");if(null==t)n=t;else if(this.validateConstraints(e,t,r),null!==a.match(/^any$/gi))n=t;else if(null!==a.match(/^(Number|String|Boolean|Object|Stream|Uuid)$/gi))n=function(e,t,r){if(null!=r)if(null!==e.match(/^Number$/gi)){if("number"!=typeof r)throw new Error(t+" with value "+r+" must be of type number.")}else if(null!==e.match(/^String$/gi)){if("string"!=typeof r.valueOf())throw new Error(t+' with value "'+r+'" must be of type string.')}else if(null!==e.match(/^Uuid$/gi)){if("string"!=typeof r.valueOf()||(n=r,!new RegExp("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$","ig").test(n)))throw new Error(t+' with value "'+r+'" must be of type string and a valid uuid.')}else if(null!==e.match(/^Boolean$/gi)){if("boolean"!=typeof r)throw new Error(t+" with value "+r+" must be of type boolean.")}else if(null!==e.match(/^Stream$/gi)){var i=typeof r;if(!("string"===i||"function"===i||r instanceof ArrayBuffer||ArrayBuffer.isView(r)||"function"==typeof Blob&&r instanceof Blob))throw new Error(t+" must be a string, Blob, ArrayBuffer, ArrayBufferView, or a function returning NodeJS.ReadableStream.")}var n;return r}(a,r,t);else if(null!==a.match(/^Enum$/gi)){n=function(e,t,r){if(!t)throw new Error("Please provide a set of allowedValues to validate "+e+" as an Enum Type.");if(!t.some(function(e){return"string"==typeof e.valueOf()?e.toLowerCase()===r.toLowerCase():e===r}))throw new Error(r+" is not a valid value for "+e+". The valid values are: "+JSON.stringify(t)+".");return r}(r,e.type.allowedValues,t)}else null!==a.match(/^(Date|DateTime|TimeSpan|DateTimeRfc1123|UnixTime)$/gi)?n=function(e,t,r){if(null!=t)if(null!==e.match(/^Date$/gi)){if(!(t instanceof Date||"string"==typeof t.valueOf()&&!isNaN(Date.parse(t))))throw new Error(r+" must be an instanceof Date or a string in ISO8601 format.");t=t instanceof Date?t.toISOString().substring(0,10):new Date(t).toISOString().substring(0,10)}else if(null!==e.match(/^DateTime$/gi)){if(!(t instanceof Date||"string"==typeof t.valueOf()&&!isNaN(Date.parse(t))))throw new Error(r+" must be an instanceof Date or a string in ISO8601 format.");t=t instanceof Date?t.toISOString():new Date(t).toISOString()}else if(null!==e.match(/^DateTimeRfc1123$/gi)){if(!(t instanceof Date||"string"==typeof t.valueOf()&&!isNaN(Date.parse(t))))throw new Error(r+" must be an instanceof Date or a string in RFC-1123 format.");t=t instanceof Date?t.toUTCString():new Date(t).toUTCString()}else if(null!==e.match(/^UnixTime$/gi)){if(!(t instanceof Date||"string"==typeof t.valueOf()&&!isNaN(Date.parse(t))))throw new Error(r+" must be an instanceof Date or a string in RFC-1123/ISO8601 format for it to be serialized in UnixTime/Epoch format.");t=function(e){if(!e)return;"string"==typeof e.valueOf()&&(e=new Date(e));return Math.floor(e.getTime()/1e3)}(t)}else if(null!==e.match(/^TimeSpan$/gi)){if(!function(e){return f.test(e)}(t))throw new Error(r+' must be a string in ISO 8601 format. Instead was "'+t+'".');t=t}return t}(a,t,r):null!==a.match(/^ByteArray$/gi)?n=function(e,t){if(null!=t){if(!(t instanceof Uint8Array))throw new Error(e+" must be of type Uint8Array.");t=i(t)}return t}(r,t):null!==a.match(/^Base64Url$/gi)?n=function(e,t){if(null!=t){if(!(t instanceof Uint8Array))throw new Error(e+" must be of type Uint8Array.");t=function(e){if(!e)return;if(!(e instanceof Uint8Array))throw new Error("Please provide an input of type Uint8Array for converting to Base64Url.");return function(e,t){var r=e.length;for(;r-1>=0&&e[r-1]===t;)--r;return e.substr(0,r)}(i(e),"=").replace(/\+/g,"-").replace(/\//g,"_")}(t)}return t}(r,t):null!==a.match(/^Sequence$/gi)?n=function(e,t,r,i){if(!Array.isArray(r))throw new Error(i+" must be of type Array.");var n=t.type.element;if(!n||"object"!=typeof n)throw new Error('element" metadata for an Array must be defined in the mapper and it must of type "object" in '+i+".");for(var a=[],s=0;s<r.length;s++)a[s]=e.serialize(n,r[s],i);return a}(this,e,t,r):null!==a.match(/^Dictionary$/gi)?n=function(e,t,r,i){if("object"!=typeof r)throw new Error(i+" must be of type object.");var n=t.type.value;if(!n||"object"!=typeof n)throw new Error('"value" metadata for a Dictionary must be defined in the mapper and it must of type "object" in '+i+".");for(var a={},s=0,o=Object.keys(r);s<o.length;s++){var m=o[s];a[m]=e.serialize(n,r[m],i+"."+m)}return a}(this,e,t,r):null!==a.match(/^Composite$/gi)&&(n=function(e,t,r,i){var n;z(e,t)&&(t=C(e,t,r,"clientName"));if(null!=r){for(var a={},s=v(e,t,i),o=0,m=Object.keys(s);o<m.length;o++){var d=m[o],l=s[d];if(!l.readOnly){var c=void 0,p=a;if(e.isXML)c=l.xmlIsWrapped?l.xmlName:l.xmlElementName||l.xmlName;else{var u=b(l.serializedName);c=u.pop();for(var y=0,h=u;y<h.length;y++){var f=h[y];null==p[f]&&null!=r[d]&&(p[f]={}),p=p[f]}}if(null!=p){var g=""!==l.serializedName?i+"."+l.serializedName:i,N=r[d],S=z(e,t);S&&S.clientName===d&&null==N&&(N=t.serializedName);var P=e.serialize(l,N,g);void 0!==P&&null!=c&&(l.xmlIsAttribute?(p.$=p.$||{},p.$[c]=P):l.xmlIsWrapped?p[c]=((n={})[l.xmlElementName]=P,n):p[c]=P)}}}var x=t.type.additionalProperties;if(x){var R=Object.keys(s),q=function(t){R.every(function(e){return e!==t})&&(a[t]=e.serialize(x,r[t],i+'["'+t+'"]'))};for(var T in r)q(T)}return a}return r}(this,e,t,r));return n},e.prototype.deserialize=function(e,t,r){if(null==t)return this.isXML&&"Sequence"===e.type.name&&!e.xmlIsWrapped&&(t=[]),void 0!==e.defaultValue&&(t=e.defaultValue),t;var i,a=e.type.name;return r||(r=e.serializedName),null!==a.match(/^Composite$/gi)?i=function(e,t,r,i){z(e,t)&&(t=C(e,t,r,"serializedName"));for(var n=v(e,t,i),a={},s=[],o=0,m=Object.keys(n);o<m.length;o++){var d=m[o],l=n[d],c=b(n[d].serializedName);s.push(c[0]);var p=l.serializedName,u=l.xmlName,y=l.xmlElementName,h=i;""!==p&&void 0!==p&&(h=i+"."+p);var f=l.headerCollectionPrefix;if(f){for(var g={},N=0,P=Object.keys(r);N<P.length;N++){var x=P[N];x.startsWith(f)&&(g[x.substring(f.length)]=e.deserialize(l.type.value,r[x],h)),s.push(x)}a[d]=g}else if(e.isXML)if(l.xmlIsAttribute&&r.$)a[d]=e.deserialize(l,r.$[u],h);else{var R=r[y||u||p];if(l.xmlIsWrapped)void 0===(R=(R=r[u])&&R[y])&&(R=[]);a[d]=e.deserialize(l,R,h)}else{for(var q=void 0,T=r,M=0,A=c;M<A.length;M++){var E=A[M];if(!T)break;T=T[E]}q=T;var w=t.type.polymorphicDiscriminator;w&&d===w.clientName&&null==q&&(q=t.serializedName);var I=void 0;Array.isArray(r[d])&&""===n[d].serializedName?(q=r[d],a=e.deserialize(l,q,h)):void 0===q&&void 0===l.defaultValue||(I=e.deserialize(l,q,h),a[d]=I)}}var L=t.type.additionalProperties;if(L){var B=function(e){for(var t in n){if(b(n[t].serializedName)[0]===e)return!1}return!0};for(var D in r)B(D)&&(a[D]=e.deserialize(L,r[D],i+'["'+D+'"]'))}else if(r)for(var O=0,_=Object.keys(r);O<_.length;O++){d=_[O];void 0!==a[d]||s.includes(d)||S(d)||(a[d]=r[d])}return a}(this,e,t,r):(this.isXML&&null!=t.$&&null!=t._&&(t=t._),null!==a.match(/^Number$/gi)?(i=parseFloat(t),isNaN(i)&&(i=t)):null!==a.match(/^Boolean$/gi)?i="true"===t||"false"!==t&&t:null!==a.match(/^(String|Enum|Object|Stream|Uuid|TimeSpan|any)$/gi)?i=t:null!==a.match(/^(Date|DateTime|DateTimeRfc1123)$/gi)?i=new Date(t):null!==a.match(/^UnixTime$/gi)?i=function(e){if(!e)return;return new Date(1e3*e)}(t):null!==a.match(/^ByteArray$/gi)?i=n(t):null!==a.match(/^Base64Url$/gi)?i=function(e){if(!e)return;if(e&&"string"!=typeof e.valueOf())throw new Error("Please provide an input of type string for converting to Uint8Array");return n(e=e.replace(/\-/g,"+").replace(/\_/g,"/"))}(t):null!==a.match(/^Sequence$/gi)?i=function(e,t,r,i){var n=t.type.element;if(!n||"object"!=typeof n)throw new Error('element" metadata for an Array must be defined in the mapper and it must of type "object" in '+i);if(r){Array.isArray(r)||(r=[r]);for(var a=[],s=0;s<r.length;s++)a[s]=e.deserialize(n,r[s],i+"["+s+"]");return a}return r}(this,e,t,r):null!==a.match(/^Dictionary$/gi)&&(i=function(e,t,r,i){var n=t.type.value;if(!n||"object"!=typeof n)throw new Error('"value" metadata for a Dictionary must be defined in the mapper and it must of type "object" in '+i);if(r){for(var a={},s=0,o=Object.keys(r);s<o.length;s++){var m=o[s];a[m]=e.deserialize(n,r[m],i)}return a}return r}(this,e,t,r))),e.isConstant&&(i=e.defaultValue),i},e}();function b(e){var t=[],r="";if(e)for(var i=0,n=e.split(".");i<n.length;i++){var a=n[i];"\\"===a.charAt(a.length-1)?r+=a.substr(0,a.length-1)+".":(r+=a,t.push(r),r="")}return t}function v(e,t,r){var i=t.type.modelProperties;if(!i){var n=t.type.className;if(!n)throw new Error('Class name for model "'+r+'" is not provided in the mapper "'+JSON.stringify(t,void 0,2)+'".');var a=e.modelMappers[n];if(!a)throw new Error('mapper() cannot be null or undefined for model "'+n+'".');if(!(i=a.type.modelProperties))throw new Error('modelProperties cannot be null or undefined in the mapper "'+JSON.stringify(a)+'" of type "'+n+'" for object "'+r+'".')}return i}function S(e){return["$","_"].includes(e)}function C(e,t,r,i){var n=z(e,t);if(n){var a=n[i];if(null!=a){var s=r[a];if(null!=s){var o=t.type.uberParent||t.type.className,m=s===o?s:o+"."+s,d=e.modelMappers.discriminators[m];d&&(t=d)}}}return t}function z(e,t){return t.type.polymorphicDiscriminator||P(e,t.type.uberParent)||P(e,t.type.className)}function P(e,t){return t&&e.modelMappers[t]&&e.modelMappers[t].type.polymorphicDiscriminator}var x=function(e){for(var t={},r=0,i=e;r<i.length;r++){var n=i[r];t[n]=n}return t}(["Base64Url","Boolean","ByteArray","Composite","Date","DateTime","DateTimeRfc1123","Dictionary","Enum","Number","Object","Sequence","String","Stream","TimeSpan","UnixTime"]),R=function(){function e(e,t,i,n,a,s,o,m,d,l,c,p,u){this.streamResponseBody=s,this.url=e||"",this.method=t||"GET",this.headers=a instanceof r?a:new r(a),this.body=i,this.query=n,this.formData=void 0,this.withCredentials=o||!1,this.abortSignal=m,this.timeout=d||0,this.onUploadProgress=l,this.onDownloadProgress=c,this.proxySettings=p,this.keepAlive=u}return e.prototype.validateRequestProperties=function(){if(!this.method)throw new Error("WebResource.method is required.");if(!this.url)throw new Error("WebResource.url is required.")},e.prototype.prepare=function(e){if(!e)throw new Error("options object is required");if(null==e.method||"string"!=typeof e.method.valueOf())throw new Error("options.method must be a string.");if(e.url&&e.pathTemplate)throw new Error("options.url and options.pathTemplate are mutually exclusive. Please provide exactly one of them.");if(!(null!=e.pathTemplate&&"string"==typeof e.pathTemplate.valueOf()||null!=e.url&&"string"==typeof e.url.valueOf()))throw new Error("Please provide exactly one of options.pathTemplate or options.url.");if(e.url){if("string"!=typeof e.url)throw new Error('options.url must be of type "string".');this.url=e.url}if(e.method){var t=["GET","PUT","HEAD","DELETE","OPTIONS","POST","PATCH","TRACE"];if(-1===t.indexOf(e.method.toUpperCase()))throw new Error('The provided method "'+e.method+'" is invalid. Supported HTTP methods are: '+JSON.stringify(t))}if(this.method=e.method.toUpperCase(),e.pathTemplate){var r=e.pathTemplate,i=e.pathParameters;if("string"!=typeof r)throw new Error('options.pathTemplate must be of type "string".');e.baseUrl||(e.baseUrl="https://management.azure.com");var n=e.baseUrl,a=n+(n.endsWith("/")?"":"/")+(r.startsWith("/")?r.slice(1):r),s=a.match(/({\w*\s*\w*})/gi);if(s&&s.length){if(!i)throw new Error("pathTemplate: "+r+" has been provided. Hence, options.pathParameters must also be provided.");s.forEach(function(e){var t=e.slice(1,-1),n=i[t];if(null==n||"string"!=typeof n&&"object"!=typeof n)throw new Error("pathTemplate: "+r+" contains the path parameter "+t+" however, it is not present in "+i+" - "+JSON.stringify(i,void 0,2)+'.The value of the path parameter can either be a "string" of the form { '+t+': "some sample value" } or it can be an "object" of the form { "'+t+'": { value: "some sample value", skipUrlEncoding: true } }.');if("string"==typeof n.valueOf()&&(a=a.replace(e,encodeURIComponent(n))),"object"==typeof n.valueOf()){if(!n.value)throw new Error("options.pathParameters["+t+'] is of type "object" but it does not contain a "value" property.');a=n.skipUrlEncoding?a.replace(e,n.value):a.replace(e,encodeURIComponent(n.value))}})}this.url=a}if(e.queryParameters){var o=e.queryParameters;if("object"!=typeof o)throw new Error('options.queryParameters must be of type object. It should be a JSON object of "query-parameter-name" as the key and the "query-parameter-value" as the value. The "query-parameter-value" may be fo type "string" or an "object" of the form { value: "query-parameter-value", skipUrlEncoding: true }.');this.url&&-1===this.url.indexOf("?")&&(this.url+="?");var m=[];for(var d in this.query={},o){var l=o[d];if(l)if("string"==typeof l)m.push(d+"="+encodeURIComponent(l)),this.query[d]=encodeURIComponent(l);else if("object"==typeof l){if(!l.value)throw new Error("options.queryParameters["+d+'] is of type "object" but it does not contain a "value" property.');l.skipUrlEncoding?(m.push(d+"="+l.value),this.query[d]=l.value):(m.push(d+"="+encodeURIComponent(l.value)),this.query[d]=encodeURIComponent(l.value))}}this.url+=m.join("&")}if(e.headers)for(var c=e.headers,p=0,u=Object.keys(e.headers);p<u.length;p++){var h=u[p];this.headers.set(h,c[h])}return this.headers.get("accept-language")||this.headers.set("accept-language","en-US"),this.headers.get("x-ms-client-request-id")||e.disableClientRequestId||this.headers.set("x-ms-client-request-id",y()),this.headers.get("Content-Type")||this.headers.set("Content-Type","application/json; charset=utf-8"),this.body=e.body,null!=e.body&&(e.bodyIsStream?(this.headers.get("Transfer-Encoding")||this.headers.set("Transfer-Encoding","chunked"),"application/octet-stream"!==this.headers.get("Content-Type")&&this.headers.set("Content-Type","application/octet-stream")):(e.serializationMapper&&(this.body=new N(e.mappers).serialize(e.serializationMapper,e.body,"requestBody")),e.disableJsonStringifyOnBody||(this.body=JSON.stringify(e.body)))),this.abortSignal=e.abortSignal,this.onDownloadProgress=e.onDownloadProgress,this.onUploadProgress=e.onUploadProgress,this},e.prototype.clone=function(){var t=new e(this.url,this.method,this.body,this.query,this.headers&&this.headers.clone(),this.streamResponseBody,this.withCredentials,this.abortSignal,this.timeout,this.onUploadProgress,this.onDownloadProgress);return this.formData&&(t.formData=this.formData),this.operationSpec&&(t.operationSpec=this.operationSpec),this.shouldDeserialize&&(t.shouldDeserialize=this.shouldDeserialize),this.operationResponseGetter&&(t.operationResponseGetter=this.operationResponseGetter),t},e}(),q=function(e,t){return(q=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)};function T(e,t){function r(){this.constructor=e}q(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var M=function(){return(M=Object.assign||function(e){for(var t,r=1,i=arguments.length;r<i;r++)for(var n in t=arguments[r])Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e}).apply(this,arguments)};function A(e,t,r,i){return new(r||(r=Promise))(function(n,a){function s(e){try{m(i.next(e))}catch(e){a(e)}}function o(e){try{m(i.throw(e))}catch(e){a(e)}}function m(e){e.done?n(e.value):new r(function(t){t(e.value)}).then(s,o)}m((i=i.apply(e,t||[])).next())})}function E(e,t){var r,i,n,a,s={label:0,sent:function(){if(1&n[0])throw n[1];return n[1]},trys:[],ops:[]};return a={next:o(0),throw:o(1),return:o(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function o(a){return function(o){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;s;)try{if(r=1,i&&(n=2&a[0]?i.return:a[0]?i.throw||((n=i.return)&&n.call(i),0):i.next)&&!(n=n.call(i,a[1])).done)return n;switch(i=0,n&&(a=[2&a[0],n.value]),a[0]){case 0:case 1:n=a;break;case 4:return s.label++,{value:a[1],done:!1};case 5:s.label++,i=a[1],a=[0];continue;case 7:a=s.ops.pop(),s.trys.pop();continue;default:if(!(n=(n=s.trys).length>0&&n[n.length-1])&&(6===a[0]||2===a[0])){s=0;continue}if(3===a[0]&&(!n||a[1]>n[0]&&a[1]<n[3])){s.label=a[1];break}if(6===a[0]&&s.label<n[1]){s.label=n[1],n=a;break}if(n&&s.label<n[2]){s.label=n[2],s.ops.push(a);break}n[2]&&s.ops.pop(),s.trys.pop();continue}a=t.call(e,s)}catch(e){a=[6,e],i=0}finally{r=n=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,o])}}}var w,I=function(e){function t(r,i,n,a,s,o){var m=e.call(this,r)||this;return m.code=i,m.statusCode=n,m.request=a,m.response=s,m.body=o,Object.setPrototypeOf(m,t.prototype),m}return T(t,e),t.REQUEST_SEND_ERROR="REQUEST_SEND_ERROR",t.REQUEST_ABORTED_ERROR="REQUEST_ABORTED_ERROR",t.PARSE_ERROR="PARSE_ERROR",t}(Error),L=function(){function e(){}return e.prototype.sendRequest=function(e){var t=new XMLHttpRequest;if(e.proxySettings)throw new Error("HTTP proxy is not supported in browser environment");var r=e.abortSignal;if(r){var i=function(){t.abort()};r.addEventListener("abort",i),t.addEventListener("readystatechange",function(){t.readyState===XMLHttpRequest.DONE&&r.removeEventListener("abort",i)})}if(B(t.upload,e.onUploadProgress),B(t,e.onDownloadProgress),e.formData){for(var n=e.formData,a=new FormData,s=function(e,t){t&&t.hasOwnProperty("value")&&t.hasOwnProperty("options")?a.append(e,t.value,t.options):a.append(e,t)},o=0,m=Object.keys(n);o<m.length;o++){var d=m[o],l=n[d];if(Array.isArray(l))for(var c=0;c<l.length;c++)s(d,l[c]);else s(d,l)}e.body=a,e.formData=void 0;var p=e.headers.get("Content-Type");p&&-1!==p.indexOf("multipart/form-data")&&e.headers.remove("Content-Type")}t.open(e.method,e.url),t.timeout=e.timeout,t.withCredentials=e.withCredentials;for(var u=0,y=e.headers.headersArray();u<y.length;u++){var h=y[u];t.setRequestHeader(h.name,h.value)}return t.responseType=e.streamResponseBody?"blob":"text",t.send(void 0===e.body?null:e.body),e.streamResponseBody?new Promise(function(r,i){t.addEventListener("readystatechange",function(){if(t.readyState===XMLHttpRequest.HEADERS_RECEIVED){var i=new Promise(function(r,i){t.addEventListener("load",function(){r(t.response)}),O(e,t,i)});r({request:e,status:t.status,headers:D(t),blobBody:i})}}),O(e,t,i)}):new Promise(function(r,i){t.addEventListener("load",function(){return r({request:e,status:t.status,headers:D(t),bodyAsText:t.responseText})}),O(e,t,i)})},e}();function B(e,t){t&&e.addEventListener("progress",function(e){return t({loadedBytes:e.loaded})})}function D(e){for(var t=new r,i=0,n=e.getAllResponseHeaders().trim().split(/[\r\n]+/);i<n.length;i++){var a=n[i],s=a.indexOf(":"),o=a.slice(0,s),m=a.slice(s+2);t.set(o,m)}return t}function O(e,t,r){t.addEventListener("error",function(){return r(new I("Failed to send request to "+e.url,I.REQUEST_SEND_ERROR,void 0,e))}),t.addEventListener("abort",function(){return r(new I("The request was aborted",I.REQUEST_ABORTED_ERROR,void 0,e))}),t.addEventListener("timeout",function(){return r(new I("timeout of "+t.timeout+"ms exceeded",I.REQUEST_SEND_ERROR,void 0,e))})}function _(e){return H(e.parameterPath,e.mapper)}function H(e,t){return"string"==typeof e?e:Array.isArray(e)?e.join("."):t.serializedName}function k(e){var t=!1;for(var r in e.responses){var i=e.responses[r];if(i.bodyMapper&&i.bodyMapper.type.name===x.Stream){t=!0;break}}return t}(w=e.HttpPipelineLogLevel||(e.HttpPipelineLogLevel={}))[w.OFF=0]="OFF",w[w.ERROR=1]="ERROR",w[w.WARNING=2]="WARNING",w[w.INFO=3]="INFO";var U=new DOMParser;function F(e){try{var t=U.parseFromString(e,"application/xml");!function(e){if(V){var t=e.getElementsByTagNameNS(V,"parsererror");if(t.length)throw new Error(t.item(0).innerHTML)}}(t);var r=function e(t){var r={};var i=t.childNodes.length;var n=t.childNodes[0];var a=n&&1===i&&n.nodeType===Node.TEXT_NODE&&n.nodeValue||void 0;var s=function(e){return function(e){return!!e.attributes}(e)&&e.hasAttributes()?e:void 0}(t);if(s){r.$={};for(var o=0;o<s.attributes.length;o++){var m=s.attributes[o];r.$[m.nodeName]=m.nodeValue}a&&(r._=a)}else 0===i?r="":a&&(r=a);if(!a)for(var o=0;o<i;o++){var d=t.childNodes[o];if(d.nodeType!==Node.TEXT_NODE){var l=e(d);r[d.nodeName]?Array.isArray(r[d.nodeName])?r[d.nodeName].push(l):r[d.nodeName]=[r[d.nodeName],l]:r[d.nodeName]=l}}return r}(t.childNodes[0]);return Promise.resolve(r)}catch(e){return Promise.reject(e)}}var V="";try{V=U.parseFromString("INVALID","text/xml").getElementsByTagName("parsererror")[0].namespaceURI}catch(e){}var j=document.implementation.createDocument(null,null,null),X=new XMLSerializer;function G(e,t){var r=function e(t,r){if("string"==typeof t||"number"==typeof t||"boolean"==typeof t){var i=j.createElement(r);return i.textContent=t.toString(),[i]}if(Array.isArray(t)){for(var n=[],a=0,s=t;a<s.length;a++)for(var o=s[a],m=0,d=e(o,r);m<d.length;m++){var l=d[m];n.push(l)}return n}if("object"==typeof t){for(var i=j.createElement(r),c=0,p=Object.keys(t);c<p.length;c++){var u=p[c];if("$"===u)for(var y=0,h=K(t[u]);y<h.length;y++){var f=h[y];i.attributes.setNamedItem(f)}else for(var g=0,N=e(t[u],u);g<N.length;g++){var l=N[g];i.appendChild(l)}}return[i]}throw new Error("Illegal value passed to buildObject: "+t)}(e,t&&t.rootName||"root")[0];return'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>'+X.serializeToString(r)}function K(e){for(var t=[],r=0,i=Object.keys(e);r<i.length;r++){var n=i[r],a=j.createAttribute(n);a.value=e[n].toString(),t.push(a)}return t}var W=function(){function e(e,t){this._nextPolicy=e,this._options=t}return e.prototype.shouldLog=function(e){return this._options.shouldLog(e)},e.prototype.log=function(e,t){this._options.log(e,t)},e}(),$=function(){function t(e){this._logger=e}return t.prototype.shouldLog=function(t){return!!this._logger&&t!==e.HttpPipelineLogLevel.OFF&&t<=this._logger.minimumLogLevel},t.prototype.log=function(e,t){this._logger&&this.shouldLog(e)&&this._logger.log(e,t)},t}();function Q(e){return{create:function(t,r){return new Z(t,e,r)}}}var Y=["application/json","text/json"],J=["application/xml","application/atom+xml"],Z=function(e){function t(t,r,i){var n=e.call(this,t,i)||this;return n.jsonContentTypes=r&&r.json||Y,n.xmlContentTypes=r&&r.xml||J,n}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){var t=this;return E(this,function(r){return[2,this._nextPolicy.sendRequest(e).then(function(e){return function(e,t,r){return function(e,t,r){var i=function(e){var t='Error "'+e+'" occurred while parsing the response body - '+r.bodyAsText+".",i=e.code||I.PARSE_ERROR,n=new I(t,i,r.status,r.request,r,r.bodyAsText);return Promise.reject(n)};if(!r.request.streamResponseBody&&r.bodyAsText){var n=r.bodyAsText,a=r.headers.get("Content-Type")||"",s=a?a.split(";").map(function(e){return e.toLowerCase()}):[];if(0===s.length||s.some(function(t){return-1!==e.indexOf(t)}))return new Promise(function(e){r.parsedBody=JSON.parse(n),e(r)}).catch(i);if(s.some(function(e){return-1!==t.indexOf(e)}))return F(n).then(function(e){return r.parsedBody=e,r}).catch(i)}return Promise.resolve(r)}(e,t,r).then(function(e){if(function(e){var t,r=e.request.shouldDeserialize;t=void 0===r||("boolean"==typeof r?r:r(e));return t}(e)){var t=e.request.operationSpec;if(t&&t.responses){var i=e.status,n=Object.keys(t.responses),a=0===n.length||1===n.length&&"default"===n[0],s=function(e){var t,r=e.request,i=r.operationSpec;if(i){var n=r.operationResponseGetter;t=n?n(i,e):i.responses[e.status]}return t}(e);if(a?200<=i&&i<300:!!s){if(s){if(s.bodyMapper){f=e.parsedBody;t.isXML&&s.bodyMapper.type.name===x.Sequence&&(f="object"==typeof f?f[s.bodyMapper.xmlElementName]:[]);try{e.parsedBody=t.serializer.deserialize(s.bodyMapper,f,"operationRes.parsedBody")}catch(l){var o=new I("Error "+l+" occurred in deserializing the responseBody - "+e.bodyAsText);return o.request=u(e.request),o.response=p(e),Promise.reject(o)}}else"HEAD"===t.httpMethod&&(e.parsedBody=r.status>=200&&r.status<300);s.headersMapper&&(e.parsedHeaders=t.serializer.deserialize(s.headersMapper,e.headers.rawHeaders(),"operationRes.parsedHeaders"))}}else{var m=t.responses.default;if(m){var d=k(t)?"Unexpected status code: "+i:e.bodyAsText,l=new I(d);l.statusCode=i,l.request=u(e.request),l.response=p(e);var c=e.parsedBody;try{if(c){var y=m.bodyMapper;if(y&&"CloudError"===y.serializedName)c.error&&(c=c.error),c.code&&(l.code=c.code),c.message&&(l.message=c.message);else{var h=c;c.error&&(h=c.error),l.code=h.code,h.message&&(l.message=h.message)}if(y){var f=c;t.isXML&&y.type.name===x.Sequence&&(f="object"==typeof c?c[y.xmlElementName]:[]),l.body=t.serializer.deserialize(y,f,"error.body")}}}catch(t){l.message='Error "'+t.message+'" occurred in deserializing the responseBody - "'+e.bodyAsText+'" for the default response.'}return Promise.reject(l)}}}}return Promise.resolve(e)})}(t.jsonContentTypes,t.xmlContentTypes,e)})]})})},t}(W);var ee=3e4,te=3,re=9e4,ie=3e3,ne=function(e){function t(t,r,i,n,a,s){var o=e.call(this,t,r)||this;function m(e){return"number"==typeof e}return o.retryCount=m(i)?i:te,o.retryInterval=m(n)?n:ee,o.minRetryInterval=m(a)?a:ie,o.maxRetryInterval=m(s)?s:re,o}return T(t,e),t.prototype.sendRequest=function(e){var t=this;return this._nextPolicy.sendRequest(e.clone()).then(function(r){return ae(t,e,r)}).catch(function(r){return ae(t,e,r.response,void 0,r)})},t}(W);function ae(e,t,r,i,n){i=function(e,t,r){t||(t={retryCount:0,retryInterval:0}),r&&(t.error&&(r.innerError=t.error),t.error=r),t.retryCount++;var i=Math.pow(2,t.retryCount)-1;return i*=.8*e.retryInterval+Math.floor(Math.random()*(1.2*e.retryInterval-.8*e.retryInterval)),t.retryInterval=Math.min(e.minRetryInterval+i,e.maxRetryInterval),t}(e,i,n);var a=t.abortSignal&&t.abortSignal.aborted;if(!a&&function(e,t,r){if(null==t||t<500&&408!==t||501===t||505===t)return!1;if(!r)throw new Error("retryData for the ExponentialRetryPolicyFilter cannot be null.");return(r&&r.retryCount)<e.retryCount}(e,r&&r.status,i))return h(i.retryInterval).then(function(){return e._nextPolicy.sendRequest(t.clone())}).then(function(r){return ae(e,t,r,i,void 0)}).catch(function(n){return ae(e,t,r,i,n)});if(a||n||!r){var s=i.error||new I("Failed to send the request.",I.REQUEST_SEND_ERROR,r&&r.status,r&&r.request,r);return Promise.reject(s)}return Promise.resolve(r)}var se=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n._requestIdHeaderName=i,n}return T(t,e),t.prototype.sendRequest=function(e){return e.headers.contains(this._requestIdHeaderName)||e.headers.set(this._requestIdHeaderName,y()),this._nextPolicy.sendRequest(e)},t}(W);function oe(){return"x-ms-command-name"}var me=oe;function de(){var e,t,r,i,n=[{key:"ms-rest-js",value:l.msRestVersion}],a=[{key:"OS",value:((e=window.navigator).oscpu||e.platform).replace(" ","")}];return t=n.concat(a),void 0===r&&(r=" "),void 0===i&&(i="/"),t.map(function(e){var t=e.value?""+i+e.value:"";return""+e.key+t}).join(r)}var le=function(e){function t(t,r,i,n){var a=e.call(this,t,r)||this;return a._nextPolicy=t,a._options=r,a.headerKey=i,a.headerValue=n,a}return T(t,e),t.prototype.sendRequest=function(e){return this.addUserAgentHeader(e),this._nextPolicy.sendRequest(e)},t.prototype.addUserAgentHeader=function(e){e.headers||(e.headers=new r),!e.headers.get(this.headerKey)&&this.headerValue&&e.headers.set(this.headerKey,this.headerValue)},t}(W),ce=function(){function e(){this._rawQuery={}}return e.prototype.any=function(){return Object.keys(this._rawQuery).length>0},e.prototype.set=function(e,t){if(e)if(null!=t){var r=Array.isArray(t)?t:t.toString();this._rawQuery[e]=r}else delete this._rawQuery[e]},e.prototype.get=function(e){return e?this._rawQuery[e]:void 0},e.prototype.toString=function(){var e="";for(var t in this._rawQuery){e&&(e+="&");var r=this._rawQuery[t];if(Array.isArray(r)){for(var i=[],n=0,a=r;n<a.length;n++){var s=a[n];i.push(t+"="+s)}e+=i.join("&")}else e+=t+"="+r}return e},e.parse=function(t){var r=new e;if(t){t.startsWith("?")&&(t=t.substring(1));for(var i="ParameterName",n="",a="",s=0;s<t.length;++s){var o=t[s];switch(i){case"ParameterName":switch(o){case"=":i="ParameterValue";break;case"&":n="",a="";break;default:n+=o}break;case"ParameterValue":switch(o){case"=":n="",a="",i="Invalid";break;case"&":r.set(n,a),n="",a="",i="ParameterName";break;default:a+=o}break;case"Invalid":"&"===o&&(i="ParameterName");break;default:throw new Error("Unrecognized URLQuery parse state: "+i)}}"ParameterValue"===i&&r.set(n,a)}return r},e}(),pe=function(){function e(){}return e.prototype.setScheme=function(e){e?this.set(e,"SCHEME"):this._scheme=void 0},e.prototype.getScheme=function(){return this._scheme},e.prototype.setHost=function(e){e?this.set(e,"SCHEME_OR_HOST"):this._host=void 0},e.prototype.getHost=function(){return this._host},e.prototype.setPort=function(e){null==e||""===e?this._port=void 0:this.set(e.toString(),"PORT")},e.prototype.getPort=function(){return this._port},e.prototype.setPath=function(e){e?-1!==e.indexOf("://")?this.set(e,"SCHEME"):this.set(e,"PATH"):this._path=void 0},e.prototype.appendPath=function(e){if(e){var t=this.getPath();t&&(t.endsWith("/")||(t+="/"),e.startsWith("/")&&(e=e.substring(1)),e=t+e),this.set(e,"PATH")}},e.prototype.getPath=function(){return this._path},e.prototype.setQuery=function(e){this._query=e?ce.parse(e):void 0},e.prototype.setQueryParameter=function(e,t){e&&(this._query||(this._query=new ce),this._query.set(e,t))},e.prototype.getQueryParameterValue=function(e){return this._query?this._query.get(e):void 0},e.prototype.getQuery=function(){return this._query?this._query.toString():void 0},e.prototype.set=function(e,t){for(var r=new ye(e,t);r.next();){var i=r.current();if(i)switch(i.type){case"SCHEME":this._scheme=i.text||void 0;break;case"HOST":this._host=i.text||void 0;break;case"PORT":this._port=i.text||void 0;break;case"PATH":var n=i.text||void 0;this._path&&"/"!==this._path&&"/"===n||(this._path=n);break;case"QUERY":this._query=ce.parse(i.text);break;default:throw new Error("Unrecognized URLTokenType: "+i.type)}}},e.prototype.toString=function(){var e="";return this._scheme&&(e+=this._scheme+"://"),this._host&&(e+=this._host),this._port&&(e+=":"+this._port),this._path&&(this._path.startsWith("/")||(e+="/"),e+=this._path),this._query&&this._query.any()&&(e+="?"+this._query.toString()),e},e.prototype.replaceAll=function(e,t){e&&(this.setScheme(g(this.getScheme(),e,t)),this.setHost(g(this.getHost(),e,t)),this.setPort(g(this.getPort(),e,t)),this.setPath(g(this.getPath(),e,t)),this.setQuery(g(this.getQuery(),e,t)))},e.parse=function(t){var r=new e;return r.set(t,"SCHEME_OR_HOST"),r},e}(),ue=function(){function e(e,t){this.text=e,this.type=t}return e.scheme=function(t){return new e(t,"SCHEME")},e.host=function(t){return new e(t,"HOST")},e.port=function(t){return new e(t,"PORT")},e.path=function(t){return new e(t,"PATH")},e.query=function(t){return new e(t,"QUERY")},e}();var ye=function(){function e(e,t){this._text=e,this._textLength=e?e.length:0,this._currentState=null!=t?t:"SCHEME_OR_HOST",this._currentIndex=0}return e.prototype.current=function(){return this._currentToken},e.prototype.next=function(){if(he(this))switch(this._currentState){case"SCHEME":t=function(e){return be(e,function(e){return function(e){var t=e.charCodeAt(0);return 48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122}(e)})}(e=this),e._currentToken=ue.scheme(t),he(e)?e._currentState="HOST":e._currentState="DONE";break;case"SCHEME_OR_HOST":!function(e){var t=ve(e,":","/","?");he(e)?":"===fe(e)?"://"===Ne(e,3)?(e._currentToken=ue.scheme(t),e._currentState="HOST"):(e._currentToken=ue.host(t),e._currentState="PORT"):(e._currentToken=ue.host(t),"/"===fe(e)?e._currentState="PATH":e._currentState="QUERY"):(e._currentToken=ue.host(t),e._currentState="DONE")}(this);break;case"HOST":!function(e){"://"===Ne(e,3)&&ge(e,3);var t=ve(e,":","/","?");e._currentToken=ue.host(t),he(e)?":"===fe(e)?e._currentState="PORT":"/"===fe(e)?e._currentState="PATH":e._currentState="QUERY":e._currentState="DONE"}(this);break;case"PORT":!function(e){":"===fe(e)&&ge(e);var t=ve(e,"/","?");e._currentToken=ue.port(t),he(e)?"/"===fe(e)?e._currentState="PATH":e._currentState="QUERY":e._currentState="DONE"}(this);break;case"PATH":!function(e){var t=ve(e,"?");e._currentToken=ue.path(t),he(e)?e._currentState="QUERY":e._currentState="DONE"}(this);break;case"QUERY":!function(e){"?"===fe(e)&&ge(e);var t=function(e){var t="";e._currentIndex<e._textLength&&(t=e._text.substring(e._currentIndex),e._currentIndex=e._textLength);return t}(e);e._currentToken=ue.query(t),e._currentState="DONE"}(this);break;default:throw new Error("Unrecognized URLTokenizerState: "+this._currentState)}else this._currentToken=void 0;var e,t;return!!this._currentToken},e}();function he(e){return e._currentIndex<e._textLength}function fe(e){return e._text[e._currentIndex]}function ge(e,t){he(e)&&(t||(t=1),e._currentIndex+=t)}function Ne(e,t){var r=e._currentIndex+t;return e._textLength<r&&(r=e._textLength),e._text.substring(e._currentIndex,r)}function be(e,t){for(var r="";he(e);){var i=fe(e);if(!t(i))break;r+=i,ge(e)}return r}function ve(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];return be(e,function(e){return-1===t.indexOf(e)})}var Se=function(e){function t(t,r,i){void 0===i&&(i=20);var n=e.call(this,t,r)||this;return n.maxRetries=i,n}return T(t,e),t.prototype.sendRequest=function(e){var t=this;return this._nextPolicy.sendRequest(e).then(function(e){return function e(t,r,i){var n=r.request,a=r.status;var s=r.headers.get("location");if(s&&(300===a||307===a||303===a&&"POST"===n.method)&&(!t.maxRetries||i<t.maxRetries)){var o=pe.parse(n.url);return o.setPath(s),n.url=o.toString(),303===a&&(n.method="GET"),t._nextPolicy.sendRequest(n).then(function(r){return e(t,r,i+1)})}return Promise.resolve(r)}(t,e,0)})},t}(W);var Ce=function(e){function t(t,r,i){void 0===i&&(i=30);var n=e.call(this,t,r)||this;return n._retryTimeout=i,n}return T(t,e),t.prototype.sendRequest=function(e){var t=this;return this._nextPolicy.sendRequest(e.clone()).then(function(r){return function(e,t,r){if(409===r.status){var i=function(e){var t,r;if(e){try{r=JSON.parse(e)}catch(e){}if(r&&r.error&&r.error.message&&r.error.code&&"MissingSubscriptionRegistration"===r.error.code){var i=r.error.message.match(/.*'(.*)'/i);i&&(t=i.pop())}}return t}(r.bodyAsText);if(i){var n=function(e){var t,r=e.match(/.*\/subscriptions\/[a-f0-9-]+\//gi);if(!r||!r[0])throw new Error("Unable to extract subscriptionId from the given url - "+e+".");t=r[0];return t}(t.url);return function(e,t,r,i){var n=t+"providers/"+r+"/register?api-version=2016-02-01",a=t+"providers/"+r+"?api-version=2016-02-01",s=ze(i);return s.method="POST",s.url=n,e._nextPolicy.sendRequest(s).then(function(t){if(200!==t.status)throw new Error("Autoregistration of "+r+" failed. Please try registering manually.");return function e(t,r,i){var n=ze(i);n.url=r;n.method="GET";return t._nextPolicy.sendRequest(n).then(function(n){var a=n.parsedBody;return!(!n.parsedBody||!a.registrationState||"Registered"!==a.registrationState)||h(1e3*t._retryTimeout).then(function(){return e(t,r,i)})})}(e,a,i)})}(e,n,i,t).catch(function(){return!1}).then(function(i){return i?(t.headers.set("x-ms-client-request-id",y()),e._nextPolicy.sendRequest(t.clone())):r})}}return Promise.resolve(r)}(t,e,r)})},t}(W);function ze(e,t){void 0===t&&(t=!1);var r=e.clone();return t&&(r.url=e.url),r.headers.set("x-ms-client-request-id",y()),r.headers.set("Content-Type","application/json; charset=utf-8"),r}var Pe=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n.authenticationProvider=i,n}return T(t,e),t.prototype.signRequest=function(e){return this.authenticationProvider.signRequest(e)},t.prototype.sendRequest=function(e){var t=this;return this.signRequest(e).then(function(e){return t._nextPolicy.sendRequest(e)})},t}(W);var xe,Re=function(e){function t(t,r,i,n,a,s){var o=e.call(this,t,r)||this;return o.DEFAULT_CLIENT_RETRY_INTERVAL=3e4,o.DEFAULT_CLIENT_RETRY_COUNT=3,o.DEFAULT_CLIENT_MAX_RETRY_INTERVAL=9e4,o.DEFAULT_CLIENT_MIN_RETRY_INTERVAL=3e3,o.retryCount="number"==typeof i?i:o.DEFAULT_CLIENT_RETRY_COUNT,o.retryInterval="number"==typeof n?n:o.DEFAULT_CLIENT_RETRY_INTERVAL,o.minRetryInterval="number"==typeof a?a:o.DEFAULT_CLIENT_MIN_RETRY_INTERVAL,o.maxRetryInterval="number"==typeof s?s:o.DEFAULT_CLIENT_MAX_RETRY_INTERVAL,o}return T(t,e),t.prototype.sendRequest=function(e){var t=this;return this._nextPolicy.sendRequest(e.clone()).then(function(r){return function e(t,r,i,n,a){n=function(e,t,r){t||(t={retryCount:0,retryInterval:0});r&&(t.error&&(r.innerError=t.error),t.error=r);t.retryCount++;var i=Math.pow(2,t.retryCount)-1,n=.8*e.retryInterval+Math.floor(Math.random()*(1.2*e.retryInterval-.8*e.retryInterval));return i*=n,t.retryInterval=Math.min(e.minRetryInterval+i,e.maxRetryInterval),t}(t,n,a);return a&&a.code&&function(e,t){var r;if(!t)throw new Error("retryData for the SystemErrorRetryPolicyFilter cannot be null.");r=t&&t.retryCount;return r<e.retryCount}(t,n)&&("ETIMEDOUT"===a.code||"ESOCKETTIMEDOUT"===a.code||"ECONNREFUSED"===a.code||"ECONNRESET"===a.code||"ENOENT"===a.code)?h(n.retryInterval).then(function(){return t._nextPolicy.sendRequest(r.clone())}).then(function(i){return e(t,r,i,n,a)}).catch(function(a){return e(t,r,i,n,a)}):null!=a?(a=n.error,Promise.reject(a)):Promise.resolve(i)}(t,e,r)})},t}(W);function qe(e){if(e||(e=function(){if(process)return process.env[l.HTTPS_PROXY]?process.env[l.HTTPS_PROXY]:process.env[l.HTTPS_PROXY.toLowerCase()]?process.env[l.HTTPS_PROXY.toLowerCase()]:process.env[l.HTTP_PROXY]?process.env[l.HTTP_PROXY]:process.env[l.HTTP_PROXY.toLowerCase()]?process.env[l.HTTP_PROXY.toLowerCase()]:void 0}())){var t=pe.parse(e);return{host:t.getScheme()+"://"+t.getHost(),port:Number.parseInt(t.getPort()||"80")}}}!function(e){e.Csv=",",e.Ssv=" ",e.Tsv="\t",e.Pipes="|",e.Multi="Multi"}(xe||(xe={}));var Te=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n.proxySettings=i,n}return T(t,e),t.prototype.sendRequest=function(e){return e.proxySettings||(e.proxySettings=this.proxySettings),this._nextPolicy.sendRequest(e)},t}(W),Me=l.HttpConstants.StatusCodes;var Ae=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n._handleResponse=i||n._defaultResponseHandler,n}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){var t=this;return E(this,function(r){return[2,this._nextPolicy.sendRequest(e.clone()).then(function(r){return r.status!==Me.TooManyRequests?r:t._handleResponse(e,r)})]})})},t.prototype._defaultResponseHandler=function(e,r){return A(this,void 0,void 0,function(){var i,n,a=this;return E(this,function(s){return(i=r.headers.get(l.HeaderConstants.RETRY_AFTER))&&(n=t.parseRetryAfterHeader(i))?[2,h(n).then(function(t){return a._nextPolicy.sendRequest(e)})]:[2,r]})})},t.parseRetryAfterHeader=function(e){var r=Number(e);return Number.isNaN(r)?t.parseDateRetryAfterHeader(e):1e3*r},t.parseDateRetryAfterHeader=function(e){try{var t=Date.now(),r=Date.parse(e)-t;return Number.isNaN(r)?void 0:r}catch(e){return}},t}(W),Ee=function(){function e(e,t){if(t||(t={}),e&&!e.signRequest)throw new Error("credentials argument needs to implement signRequest method");var r;if(this._withCredentials=t.withCredentials||!1,this._httpClient=t.httpClient||new L,this._requestPolicyOptions=new $(t.httpPipelineLogger),Array.isArray(t.requestPolicyFactories))r=t.requestPolicyFactories;else if(r=function(e,t){var r=[];t.generateClientRequestIdHeader&&r.push((void 0===(i=t.clientRequestIdHeaderName)&&(i="x-ms-client-request-id"),{create:function(e,t){return new se(e,t,i)}}));var i;e&&("function"==typeof e.create?r.push(e):r.push((n=e,{create:function(e,t){return new Pe(e,t,n)}})));var n;var a=we(t.userAgentHeaderName,me),s=we(t.userAgent,de);a&&s&&r.push((m=(o={key:a,value:s})&&null!=o.key?o.key:"x-ms-command-name",d=o&&null!=o.value?o.value:de(),{create:function(e,t){return new le(e,t,m,d)}}));var o,m,d;r.push(function(e){return void 0===e&&(e=20),{create:function(t,r){return new Se(t,r,e)}}}()),r.push(function(e){return void 0===e&&(e=30),{create:function(t,r){return new Ce(t,r,e)}}}(t.rpRegistrationRetryTimeout)),t.noRetryPolicy||(r.push({create:function(e,t){return new ne(e,t,l,c,p,u)}}),r.push(function(e,t,r,i){return{create:function(n,a){return new Re(n,a,e,t,r,i)}}}()),r.push({create:function(e,t){return new Ae(e,t)}}));var l,c,p,u;r.push(Q(t.deserializationContentTypes));var y=t.proxySettings||qe();y&&r.push(function(e){return{create:function(t,r){return new Te(t,r,e)}}}(y));return r}(e,t),t.requestPolicyFactories){var i=t.requestPolicyFactories(r);i&&(r=i)}this._requestPolicyFactories=r}return e.prototype.sendRequest=function(e){if(null==e||"object"!=typeof e)throw new Error("options cannot be null or undefined and it must be of type object.");var t;try{e instanceof R?(e.validateRequestProperties(),t=e):t=(t=new R).prepare(e)}catch(e){return Promise.reject(e)}var r=this._httpClient;if(this._requestPolicyFactories&&this._requestPolicyFactories.length>0)for(var i=this._requestPolicyFactories.length-1;i>=0;--i)r=this._requestPolicyFactories[i].create(r,this._requestPolicyOptions);return r.sendRequest(t)},e.prototype.sendOperationRequest=function(e,t,r){"function"==typeof e.options&&(r=e.options,e.options=void 0);var i,n=new R;try{var a=t.baseUrl||this.baseUri;if(!a)throw new Error("If operationSpec.baseUrl is not specified, then the ServiceClient must have a baseUri string property that contains the base URL to use.");n.method=t.httpMethod,n.operationSpec=t;var s=pe.parse(a);if(t.path&&s.appendPath(t.path),t.urlParameters&&t.urlParameters.length>0)for(var o=0,m=t.urlParameters;o<m.length;o++){var d=m[o],l=Ie(this,e,d,t.serializer);l=t.serializer.serialize(d.mapper,l,_(d)),d.skipEncoding||(l=encodeURIComponent(l)),s.replaceAll("{"+(d.mapper.serializedName||_(d))+"}",l)}if(t.queryParameters&&t.queryParameters.length>0)for(var c=0,p=t.queryParameters;c<p.length;c++){var u=p[c],y=Ie(this,e,u,t.serializer);if(null!=y){if(y=t.serializer.serialize(u.mapper,y,_(u)),null!=u.collectionFormat)if(u.collectionFormat===xe.Multi)if(0===y.length)y="";else for(var h in y){var f=y[h];y[h]=null==f?"":f.toString()}else y=y.join(u.collectionFormat);if(!u.skipEncoding)if(Array.isArray(y))for(var h in y)y[h]=encodeURIComponent(y[h]);else y=encodeURIComponent(y);s.setQueryParameter(u.mapper.serializedName||_(u),y)}}n.url=s.toString();var g=t.contentType||this.requestContentType;if(g&&n.headers.set("Content-Type",g),t.headerParameters)for(var N=0,b=t.headerParameters;N<b.length;N++){var v=b[N],S=Ie(this,e,v,t.serializer);if(null!=S){S=t.serializer.serialize(v.mapper,S,_(v));var C=v.mapper.headerCollectionPrefix;if(C)for(var z=0,P=Object.keys(S);z<P.length;z++){var q=P[z];n.headers.set(C+q,S[q])}else n.headers.set(v.mapper.serializedName||_(v),S)}}var T=e.options;if(T){if(T.customHeaders)for(var A in T.customHeaders)n.headers.set(A,T.customHeaders[A]);T.abortSignal&&(n.abortSignal=T.abortSignal),T.timeout&&(n.timeout=T.timeout),T.onUploadProgress&&(n.onUploadProgress=T.onUploadProgress),T.onDownloadProgress&&(n.onDownloadProgress=T.onDownloadProgress)}n.withCredentials=this._withCredentials,function(e,t,r,i){if(i.requestBody&&i.requestBody.mapper){t.body=Ie(e,r,i.requestBody,i.serializer);var n=i.requestBody.mapper,a=n.required,s=n.xmlName,o=n.xmlElementName,m=n.serializedName,d=n.type.name;try{if(null!=t.body||a){var l=_(i.requestBody);t.body=i.serializer.serialize(n,t.body,l);var c=d===x.Stream;i.isXML?d===x.Sequence?t.body=G(function(e,t){var r;return Array.isArray(e)||(e=[e]),(r={})[t]=e,r}(t.body,o||s||m),{rootName:s||m}):c||(t.body=G(t.body,{rootName:s||m})):c||(t.body=JSON.stringify(t.body))}}catch(e){throw new Error('Error "'+e.message+'" occurred in serializing the payload - '+JSON.stringify(m,void 0,"  ")+".")}}else if(i.formDataParameters&&i.formDataParameters.length>0){t.formData={};for(var p=0,u=i.formDataParameters;p<u.length;p++){var y=u[p],h=Ie(e,r,y,i.serializer);if(null!=h){var f=y.mapper.serializedName||_(y);t.formData[f]=i.serializer.serialize(y.mapper,h,_(y))}}}}(this,n,e,t),null==n.streamResponseBody&&(n.streamResponseBody=k(t)),i=this.sendRequest(n).then(function(e){return function(e,t){var r=e.parsedHeaders,i=t&&t.bodyMapper,n=function(t){return Object.defineProperty(t,"_response",{value:e})};if(i){var a=i.type.name;if("Stream"===a)return n(M({},r,{blobBody:e.blobBody,readableStreamBody:e.readableStreamBody}));var s="Composite"===a&&i.type.modelProperties||{},o=Object.keys(s).some(function(e){return""===s[e].serializedName});if("Sequence"===a||o){for(var m=(e.parsedBody||[]).slice(),d=0,l=Object.keys(s);d<l.length;d++){var c=l[d];s[c].serializedName&&(m[c]=e.parsedBody[c])}if(r)for(var p=0,u=Object.keys(r);p<u.length;p++){c=u[p];m[c]=r[c]}return n(m),m}if("Composite"===a||"Dictionary"===a)return n(M({},r,e.parsedBody))}if(i||"HEAD"===e.request.method||(y=e.parsedBody,"object"!=typeof y&&"function"!=typeof y||null===y))return n(M({},r,{body:e.parsedBody}));var y;return n(M({},r,e.parsedBody))}(e,t.responses[e.status])})}catch(e){i=Promise.reject(e)}var E=r;return E&&i.then(function(e){return E(null,e._response.parsedBody,e._response.request,e._response)}).catch(function(e){return E(e)}),i},e}();function we(e,t){var r;return"string"==typeof e?r=e:(r=t(),"function"==typeof e&&(r=e(r))),r}function Ie(e,t,r,i){return function e(t,r,i,n,a){var s;"string"==typeof i&&(i=[i]);if(Array.isArray(i)){if(i.length>0){if(n.isConstant)s=n.defaultValue;else{var o=Le(r,i);o.propertyFound||(o=Le(t,i));var m=!1;o.propertyFound||(m=n.required||"options"===i[0]&&2===i.length),s=m?n.defaultValue:o.propertyValue}var d=H(i,n);a.serialize(n,s,d)}}else for(var l in n.required&&(s={}),i){var c=n.type.modelProperties[l],p=i[l],u=e(t,r,p,c,a),y=H(p,c);a.serialize(c,u,y),void 0!==u&&(s||(s={}),s[l]=u)}return s}(e,t,r.parameterPath,r.mapper,i)}function Le(e,t){for(var r={propertyFound:!1},i=0;i<t.length;++i){var n=t[i];if(!(null!=e&&n in e))break;e=e[n]}return i===t.length&&(r.propertyValue=e,r.propertyFound=!0),r}var Be=Object.freeze({}),De=function(){function e(e,t,r,i){var n=this;void 0===t&&(t=0),this.onabort=null,this._aborted=!1,this.children=[],this.abortEventListeners=[],this.parent=e,this.key=r,this.value=i,t>0&&(this.timer=setTimeout(function(){n.abort.call(n)},t),this.timer&&c&&this.timer.unref())}return Object.defineProperty(e.prototype,"aborted",{get:function(){return this._aborted},enumerable:!0,configurable:!0}),Object.defineProperty(e,"none",{get:function(){return new e(void 0,0)},enumerable:!0,configurable:!0}),e.timeout=function(t){return new e(void 0,t)},e.prototype.withTimeout=function(t){var r=new e(this,t);return this.children.push(r),r},e.prototype.withValue=function(t,r){var i=new e(this,0,t,r);return this.children.push(i),i},e.prototype.getValue=function(e){for(var t=this;t;t=t.parent)if(t.key===e)return t.value},e.prototype.abort=function(){var e=this;this.aborted||(this.cancelTimer(),this.onabort&&this.onabort.call(this,{type:"abort"}),this.abortEventListeners.forEach(function(t){t.call(e,{type:"abort"})}),this.children.forEach(function(e){return e.cancelByParent()}),this._aborted=!0)},e.prototype.addEventListener=function(e,t){this.abortEventListeners.push(t)},e.prototype.removeEventListener=function(e,t){var r=this.abortEventListeners.indexOf(t);r>-1&&this.abortEventListeners.splice(r,1)},e.prototype.dispatchEvent=function(){throw new Error("Method not implemented.")},e.prototype.cancelByParent=function(){this.abort()},e.prototype.cancelTimer=function(){this.timer&&clearTimeout(this.timer)},e}(),Oe={serializedName:"KeyInfo",type:{name:"Composite",className:"KeyInfo",modelProperties:{start:{xmlName:"Start",required:!0,serializedName:"Start",type:{name:"String"}},expiry:{xmlName:"Expiry",required:!0,serializedName:"Expiry",type:{name:"String"}}}}},_e={serializedName:"UserDelegationKey",type:{name:"Composite",className:"UserDelegationKey",modelProperties:{signedOid:{xmlName:"SignedOid",required:!0,serializedName:"SignedOid",type:{name:"String"}},signedTid:{xmlName:"SignedTid",required:!0,serializedName:"SignedTid",type:{name:"String"}},signedStart:{xmlName:"SignedStart",required:!0,serializedName:"SignedStart",type:{name:"String"}},signedExpiry:{xmlName:"SignedExpiry",required:!0,serializedName:"SignedExpiry",type:{name:"String"}},signedService:{xmlName:"SignedService",required:!0,serializedName:"SignedService",type:{name:"String"}},signedVersion:{xmlName:"SignedVersion",required:!0,serializedName:"SignedVersion",type:{name:"String"}},value:{xmlName:"Value",required:!0,serializedName:"Value",type:{name:"String"}}}}},He={serializedName:"StorageError",type:{name:"Composite",className:"StorageError",modelProperties:{message:{xmlName:"Message",serializedName:"Message",type:{name:"String"}}}}},ke={serializedName:"DataLakeStorageError",type:{name:"Composite",className:"DataLakeStorageError",modelProperties:{error:{xmlName:"error",serializedName:"error",type:{name:"Composite",className:"DataLakeStorageErrorError"}}}}},Ue={xmlName:"EnumerationResults",serializedName:"ListBlobsFlatSegmentResponse",type:{name:"Composite",className:"ListBlobsFlatSegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:!0,xmlName:"ServiceEndpoint",required:!0,serializedName:"ServiceEndpoint",type:{name:"String"}},containerName:{xmlIsAttribute:!0,xmlName:"ContainerName",required:!0,serializedName:"ContainerName",type:{name:"String"}},prefix:{xmlName:"Prefix",serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",serializedName:"MaxResults",type:{name:"Number"}},delimiter:{xmlName:"Delimiter",serializedName:"Delimiter",type:{name:"String"}},segment:{xmlName:"Blobs",required:!0,serializedName:"Segment",type:{name:"Composite",className:"BlobFlatListSegment"}},nextMarker:{xmlName:"NextMarker",serializedName:"NextMarker",type:{name:"String"}}}}},Fe={xmlName:"EnumerationResults",serializedName:"ListBlobsHierarchySegmentResponse",type:{name:"Composite",className:"ListBlobsHierarchySegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:!0,xmlName:"ServiceEndpoint",required:!0,serializedName:"ServiceEndpoint",type:{name:"String"}},containerName:{xmlIsAttribute:!0,xmlName:"ContainerName",required:!0,serializedName:"ContainerName",type:{name:"String"}},prefix:{xmlName:"Prefix",serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",serializedName:"MaxResults",type:{name:"Number"}},delimiter:{xmlName:"Delimiter",serializedName:"Delimiter",type:{name:"String"}},segment:{xmlName:"Blobs",required:!0,serializedName:"Segment",type:{name:"Composite",className:"BlobHierarchyListSegment"}},nextMarker:{xmlName:"NextMarker",serializedName:"NextMarker",type:{name:"String"}}}}},Ve={serializedName:"BlockList",type:{name:"Composite",className:"BlockList",modelProperties:{committedBlocks:{xmlIsWrapped:!0,xmlName:"CommittedBlocks",xmlElementName:"Block",serializedName:"CommittedBlocks",type:{name:"Sequence",element:{type:{name:"Composite",className:"Block"}}}},uncommittedBlocks:{xmlIsWrapped:!0,xmlName:"UncommittedBlocks",xmlElementName:"Block",serializedName:"UncommittedBlocks",type:{name:"Sequence",element:{type:{name:"Composite",className:"Block"}}}}}}},je={xmlName:"BlockList",serializedName:"BlockLookupList",type:{name:"Composite",className:"BlockLookupList",modelProperties:{committed:{xmlName:"Committed",xmlElementName:"Committed",serializedName:"Committed",type:{name:"Sequence",element:{type:{name:"String"}}}},uncommitted:{xmlName:"Uncommitted",xmlElementName:"Uncommitted",serializedName:"Uncommitted",type:{name:"Sequence",element:{type:{name:"String"}}}},latest:{xmlName:"Latest",xmlElementName:"Latest",serializedName:"Latest",type:{name:"Sequence",element:{type:{name:"String"}}}}}}},Xe={xmlName:"EnumerationResults",serializedName:"ListContainersSegmentResponse",type:{name:"Composite",className:"ListContainersSegmentResponse",modelProperties:{serviceEndpoint:{xmlIsAttribute:!0,xmlName:"ServiceEndpoint",required:!0,serializedName:"ServiceEndpoint",type:{name:"String"}},prefix:{xmlName:"Prefix",serializedName:"Prefix",type:{name:"String"}},marker:{xmlName:"Marker",serializedName:"Marker",type:{name:"String"}},maxResults:{xmlName:"MaxResults",serializedName:"MaxResults",type:{name:"Number"}},containerItems:{xmlIsWrapped:!0,xmlName:"Containers",xmlElementName:"Container",required:!0,serializedName:"ContainerItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"ContainerItem"}}}},nextMarker:{xmlName:"NextMarker",serializedName:"NextMarker",type:{name:"String"}}}}},Ge={serializedName:"PageList",type:{name:"Composite",className:"PageList",modelProperties:{pageRange:{xmlName:"PageRange",xmlElementName:"PageRange",serializedName:"PageRange",type:{name:"Sequence",element:{type:{name:"Composite",className:"PageRange"}}}},clearRange:{xmlName:"ClearRange",xmlElementName:"ClearRange",serializedName:"ClearRange",type:{name:"Sequence",element:{type:{name:"Composite",className:"ClearRange"}}}}}}},Ke={serializedName:"StorageServiceProperties",type:{name:"Composite",className:"StorageServiceProperties",modelProperties:{logging:{xmlName:"Logging",serializedName:"Logging",type:{name:"Composite",className:"Logging"}},hourMetrics:{xmlName:"HourMetrics",serializedName:"HourMetrics",type:{name:"Composite",className:"Metrics"}},minuteMetrics:{xmlName:"MinuteMetrics",serializedName:"MinuteMetrics",type:{name:"Composite",className:"Metrics"}},cors:{xmlIsWrapped:!0,xmlName:"Cors",xmlElementName:"CorsRule",serializedName:"Cors",type:{name:"Sequence",element:{type:{name:"Composite",className:"CorsRule"}}}},defaultServiceVersion:{xmlName:"DefaultServiceVersion",serializedName:"DefaultServiceVersion",type:{name:"String"}},deleteRetentionPolicy:{xmlName:"DeleteRetentionPolicy",serializedName:"DeleteRetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}},staticWebsite:{xmlName:"StaticWebsite",serializedName:"StaticWebsite",type:{name:"Composite",className:"StaticWebsite"}}}}},We={serializedName:"StorageServiceStats",type:{name:"Composite",className:"StorageServiceStats",modelProperties:{geoReplication:{xmlName:"GeoReplication",serializedName:"GeoReplication",type:{name:"Composite",className:"GeoReplication"}}}}},$e={serializedName:"service-setproperties-headers",type:{name:"Composite",className:"ServiceSetPropertiesHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Qe={serializedName:"service-getproperties-headers",type:{name:"Composite",className:"ServiceGetPropertiesHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ye={serializedName:"service-getstatistics-headers",type:{name:"Composite",className:"ServiceGetStatisticsHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Je={serializedName:"service-listcontainerssegment-headers",type:{name:"Composite",className:"ServiceListContainersSegmentHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ze={serializedName:"service-getuserdelegationkey-headers",type:{name:"Composite",className:"ServiceGetUserDelegationKeyHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},et={serializedName:"service-getaccountinfo-headers",type:{name:"Composite",className:"ServiceGetAccountInfoHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},tt={serializedName:"service-submitbatch-headers",type:{name:"Composite",className:"ServiceSubmitBatchHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},contentType:{serializedName:"content-type",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},rt={serializedName:"container-create-headers",type:{name:"Composite",className:"ContainerCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},it={serializedName:"container-getproperties-headers",type:{name:"Composite",className:"ContainerGetPropertiesHeaders",modelProperties:{metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobPublicAccess:{serializedName:"x-ms-blob-public-access",type:{name:"String"}},hasImmutabilityPolicy:{serializedName:"x-ms-has-immutability-policy",type:{name:"Boolean"}},hasLegalHold:{serializedName:"x-ms-has-legal-hold",type:{name:"Boolean"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},nt={serializedName:"container-delete-headers",type:{name:"Composite",className:"ContainerDeleteHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},at={serializedName:"container-setmetadata-headers",type:{name:"Composite",className:"ContainerSetMetadataHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},st={serializedName:"container-getaccesspolicy-headers",type:{name:"Composite",className:"ContainerGetAccessPolicyHeaders",modelProperties:{blobPublicAccess:{serializedName:"x-ms-blob-public-access",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},ot={serializedName:"container-setaccesspolicy-headers",type:{name:"Composite",className:"ContainerSetAccessPolicyHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},mt={serializedName:"container-acquirelease-headers",type:{name:"Composite",className:"ContainerAcquireLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},dt={serializedName:"container-releaselease-headers",type:{name:"Composite",className:"ContainerReleaseLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},lt={serializedName:"container-renewlease-headers",type:{name:"Composite",className:"ContainerRenewLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},ct={serializedName:"container-breaklease-headers",type:{name:"Composite",className:"ContainerBreakLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseTime:{serializedName:"x-ms-lease-time",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},pt={serializedName:"container-changelease-headers",type:{name:"Composite",className:"ContainerChangeLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},ut={serializedName:"container-listblobflatsegment-headers",type:{name:"Composite",className:"ContainerListBlobFlatSegmentHeaders",modelProperties:{contentType:{serializedName:"content-type",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},yt={serializedName:"container-listblobhierarchysegment-headers",type:{name:"Composite",className:"ContainerListBlobHierarchySegmentHeaders",modelProperties:{contentType:{serializedName:"content-type",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},ht={serializedName:"container-getaccountinfo-headers",type:{name:"Composite",className:"ContainerGetAccountInfoHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},ft={serializedName:"blob-download-headers",type:{name:"Composite",className:"BlobDownloadHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},contentLength:{serializedName:"content-length",type:{name:"Number"}},contentType:{serializedName:"content-type",type:{name:"String"}},contentRange:{serializedName:"content-range",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},contentEncoding:{serializedName:"content-encoding",type:{name:"String"}},cacheControl:{serializedName:"cache-control",type:{name:"String"}},contentDisposition:{serializedName:"content-disposition",type:{name:"String"}},contentLanguage:{serializedName:"content-language",type:{name:"String"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},blobType:{serializedName:"x-ms-blob-type",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},copyCompletionTime:{serializedName:"x-ms-copy-completion-time",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{serializedName:"x-ms-copy-status-description",type:{name:"String"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyProgress:{serializedName:"x-ms-copy-progress",type:{name:"String"}},copySource:{serializedName:"x-ms-copy-source",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},acceptRanges:{serializedName:"accept-ranges",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},isServerEncrypted:{serializedName:"x-ms-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},blobContentMD5:{serializedName:"x-ms-blob-content-md5",type:{name:"ByteArray"}},contentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},gt={serializedName:"blob-getproperties-headers",type:{name:"Composite",className:"BlobGetPropertiesHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},creationTime:{serializedName:"x-ms-creation-time",type:{name:"DateTimeRfc1123"}},metadata:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"},blobType:{serializedName:"x-ms-blob-type",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},copyCompletionTime:{serializedName:"x-ms-copy-completion-time",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{serializedName:"x-ms-copy-status-description",type:{name:"String"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyProgress:{serializedName:"x-ms-copy-progress",type:{name:"String"}},copySource:{serializedName:"x-ms-copy-source",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},isIncrementalCopy:{serializedName:"x-ms-incremental-copy",type:{name:"Boolean"}},destinationSnapshot:{serializedName:"x-ms-copy-destination-snapshot",type:{name:"String"}},leaseDuration:{serializedName:"x-ms-lease-duration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},leaseState:{serializedName:"x-ms-lease-state",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseStatus:{serializedName:"x-ms-lease-status",type:{name:"Enum",allowedValues:["locked","unlocked"]}},contentLength:{serializedName:"content-length",type:{name:"Number"}},contentType:{serializedName:"content-type",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},contentEncoding:{serializedName:"content-encoding",type:{name:"String"}},contentDisposition:{serializedName:"content-disposition",type:{name:"String"}},contentLanguage:{serializedName:"content-language",type:{name:"String"}},cacheControl:{serializedName:"cache-control",type:{name:"String"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},acceptRanges:{serializedName:"accept-ranges",type:{name:"String"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},isServerEncrypted:{serializedName:"x-ms-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},accessTier:{serializedName:"x-ms-access-tier",type:{name:"String"}},accessTierInferred:{serializedName:"x-ms-access-tier-inferred",type:{name:"Boolean"}},archiveStatus:{serializedName:"x-ms-archive-status",type:{name:"String"}},accessTierChangeTime:{serializedName:"x-ms-access-tier-change-time",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Nt={serializedName:"blob-delete-headers",type:{name:"Composite",className:"BlobDeleteHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},bt={serializedName:"blob-setaccesscontrol-headers",type:{name:"Composite",className:"BlobSetAccessControlHeaders",modelProperties:{date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}}}}},vt={serializedName:"blob-getaccesscontrol-headers",type:{name:"Composite",className:"BlobGetAccessControlHeaders",modelProperties:{date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},xMsOwner:{serializedName:"x-ms-owner",type:{name:"String"}},xMsGroup:{serializedName:"x-ms-group",type:{name:"String"}},xMsPermissions:{serializedName:"x-ms-permissions",type:{name:"String"}},xMsAcl:{serializedName:"x-ms-acl",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}}}}},St={serializedName:"blob-rename-headers",type:{name:"Composite",className:"BlobRenameHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},contentLength:{serializedName:"content-length",type:{name:"Number"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}}}}},Ct={serializedName:"pageblob-create-headers",type:{name:"Composite",className:"PageBlobCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},zt={serializedName:"appendblob-create-headers",type:{name:"Composite",className:"AppendBlobCreateHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Pt={serializedName:"blockblob-upload-headers",type:{name:"Composite",className:"BlockBlobUploadHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},xt={serializedName:"blob-undelete-headers",type:{name:"Composite",className:"BlobUndeleteHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Rt={serializedName:"blob-sethttpheaders-headers",type:{name:"Composite",className:"BlobSetHTTPHeadersHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},qt={serializedName:"blob-setmetadata-headers",type:{name:"Composite",className:"BlobSetMetadataHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Tt={serializedName:"blob-acquirelease-headers",type:{name:"Composite",className:"BlobAcquireLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Mt={serializedName:"blob-releaselease-headers",type:{name:"Composite",className:"BlobReleaseLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},At={serializedName:"blob-renewlease-headers",type:{name:"Composite",className:"BlobRenewLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Et={serializedName:"blob-changelease-headers",type:{name:"Composite",className:"BlobChangeLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},leaseId:{serializedName:"x-ms-lease-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},wt={serializedName:"blob-breaklease-headers",type:{name:"Composite",className:"BlobBreakLeaseHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},leaseTime:{serializedName:"x-ms-lease-time",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},It={serializedName:"blob-createsnapshot-headers",type:{name:"Composite",className:"BlobCreateSnapshotHeaders",modelProperties:{snapshot:{serializedName:"x-ms-snapshot",type:{name:"String"}},eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Lt={serializedName:"blob-startcopyfromurl-headers",type:{name:"Composite",className:"BlobStartCopyFromURLHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Bt={serializedName:"blob-copyfromurl-headers",type:{name:"Composite",className:"BlobCopyFromURLHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["success"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Dt={serializedName:"blob-abortcopyfromurl-headers",type:{name:"Composite",className:"BlobAbortCopyFromURLHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ot={serializedName:"blob-settier-headers",type:{name:"Composite",className:"BlobSetTierHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},_t={serializedName:"blob-getaccountinfo-headers",type:{name:"Composite",className:"BlobGetAccountInfoHeaders",modelProperties:{clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},skuName:{serializedName:"x-ms-sku-name",type:{name:"Enum",allowedValues:["Standard_LRS","Standard_GRS","Standard_RAGRS","Standard_ZRS","Premium_LRS"]}},accountKind:{serializedName:"x-ms-account-kind",type:{name:"Enum",allowedValues:["Storage","BlobStorage","StorageV2"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ht={serializedName:"blockblob-stageblock-headers",type:{name:"Composite",className:"BlockBlobStageBlockHeaders",modelProperties:{contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},kt={serializedName:"blockblob-stageblockfromurl-headers",type:{name:"Composite",className:"BlockBlobStageBlockFromURLHeaders",modelProperties:{contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ut={serializedName:"blockblob-commitblocklist-headers",type:{name:"Composite",className:"BlockBlobCommitBlockListHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Ft={serializedName:"blockblob-getblocklist-headers",type:{name:"Composite",className:"BlockBlobGetBlockListHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},contentType:{serializedName:"content-type",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Vt={serializedName:"pageblob-uploadpages-headers",type:{name:"Composite",className:"PageBlobUploadPagesHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},jt={serializedName:"pageblob-clearpages-headers",type:{name:"Composite",className:"PageBlobClearPagesHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Xt={serializedName:"pageblob-uploadpagesfromurl-headers",type:{name:"Composite",className:"PageBlobUploadPagesFromURLHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Gt={serializedName:"pageblob-getpageranges-headers",type:{name:"Composite",className:"PageBlobGetPageRangesHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Kt={serializedName:"pageblob-getpagerangesdiff-headers",type:{name:"Composite",className:"PageBlobGetPageRangesDiffHeaders",modelProperties:{lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},eTag:{serializedName:"etag",type:{name:"String"}},blobContentLength:{serializedName:"x-ms-blob-content-length",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Wt={serializedName:"pageblob-resize-headers",type:{name:"Composite",className:"PageBlobResizeHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},$t={serializedName:"pageblob-updatesequencenumber-headers",type:{name:"Composite",className:"PageBlobUpdateSequenceNumberHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},blobSequenceNumber:{serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Qt={serializedName:"pageblob-copyincremental-headers",type:{name:"Composite",className:"PageBlobCopyIncrementalHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},copyId:{serializedName:"x-ms-copy-id",type:{name:"String"}},copyStatus:{serializedName:"x-ms-copy-status",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Yt={serializedName:"appendblob-appendblock-headers",type:{name:"Composite",className:"AppendBlobAppendBlockHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},clientRequestId:{serializedName:"x-ms-client-request-id",type:{name:"String"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobAppendOffset:{serializedName:"x-ms-blob-append-offset",type:{name:"String"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},isServerEncrypted:{serializedName:"x-ms-request-server-encrypted",type:{name:"Boolean"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Jt={serializedName:"appendblob-appendblockfromurl-headers",type:{name:"Composite",className:"AppendBlobAppendBlockFromUrlHeaders",modelProperties:{eTag:{serializedName:"etag",type:{name:"String"}},lastModified:{serializedName:"last-modified",type:{name:"DateTimeRfc1123"}},contentMD5:{serializedName:"content-md5",type:{name:"ByteArray"}},xMsContentCrc64:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}},requestId:{serializedName:"x-ms-request-id",type:{name:"String"}},version:{serializedName:"x-ms-version",type:{name:"String"}},date:{serializedName:"date",type:{name:"DateTimeRfc1123"}},blobAppendOffset:{serializedName:"x-ms-blob-append-offset",type:{name:"String"}},blobCommittedBlockCount:{serializedName:"x-ms-blob-committed-block-count",type:{name:"Number"}},encryptionKeySha256:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}},errorCode:{serializedName:"x-ms-error-code",type:{name:"String"}}}}},Zt=Object.freeze({ContainerItem:{xmlName:"Container",serializedName:"ContainerItem",type:{name:"Composite",className:"ContainerItem",modelProperties:{name:{xmlName:"Name",required:!0,serializedName:"Name",type:{name:"String"}},properties:{xmlName:"Properties",required:!0,serializedName:"Properties",type:{name:"Composite",className:"ContainerProperties"}},metadata:{xmlName:"Metadata",serializedName:"Metadata",type:{name:"Dictionary",value:{type:{name:"String"}}}}}}},ContainerProperties:{serializedName:"ContainerProperties",type:{name:"Composite",className:"ContainerProperties",modelProperties:{lastModified:{xmlName:"Last-Modified",required:!0,serializedName:"Last-Modified",type:{name:"DateTimeRfc1123"}},etag:{xmlName:"Etag",required:!0,serializedName:"Etag",type:{name:"String"}},leaseStatus:{xmlName:"LeaseStatus",serializedName:"LeaseStatus",type:{name:"Enum",allowedValues:["locked","unlocked"]}},leaseState:{xmlName:"LeaseState",serializedName:"LeaseState",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseDuration:{xmlName:"LeaseDuration",serializedName:"LeaseDuration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},publicAccess:{xmlName:"PublicAccess",serializedName:"PublicAccess",type:{name:"String"}},hasImmutabilityPolicy:{xmlName:"HasImmutabilityPolicy",serializedName:"HasImmutabilityPolicy",type:{name:"Boolean"}},hasLegalHold:{xmlName:"HasLegalHold",serializedName:"HasLegalHold",type:{name:"Boolean"}}}}},CorsRule:{serializedName:"CorsRule",type:{name:"Composite",className:"CorsRule",modelProperties:{allowedOrigins:{xmlName:"AllowedOrigins",required:!0,serializedName:"AllowedOrigins",type:{name:"String"}},allowedMethods:{xmlName:"AllowedMethods",required:!0,serializedName:"AllowedMethods",type:{name:"String"}},allowedHeaders:{xmlName:"AllowedHeaders",required:!0,serializedName:"AllowedHeaders",type:{name:"String"}},exposedHeaders:{xmlName:"ExposedHeaders",required:!0,serializedName:"ExposedHeaders",type:{name:"String"}},maxAgeInSeconds:{xmlName:"MaxAgeInSeconds",required:!0,serializedName:"MaxAgeInSeconds",constraints:{InclusiveMinimum:0},type:{name:"Number"}}}}},GeoReplication:{serializedName:"GeoReplication",type:{name:"Composite",className:"GeoReplication",modelProperties:{status:{xmlName:"Status",required:!0,serializedName:"Status",type:{name:"String"}},lastSyncTime:{xmlName:"LastSyncTime",required:!0,serializedName:"LastSyncTime",type:{name:"DateTimeRfc1123"}}}}},KeyInfo:Oe,ListContainersSegmentResponse:Xe,Logging:{serializedName:"Logging",type:{name:"Composite",className:"Logging",modelProperties:{version:{xmlName:"Version",required:!0,serializedName:"Version",type:{name:"String"}},deleteProperty:{xmlName:"Delete",required:!0,serializedName:"Delete",type:{name:"Boolean"}},read:{xmlName:"Read",required:!0,serializedName:"Read",type:{name:"Boolean"}},write:{xmlName:"Write",required:!0,serializedName:"Write",type:{name:"Boolean"}},retentionPolicy:{xmlName:"RetentionPolicy",required:!0,serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}}}}},Metrics:{serializedName:"Metrics",type:{name:"Composite",className:"Metrics",modelProperties:{version:{xmlName:"Version",serializedName:"Version",type:{name:"String"}},enabled:{xmlName:"Enabled",required:!0,serializedName:"Enabled",type:{name:"Boolean"}},includeAPIs:{xmlName:"IncludeAPIs",serializedName:"IncludeAPIs",type:{name:"Boolean"}},retentionPolicy:{xmlName:"RetentionPolicy",serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy"}}}}},RetentionPolicy:{serializedName:"RetentionPolicy",type:{name:"Composite",className:"RetentionPolicy",modelProperties:{enabled:{xmlName:"Enabled",required:!0,serializedName:"Enabled",type:{name:"Boolean"}},days:{xmlName:"Days",serializedName:"Days",constraints:{InclusiveMinimum:1},type:{name:"Number"}}}}},ServiceGetAccountInfoHeaders:et,ServiceGetPropertiesHeaders:Qe,ServiceGetStatisticsHeaders:Ye,ServiceGetUserDelegationKeyHeaders:Ze,ServiceListContainersSegmentHeaders:Je,ServiceSetPropertiesHeaders:$e,ServiceSubmitBatchHeaders:tt,StaticWebsite:{serializedName:"StaticWebsite",type:{name:"Composite",className:"StaticWebsite",modelProperties:{enabled:{xmlName:"Enabled",required:!0,serializedName:"Enabled",type:{name:"Boolean"}},indexDocument:{xmlName:"IndexDocument",serializedName:"IndexDocument",type:{name:"String"}},errorDocument404Path:{xmlName:"ErrorDocument404Path",serializedName:"ErrorDocument404Path",type:{name:"String"}}}}},StorageError:He,StorageServiceProperties:Ke,StorageServiceStats:We,UserDelegationKey:_e}),er={parameterPath:["options","access"],mapper:{serializedName:"x-ms-blob-public-access",type:{name:"String"}}},tr={parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-lease-action",defaultValue:"acquire",type:{name:"String"}}},rr={parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-lease-action",defaultValue:"release",type:{name:"String"}}},ir={parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-lease-action",defaultValue:"renew",type:{name:"String"}}},nr={parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-lease-action",defaultValue:"break",type:{name:"String"}}},ar={parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-lease-action",defaultValue:"change",type:{name:"String"}}},sr={parameterPath:["options","appendPositionAccessConditions","appendPosition"],mapper:{serializedName:"x-ms-blob-condition-appendpos",type:{name:"Number"}}},or={parameterPath:["options","blobHTTPHeaders","blobCacheControl"],mapper:{serializedName:"x-ms-blob-cache-control",type:{name:"String"}}},mr={parameterPath:["options","blobHTTPHeaders","blobContentDisposition"],mapper:{serializedName:"x-ms-blob-content-disposition",type:{name:"String"}}},dr={parameterPath:["options","blobHTTPHeaders","blobContentEncoding"],mapper:{serializedName:"x-ms-blob-content-encoding",type:{name:"String"}}},lr={parameterPath:["options","blobHTTPHeaders","blobContentLanguage"],mapper:{serializedName:"x-ms-blob-content-language",type:{name:"String"}}},cr={parameterPath:"blobContentLength",mapper:{required:!0,serializedName:"x-ms-blob-content-length",type:{name:"Number"}}},pr={parameterPath:["options","blobHTTPHeaders","blobContentMD5"],mapper:{serializedName:"x-ms-blob-content-md5",type:{name:"ByteArray"}}},ur={parameterPath:["options","blobHTTPHeaders","blobContentType"],mapper:{serializedName:"x-ms-blob-content-type",type:{name:"String"}}},yr={parameterPath:["options","blobSequenceNumber"],mapper:{serializedName:"x-ms-blob-sequence-number",defaultValue:0,type:{name:"Number"}}},hr={parameterPath:"blockId",mapper:{required:!0,serializedName:"blockid",type:{name:"String"}}},fr={parameterPath:["options","breakPeriod"],mapper:{serializedName:"x-ms-lease-break-period",type:{name:"Number"}}},gr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"properties",type:{name:"String"}}},Nr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"page",type:{name:"String"}}},br={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"pagelist",type:{name:"String"}}},vr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"appendblock",type:{name:"String"}}},Sr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"block",type:{name:"String"}}},Cr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"blocklist",type:{name:"String"}}},zr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"list",type:{name:"String"}}},Pr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"metadata",type:{name:"String"}}},xr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"acl",type:{name:"String"}}},Rr={parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"lease",type:{name:"String"}}},qr={parameterPath:"contentLength",mapper:{required:!0,serializedName:"Content-Length",type:{name:"Number"}}},Tr={parameterPath:"copySource",mapper:{required:!0,serializedName:"x-ms-copy-source",type:{name:"String"}}},Mr={parameterPath:["options","duration"],mapper:{serializedName:"x-ms-lease-duration",type:{name:"Number"}}},Ar={parameterPath:["options","cpkInfo","encryptionAlgorithm"],mapper:{serializedName:"x-ms-encryption-algorithm",type:{name:"Enum",allowedValues:["AES256"]}}},Er={parameterPath:["options","cpkInfo","encryptionKey"],mapper:{serializedName:"x-ms-encryption-key",type:{name:"String"}}},wr={parameterPath:["options","cpkInfo","encryptionKeySha256"],mapper:{serializedName:"x-ms-encryption-key-sha256",type:{name:"String"}}},Ir={parameterPath:["options","modifiedAccessConditions","ifMatch"],mapper:{serializedName:"If-Match",type:{name:"String"}}},Lr={parameterPath:["options","modifiedAccessConditions","ifModifiedSince"],mapper:{serializedName:"If-Modified-Since",type:{name:"DateTimeRfc1123"}}},Br={parameterPath:["options","modifiedAccessConditions","ifNoneMatch"],mapper:{serializedName:"If-None-Match",type:{name:"String"}}},Dr={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberEqualTo"],mapper:{serializedName:"x-ms-if-sequence-number-eq",type:{name:"Number"}}},Or={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberLessThan"],mapper:{serializedName:"x-ms-if-sequence-number-lt",type:{name:"Number"}}},_r={parameterPath:["options","sequenceNumberAccessConditions","ifSequenceNumberLessThanOrEqualTo"],mapper:{serializedName:"x-ms-if-sequence-number-le",type:{name:"Number"}}},Hr={parameterPath:["options","modifiedAccessConditions","ifUnmodifiedSince"],mapper:{serializedName:"If-Unmodified-Since",type:{name:"DateTimeRfc1123"}}},kr={parameterPath:["options","include"],mapper:{serializedName:"include",type:{name:"Sequence",element:{type:{name:"Enum",allowedValues:["copy","deleted","metadata","snapshots","uncommittedblobs"]}}}},collectionFormat:xe.Csv},Ur={parameterPath:["options","leaseAccessConditions","leaseId"],mapper:{serializedName:"x-ms-lease-id",type:{name:"String"}}},Fr={parameterPath:"leaseId",mapper:{required:!0,serializedName:"x-ms-lease-id",type:{name:"String"}}},Vr={parameterPath:["options","marker"],mapper:{serializedName:"marker",type:{name:"String"}}},jr={parameterPath:["options","maxresults"],mapper:{serializedName:"maxresults",constraints:{InclusiveMinimum:1},type:{name:"Number"}}},Xr={parameterPath:["options","appendPositionAccessConditions","maxSize"],mapper:{serializedName:"x-ms-blob-condition-maxsize",type:{name:"Number"}}},Gr={parameterPath:["options","metadata"],mapper:{serializedName:"x-ms-meta",type:{name:"Dictionary",value:{type:{name:"String"}}},headerCollectionPrefix:"x-ms-meta-"}},Kr={parameterPath:"pageWrite",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-page-write",defaultValue:"update",type:{name:"String"}}},Wr={parameterPath:["options","posixPermissions"],mapper:{serializedName:"x-ms-permissions",type:{name:"String"}}},$r={parameterPath:["options","prefix"],mapper:{serializedName:"prefix",type:{name:"String"}}},Qr={parameterPath:["options","proposedLeaseId"],mapper:{serializedName:"x-ms-proposed-lease-id",type:{name:"String"}}},Yr={parameterPath:"proposedLeaseId",mapper:{required:!0,serializedName:"x-ms-proposed-lease-id",type:{name:"String"}}},Jr={parameterPath:["options","range"],mapper:{serializedName:"x-ms-range",type:{name:"String"}}},Zr={parameterPath:["options","rehydratePriority"],mapper:{serializedName:"x-ms-rehydrate-priority",type:{name:"String"}}},ei={parameterPath:["options","requestId"],mapper:{serializedName:"x-ms-client-request-id",type:{name:"String"}}},ti={parameterPath:"restype",mapper:{required:!0,isConstant:!0,serializedName:"restype",defaultValue:"service",type:{name:"String"}}},ri={parameterPath:"restype",mapper:{required:!0,isConstant:!0,serializedName:"restype",defaultValue:"account",type:{name:"String"}}},ii={parameterPath:"restype",mapper:{required:!0,isConstant:!0,serializedName:"restype",defaultValue:"container",type:{name:"String"}}},ni={parameterPath:["options","snapshot"],mapper:{serializedName:"snapshot",type:{name:"String"}}},ai={parameterPath:["options","sourceContentCrc64"],mapper:{serializedName:"x-ms-source-content-crc64",type:{name:"ByteArray"}}},si={parameterPath:["options","sourceContentMD5"],mapper:{serializedName:"x-ms-source-content-md5",type:{name:"ByteArray"}}},oi={parameterPath:["options","sourceModifiedAccessConditions","sourceIfMatch"],mapper:{serializedName:"x-ms-source-if-match",type:{name:"String"}}},mi={parameterPath:["options","sourceModifiedAccessConditions","sourceIfModifiedSince"],mapper:{serializedName:"x-ms-source-if-modified-since",type:{name:"DateTimeRfc1123"}}},di={parameterPath:["options","sourceModifiedAccessConditions","sourceIfNoneMatch"],mapper:{serializedName:"x-ms-source-if-none-match",type:{name:"String"}}},li={parameterPath:["options","sourceModifiedAccessConditions","sourceIfUnmodifiedSince"],mapper:{serializedName:"x-ms-source-if-unmodified-since",type:{name:"DateTimeRfc1123"}}},ci={parameterPath:["options","sourceRange"],mapper:{serializedName:"x-ms-source-range",type:{name:"String"}}},pi={parameterPath:"sourceUrl",mapper:{required:!0,serializedName:"x-ms-copy-source",type:{name:"String"}}},ui={parameterPath:["options","tier"],mapper:{serializedName:"x-ms-access-tier",type:{name:"String"}}},yi={parameterPath:["options","timeout"],mapper:{serializedName:"timeout",constraints:{InclusiveMinimum:0},type:{name:"Number"}}},hi={parameterPath:["options","transactionalContentCrc64"],mapper:{serializedName:"x-ms-content-crc64",type:{name:"ByteArray"}}},fi={parameterPath:["options","transactionalContentMD5"],mapper:{serializedName:"Content-MD5",type:{name:"ByteArray"}}},gi={parameterPath:"url",mapper:{required:!0,serializedName:"url",defaultValue:"",type:{name:"String"}},skipEncoding:!0},Ni={parameterPath:"version",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-version",defaultValue:"2019-02-02",type:{name:"String"}}},bi=function(){function e(e){this.client=e}return e.prototype.setProperties=function(e,t,r){return this.client.sendOperationRequest({storageServiceProperties:e,options:t},Si,r)},e.prototype.getProperties=function(e,t){return this.client.sendOperationRequest({options:e},Ci,t)},e.prototype.getStatistics=function(e,t){return this.client.sendOperationRequest({options:e},zi,t)},e.prototype.listContainersSegment=function(e,t){return this.client.sendOperationRequest({options:e},Pi,t)},e.prototype.getUserDelegationKey=function(e,t,r){return this.client.sendOperationRequest({keyInfo:e,options:t},xi,r)},e.prototype.getAccountInfo=function(e,t){return this.client.sendOperationRequest({options:e},Ri,t)},e.prototype.submitBatch=function(e,t,r,i,n){return this.client.sendOperationRequest({body:e,contentLength:t,multipartContentType:r,options:i},qi,n)},e}(),vi=new N(Zt,!0),Si={httpMethod:"PUT",urlParameters:[gi],queryParameters:[yi,ti,gr],headerParameters:[Ni,ei],requestBody:{parameterPath:"storageServiceProperties",mapper:M({},Ke,{required:!0})},contentType:"application/xml; charset=utf-8",responses:{202:{headersMapper:$e},default:{bodyMapper:He}},isXML:!0,serializer:vi},Ci={httpMethod:"GET",urlParameters:[gi],queryParameters:[yi,ti,gr],headerParameters:[Ni,ei],responses:{200:{bodyMapper:Ke,headersMapper:Qe},default:{bodyMapper:He}},isXML:!0,serializer:vi},zi={httpMethod:"GET",urlParameters:[gi],queryParameters:[yi,ti,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"stats",type:{name:"String"}}}],headerParameters:[Ni,ei],responses:{200:{bodyMapper:We,headersMapper:Ye},default:{bodyMapper:He}},isXML:!0,serializer:vi},Pi={httpMethod:"GET",urlParameters:[gi],queryParameters:[$r,Vr,jr,{parameterPath:["options","include"],mapper:{serializedName:"include",type:{name:"Enum",allowedValues:["metadata"]}}},yi,zr],headerParameters:[Ni,ei],responses:{200:{bodyMapper:Xe,headersMapper:Je},default:{bodyMapper:He}},isXML:!0,serializer:vi},xi={httpMethod:"POST",urlParameters:[gi],queryParameters:[yi,ti,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"userdelegationkey",type:{name:"String"}}}],headerParameters:[Ni,ei],requestBody:{parameterPath:"keyInfo",mapper:M({},Oe,{required:!0})},contentType:"application/xml; charset=utf-8",responses:{200:{bodyMapper:_e,headersMapper:Ze},default:{bodyMapper:He}},isXML:!0,serializer:vi},Ri={httpMethod:"GET",urlParameters:[gi],queryParameters:[ri,gr],headerParameters:[Ni],responses:{200:{headersMapper:et},default:{bodyMapper:He}},isXML:!0,serializer:vi},qi={httpMethod:"POST",urlParameters:[gi],queryParameters:[yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"batch",type:{name:"String"}}}],headerParameters:[qr,{parameterPath:"multipartContentType",mapper:{required:!0,serializedName:"Content-Type",type:{name:"String"}}},Ni,ei],requestBody:{parameterPath:"body",mapper:{required:!0,serializedName:"body",type:{name:"Stream"}}},contentType:"application/xml; charset=utf-8",responses:{202:{bodyMapper:{serializedName:"parsedResponse",type:{name:"Stream"}},headersMapper:tt},default:{bodyMapper:He}},isXML:!0,serializer:vi},Ti=Object.freeze({AccessPolicy:{serializedName:"AccessPolicy",type:{name:"Composite",className:"AccessPolicy",modelProperties:{start:{xmlName:"Start",required:!0,serializedName:"Start",type:{name:"String"}},expiry:{xmlName:"Expiry",required:!0,serializedName:"Expiry",type:{name:"String"}},permission:{xmlName:"Permission",required:!0,serializedName:"Permission",type:{name:"String"}}}}},BlobFlatListSegment:{xmlName:"Blobs",serializedName:"BlobFlatListSegment",type:{name:"Composite",className:"BlobFlatListSegment",modelProperties:{blobItems:{xmlName:"BlobItems",xmlElementName:"Blob",required:!0,serializedName:"BlobItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobItem"}}}}}}},BlobHierarchyListSegment:{xmlName:"Blobs",serializedName:"BlobHierarchyListSegment",type:{name:"Composite",className:"BlobHierarchyListSegment",modelProperties:{blobPrefixes:{xmlName:"BlobPrefixes",xmlElementName:"BlobPrefix",serializedName:"BlobPrefixes",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobPrefix"}}}},blobItems:{xmlName:"BlobItems",xmlElementName:"Blob",required:!0,serializedName:"BlobItems",type:{name:"Sequence",element:{type:{name:"Composite",className:"BlobItem"}}}}}}},BlobItem:{xmlName:"Blob",serializedName:"BlobItem",type:{name:"Composite",className:"BlobItem",modelProperties:{name:{xmlName:"Name",required:!0,serializedName:"Name",type:{name:"String"}},deleted:{xmlName:"Deleted",required:!0,serializedName:"Deleted",type:{name:"Boolean"}},snapshot:{xmlName:"Snapshot",required:!0,serializedName:"Snapshot",type:{name:"String"}},properties:{xmlName:"Properties",required:!0,serializedName:"Properties",type:{name:"Composite",className:"BlobProperties"}},metadata:{xmlName:"Metadata",serializedName:"Metadata",type:{name:"Composite",className:"BlobMetadata",additionalProperties:{type:{name:"String"}}}}}}},BlobMetadata:{xmlName:"Metadata",serializedName:"BlobMetadata",type:{name:"Composite",className:"BlobMetadata",modelProperties:{encrypted:{xmlIsAttribute:!0,xmlName:"Encrypted",serializedName:"Encrypted",type:{name:"String"}}},additionalProperties:{type:{name:"String"}}}},BlobPrefix:{serializedName:"BlobPrefix",type:{name:"Composite",className:"BlobPrefix",modelProperties:{name:{xmlName:"Name",required:!0,serializedName:"Name",type:{name:"String"}}}}},BlobProperties:{xmlName:"Properties",serializedName:"BlobProperties",type:{name:"Composite",className:"BlobProperties",modelProperties:{creationTime:{xmlName:"Creation-Time",serializedName:"Creation-Time",type:{name:"DateTimeRfc1123"}},lastModified:{xmlName:"Last-Modified",required:!0,serializedName:"Last-Modified",type:{name:"DateTimeRfc1123"}},etag:{xmlName:"Etag",required:!0,serializedName:"Etag",type:{name:"String"}},contentLength:{xmlName:"Content-Length",serializedName:"Content-Length",type:{name:"Number"}},contentType:{xmlName:"Content-Type",serializedName:"Content-Type",type:{name:"String"}},contentEncoding:{xmlName:"Content-Encoding",serializedName:"Content-Encoding",type:{name:"String"}},contentLanguage:{xmlName:"Content-Language",serializedName:"Content-Language",type:{name:"String"}},contentMD5:{xmlName:"Content-MD5",serializedName:"Content-MD5",type:{name:"ByteArray"}},contentDisposition:{xmlName:"Content-Disposition",serializedName:"Content-Disposition",type:{name:"String"}},cacheControl:{xmlName:"Cache-Control",serializedName:"Cache-Control",type:{name:"String"}},blobSequenceNumber:{xmlName:"x-ms-blob-sequence-number",serializedName:"x-ms-blob-sequence-number",type:{name:"Number"}},blobType:{xmlName:"BlobType",serializedName:"BlobType",type:{name:"Enum",allowedValues:["BlockBlob","PageBlob","AppendBlob"]}},leaseStatus:{xmlName:"LeaseStatus",serializedName:"LeaseStatus",type:{name:"Enum",allowedValues:["locked","unlocked"]}},leaseState:{xmlName:"LeaseState",serializedName:"LeaseState",type:{name:"Enum",allowedValues:["available","leased","expired","breaking","broken"]}},leaseDuration:{xmlName:"LeaseDuration",serializedName:"LeaseDuration",type:{name:"Enum",allowedValues:["infinite","fixed"]}},copyId:{xmlName:"CopyId",serializedName:"CopyId",type:{name:"String"}},copyStatus:{xmlName:"CopyStatus",serializedName:"CopyStatus",type:{name:"Enum",allowedValues:["pending","success","aborted","failed"]}},copySource:{xmlName:"CopySource",serializedName:"CopySource",type:{name:"String"}},copyProgress:{xmlName:"CopyProgress",serializedName:"CopyProgress",type:{name:"String"}},copyCompletionTime:{xmlName:"CopyCompletionTime",serializedName:"CopyCompletionTime",type:{name:"DateTimeRfc1123"}},copyStatusDescription:{xmlName:"CopyStatusDescription",serializedName:"CopyStatusDescription",type:{name:"String"}},serverEncrypted:{xmlName:"ServerEncrypted",serializedName:"ServerEncrypted",type:{name:"Boolean"}},incrementalCopy:{xmlName:"IncrementalCopy",serializedName:"IncrementalCopy",type:{name:"Boolean"}},destinationSnapshot:{xmlName:"DestinationSnapshot",serializedName:"DestinationSnapshot",type:{name:"String"}},deletedTime:{xmlName:"DeletedTime",serializedName:"DeletedTime",type:{name:"DateTimeRfc1123"}},remainingRetentionDays:{xmlName:"RemainingRetentionDays",serializedName:"RemainingRetentionDays",type:{name:"Number"}},accessTier:{xmlName:"AccessTier",serializedName:"AccessTier",type:{name:"String"}},accessTierInferred:{xmlName:"AccessTierInferred",serializedName:"AccessTierInferred",type:{name:"Boolean"}},archiveStatus:{xmlName:"ArchiveStatus",serializedName:"ArchiveStatus",type:{name:"String"}},customerProvidedKeySha256:{xmlName:"CustomerProvidedKeySha256",serializedName:"CustomerProvidedKeySha256",type:{name:"String"}},accessTierChangeTime:{xmlName:"AccessTierChangeTime",serializedName:"AccessTierChangeTime",type:{name:"DateTimeRfc1123"}}}}},ContainerAcquireLeaseHeaders:mt,ContainerBreakLeaseHeaders:ct,ContainerChangeLeaseHeaders:pt,ContainerCreateHeaders:rt,ContainerDeleteHeaders:nt,ContainerGetAccessPolicyHeaders:st,ContainerGetAccountInfoHeaders:ht,ContainerGetPropertiesHeaders:it,ContainerListBlobFlatSegmentHeaders:ut,ContainerListBlobHierarchySegmentHeaders:yt,ContainerReleaseLeaseHeaders:dt,ContainerRenewLeaseHeaders:lt,ContainerSetAccessPolicyHeaders:ot,ContainerSetMetadataHeaders:at,ListBlobsFlatSegmentResponse:Ue,ListBlobsHierarchySegmentResponse:Fe,SignedIdentifier:{serializedName:"SignedIdentifier",type:{name:"Composite",className:"SignedIdentifier",modelProperties:{id:{xmlName:"Id",required:!0,serializedName:"Id",type:{name:"String"}},accessPolicy:{xmlName:"AccessPolicy",required:!0,serializedName:"AccessPolicy",type:{name:"Composite",className:"AccessPolicy"}}}}},StorageError:He}),Mi=function(){function e(e){this.client=e}return e.prototype.create=function(e,t){return this.client.sendOperationRequest({options:e},Ei,t)},e.prototype.getProperties=function(e,t){return this.client.sendOperationRequest({options:e},wi,t)},e.prototype.deleteMethod=function(e,t){return this.client.sendOperationRequest({options:e},Ii,t)},e.prototype.setMetadata=function(e,t){return this.client.sendOperationRequest({options:e},Li,t)},e.prototype.getAccessPolicy=function(e,t){return this.client.sendOperationRequest({options:e},Bi,t)},e.prototype.setAccessPolicy=function(e,t){return this.client.sendOperationRequest({options:e},Di,t)},e.prototype.acquireLease=function(e,t){return this.client.sendOperationRequest({options:e},Oi,t)},e.prototype.releaseLease=function(e,t,r){return this.client.sendOperationRequest({leaseId:e,options:t},_i,r)},e.prototype.renewLease=function(e,t,r){return this.client.sendOperationRequest({leaseId:e,options:t},Hi,r)},e.prototype.breakLease=function(e,t){return this.client.sendOperationRequest({options:e},ki,t)},e.prototype.changeLease=function(e,t,r,i){return this.client.sendOperationRequest({leaseId:e,proposedLeaseId:t,options:r},Ui,i)},e.prototype.listBlobFlatSegment=function(e,t){return this.client.sendOperationRequest({options:e},Fi,t)},e.prototype.listBlobHierarchySegment=function(e,t,r){return this.client.sendOperationRequest({delimiter:e,options:t},Vi,r)},e.prototype.getAccountInfo=function(e,t){return this.client.sendOperationRequest({options:e},ji,t)},e}(),Ai=new N(Ti,!0),Ei={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii],headerParameters:[Gr,er,Ni,ei],responses:{201:{headersMapper:rt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},wi={httpMethod:"GET",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii],headerParameters:[Ni,ei,Ur],responses:{200:{headersMapper:it},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Ii={httpMethod:"DELETE",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii],headerParameters:[Ni,ei,Ur,Lr,Hr],responses:{202:{headersMapper:nt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Li={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii,Pr],headerParameters:[Gr,Ni,ei,Ur,Lr],responses:{200:{headersMapper:at},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Bi={httpMethod:"GET",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii,xr],headerParameters:[Ni,ei,Ur],responses:{200:{bodyMapper:{xmlElementName:"SignedIdentifier",serializedName:"parsedResponse",type:{name:"Sequence",element:{type:{name:"Composite",className:"SignedIdentifier"}}}},headersMapper:st},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Di={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,ii,xr],headerParameters:[er,Ni,ei,Ur,Lr,Hr],requestBody:{parameterPath:["options","containerAcl"],mapper:{xmlName:"SignedIdentifiers",xmlElementName:"SignedIdentifier",serializedName:"containerAcl",type:{name:"Sequence",element:{type:{name:"Composite",className:"SignedIdentifier"}}}}},contentType:"application/xml; charset=utf-8",responses:{200:{headersMapper:ot},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Oi={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,Rr,ii],headerParameters:[Mr,Qr,Ni,ei,tr,Lr,Hr],responses:{201:{headersMapper:mt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},_i={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,Rr,ii],headerParameters:[Fr,Ni,ei,rr,Lr,Hr],responses:{200:{headersMapper:dt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Hi={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,Rr,ii],headerParameters:[Fr,Ni,ei,ir,Lr,Hr],responses:{200:{headersMapper:lt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},ki={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,Rr,ii],headerParameters:[fr,Ni,ei,nr,Lr,Hr],responses:{202:{headersMapper:ct},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Ui={httpMethod:"PUT",path:"{containerName}",urlParameters:[gi],queryParameters:[yi,Rr,ii],headerParameters:[Fr,Yr,Ni,ei,ar,Lr,Hr],responses:{200:{headersMapper:pt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Fi={httpMethod:"GET",path:"{containerName}",urlParameters:[gi],queryParameters:[$r,Vr,jr,kr,yi,ii,zr],headerParameters:[Ni,ei],responses:{200:{bodyMapper:Ue,headersMapper:ut},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Vi={httpMethod:"GET",path:"{containerName}",urlParameters:[gi],queryParameters:[$r,{parameterPath:"delimiter",mapper:{required:!0,serializedName:"delimiter",type:{name:"String"}}},Vr,jr,kr,yi,ii,zr],headerParameters:[Ni,ei],responses:{200:{bodyMapper:Fe,headersMapper:yt},default:{bodyMapper:He}},isXML:!0,serializer:Ai},ji={httpMethod:"GET",path:"{containerName}",urlParameters:[gi],queryParameters:[ri,gr],headerParameters:[Ni],responses:{200:{headersMapper:ht},default:{bodyMapper:He}},isXML:!0,serializer:Ai},Xi=Object.freeze({BlobAbortCopyFromURLHeaders:Dt,BlobAcquireLeaseHeaders:Tt,BlobBreakLeaseHeaders:wt,BlobChangeLeaseHeaders:Et,BlobCopyFromURLHeaders:Bt,BlobCreateSnapshotHeaders:It,BlobDeleteHeaders:Nt,BlobDownloadHeaders:ft,BlobGetAccessControlHeaders:vt,BlobGetAccountInfoHeaders:_t,BlobGetPropertiesHeaders:gt,BlobReleaseLeaseHeaders:Mt,BlobRenameHeaders:St,BlobRenewLeaseHeaders:At,BlobSetAccessControlHeaders:bt,BlobSetHTTPHeadersHeaders:Rt,BlobSetMetadataHeaders:qt,BlobSetTierHeaders:Ot,BlobStartCopyFromURLHeaders:Lt,BlobUndeleteHeaders:xt,DataLakeStorageError:ke,DataLakeStorageErrorError:{serializedName:"DataLakeStorageError_error",type:{name:"Composite",className:"DataLakeStorageErrorError",modelProperties:{code:{xmlName:"Code",serializedName:"Code",type:{name:"String"}},message:{xmlName:"Message",serializedName:"Message",type:{name:"String"}}}}},StorageError:He}),Gi=function(){function e(e){this.client=e}return e.prototype.download=function(e,t){return this.client.sendOperationRequest({options:e},Wi,t)},e.prototype.getProperties=function(e,t){return this.client.sendOperationRequest({options:e},$i,t)},e.prototype.deleteMethod=function(e,t){return this.client.sendOperationRequest({options:e},Qi,t)},e.prototype.setAccessControl=function(e,t){return this.client.sendOperationRequest({options:e},Yi,t)},e.prototype.getAccessControl=function(e,t){return this.client.sendOperationRequest({options:e},Ji,t)},e.prototype.rename=function(e,t,r){return this.client.sendOperationRequest({renameSource:e,options:t},Zi,r)},e.prototype.undelete=function(e,t){return this.client.sendOperationRequest({options:e},en,t)},e.prototype.setHTTPHeaders=function(e,t){return this.client.sendOperationRequest({options:e},tn,t)},e.prototype.setMetadata=function(e,t){return this.client.sendOperationRequest({options:e},rn,t)},e.prototype.acquireLease=function(e,t){return this.client.sendOperationRequest({options:e},nn,t)},e.prototype.releaseLease=function(e,t,r){return this.client.sendOperationRequest({leaseId:e,options:t},an,r)},e.prototype.renewLease=function(e,t,r){return this.client.sendOperationRequest({leaseId:e,options:t},sn,r)},e.prototype.changeLease=function(e,t,r,i){return this.client.sendOperationRequest({leaseId:e,proposedLeaseId:t,options:r},on,i)},e.prototype.breakLease=function(e,t){return this.client.sendOperationRequest({options:e},mn,t)},e.prototype.createSnapshot=function(e,t){return this.client.sendOperationRequest({options:e},dn,t)},e.prototype.startCopyFromURL=function(e,t,r){return this.client.sendOperationRequest({copySource:e,options:t},ln,r)},e.prototype.copyFromURL=function(e,t,r){return this.client.sendOperationRequest({copySource:e,options:t},cn,r)},e.prototype.abortCopyFromURL=function(e,t,r){return this.client.sendOperationRequest({copyId:e,options:t},pn,r)},e.prototype.setTier=function(e,t,r){return this.client.sendOperationRequest({tier:e,options:t},un,r)},e.prototype.getAccountInfo=function(e,t){return this.client.sendOperationRequest({options:e},yn,t)},e}(),Ki=new N(Xi,!0),Wi={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,yi],headerParameters:[Jr,{parameterPath:["options","rangeGetContentMD5"],mapper:{serializedName:"x-ms-range-get-content-md5",type:{name:"Boolean"}}},{parameterPath:["options","rangeGetContentCRC64"],mapper:{serializedName:"x-ms-range-get-content-crc64",type:{name:"Boolean"}}},Ni,ei,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{200:{bodyMapper:{serializedName:"parsedResponse",type:{name:"Stream"}},headersMapper:ft},206:{bodyMapper:{serializedName:"parsedResponse",type:{name:"Stream"}},headersMapper:ft},default:{bodyMapper:He}},isXML:!0,serializer:Ki},$i={httpMethod:"HEAD",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,yi],headerParameters:[Ni,ei,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{200:{headersMapper:gt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},Qi={httpMethod:"DELETE",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,yi],headerParameters:[{parameterPath:["options","deleteSnapshots"],mapper:{serializedName:"x-ms-delete-snapshots",type:{name:"Enum",allowedValues:["include","only"]}}},Ni,ei,Ur,Lr,Hr,Ir,Br],responses:{202:{headersMapper:Nt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},Yi={httpMethod:"PATCH",path:"{filesystem}/{path}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"action",defaultValue:"setAccessControl",type:{name:"String"}}}],headerParameters:[{parameterPath:["options","owner"],mapper:{serializedName:"x-ms-owner",type:{name:"String"}}},{parameterPath:["options","group"],mapper:{serializedName:"x-ms-group",type:{name:"String"}}},Wr,{parameterPath:["options","posixAcl"],mapper:{serializedName:"x-ms-acl",type:{name:"String"}}},ei,Ni,Ur,Ir,Br,Lr,Hr],responses:{200:{headersMapper:bt},default:{bodyMapper:ke}},isXML:!0,serializer:Ki},Ji={httpMethod:"HEAD",path:"{filesystem}/{path}",urlParameters:[gi],queryParameters:[yi,{parameterPath:["options","upn"],mapper:{serializedName:"upn",type:{name:"Boolean"}}},{parameterPath:"action",mapper:{required:!0,isConstant:!0,serializedName:"action",defaultValue:"getAccessControl",type:{name:"String"}}}],headerParameters:[ei,Ni,Ur,Ir,Br,Lr,Hr],responses:{200:{headersMapper:vt},default:{bodyMapper:ke}},isXML:!0,serializer:Ki},Zi={httpMethod:"PUT",path:"{filesystem}/{path}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"pathRenameMode",mapper:{serializedName:"mode",type:{name:"Enum",allowedValues:["legacy","posix"]}}}],headerParameters:[{parameterPath:"renameSource",mapper:{required:!0,serializedName:"x-ms-rename-source",type:{name:"String"}}},{parameterPath:["options","directoryProperties"],mapper:{serializedName:"x-ms-properties",type:{name:"String"}}},Wr,{parameterPath:["options","posixUmask"],mapper:{serializedName:"x-ms-umask",type:{name:"String"}}},{parameterPath:["options","sourceLeaseId"],mapper:{serializedName:"x-ms-source-lease-id",type:{name:"String"}}},Ni,ei,{parameterPath:["options","directoryHttpHeaders","cacheControl"],mapper:{serializedName:"x-ms-cache-control",type:{name:"String"}}},{parameterPath:["options","directoryHttpHeaders","contentType"],mapper:{serializedName:"x-ms-content-type",type:{name:"String"}}},{parameterPath:["options","directoryHttpHeaders","contentEncoding"],mapper:{serializedName:"x-ms-content-encoding",type:{name:"String"}}},{parameterPath:["options","directoryHttpHeaders","contentLanguage"],mapper:{serializedName:"x-ms-content-language",type:{name:"String"}}},{parameterPath:["options","directoryHttpHeaders","contentDisposition"],mapper:{serializedName:"x-ms-content-disposition",type:{name:"String"}}},Ur,Lr,Hr,Ir,Br,mi,li,oi,di],responses:{201:{headersMapper:St},default:{bodyMapper:ke}},isXML:!0,serializer:Ki},en={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"undelete",type:{name:"String"}}}],headerParameters:[Ni,ei],responses:{200:{headersMapper:xt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},tn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,gr],headerParameters:[Ni,ei,or,ur,pr,dr,lr,mr,Ur,Lr,Hr,Ir,Br],responses:{200:{headersMapper:Rt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},rn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Pr],headerParameters:[Gr,Ni,ei,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{200:{headersMapper:qt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},nn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Rr],headerParameters:[Mr,Qr,Ni,ei,tr,Lr,Hr,Ir,Br],responses:{201:{headersMapper:Tt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},an={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Rr],headerParameters:[Fr,Ni,ei,rr,Lr,Hr,Ir,Br],responses:{200:{headersMapper:Mt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},sn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Rr],headerParameters:[Fr,Ni,ei,ir,Lr,Hr,Ir,Br],responses:{200:{headersMapper:At},default:{bodyMapper:He}},isXML:!0,serializer:Ki},on={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Rr],headerParameters:[Fr,Yr,Ni,ei,ar,Lr,Hr,Ir,Br],responses:{200:{headersMapper:Et},default:{bodyMapper:He}},isXML:!0,serializer:Ki},mn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Rr],headerParameters:[fr,Ni,ei,nr,Lr,Hr,Ir,Br],responses:{202:{headersMapper:wt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},dn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"snapshot",type:{name:"String"}}}],headerParameters:[Gr,Ni,ei,Er,wr,Ar,Lr,Hr,Ir,Br,Ur],responses:{201:{headersMapper:It},default:{bodyMapper:He}},isXML:!0,serializer:Ki},ln={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi],headerParameters:[Gr,ui,Zr,Tr,Ni,ei,mi,li,oi,di,Lr,Hr,Ir,Br,Ur],responses:{202:{headersMapper:Lt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},cn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi],headerParameters:[Gr,ui,Tr,Ni,ei,{parameterPath:"xMsRequiresSync",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-requires-sync",defaultValue:"true",type:{name:"String"}}},mi,li,oi,di,Lr,Hr,Ir,Br,Ur],responses:{202:{headersMapper:Bt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},pn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[{parameterPath:"copyId",mapper:{required:!0,serializedName:"copyid",type:{name:"String"}}},yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"copy",type:{name:"String"}}}],headerParameters:[Ni,ei,{parameterPath:"copyActionAbortConstant",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-copy-action",defaultValue:"abort",type:{name:"String"}}},Ur],responses:{204:{headersMapper:Dt},default:{bodyMapper:He}},isXML:!0,serializer:Ki},un={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"tier",type:{name:"String"}}}],headerParameters:[{parameterPath:"tier",mapper:{required:!0,serializedName:"x-ms-access-tier",type:{name:"String"}}},Zr,Ni,ei,Ur],responses:{200:{headersMapper:Ot},202:{headersMapper:Ot},default:{bodyMapper:He}},isXML:!0,serializer:Ki},yn={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ri,gr],headerParameters:[Ni],responses:{200:{headersMapper:_t},default:{bodyMapper:He}},isXML:!0,serializer:Ki},hn=Object.freeze({ClearRange:{serializedName:"ClearRange",type:{name:"Composite",className:"ClearRange",modelProperties:{start:{xmlName:"Start",required:!0,serializedName:"Start",type:{name:"Number"}},end:{xmlName:"End",required:!0,serializedName:"End",type:{name:"Number"}}}}},PageBlobClearPagesHeaders:jt,PageBlobCopyIncrementalHeaders:Qt,PageBlobCreateHeaders:Ct,PageBlobGetPageRangesDiffHeaders:Kt,PageBlobGetPageRangesHeaders:Gt,PageBlobResizeHeaders:Wt,PageBlobUpdateSequenceNumberHeaders:$t,PageBlobUploadPagesFromURLHeaders:Xt,PageBlobUploadPagesHeaders:Vt,PageList:Ge,PageRange:{serializedName:"PageRange",type:{name:"Composite",className:"PageRange",modelProperties:{start:{xmlName:"Start",required:!0,serializedName:"Start",type:{name:"Number"}},end:{xmlName:"End",required:!0,serializedName:"End",type:{name:"Number"}}}}},StorageError:He}),fn=function(){function e(e){this.client=e}return e.prototype.create=function(e,t,r,i){return this.client.sendOperationRequest({contentLength:e,blobContentLength:t,options:r},Nn,i)},e.prototype.uploadPages=function(e,t,r,i){return this.client.sendOperationRequest({body:e,contentLength:t,options:r},bn,i)},e.prototype.clearPages=function(e,t,r){return this.client.sendOperationRequest({contentLength:e,options:t},vn,r)},e.prototype.uploadPagesFromURL=function(e,t,r,i,n,a){return this.client.sendOperationRequest({sourceUrl:e,sourceRange:t,contentLength:r,range:i,options:n},Sn,a)},e.prototype.getPageRanges=function(e,t){return this.client.sendOperationRequest({options:e},Cn,t)},e.prototype.getPageRangesDiff=function(e,t){return this.client.sendOperationRequest({options:e},zn,t)},e.prototype.resize=function(e,t,r){return this.client.sendOperationRequest({blobContentLength:e,options:t},Pn,r)},e.prototype.updateSequenceNumber=function(e,t,r){return this.client.sendOperationRequest({sequenceNumberAction:e,options:t},xn,r)},e.prototype.copyIncremental=function(e,t,r){return this.client.sendOperationRequest({copySource:e,options:t},Rn,r)},e}(),gn=new N(hn,!0),Nn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi],headerParameters:[qr,Gr,cr,yr,Ni,ei,ui,{parameterPath:"blobType",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-blob-type",defaultValue:"PageBlob",type:{name:"String"}}},ur,dr,lr,pr,or,mr,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{201:{headersMapper:Ct},default:{bodyMapper:He}},isXML:!0,serializer:gn},bn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Nr],headerParameters:[qr,fi,hi,Jr,Ni,ei,Kr,Ur,Er,wr,Ar,_r,Or,Dr,Lr,Hr,Ir,Br],requestBody:{parameterPath:"body",mapper:{required:!0,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:Vt},default:{bodyMapper:He}},isXML:!0,serializer:gn},vn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Nr],headerParameters:[qr,Jr,Ni,ei,{parameterPath:"pageWrite",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-page-write",defaultValue:"clear",type:{name:"String"}}},Ur,Er,wr,Ar,_r,Or,Dr,Lr,Hr,Ir,Br],responses:{201:{headersMapper:jt},default:{bodyMapper:He}},isXML:!0,serializer:gn},Sn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Nr],headerParameters:[pi,{parameterPath:"sourceRange",mapper:{required:!0,serializedName:"x-ms-source-range",type:{name:"String"}}},si,ai,qr,{parameterPath:"range",mapper:{required:!0,serializedName:"x-ms-range",type:{name:"String"}}},Ni,ei,Kr,Er,wr,Ar,Ur,_r,Or,Dr,Lr,Hr,Ir,Br,mi,li,oi,di],responses:{201:{headersMapper:Xt},default:{bodyMapper:He}},isXML:!0,serializer:gn},Cn={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,yi,br],headerParameters:[Jr,Ni,ei,Ur,Lr,Hr,Ir,Br],responses:{200:{bodyMapper:Ge,headersMapper:Gt},default:{bodyMapper:He}},isXML:!0,serializer:gn},zn={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,yi,{parameterPath:["options","prevsnapshot"],mapper:{serializedName:"prevsnapshot",type:{name:"String"}}},br],headerParameters:[Jr,Ni,ei,Ur,Lr,Hr,Ir,Br],responses:{200:{bodyMapper:Ge,headersMapper:Kt},default:{bodyMapper:He}},isXML:!0,serializer:gn},Pn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,gr],headerParameters:[cr,Ni,ei,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{200:{headersMapper:Wt},default:{bodyMapper:He}},isXML:!0,serializer:gn},xn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,gr],headerParameters:[{parameterPath:"sequenceNumberAction",mapper:{required:!0,serializedName:"x-ms-sequence-number-action",type:{name:"Enum",allowedValues:["max","update","increment"]}}},yr,Ni,ei,Ur,Lr,Hr,Ir,Br],responses:{200:{headersMapper:$t},default:{bodyMapper:He}},isXML:!0,serializer:gn},Rn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,{parameterPath:"comp",mapper:{required:!0,isConstant:!0,serializedName:"comp",defaultValue:"incrementalcopy",type:{name:"String"}}}],headerParameters:[Tr,Ni,ei,Lr,Hr,Ir,Br],responses:{202:{headersMapper:Qt},default:{bodyMapper:He}},isXML:!0,serializer:gn},qn=Object.freeze({AppendBlobAppendBlockFromUrlHeaders:Jt,AppendBlobAppendBlockHeaders:Yt,AppendBlobCreateHeaders:zt,StorageError:He}),Tn=function(){function e(e){this.client=e}return e.prototype.create=function(e,t,r){return this.client.sendOperationRequest({contentLength:e,options:t},An,r)},e.prototype.appendBlock=function(e,t,r,i){return this.client.sendOperationRequest({body:e,contentLength:t,options:r},En,i)},e.prototype.appendBlockFromUrl=function(e,t,r,i){return this.client.sendOperationRequest({sourceUrl:e,contentLength:t,options:r},wn,i)},e}(),Mn=new N(qn,!0),An={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi],headerParameters:[qr,Gr,Ni,ei,{parameterPath:"blobType",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-blob-type",defaultValue:"AppendBlob",type:{name:"String"}}},ur,dr,lr,pr,or,mr,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],responses:{201:{headersMapper:zt},default:{bodyMapper:He}},isXML:!0,serializer:Mn},En={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,vr],headerParameters:[qr,fi,hi,Ni,ei,Ur,Xr,sr,Er,wr,Ar,Lr,Hr,Ir,Br],requestBody:{parameterPath:"body",mapper:{required:!0,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:Yt},default:{bodyMapper:He}},isXML:!0,serializer:Mn},wn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,vr],headerParameters:[pi,ci,si,ai,qr,fi,Ni,ei,Er,wr,Ar,Ur,Xr,sr,Lr,Hr,Ir,Br,mi,li,oi,di],responses:{201:{headersMapper:Jt},default:{bodyMapper:He}},isXML:!0,serializer:Mn},In=Object.freeze({Block:{serializedName:"Block",type:{name:"Composite",className:"Block",modelProperties:{name:{xmlName:"Name",required:!0,serializedName:"Name",type:{name:"String"}},size:{xmlName:"Size",required:!0,serializedName:"Size",type:{name:"Number"}}}}},BlockBlobCommitBlockListHeaders:Ut,BlockBlobGetBlockListHeaders:Ft,BlockBlobStageBlockFromURLHeaders:kt,BlockBlobStageBlockHeaders:Ht,BlockBlobUploadHeaders:Pt,BlockList:Ve,BlockLookupList:je,StorageError:He}),Ln=function(){function e(e){this.client=e}return e.prototype.upload=function(e,t,r,i){return this.client.sendOperationRequest({body:e,contentLength:t,options:r},Dn,i)},e.prototype.stageBlock=function(e,t,r,i,n){return this.client.sendOperationRequest({blockId:e,contentLength:t,body:r,options:i},On,n)},e.prototype.stageBlockFromURL=function(e,t,r,i,n){return this.client.sendOperationRequest({blockId:e,contentLength:t,sourceUrl:r,options:i},_n,n)},e.prototype.commitBlockList=function(e,t,r){return this.client.sendOperationRequest({blocks:e,options:t},Hn,r)},e.prototype.getBlockList=function(e,t,r){return this.client.sendOperationRequest({listType:e,options:t},kn,r)},e}(),Bn=new N(In,!0),Dn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi],headerParameters:[qr,Gr,ui,Ni,ei,{parameterPath:"blobType",mapper:{required:!0,isConstant:!0,serializedName:"x-ms-blob-type",defaultValue:"BlockBlob",type:{name:"String"}}},ur,dr,lr,pr,or,mr,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],requestBody:{parameterPath:"body",mapper:{required:!0,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:Pt},default:{bodyMapper:He}},isXML:!0,serializer:Bn},On={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[hr,yi,Sr],headerParameters:[qr,fi,hi,Ni,ei,Ur,Er,wr,Ar],requestBody:{parameterPath:"body",mapper:{required:!0,serializedName:"body",type:{name:"Stream"}}},contentType:"application/octet-stream",responses:{201:{headersMapper:Ht},default:{bodyMapper:He}},isXML:!0,serializer:Bn},_n={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[hr,yi,Sr],headerParameters:[qr,pi,ci,si,ai,Ni,ei,Er,wr,Ar,Ur,mi,li,oi,di],responses:{201:{headersMapper:kt},default:{bodyMapper:He}},isXML:!0,serializer:Bn},Hn={httpMethod:"PUT",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[yi,Cr],headerParameters:[fi,hi,Gr,ui,Ni,ei,or,ur,dr,lr,pr,mr,Ur,Er,wr,Ar,Lr,Hr,Ir,Br],requestBody:{parameterPath:"blocks",mapper:M({},je,{required:!0})},contentType:"application/xml; charset=utf-8",responses:{201:{headersMapper:Ut},default:{bodyMapper:He}},isXML:!0,serializer:Bn},kn={httpMethod:"GET",path:"{containerName}/{blob}",urlParameters:[gi],queryParameters:[ni,{parameterPath:"listType",mapper:{required:!0,serializedName:"blocklisttype",defaultValue:"committed",type:{name:"Enum",allowedValues:["committed","uncommitted","all"]}}},yi,Cr],headerParameters:[Ni,ei,Ur],responses:{200:{bodyMapper:Ve,headersMapper:Ft},default:{bodyMapper:He}},isXML:!0,serializer:Bn};function Un(e){if(e.offset<0)throw new RangeError("IRange.offset cannot be smaller than 0.");if(e.count&&e.count<=0)throw new RangeError("IRange.count must be larger than 0. Leave it undefined if you want a range from offset to the end.");return e.count?"bytes="+e.offset+"-"+(e.offset+e.count-1):"bytes="+e.offset+"-"}var Fn,Vn,jn=268435456,Xn=104857600,Gn=5e4,Kn=4194304,Wn={FORCE_BROWSER_NO_CACHE:"_",SIGNATURE:"sig",SNAPSHOT:"snapshot",TIMEOUT:"timeout"},$n=202,Qn=409,Yn=404,Jn=412,Zn=416,ea={AUTHORIZATION:"Authorization",AUTHORIZATION_SCHEME:"Bearer",CONTENT_ENCODING:"Content-Encoding",CONTENT_ID:"Content-ID",CONTENT_LANGUAGE:"Content-Language",CONTENT_LENGTH:"Content-Length",CONTENT_MD5:"Content-Md5",CONTENT_TRANSFER_ENCODING:"Content-Transfer-Encoding",CONTENT_TYPE:"Content-Type",COOKIE:"Cookie",DATE:"date",IF_MATCH:"if-match",IF_MODIFIED_SINCE:"if-modified-since",IF_NONE_MATCH:"if-none-match",IF_UNMODIFIED_SINCE:"if-unmodified-since",PREFIX_FOR_STORAGE:"x-ms-",RANGE:"Range",USER_AGENT:"User-Agent",X_MS_CLIENT_REQUEST_ID:"x-ms-client-request-id",X_MS_DATE:"x-ms-date",X_MS_ERROR_CODE:"x-ms-error-code",X_MS_VERSION:"x-ms-version"},ta="\r\n",ra="AES256";function ia(e){if(null!=e)return e}function na(e,t){if(e&&!t)throw new RangeError("Customer-provided encryption key must be used over HTTPS.");e&&!e.encryptionAlgorithm&&(e.encryptionAlgorithm=ra)}function aa(e){var t=pe.parse(e),r=t.getPath();return r=r||"/",r=encodeURIComponent(r).replace(/%2F/g,"/").replace(/'/g,"%27").replace(/\+/g,"%20").replace(/%25/g,"%"),t.setPath(r),t.toString()}function sa(e,t){var r=pe.parse(e),i=r.getPath();return i=i?i.endsWith("/")?""+i+t:i+"/"+t:t,r.setPath(i),r.toString()}function oa(e,t,r){var i=pe.parse(e);return i.setQueryParameter(t,r),i.toString()}function ma(e){var t=pe.parse(e),r=t.getPath();if(!r)throw new RangeError("Invalid url without valid path.");var i=t.getQuery()||"";return""!=(i=i.trim())&&(i=i.startsWith("?")?i:"?"+i),""+r+i}function da(e,t){void 0===t&&(t=!0);var r=e.toISOString();return t?r.substring(0,r.length-1)+"0000Z":r.substring(0,r.length-5)+"Z"}function la(e,t){e.length>42&&(e=e.slice(0,42));var r,i=e+function(e,t,r){void 0===r&&(r=" ");if(String.prototype.padStart)return e.padStart(t,r);return r=r||" ",e.length>t?e:((t-=e.length)>r.length&&(r+=r.repeat(t/r.length)),r.slice(0,t)+e)}(t.toString(),48-e.length,"0");return r=i,c?Buffer.from(r).toString("base64"):btoa(r)}function ca(e,t,r){return A(this,void 0,void 0,function(){return E(this,function(i){return[2,new Promise(function(i,n){var a,s=function(){void 0!==a&&clearTimeout(a),n(r)};a=setTimeout(function(){void 0!==t&&t.removeEventListener("abort",s),i()},e),void 0!==t&&t.addEventListener("abort",s)})]})})}function pa(e,t){return e.toLocaleLowerCase()===t.toLocaleLowerCase()}(Fn=e.BlockBlobTier||(e.BlockBlobTier={})).Hot="Hot",Fn.Cool="Cool",Fn.Archive="Archive",(Vn=e.PremiumPageBlobTier||(e.PremiumPageBlobTier={})).P4="P4",Vn.P6="P6",Vn.P10="P10",Vn.P15="P15",Vn.P20="P20",Vn.P30="P30",Vn.P40="P40",Vn.P50="P50",Vn.P60="P60",Vn.P70="P70",Vn.P80="P80";var ua,ya=function(e){function t(t,r){return e.call(this,t,r)||this}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return"GET"!==e.method.toUpperCase()&&"HEAD"!==e.method.toUpperCase()||(e.url=oa(e.url,Wn.FORCE_BROWSER_NO_CACHE,(new Date).getTime().toString())),e.headers.remove(ea.COOKIE),e.headers.remove(ea.CONTENT_LENGTH),[2,this._nextPolicy.sendRequest(e)]})})},t}(W),ha=function(){function e(){}return e.prototype.create=function(e,t){return new ya(e,t)},e}(),fa=function(){function e(){}return e.prototype.create=function(e,t){throw new Error("Method should be implemented in children classes.")},e}(),ga="azure-storage-blob",Na="1.0.0",ba=function(e){function t(t,r){var i=this;if(null==t)throw new Error("'url' cannot be null.");if(r||(r={}),!r.userAgent){var n=de();r.userAgent=ga+"/"+Na+" "+n}return(i=e.call(this,void 0,r)||this).version="2019-02-02",i.baseUri="{url}",i.requestContentType="application/json; charset=utf-8",i.url=t,null!==r.pathRenameMode&&void 0!==r.pathRenameMode&&(i.pathRenameMode=r.pathRenameMode),i}return T(t,e),t}(Ee),va=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n.keepAliveOptions=i,n}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return e.keepAlive=this.keepAliveOptions.enable,[2,this._nextPolicy.sendRequest(e)]})})},t}(W),Sa=function(){function e(e){void 0===e&&(e={enable:!0}),this.keepAliveOptions=e}return e.prototype.create=function(e,t){return new va(e,t,this.keepAliveOptions)},e}(),Ca={logWarningIfTryOverThreshold:3e3},za=function(t){function r(e,r,i){void 0===i&&(i=Ca);var n=t.call(this,e,r)||this;return n.tryCount=0,n.operationStartTime=new Date,n.requestStartTime=new Date,n.loggingOptions=i,n}return T(r,t),r.prototype.sendRequest=function(t){return A(this,void 0,void 0,function(){var r,i,n,a,s,o,m,d,l,c;return E(this,function(p){switch(p.label){case 0:this.tryCount++,this.requestStartTime=new Date,1===this.tryCount&&(this.operationStartTime=this.requestStartTime),function(e,t){return pe.parse(e).getQueryParameterValue(t)}(r=t.url,Wn.SIGNATURE)&&(r=oa(r,Wn.SIGNATURE,"*****")),this.log(e.HttpPipelineLogLevel.INFO,"'"+r+"'==> OUTGOING REQUEST (Try number="+this.tryCount+")."),p.label=1;case 1:return p.trys.push([1,3,,4]),[4,this._nextPolicy.sendRequest(t)];case 2:return i=p.sent(),n=new Date,a=n.getTime()-this.requestStartTime.getTime(),s=n.getTime()-this.operationStartTime.getTime(),o=e.HttpPipelineLogLevel.INFO,m="",this.shouldLog(e.HttpPipelineLogLevel.INFO)&&(m="Successfully Received Response. "),a>=this.loggingOptions.logWarningIfTryOverThreshold&&this.shouldLog(e.HttpPipelineLogLevel.WARNING)&&(o=e.HttpPipelineLogLevel.WARNING,m="SLOW OPERATION. Duration > "+this.loggingOptions.logWarningIfTryOverThreshold+" ms. "),(i.status>=400&&i.status<=499&&i.status!==Yn&&i.status!==Qn&&i.status!==Jn&&i.status!==Zn||i.status>=500&&i.status<=509)&&(d="REQUEST ERROR: HTTP request failed with status code: "+i.status+". ",m=d,o=e.HttpPipelineLogLevel.ERROR),l="Request try:"+this.tryCount+", status:"+i.status+" request duration:"+a+" ms, operation duration:"+s+" ms\n",this.log(o,m+l),[2,i];case 3:throw c=p.sent(),this.log(e.HttpPipelineLogLevel.ERROR,"Unexpected failure attempting to make request. Error message: "+c.message),c;case 4:return[2]}})})},r}(W),Pa=function(){function e(e){this.loggingOptions=e}return e.prototype.create=function(e,t){return new za(e,t,this.loggingOptions)},e}(),xa=function(){function e(e,t){void 0===t&&(t={}),this.factories=e,this.options=t}return e.prototype.toServiceClientOptions=function(){return{httpClient:this.options.HTTPClient,httpPipelineLogger:this.options.logger,requestPolicyFactories:this.factories}},e}();(ua=e.RetryPolicyType||(e.RetryPolicyType={}))[ua.EXPONENTIAL=0]="EXPONENTIAL",ua[ua.FIXED=1]="FIXED";var Ra,qa={maxRetryDelayInMs:12e4,maxTries:4,retryDelayInMs:4e3,retryPolicyType:e.RetryPolicyType.EXPONENTIAL,secondaryHost:"",tryTimeoutInMs:void 0},Ta=new I("The request was aborted",I.REQUEST_ABORTED_ERROR),Ma=function(t){function r(e,r,i){void 0===i&&(i=qa);var n=t.call(this,e,r)||this;return n.retryOptions={retryPolicyType:i.retryPolicyType?i.retryPolicyType:qa.retryPolicyType,maxTries:i.maxTries&&i.maxTries>=1?Math.floor(i.maxTries):qa.maxTries,tryTimeoutInMs:i.tryTimeoutInMs&&i.tryTimeoutInMs>=0?i.tryTimeoutInMs:qa.tryTimeoutInMs,retryDelayInMs:i.retryDelayInMs&&i.retryDelayInMs>=0?Math.min(i.retryDelayInMs,i.maxRetryDelayInMs?i.maxRetryDelayInMs:qa.maxRetryDelayInMs):qa.retryDelayInMs,maxRetryDelayInMs:i.maxRetryDelayInMs&&i.maxRetryDelayInMs>=0?i.maxRetryDelayInMs:qa.maxRetryDelayInMs,secondaryHost:i.secondaryHost?i.secondaryHost:qa.secondaryHost},n}return T(r,t),r.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this.attemptSendRequest(e,!1,1)]})})},r.prototype.attemptSendRequest=function(t,r,i){return A(this,void 0,void 0,function(){var n,a,s,o;return E(this,function(m){switch(m.label){case 0:n=t.clone(),(a=r||!this.retryOptions.secondaryHost||!("GET"===t.method||"HEAD"===t.method||"OPTIONS"===t.method)||i%2==1)||(n.url=function(e,t){var r=pe.parse(e);return r.setHost(t),r.toString()}(n.url,this.retryOptions.secondaryHost)),this.retryOptions.tryTimeoutInMs&&(n.url=oa(n.url,Wn.TIMEOUT,Math.floor(this.retryOptions.tryTimeoutInMs/1e3).toString())),m.label=1;case 1:return m.trys.push([1,3,,4]),this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: =====> Try="+i+" "+(a?"Primary":"Secondary")),[4,this._nextPolicy.sendRequest(n)];case 2:return s=m.sent(),this.shouldRetry(a,i,s)?(r=r||!a&&404===s.status,[3,4]):[2,s];case 3:if(o=m.sent(),this.logf(e.HttpPipelineLogLevel.ERROR,"RetryPolicy: Caught error, message: "+o.message+", code: "+o.code),!this.shouldRetry(a,i,s,o))throw o;return[3,4];case 4:return[4,this.delay(a,i,t.abortSignal)];case 5:return m.sent(),[4,this.attemptSendRequest(t,r,++i)];case 6:return[2,m.sent()]}})})},r.prototype.shouldRetry=function(t,r,i,n){if(r>=this.retryOptions.maxTries)return this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: Attempt(s) "+r+" >= maxTries "+this.retryOptions.maxTries+", no further try."),!1;if(n)for(var a=0,s=["ETIMEDOUT","ESOCKETTIMEDOUT","ECONNREFUSED","ECONNRESET","ENOENT","ENOTFOUND","TIMEOUT","REQUEST_SEND_ERROR"];a<s.length;a++){var o=s[a];if(n.name.toUpperCase().includes(o)||n.message.toUpperCase().includes(o)||n.code&&n.code.toString().toUpperCase().includes(o))return this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: Network error "+o+" found, will retry."),!0}if(i||n){var m=i?i.status:n?n.statusCode:0;if(!t&&404===m)return this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: Secondary access with 404, will retry."),!0;if(503===m||500===m)return this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: Will retry for status code "+m+"."),!0}return!1},r.prototype.logf=function(e,t){},r.prototype.delay=function(t,r,i){return A(this,void 0,void 0,function(){var n;return E(this,function(a){if(n=0,t)switch(this.retryOptions.retryPolicyType){case e.RetryPolicyType.EXPONENTIAL:n=Math.min((Math.pow(2,r-1)-1)*this.retryOptions.retryDelayInMs,this.retryOptions.maxRetryDelayInMs);break;case e.RetryPolicyType.FIXED:n=this.retryOptions.retryDelayInMs}else n=1e3*Math.random();return this.logf(e.HttpPipelineLogLevel.INFO,"RetryPolicy: Delay for "+n+"ms"),[2,ca(n,i,Ta)]})})},r}(W),Aa=function(){function e(e){this.retryOptions=e}return e.prototype.create=function(e,t){return new Ma(e,t,this.retryOptions)},e}(),Ea=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n.telemetry=i,n}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this._nextPolicy.sendRequest(e)]})})},t}(W),wa=function(){function e(e){this.telemetryString=[].join(" ")}return e.prototype.create=function(e,t){return new Ea(e,t,this.telemetryString)},e}(),Ia=function(e){function t(t,r){return e.call(this,t,r)||this}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return e.headers.contains(ea.X_MS_CLIENT_REQUEST_ID)||e.headers.set(ea.X_MS_CLIENT_REQUEST_ID,y()),[2,this._nextPolicy.sendRequest(e)]})})},t}(W),La=function(){function e(){}return e.prototype.create=function(e,t){return new Ia(e,t)},e}(),Ba=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return T(t,e),t.prototype.sendRequest=function(e){return this._nextPolicy.sendRequest(this.signRequest(e))},t.prototype.signRequest=function(e){return e},t}(W),Da=function(e){function t(t,r){return e.call(this,t,r)||this}return T(t,e),t}(Ba),Oa=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return T(t,e),t.prototype.create=function(e,t){return new Da(e,t)},t}(fa),_a=function(){function e(e,t){this.url=aa(e),this.pipeline=t,this.storageClientContext=new ba(this.url,t.toServiceClientOptions()),this.isHttps=pa(function(e){return pe.parse(e).getScheme()}(this.url)||"","https"),this.credential=new Oa;for(var r=0,i=this.pipeline.factories;r<i.length;r++){var n=i[r];n instanceof fa&&(this.credential=n)}this.storageClientContext.requestContentType=void 0}return e.newPipeline=function(e,t){void 0===t&&(t={});var r=[new Sa(t.keepAliveOptions),new wa(t.telemetry),new La,new ha,Q(),new Aa(t.retryOptions),new Pa,e];return new xa(r,{HTTPClient:t.httpClient,logger:t.logger})},e}(),Ha=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.blobContext=new Gi(i.storageClientContext),i}return T(t,e),t.fromContainerURL=function(e,r){return new t(sa(e.url,encodeURIComponent(r)),e.pipeline)},t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.withSnapshot=function(e){return new t(oa(this.url,Wn.SNAPSHOT,0===e.length?void 0:e),this.pipeline)},t.prototype.download=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){var n,a=this;return E(this,function(s){switch(s.label){case 0:return i.blobAccessConditions=i.blobAccessConditions||{},i.blobAccessConditions.modifiedAccessConditions=i.blobAccessConditions.modifiedAccessConditions||{},na(i.customerProvidedKey,this.isHttps),[4,this.blobContext.download({abortSignal:e,leaseAccessConditions:i.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:i.blobAccessConditions.modifiedAccessConditions,onDownloadProgress:c?void 0:i.progress,range:0!==t||r?Un({offset:t,count:r}):void 0,rangeGetContentMD5:i.rangeGetContentMD5,rangeGetContentCRC64:i.rangeGetContentCrc64,snapshot:i.snapshot,cpkInfo:i.customerProvidedKey})];case 1:if(n=s.sent(),!c)return[2,n];if((void 0===i.maxRetryRequests||i.maxRetryRequests<0)&&(i.maxRetryRequests=5),void 0===n.contentLength)throw new RangeError("File download response doesn't contain valid content length header");if(!n.eTag)throw new RangeError("File download response doesn't contain valid etag header");return[2,new 1(e,n,function(r){return A(a,void 0,void 0,function(){var a;return E(this,function(s){switch(s.label){case 0:return a={leaseAccessConditions:i.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:{ifMatch:i.blobAccessConditions.modifiedAccessConditions.ifMatch||n.eTag,ifModifiedSince:i.blobAccessConditions.modifiedAccessConditions.ifModifiedSince,ifNoneMatch:i.blobAccessConditions.modifiedAccessConditions.ifNoneMatch,ifUnmodifiedSince:i.blobAccessConditions.modifiedAccessConditions.ifUnmodifiedSince},range:Un({count:t+n.contentLength-r,offset:r}),rangeGetContentMD5:i.rangeGetContentMD5,rangeGetContentCRC64:i.rangeGetContentCrc64,snapshot:i.snapshot,cpkInfo:i.customerProvidedKey},[4,this.blobContext.download(M({abortSignal:e},a))];case 1:return[2,s.sent().readableStreamBody]}})})},t,n.contentLength,{maxRetryRequests:i.maxRetryRequests,progress:i.progress})]}})})},t.prototype.getProperties=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return t.blobAccessConditions=t.blobAccessConditions||{},na(t.customerProvidedKey,this.isHttps),[2,this.blobContext.getProperties({abortSignal:e,leaseAccessConditions:t.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:t.blobAccessConditions.modifiedAccessConditions,cpkInfo:t.customerProvidedKey})]})})},t.prototype.delete=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return t.blobAccessConditions=t.blobAccessConditions||{},[2,this.blobContext.deleteMethod({abortSignal:e,deleteSnapshots:t.deleteSnapshots,leaseAccessConditions:t.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:t.blobAccessConditions.modifiedAccessConditions})]})})},t.prototype.undelete=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this.blobContext.undelete({abortSignal:e})]})})},t.prototype.setHTTPHeaders=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.blobAccessConditions=r.blobAccessConditions||{},na(r.customerProvidedKey,this.isHttps),[2,this.blobContext.setHTTPHeaders({abortSignal:e,blobHTTPHeaders:t,leaseAccessConditions:r.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:r.blobAccessConditions.modifiedAccessConditions,cpkInfo:r.customerProvidedKey})]})})},t.prototype.setMetadata=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.blobAccessConditions=r.blobAccessConditions||{},na(r.customerProvidedKey,this.isHttps),[2,this.blobContext.setMetadata({abortSignal:e,leaseAccessConditions:r.blobAccessConditions.leaseAccessConditions,metadata:t,modifiedAccessConditions:r.blobAccessConditions.modifiedAccessConditions,cpkInfo:r.customerProvidedKey})]})})},t.prototype.acquireLease=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return[2,this.blobContext.acquireLease({abortSignal:e,duration:r,modifiedAccessConditions:i.modifiedAccessConditions,proposedLeaseId:t})]})})},t.prototype.releaseLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.blobContext.releaseLease(t,{abortSignal:e,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.renewLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.blobContext.renewLease(t,{abortSignal:e,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.changeLease=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return[2,this.blobContext.changeLease(t,r,{abortSignal:e,modifiedAccessConditions:i.modifiedAccessConditions})]})})},t.prototype.breakLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.blobContext.breakLease({abortSignal:e,breakPeriod:t,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.createSnapshot=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return t.blobAccessConditions=t.blobAccessConditions||{},na(t.customerProvidedKey,this.isHttps),[2,this.blobContext.createSnapshot({abortSignal:e,leaseAccessConditions:t.blobAccessConditions.leaseAccessConditions,metadata:t.metadata,modifiedAccessConditions:t.blobAccessConditions.modifiedAccessConditions,cpkInfo:t.customerProvidedKey})]})})},t.prototype.startCopyFromURL=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.blobAccessConditions=r.blobAccessConditions||{},r.sourceModifiedAccessConditions=r.sourceModifiedAccessConditions||{},[2,this.blobContext.startCopyFromURL(t,{abortSignal:e,leaseAccessConditions:r.blobAccessConditions.leaseAccessConditions,metadata:r.metadata,modifiedAccessConditions:r.blobAccessConditions.modifiedAccessConditions,sourceModifiedAccessConditions:{sourceIfMatch:r.sourceModifiedAccessConditions.ifMatch,sourceIfModifiedSince:r.sourceModifiedAccessConditions.ifModifiedSince,sourceIfNoneMatch:r.sourceModifiedAccessConditions.ifNoneMatch,sourceIfUnmodifiedSince:r.sourceModifiedAccessConditions.ifUnmodifiedSince},rehydratePriority:r.rehydratePriority,tier:ia(r.tier)})]})})},t.prototype.abortCopyFromURL=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.blobContext.abortCopyFromURL(t,{abortSignal:e,leaseAccessConditions:r.leaseAccessConditions})]})})},t.prototype.syncCopyFromURL=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.blobAccessConditions=r.blobAccessConditions||{},r.sourceModifiedAccessConditions=r.sourceModifiedAccessConditions||{},[2,this.blobContext.copyFromURL(t,{abortSignal:e,metadata:r.metadata,leaseAccessConditions:r.blobAccessConditions.leaseAccessConditions,modifiedAccessConditions:r.blobAccessConditions.modifiedAccessConditions,sourceModifiedAccessConditions:{sourceIfMatch:r.sourceModifiedAccessConditions.ifMatch,sourceIfModifiedSince:r.sourceModifiedAccessConditions.ifModifiedSince,sourceIfNoneMatch:r.sourceModifiedAccessConditions.ifNoneMatch,sourceIfUnmodifiedSince:r.sourceModifiedAccessConditions.ifUnmodifiedSince}})]})})},t.prototype.setTier=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){switch(i.label){case 0:return[4,this.blobContext.setTier(ia(t),{abortSignal:e,leaseAccessConditions:r.leaseAccessConditions,rehydratePriority:r.rehydratePriority})];case 1:return[2,i.sent()]}})})},t}(_a),ka=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.appendBlobContext=new Tn(i.storageClientContext),i}return T(t,e),t.fromContainerURL=function(e,r){return new t(sa(e.url,encodeURIComponent(r)),e.pipeline)},t.fromBlobURL=function(e){return new t(e.url,e.pipeline)},t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.withSnapshot=function(e){return new t(oa(this.url,Wn.SNAPSHOT,0===e.length?void 0:e),this.pipeline)},t.prototype.create=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return t.accessConditions=t.accessConditions||{},na(t.customerProvidedKey,this.isHttps),[2,this.appendBlobContext.create(0,{abortSignal:e,blobHTTPHeaders:t.blobHTTPHeaders,leaseAccessConditions:t.accessConditions.leaseAccessConditions,metadata:t.metadata,modifiedAccessConditions:t.accessConditions.modifiedAccessConditions,cpkInfo:t.customerProvidedKey})]})})},t.prototype.appendBlock=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return i.accessConditions=i.accessConditions||{},na(i.customerProvidedKey,this.isHttps),[2,this.appendBlobContext.appendBlock(t,r,{abortSignal:e,appendPositionAccessConditions:i.accessConditions.appendPositionAccessConditions,leaseAccessConditions:i.accessConditions.leaseAccessConditions,modifiedAccessConditions:i.accessConditions.modifiedAccessConditions,onUploadProgress:i.progress,transactionalContentMD5:i.transactionalContentMD5,transactionalContentCrc64:i.transactionalContentCrc64,cpkInfo:i.customerProvidedKey})]})})},t.prototype.appendBlockFromURL=function(e,t,r,i,n){return void 0===n&&(n={}),A(this,void 0,void 0,function(){return E(this,function(a){return n.accessConditions=n.accessConditions||{},n.sourceModifiedAccessConditions=n.sourceModifiedAccessConditions||{},na(n.customerProvidedKey,this.isHttps),[2,this.appendBlobContext.appendBlockFromUrl(t,0,{abortSignal:e,sourceRange:Un({offset:r,count:i}),sourceContentMD5:n.sourceContentMD5,sourceContentCrc64:n.sourceContentCrc64,leaseAccessConditions:n.accessConditions.leaseAccessConditions,appendPositionAccessConditions:n.accessConditions.appendPositionAccessConditions,modifiedAccessConditions:n.accessConditions.modifiedAccessConditions,sourceModifiedAccessConditions:{sourceIfMatch:n.sourceModifiedAccessConditions.ifMatch,sourceIfModifiedSince:n.sourceModifiedAccessConditions.ifModifiedSince,sourceIfNoneMatch:n.sourceModifiedAccessConditions.ifNoneMatch,sourceIfUnmodifiedSince:n.sourceModifiedAccessConditions.ifUnmodifiedSince},cpkInfo:n.customerProvidedKey})]})})},t}(Ha);!function(e){e[e.LOCKED=0]="LOCKED",e[e.UNLOCKED=1]="UNLOCKED"}(Ra||(Ra={}));var Ua,Fa=function(){function e(){}return e.lock=function(e){return A(this,void 0,void 0,function(){var t=this;return E(this,function(r){return[2,new Promise(function(r){void 0===t.keys[e]||t.keys[e]===Ra.UNLOCKED?(t.keys[e]=Ra.LOCKED,r()):t.onUnlockEvent(e,function(){t.keys[e]=Ra.LOCKED,r()})})]})})},e.unlock=function(e){return A(this,void 0,void 0,function(){var t=this;return E(this,function(r){return[2,new Promise(function(r){t.keys[e]===Ra.LOCKED&&t.emitUnlockEvent(e),delete t.keys[e],r()})]})})},e.onUnlockEvent=function(e,t){void 0===this.listeners[e]?this.listeners[e]=[t]:this.listeners[e].push(t)},e.emitUnlockEvent=function(e){var t=this;if(void 0!==this.listeners[e]&&this.listeners[e].length>0){var r=this.listeners[e].shift();setImmediate(function(){r.call(t)})}},e.keys={},e.listeners={},e}(),Va=function(){function e(){this.batch="batch",this.batchRequest=new Ga}return e.prototype.getMultiPartContentType=function(){return this.batchRequest.getMultipartContentType()},e.prototype.getHttpRequestBody=function(){return this.batchRequest.getHttpRequestBody()},e.prototype.getSubRequests=function(){return this.batchRequest.getSubRequests()},e.prototype.addSubRequestInternal=function(e,t){return A(this,void 0,void 0,function(){return E(this,function(r){switch(r.label){case 0:return[4,Fa.lock(this.batch)];case 1:r.sent(),r.label=2;case 2:return r.trys.push([2,,4,6]),this.batchRequest.preAddSubRequest(e),[4,t()];case 3:return r.sent(),this.batchRequest.postAddSubRequest(e),[3,6];case 4:return[4,Fa.unlock(this.batch)];case 5:return r.sent(),[7];case 6:return[2]}})})},e}(),ja=function(e){function t(){return e.call(this)||this}return T(t,e),t.prototype.addSubRequest=function(t,r,i){return A(this,void 0,void 0,function(){var n,a,s=this;return E(this,function(o){switch(o.label){case 0:if("string"==typeof t&&r instanceof fa)n=t,a=r;else{if(!(t instanceof Ha))throw new RangeError("Invalid arguments. Either url and credential, or BlobURL need be provided.");n=t.url,a=t.credential,i=r}return i||(i={}),[4,e.prototype.addSubRequestInternal.call(this,{url:n,credential:a},function(){return A(s,void 0,void 0,function(){return E(this,function(e){switch(e.label){case 0:return[4,new Ha(n,this.batchRequest.createPipeline(a)).delete(De.none,i)];case 1:return e.sent(),[2]}})})})];case 1:return o.sent(),[2]}})})},t}(Va),Xa=function(e){function t(){return e.call(this)||this}return T(t,e),t.prototype.addSubRequest=function(t,r,i,n){return A(this,void 0,void 0,function(){var a,s,o,m=this;return E(this,function(d){switch(d.label){case 0:if("string"==typeof t&&r instanceof fa)a=t,s=r,o=i;else{if(!(t instanceof Ha))throw new RangeError("Invalid arguments. Either url and credential, or BlobURL need be provided.");a=t.url,s=t.credential,o=r,n=i}return n||(n={}),[4,e.prototype.addSubRequestInternal.call(this,{url:a,credential:s},function(){return A(m,void 0,void 0,function(){return E(this,function(e){switch(e.label){case 0:return[4,new Ha(a,this.batchRequest.createPipeline(s)).setTier(De.none,o,n)];case 1:return e.sent(),[2]}})})})];case 1:return d.sent(),[2]}})})},t}(Va),Ga=function(){function e(){this.operationCount=0,this.body="";var e=y();this.boundary="batch_"+e,this.subRequestPrefix="--"+this.boundary+ta+ea.CONTENT_TYPE+": application/http"+ta+ea.CONTENT_TRANSFER_ENCODING+": binary",this.multipartContentType="multipart/mixed; boundary="+this.boundary,this.batchRequestEnding="--"+this.boundary+"--",this.subRequests=new Map}return e.prototype.createPipeline=function(e){var t=e instanceof Oa,r=3+(t?0:1),i=new Array(r);return i[0]=Q(),i[1]=new Qa,t||(i[2]=e),i[r-1]=new Wa(this),new xa(i,{})},e.prototype.appendSubRequestToBody=function(e){this.body+=[this.subRequestPrefix,ea.CONTENT_ID+": "+this.operationCount,"",e.method.toString()+" "+ma(e.url)+" HTTP/1.1"+ta].join(ta);for(var t=0,r=e.headers.headersArray();t<r.length;t++){var i=r[t];this.body+=i.name+": "+i.value+ta}this.body+=ta},e.prototype.preAddSubRequest=function(e){if(this.operationCount>=256)throw new RangeError("Cannot exceed 256 sub requests in a single batch");var t=function(e){return pe.parse(e).getPath()}(e.url);if(!t||""==t)throw new RangeError("Invalid url for sub request: '"+e.url+"'")},e.prototype.postAddSubRequest=function(e){this.subRequests.set(this.operationCount,e),this.operationCount++},e.prototype.getHttpRequestBody=function(){return""+this.body+this.batchRequestEnding+ta},e.prototype.getMultipartContentType=function(){return this.multipartContentType},e.prototype.getSubRequests=function(){return this.subRequests},e}(),Ka=function(e){function t(t,i,n){var a=e.call(this,i,n)||this;return a.dummyResponse={request:new R,status:200,headers:new r},a.batchRequest=t,a}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){switch(t.label){case 0:return[4,this.batchRequest.appendSubRequestToBody(e)];case 1:return t.sent(),[2,this.dummyResponse]}})})},t}(W),Wa=function(){function e(e){this.batchRequest=e}return e.prototype.create=function(e,t){return new Ka(this.batchRequest,e,t)},e}(),$a=function(e){function t(t,r){return e.call(this,t,r)||this}return T(t,e),t.prototype.sendRequest=function(e){return A(this,void 0,void 0,function(){var t,r,i,n;return E(this,function(a){for(t="",r=0,i=e.headers.headersArray();r<i.length;r++)pa((n=i[r]).name,ea.X_MS_VERSION)&&(t=n.name);return""!==t&&e.headers.remove(t),[2,this._nextPolicy.sendRequest(e)]})})},t}(W),Qa=function(){function e(){}return e.prototype.create=function(e,t){return new $a(e,t)},e}(),Ya=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.blockBlobContext=new Ln(i.storageClientContext),i}return T(t,e),t.fromContainerURL=function(e,r){return new t(sa(e.url,encodeURIComponent(r)),e.pipeline)},t.fromBlobURL=function(e){return new t(e.url,e.pipeline)},t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.withSnapshot=function(e){return new t(oa(this.url,Wn.SNAPSHOT,0===e.length?void 0:e),this.pipeline)},t.prototype.upload=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return i.accessConditions=i.accessConditions||{},na(i.customerProvidedKey,this.isHttps),[2,this.blockBlobContext.upload(t,r,{abortSignal:e,blobHTTPHeaders:i.blobHTTPHeaders,leaseAccessConditions:i.accessConditions.leaseAccessConditions,metadata:i.metadata,modifiedAccessConditions:i.accessConditions.modifiedAccessConditions,onUploadProgress:i.progress,cpkInfo:i.customerProvidedKey,tier:ia(i.tier)})]})})},t.prototype.stageBlock=function(e,t,r,i,n){return void 0===n&&(n={}),A(this,void 0,void 0,function(){return E(this,function(a){return na(n.customerProvidedKey,this.isHttps),[2,this.blockBlobContext.stageBlock(t,i,r,{abortSignal:e,leaseAccessConditions:n.leaseAccessConditions,onUploadProgress:n.progress,transactionalContentMD5:n.transactionalContentMD5,transactionalContentCrc64:n.transactionalContentCrc64,cpkInfo:n.customerProvidedKey})]})})},t.prototype.stageBlockFromURL=function(e,t,r,i,n,a){return void 0===a&&(a={}),A(this,void 0,void 0,function(){return E(this,function(s){return na(a.customerProvidedKey,this.isHttps),[2,this.blockBlobContext.stageBlockFromURL(t,0,r,{abortSignal:e,leaseAccessConditions:a.leaseAccessConditions,sourceContentMD5:a.sourceContentMD5,sourceContentCrc64:a.sourceContentCrc64,sourceRange:0!==i||n?Un({offset:i,count:n}):void 0,cpkInfo:a.customerProvidedKey})]})})},t.prototype.commitBlockList=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.accessConditions=r.accessConditions||{},na(r.customerProvidedKey,this.isHttps),[2,this.blockBlobContext.commitBlockList({latest:t},{abortSignal:e,blobHTTPHeaders:r.blobHTTPHeaders,leaseAccessConditions:r.accessConditions.leaseAccessConditions,metadata:r.metadata,modifiedAccessConditions:r.accessConditions.modifiedAccessConditions,cpkInfo:r.customerProvidedKey,tier:ia(r.tier)})]})})},t.prototype.getBlockList=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){var i;return E(this,function(n){switch(n.label){case 0:return[4,this.blockBlobContext.getBlockList(t,{abortSignal:e,leaseAccessConditions:r.leaseAccessConditions})];case 1:return(i=n.sent()).committedBlocks||(i.committedBlocks=[]),i.uncommittedBlocks||(i.uncommittedBlocks=[]),[2,i]}})})},t}(Ha),Ja=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.containerContext=new Mi(i.storageClientContext),i}return T(t,e),t.fromServiceURL=function(e,r){return new t(sa(e.url,encodeURIComponent(r)),e.pipeline)},t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.create=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return[2,this.containerContext.create(M({},t,{abortSignal:e}))]})})},t.prototype.getProperties=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){return t.leaseAccessConditions||(t.leaseAccessConditions={}),[2,this.containerContext.getProperties(M({abortSignal:e},t.leaseAccessConditions))]})})},t.prototype.delete=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){return E(this,function(r){if(t.containerAccessConditions||(t.containerAccessConditions={}),t.containerAccessConditions.modifiedAccessConditions||(t.containerAccessConditions.modifiedAccessConditions={}),t.containerAccessConditions.leaseAccessConditions||(t.containerAccessConditions.leaseAccessConditions={}),t.containerAccessConditions.modifiedAccessConditions.ifMatch&&""!==t.containerAccessConditions.modifiedAccessConditions.ifMatch||t.containerAccessConditions.modifiedAccessConditions.ifNoneMatch&&""!==t.containerAccessConditions.modifiedAccessConditions.ifNoneMatch)throw new RangeError("the IfMatch and IfNoneMatch access conditions must have their default        values because they are ignored by the service");return[2,this.containerContext.deleteMethod({abortSignal:e,leaseAccessConditions:t.containerAccessConditions.leaseAccessConditions,modifiedAccessConditions:t.containerAccessConditions.modifiedAccessConditions})]})})},t.prototype.setMetadata=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){if(r.containerAccessConditions||(r.containerAccessConditions={}),r.containerAccessConditions.modifiedAccessConditions||(r.containerAccessConditions.modifiedAccessConditions={}),r.containerAccessConditions.leaseAccessConditions||(r.containerAccessConditions.leaseAccessConditions={}),r.containerAccessConditions.modifiedAccessConditions.ifUnmodifiedSince||r.containerAccessConditions.modifiedAccessConditions.ifMatch&&""!==r.containerAccessConditions.modifiedAccessConditions.ifMatch||r.containerAccessConditions.modifiedAccessConditions.ifNoneMatch&&""!==r.containerAccessConditions.modifiedAccessConditions.ifNoneMatch)throw new RangeError("the IfUnmodifiedSince, IfMatch, and IfNoneMatch must have their default values        because they are ignored by the blob service");return[2,this.containerContext.setMetadata({abortSignal:e,leaseAccessConditions:r.containerAccessConditions.leaseAccessConditions,metadata:t,modifiedAccessConditions:r.containerAccessConditions.modifiedAccessConditions})]})})},t.prototype.getAccessPolicy=function(e,t){return void 0===t&&(t={}),A(this,void 0,void 0,function(){var r,i,n,a,s,o;return E(this,function(m){switch(m.label){case 0:return t.leaseAccessConditions||(t.leaseAccessConditions={}),[4,this.containerContext.getAccessPolicy({abortSignal:e,leaseAccessConditions:t.leaseAccessConditions})];case 1:for(r=m.sent(),i={_response:r._response,blobPublicAccess:r.blobPublicAccess,date:r.date,eTag:r.eTag,errorCode:r.errorCode,lastModified:r.lastModified,requestId:r.requestId,clientRequestId:r.clientRequestId,signedIdentifiers:[],version:r.version},n=0,a=r;n<a.length;n++)s=a[n],o={permission:s.accessPolicy.permission},s.accessPolicy.expiry&&(o.expiry=new Date(s.accessPolicy.expiry)),s.accessPolicy.start&&(o.start=new Date(s.accessPolicy.start)),i.signedIdentifiers.push({accessPolicy:o,id:s.id});return[2,i]}})})},t.prototype.setAccessPolicy=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){var n,a,s,o;return E(this,function(m){for(i.containerAccessConditions=i.containerAccessConditions||{},n=[],a=0,s=r||[];a<s.length;a++)o=s[a],n.push({accessPolicy:{expiry:o.accessPolicy.expiry?da(o.accessPolicy.expiry):"",permission:o.accessPolicy.permission,start:o.accessPolicy.start?da(o.accessPolicy.start):""},id:o.id});return[2,this.containerContext.setAccessPolicy({abortSignal:e,access:t,containerAcl:n,leaseAccessConditions:i.containerAccessConditions.leaseAccessConditions,modifiedAccessConditions:i.containerAccessConditions.modifiedAccessConditions})]})})},t.prototype.acquireLease=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return[2,this.containerContext.acquireLease({abortSignal:e,duration:r,modifiedAccessConditions:i.modifiedAccessConditions,proposedLeaseId:t})]})})},t.prototype.releaseLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.containerContext.releaseLease(t,{abortSignal:e,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.renewLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.containerContext.renewLease(t,{abortSignal:e,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.breakLease=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.containerContext.breakLease({abortSignal:e,breakPeriod:t,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t.prototype.changeLease=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return[2,this.containerContext.changeLease(t,r,{abortSignal:e,modifiedAccessConditions:i.modifiedAccessConditions})]})})},t.prototype.listBlobFlatSegment=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.containerContext.listBlobFlatSegment(M({abortSignal:e,marker:t},r))]})})},t.prototype.listBlobHierarchySegment=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return[2,this.containerContext.listBlobHierarchySegment(t,M({abortSignal:e,marker:r},i))]})})},t}(_a),Za=function(e){function t(t,r,i){var n=e.call(this,t,r)||this;return n.tokenCredential=i,n.authorizationScheme=ea.AUTHORIZATION_SCHEME,n}return T(t,e),t.prototype.signRequest=function(e){return e.headers||(e.headers=new r),e.headers.set(ea.AUTHORIZATION,this.authorizationScheme+" "+this.tokenCredential.token),e},t}(Ba),es=function(e){function t(t){var r=e.call(this)||this;return r.token=t,r}return T(t,e),t.prototype.create=function(e,t){return new Za(e,t,this)},t}(fa),ts="object"==typeof Reflect?Reflect:null,rs=ts&&"function"==typeof ts.apply?ts.apply:function(e,t,r){return Function.prototype.apply.call(e,t,r)};Ua=ts&&"function"==typeof ts.ownKeys?ts.ownKeys:Object.getOwnPropertySymbols?function(e){return Object.getOwnPropertyNames(e).concat(Object.getOwnPropertySymbols(e))}:function(e){return Object.getOwnPropertyNames(e)};var is=Number.isNaN||function(e){return e!=e};function ns(){ns.init.call(this)}var as=ns;ns.EventEmitter=ns,ns.prototype._events=void 0,ns.prototype._eventsCount=0,ns.prototype._maxListeners=void 0;var ss=10;function os(e){return void 0===e._maxListeners?ns.defaultMaxListeners:e._maxListeners}function ms(e,t,r,i){var n,a,s,o;if("function"!=typeof r)throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof r);if(void 0===(a=e._events)?(a=e._events=Object.create(null),e._eventsCount=0):(void 0!==a.newListener&&(e.emit("newListener",t,r.listener?r.listener:r),a=e._events),s=a[t]),void 0===s)s=a[t]=r,++e._eventsCount;else if("function"==typeof s?s=a[t]=i?[r,s]:[s,r]:i?s.unshift(r):s.push(r),(n=os(e))>0&&s.length>n&&!s.warned){s.warned=!0;var m=new Error("Possible EventEmitter memory leak detected. "+s.length+" "+String(t)+" listeners added. Use emitter.setMaxListeners() to increase limit");m.name="MaxListenersExceededWarning",m.emitter=e,m.type=t,m.count=s.length,o=m,console&&console.warn&&console.warn(o)}return e}function ds(e,t,r){var i={fired:!1,wrapFn:void 0,target:e,type:t,listener:r},n=function(){for(var e=[],t=0;t<arguments.length;t++)e.push(arguments[t]);this.fired||(this.target.removeListener(this.type,this.wrapFn),this.fired=!0,rs(this.listener,this.target,e))}.bind(i);return n.listener=r,i.wrapFn=n,n}function ls(e,t,r){var i=e._events;if(void 0===i)return[];var n=i[t];return void 0===n?[]:"function"==typeof n?r?[n.listener||n]:[n]:r?function(e){for(var t=new Array(e.length),r=0;r<t.length;++r)t[r]=e[r].listener||e[r];return t}(n):ps(n,n.length)}function cs(e){var t=this._events;if(void 0!==t){var r=t[e];if("function"==typeof r)return 1;if(void 0!==r)return r.length}return 0}function ps(e,t){for(var r=new Array(t),i=0;i<t;++i)r[i]=e[i];return r}Object.defineProperty(ns,"defaultMaxListeners",{enumerable:!0,get:function(){return ss},set:function(e){if("number"!=typeof e||e<0||is(e))throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received '+e+".");ss=e}}),ns.init=function(){void 0!==this._events&&this._events!==Object.getPrototypeOf(this)._events||(this._events=Object.create(null),this._eventsCount=0),this._maxListeners=this._maxListeners||void 0},ns.prototype.setMaxListeners=function(e){if("number"!=typeof e||e<0||is(e))throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received '+e+".");return this._maxListeners=e,this},ns.prototype.getMaxListeners=function(){return os(this)},ns.prototype.emit=function(e){for(var t=[],r=1;r<arguments.length;r++)t.push(arguments[r]);var i="error"===e,n=this._events;if(void 0!==n)i=i&&void 0===n.error;else if(!i)return!1;if(i){var a;if(t.length>0&&(a=t[0]),a instanceof Error)throw a;var s=new Error("Unhandled error."+(a?" ("+a.message+")":""));throw s.context=a,s}var o=n[e];if(void 0===o)return!1;if("function"==typeof o)rs(o,this,t);else{var m=o.length,d=ps(o,m);for(r=0;r<m;++r)rs(d[r],this,t)}return!0},ns.prototype.addListener=function(e,t){return ms(this,e,t,!1)},ns.prototype.on=ns.prototype.addListener,ns.prototype.prependListener=function(e,t){return ms(this,e,t,!0)},ns.prototype.once=function(e,t){if("function"!=typeof t)throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof t);return this.on(e,ds(this,e,t)),this},ns.prototype.prependOnceListener=function(e,t){if("function"!=typeof t)throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof t);return this.prependListener(e,ds(this,e,t)),this},ns.prototype.removeListener=function(e,t){var r,i,n,a,s;if("function"!=typeof t)throw new TypeError('The "listener" argument must be of type Function. Received type '+typeof t);if(void 0===(i=this._events))return this;if(void 0===(r=i[e]))return this;if(r===t||r.listener===t)0==--this._eventsCount?this._events=Object.create(null):(delete i[e],i.removeListener&&this.emit("removeListener",e,r.listener||t));else if("function"!=typeof r){for(n=-1,a=r.length-1;a>=0;a--)if(r[a]===t||r[a].listener===t){s=r[a].listener,n=a;break}if(n<0)return this;0===n?r.shift():function(e,t){for(;t+1<e.length;t++)e[t]=e[t+1];e.pop()}(r,n),1===r.length&&(i[e]=r[0]),void 0!==i.removeListener&&this.emit("removeListener",e,s||t)}return this},ns.prototype.off=ns.prototype.removeListener,ns.prototype.removeAllListeners=function(e){var t,r,i;if(void 0===(r=this._events))return this;if(void 0===r.removeListener)return 0===arguments.length?(this._events=Object.create(null),this._eventsCount=0):void 0!==r[e]&&(0==--this._eventsCount?this._events=Object.create(null):delete r[e]),this;if(0===arguments.length){var n,a=Object.keys(r);for(i=0;i<a.length;++i)"removeListener"!==(n=a[i])&&this.removeAllListeners(n);return this.removeAllListeners("removeListener"),this._events=Object.create(null),this._eventsCount=0,this}if("function"==typeof(t=r[e]))this.removeListener(e,t);else if(void 0!==t)for(i=t.length-1;i>=0;i--)this.removeListener(e,t[i]);return this},ns.prototype.listeners=function(e){return ls(this,e,!0)},ns.prototype.rawListeners=function(e){return ls(this,e,!1)},ns.listenerCount=function(e,t){return"function"==typeof e.listenerCount?e.listenerCount(t):cs.call(e,t)},ns.prototype.listenerCount=cs,ns.prototype.eventNames=function(){return this._eventsCount>0?Ua(this._events):[]};var us,ys=as.EventEmitter;!function(e){e[e.Good=0]="Good",e[e.Error=1]="Error"}(us||(us={}));var hs=function(){function e(e){if(void 0===e&&(e=5),this.actives=0,this.completed=0,this.offset=0,this.operations=[],this.state=us.Good,e<1)throw new RangeError("concurrency must be larger than 0");this.concurrency=e,this.emitter=new ys}return e.prototype.addOperation=function(e){var t=this;this.operations.push(function(){return A(t,void 0,void 0,function(){var t;return E(this,function(r){switch(r.label){case 0:return r.trys.push([0,2,,3]),this.actives++,[4,e()];case 1:return r.sent(),this.actives--,this.completed++,this.parallelExecute(),[3,3];case 2:return t=r.sent(),this.emitter.emit("error",t),[3,3];case 3:return[2]}})})})},e.prototype.do=function(){return A(this,void 0,void 0,function(){var e=this;return E(this,function(t){return this.parallelExecute(),[2,new Promise(function(t,r){e.emitter.on("finish",t),e.emitter.on("error",function(t){e.state=us.Error,r(t)})})]})})},e.prototype.nextOperation=function(){return this.offset<this.operations.length?this.operations[this.offset++]:null},e.prototype.parallelExecute=function(){if(this.state!==us.Error)if(this.completed>=this.operations.length)this.emitter.emit("finish");else for(;this.actives<this.concurrency;){var e=this.nextOperation();if(!e)return;e()}},e}();function fs(e,t,r,i,n){return void 0===n&&(n={}),A(this,void 0,void 0,function(){var a,s,o,m,d,l,c,p=this;return E(this,function(u){switch(u.label){case 0:if(n.blockSize||(n.blockSize=0),n.blockSize<0||n.blockSize>Xn)throw new RangeError("blockSize option must be >= 0 and <= "+Xn);if(0===n.maxSingleShotSize||n.maxSingleShotSize||(n.maxSingleShotSize=jn),n.maxSingleShotSize<0||n.maxSingleShotSize>jn)throw new RangeError("maxSingleShotSize option must be >= 0 and <= "+jn);if(0===n.blockSize){if(r>Xn*Gn)throw new RangeError(r+" is too larger to upload to a block blob.");r>n.maxSingleShotSize&&(n.blockSize=Math.ceil(r/Gn),n.blockSize<Kn&&(n.blockSize=Kn))}if(n.blobHTTPHeaders||(n.blobHTTPHeaders={}),n.blobAccessConditions||(n.blobAccessConditions={}),r<=n.maxSingleShotSize)return[2,i.upload(e,t(0,r),r,n)];if((a=Math.floor((r-1)/n.blockSize)+1)>Gn)throw new RangeError("The buffer's size is too big or the BlockSize is too small;the number of blocks must be <= "+Gn);for(s=[],o=y(),m=0,d=new hs(n.parallelism),l=function(l){d.addOperation(function(){return A(p,void 0,void 0,function(){var d,c,p,u;return E(this,function(y){switch(y.label){case 0:return d=la(o,l),c=n.blockSize*l,p=l===a-1?r:c+n.blockSize,u=p-c,s.push(d),[4,i.stageBlock(e,d,t(c,u),u,{leaseAccessConditions:n.blobAccessConditions.leaseAccessConditions})];case 1:return y.sent(),m+=u,n.progress&&n.progress({loadedBytes:m}),[2]}})})})},c=0;c<a;c++)l(c);return[4,d.do()];case 1:return u.sent(),[2,i.commitBlockList(e,s,n)]}})})}var gs=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.pageBlobContext=new fn(i.storageClientContext),i}return T(t,e),t.fromContainerURL=function(e,r){return new t(sa(e.url,encodeURIComponent(r)),e.pipeline)},t.fromBlobURL=function(e){return new t(e.url,e.pipeline)},t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.withSnapshot=function(e){return new t(oa(this.url,Wn.SNAPSHOT,0===e.length?void 0:e),this.pipeline)},t.prototype.create=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.accessConditions=r.accessConditions||{},na(r.customerProvidedKey,this.isHttps),[2,this.pageBlobContext.create(0,t,{abortSignal:e,blobHTTPHeaders:r.blobHTTPHeaders,blobSequenceNumber:r.blobSequenceNumber,leaseAccessConditions:r.accessConditions.leaseAccessConditions,metadata:r.metadata,modifiedAccessConditions:r.accessConditions.modifiedAccessConditions,cpkInfo:r.customerProvidedKey,tier:ia(r.tier)})]})})},t.prototype.uploadPages=function(e,t,r,i,n){return void 0===n&&(n={}),A(this,void 0,void 0,function(){return E(this,function(a){return n.accessConditions=n.accessConditions||{},na(n.customerProvidedKey,this.isHttps),[2,this.pageBlobContext.uploadPages(t,i,{abortSignal:e,leaseAccessConditions:n.accessConditions.leaseAccessConditions,modifiedAccessConditions:n.accessConditions.modifiedAccessConditions,onUploadProgress:n.progress,range:Un({offset:r,count:i}),sequenceNumberAccessConditions:n.accessConditions.sequenceNumberAccessConditions,transactionalContentMD5:n.transactionalContentMD5,transactionalContentCrc64:n.transactionalContentCrc64,cpkInfo:n.customerProvidedKey})]})})},t.prototype.uploadPagesFromURL=function(e,t,r,i,n,a){return void 0===a&&(a={}),A(this,void 0,void 0,function(){return E(this,function(s){return a.accessConditions=a.accessConditions||{},a.sourceModifiedAccessConditions=a.sourceModifiedAccessConditions||{},na(a.customerProvidedKey,this.isHttps),[2,this.pageBlobContext.uploadPagesFromURL(t,Un({offset:r,count:n}),0,Un({offset:i,count:n}),{abortSignal:e,sourceContentMD5:a.sourceContentMD5,sourceContentCrc64:a.sourceContentCrc64,leaseAccessConditions:a.accessConditions.leaseAccessConditions,sequenceNumberAccessConditions:a.accessConditions.sequenceNumberAccessConditions,modifiedAccessConditions:a.accessConditions.modifiedAccessConditions,sourceModifiedAccessConditions:{sourceIfMatch:a.sourceModifiedAccessConditions.ifMatch,sourceIfModifiedSince:a.sourceModifiedAccessConditions.ifModifiedSince,sourceIfNoneMatch:a.sourceModifiedAccessConditions.ifNoneMatch,sourceIfUnmodifiedSince:a.sourceModifiedAccessConditions.ifUnmodifiedSince},cpkInfo:a.customerProvidedKey})]})})},t.prototype.clearPages=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return i.accessConditions=i.accessConditions||{},[2,this.pageBlobContext.clearPages(0,{abortSignal:e,leaseAccessConditions:i.accessConditions.leaseAccessConditions,modifiedAccessConditions:i.accessConditions.modifiedAccessConditions,range:Un({offset:t,count:r}),sequenceNumberAccessConditions:i.accessConditions.sequenceNumberAccessConditions,cpkInfo:i.customerProvidedKey})]})})},t.prototype.getPageRanges=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return i.accessConditions=i.accessConditions||{},[2,this.pageBlobContext.getPageRanges({abortSignal:e,leaseAccessConditions:i.accessConditions.leaseAccessConditions,modifiedAccessConditions:i.accessConditions.modifiedAccessConditions,range:Un({offset:t,count:r})})]})})},t.prototype.getPageRangesDiff=function(e,t,r,i,n){return void 0===n&&(n={}),A(this,void 0,void 0,function(){return E(this,function(a){return n.accessConditions=n.accessConditions||{},[2,this.pageBlobContext.getPageRangesDiff({abortSignal:e,leaseAccessConditions:n.accessConditions.leaseAccessConditions,modifiedAccessConditions:n.accessConditions.modifiedAccessConditions,prevsnapshot:i,range:Un({offset:t,count:r})})]})})},t.prototype.resize=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return r.accessConditions=r.accessConditions||{},[2,this.pageBlobContext.resize(t,{abortSignal:e,leaseAccessConditions:r.accessConditions.leaseAccessConditions,modifiedAccessConditions:r.accessConditions.modifiedAccessConditions})]})})},t.prototype.updateSequenceNumber=function(e,t,r,i){return void 0===i&&(i={}),A(this,void 0,void 0,function(){return E(this,function(n){return i.accessConditions=i.accessConditions||{},[2,this.pageBlobContext.updateSequenceNumber(t,{abortSignal:e,blobSequenceNumber:r,leaseAccessConditions:i.accessConditions.leaseAccessConditions,modifiedAccessConditions:i.accessConditions.modifiedAccessConditions})]})})},t.prototype.startCopyIncremental=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.pageBlobContext.copyIncremental(t,{abortSignal:e,modifiedAccessConditions:r.modifiedAccessConditions})]})})},t}(Ha);function Ns(e){return A(this,void 0,void 0,function(){var t;return E(this,function(r){return t=new FileReader,[2,new Promise(function(r,i){t.onloadend=function(e){r(e.target.result)},t.onerror=i,t.readAsText(e)})]})})}function bs(e){return A(this,void 0,void 0,function(){return E(this,function(t){switch(t.label){case 0:return[4,e.blobBody];case 1:return[4,Ns(t.sent())];case 2:return[2,t.sent()]}})})}var vs=function(){function e(e,t){if(!e||!e.contentType)throw new RangeError("batchResponse is malformed or doesn't contain valid content-type.");if(!t||0===t.size)throw new RangeError("Invalid state: subRequests is not provided or size is 0.");this.batchResponse=e,this.subRequests=t,this.responseBatchBoundary=this.batchResponse.contentType.split("=")[1],this.perResponsePrefix="--"+this.responseBatchBoundary+ta,this.batchResponseEnding="--"+this.responseBatchBoundary+"--"}return e.prototype.parseBatchResponse=function(){return A(this,void 0,void 0,function(){var e,t,i,n,a,s,o,m,d,l,c,p,u,y,h,f,g,N;return E(this,function(b){switch(b.label){case 0:if(this.batchResponse._response.status!=$n)throw new Error("Invalid state: batch request failed with status: '"+this.batchResponse._response.status+"'.");return[4,bs(this.batchResponse)];case 1:if(e=b.sent(),t=e.split(this.batchResponseEnding)[0].split(this.perResponsePrefix).slice(1),(i=t.length)!=this.subRequests.size&&1!=i)throw new Error("Invalid state: sub responses' count is not equal to sub requests' count.");for(n=new Array(i),a=0,s=0,o=0;o<i;o++){for(m=t[o],n[o]={},(d=n[o]).headers=new r,l=m.split(""+ta),c=!1,p=!1,u=!1,y=-1,h=0,f=l;h<f.length;h++)if(g=f[h],c)if(""!==g.trim())if(p)d.bodyAsText||(d.bodyAsText=""),d.bodyAsText+=g;else{if(-1===g.indexOf(": "))throw new Error("Invalid state: find non-empty line '"+g+"' without HTTP header delimiter ': '.");N=g.split(": "),d.headers.set(N[0],N[1]),N[0]===ea.X_MS_ERROR_CODE&&(d.errorCode=N[1],u=!0)}else p||(p=!0);else g.startsWith(ea.CONTENT_ID)&&(y=parseInt(g.split(": ")[1])),g.startsWith("HTTP/1.1")&&(c=!0,N=g.split(" "),d.status=parseInt(N[1]),d.statusMessage=N.slice(2).join(" "));-1!=y&&(d._request=this.subRequests.get(y)),u?s++:a++}return[2,{subResponses:n,subResponsesSucceededCount:a,subResponsesFailedCount:s}]}})})},e}(),Ss=function(e){function t(t,r){var i=e.call(this,t,r)||this;return i.serviceContext=new bi(i.storageClientContext),i}return T(t,e),t.prototype.withPipeline=function(e){return new t(this.url,e)},t.prototype.getProperties=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this.serviceContext.getProperties({abortSignal:e})]})})},t.prototype.setProperties=function(e,t){return A(this,void 0,void 0,function(){return E(this,function(r){return[2,this.serviceContext.setProperties(t,{abortSignal:e})]})})},t.prototype.getStatistics=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this.serviceContext.getStatistics({abortSignal:e})]})})},t.prototype.getAccountInfo=function(e){return A(this,void 0,void 0,function(){return E(this,function(t){return[2,this.serviceContext.getAccountInfo({abortSignal:e})]})})},t.prototype.listContainersSegment=function(e,t,r){return void 0===r&&(r={}),A(this,void 0,void 0,function(){return E(this,function(i){return[2,this.serviceContext.listContainersSegment(M({abortSignal:e,marker:t},r))]})})},t.prototype.getUserDelegationKey=function(e,t,r){return A(this,void 0,void 0,function(){var i,n;return E(this,function(a){switch(a.label){case 0:return[4,this.serviceContext.getUserDelegationKey({start:da(t,!1),expiry:da(r,!1)},{abortSignal:e})];case 1:return i=a.sent(),n={signedOid:i.signedOid,signedTid:i.signedTid,signedStart:new Date(i.signedStart),signedExpiry:new Date(i.signedExpiry),signedService:i.signedService,signedVersion:i.signedVersion,value:i.value},[2,M({_response:i._response,requestId:i.requestId,clientRequestId:i.clientRequestId,version:i.version,date:i.date,errorCode:i.errorCode},n)]}})})},t.prototype.submitBatch=function(e,t,r){return A(this,void 0,void 0,function(){var i,n,a;return E(this,function(s){switch(s.label){case 0:if(!t||0==t.getSubRequests().size)throw new RangeError("Batch request should contain one or more sub requests.");return i=t.getHttpRequestBody(),[4,this.serviceContext.submitBatch(i,(o=i,new Blob([o]).size),t.getMultiPartContentType(),M({abortSignal:e},r))];case 1:return n=s.sent(),[4,new vs(n,t.getSubRequests()).parseBatchResponse()];case 2:return a=s.sent(),[2,{_response:n._response,contentType:n.contentType,errorCode:n.errorCode,requestId:n.requestId,clientRequestId:n.clientRequestId,version:n.version,subResponses:a.subResponses,subResponsesSucceededCount:a.subResponsesSucceededCount,subResponsesFailedCount:a.subResponsesFailedCount}]}var o})})},t}(_a);e.Aborter=De,e.AnonymousCredential=Oa,e.AnonymousCredentialPolicy=Da,e.AppendBlobURL=ka,e.BaseRequestPolicy=W,e.BatchDeleteRequest=ja,e.BatchRequest=Va,e.BatchSetTierRequest=Xa,e.BlobURL=Ha,e.BlockBlobURL=Ya,e.BrowserPolicyFactory=ha,e.ContainerURL=Ja,e.Credential=fa,e.CredentialPolicy=Ba,e.HttpHeaders=r,e.LoggingPolicyFactory=Pa,e.Models=Be,e.PageBlobURL=gs,e.Pipeline=xa,e.RequestPolicyOptions=$,e.RestError=I,e.RetryPolicyFactory=Aa,e.ServiceURL=Ss,e.StorageURL=_a,e.TelemetryPolicyFactory=wa,e.TokenCredential=es,e.TokenCredentialPolicy=Za,e.UniqueRequestIDPolicyFactory=La,e.WebResource=R,e.deserializationPolicy=Q,e.uploadBrowserDataToBlockBlob=function(e,t,r,i){return A(this,void 0,void 0,function(){var n;return E(this,function(a){return n=new Blob([t]),[2,fs(e,function(e,t){return n.slice(e,e+t)},n.size,r,i)]})})},Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=azure-storage-blob.min.js.map
