import * as tslib_1 from "tslib";
import { streamToBuffer2 } from "./utils/utils.node";
import { BATCH_MAX_PAYLOAD_IN_BYTES } from "./utils/constants";
export function getBodyAsText(batchResponse) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var buffer, responseLength;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    buffer = Buffer.alloc(BATCH_MAX_PAYLOAD_IN_BYTES);
                    return [4 /*yield*/, streamToBuffer2(batchResponse.readableStreamBody, buffer)];
                case 1:
                    responseLength = _a.sent();
                    // Slice the buffer to trim the empty ending.
                    buffer = buffer.slice(0, responseLength);
                    return [2 /*return*/, buffer.toString()];
            }
        });
    });
}
export function utf8ByteLength(str) {
    return Buffer.byteLength(str);
}
//# sourceMappingURL=BatchUtils.js.map