/**
 * Generate IPRange format string. For example:
 *
 * "8.8.8.8" or "1.1.1.1-255.255.255.255"
 *
 * @export
 * @param {IIPRange} ipRange
 * @returns {string}
 */
export function ipRangeToString(ipRange) {
    return ipRange.end ? ipRange.start + "-" + ipRange.end : ipRange.start;
}
//# sourceMappingURL=IIPRange.js.map