import { BaseRequestPolicy, HttpHeaders, HttpPipelineLogLevel, RequestPolicyOptions, WebResource } from "@azure/ms-rest-js";
// Export following interfaces and types for customers who want to implement their
// own RequestPolicy or HTTPClient
export { HttpHeaders, HttpPipelineLogLevel, WebResource, BaseRequestPolicy, RequestPolicyOptions };
/**
 * A Pipeline class containing HTTP request policies.
 * You can create a default Pipeline by calling StorageURL.newPipeline().
 * Or you can create a Pipeline with your own policies by the constructor of Pipeline.
 * Refer to StorageURL.newPipeline() and provided policies as reference before
 * implementing your customized Pipeline.
 *
 * @export
 * @class Pipeline
 */
var Pipeline = /** @class */ (function () {
    /**
     * Creates an instance of Pipeline. Customize HTTPClient by implementing IHttpClient interface.
     *
     * @param {RequestPolicyFactory[]} factories
     * @param {IPipelineOptions} [options={}]
     * @memberof Pipeline
     */
    function Pipeline(factories, options) {
        if (options === void 0) { options = {}; }
        this.factories = factories;
        this.options = options;
    }
    /**
     * Transfer Pipeline object to ServiceClientOptions object which required by
     * ServiceClient constructor.
     *
     * @returns {ServiceClientOptions}
     * @memberof Pipeline
     */
    Pipeline.prototype.toServiceClientOptions = function () {
        return {
            httpClient: this.options.HTTPClient,
            httpPipelineLogger: this.options.logger,
            requestPolicyFactories: this.factories
        };
    };
    return Pipeline;
}());
export { Pipeline };
//# sourceMappingURL=Pipeline.js.map