import * as tslib_1 from "tslib";
import { Credential } from "../credentials/Credential";
import { TokenCredentialPolicy } from "../policies/TokenCredentialPolicy";
/**
 * TokenCredential is a Credential used to generate a TokenCredentialPolicy.
 * Renew token by setting a new token string value to token property.
 *
 * @example
 *  const tokenCredential = new TokenCredential("token");
 *  const pipeline = StorageURL.newPipeline(tokenCredential);
 *
 *  // List containers
 *  const serviceURL = new ServiceURL("https://mystorageaccount.blob.core.windows.net", pipeline);
 *
 *  // Set up a timer to refresh the token
 *  const timerID = setInterval(() => {
 *    // Update token by accessing to public tokenCredential.token
 *    tokenCredential.token = "updatedToken";
 *    // WARNING: Timer must be manually stopped! It will forbid GC of tokenCredential
 *    if (shouldStop()) {
 *      clearInterval(timerID);
 *    }
 *  }, 60 * 60 * 1000); // Set an interval time before your token expired
 * @export
 * @class TokenCredential
 * @extends {Credential}
 *
 */
var TokenCredential = /** @class */ (function (_super) {
    tslib_1.__extends(TokenCredential, _super);
    /**
     * Creates an instance of TokenCredential.
     * @param {string} token
     * @memberof TokenCredential
     */
    function TokenCredential(token) {
        var _this = _super.call(this) || this;
        _this.token = token;
        return _this;
    }
    /**
     * Creates a TokenCredentialPolicy object.
     *
     * @param {RequestPolicy} nextPolicy
     * @param {RequestPolicyOptions} options
     * @returns {TokenCredentialPolicy}
     * @memberof TokenCredential
     */
    TokenCredential.prototype.create = function (nextPolicy, options) {
        return new TokenCredentialPolicy(nextPolicy, options, this);
    };
    return TokenCredential;
}(Credential));
export { TokenCredential };
//# sourceMappingURL=TokenCredential.js.map