import * as Crypto from "crypto";
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * UserDelegationKeyCredential is only used for generation of user delegation SAS.
 * @see https://docs.microsoft.com/en-us/rest/api/storageservices/create-user-delegation-sas
 *
 * @export
 * @class UserDelegationKeyCredential
 */
var UserDelegationKeyCredential = /** @class */ (function () {
    /**
     * Creates an instance of UserDelegationKeyCredential.
     * @param {string} accountName
     * @param {UserDelegationKey} userDelegationKey
     * @memberof UserDelegationKeyCredential
     */
    function UserDelegationKeyCredential(accountName, userDelegationKey) {
        this.accountName = accountName;
        this.userDelegationKey = userDelegationKey;
        this.key = Buffer.from(userDelegationKey.value, "base64");
    }
    /**
     * Generates a hash signature for an HTTP request or for a SAS.
     *
     * @param {string} stringToSign
     * @returns {string}
     * @memberof UserDelegationKeyCredential
     */
    UserDelegationKeyCredential.prototype.computeHMACSHA256 = function (stringToSign) {
        // console.log(`stringToSign: ${JSON.stringify(stringToSign)}`);
        return Crypto.createHmac("sha256", this.key)
            .update(stringToSign, "utf8")
            .digest("base64");
    };
    return UserDelegationKeyCredential;
}());
export { UserDelegationKeyCredential };
//# sourceMappingURL=UserDelegationKeyCredential.js.map