/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/appendBlobMappers";
import * as Parameters from "../models/parameters";
/** Class representing a AppendBlob. */
var AppendBlob = /** @class */ (function () {
    /**
     * Create a AppendBlob.
     * @param {StorageClientContext} client Reference to the service client.
     */
    function AppendBlob(client) {
        this.client = client;
    }
    AppendBlob.prototype.create = function (contentLength, options, callback) {
        return this.client.sendOperationRequest({
            contentLength: contentLength,
            options: options
        }, createOperationSpec, callback);
    };
    AppendBlob.prototype.appendBlock = function (body, contentLength, options, callback) {
        return this.client.sendOperationRequest({
            body: body,
            contentLength: contentLength,
            options: options
        }, appendBlockOperationSpec, callback);
    };
    AppendBlob.prototype.appendBlockFromUrl = function (sourceUrl, contentLength, options, callback) {
        return this.client.sendOperationRequest({
            sourceUrl: sourceUrl,
            contentLength: contentLength,
            options: options
        }, appendBlockFromUrlOperationSpec, callback);
    };
    return AppendBlob;
}());
export { AppendBlob };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers, true);
var createOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.metadata,
        Parameters.version,
        Parameters.requestId,
        Parameters.blobType1,
        Parameters.blobContentType,
        Parameters.blobContentEncoding,
        Parameters.blobContentLanguage,
        Parameters.blobContentMD5,
        Parameters.blobCacheControl,
        Parameters.blobContentDisposition,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.AppendBlobCreateHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var appendBlockOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp15
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.transactionalContentMD5,
        Parameters.transactionalContentCrc64,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.maxSize,
        Parameters.appendPosition,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    requestBody: {
        parameterPath: "body",
        mapper: {
            required: true,
            serializedName: "body",
            type: {
                name: "Stream"
            }
        }
    },
    contentType: "application/octet-stream",
    responses: {
        201: {
            headersMapper: Mappers.AppendBlobAppendBlockHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var appendBlockFromUrlOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp15
    ],
    headerParameters: [
        Parameters.sourceUrl,
        Parameters.sourceRange1,
        Parameters.sourceContentMD5,
        Parameters.sourceContentCrc64,
        Parameters.contentLength,
        Parameters.transactionalContentMD5,
        Parameters.version,
        Parameters.requestId,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.leaseId0,
        Parameters.maxSize,
        Parameters.appendPosition,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.AppendBlobAppendBlockFromUrlHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
//# sourceMappingURL=appendBlob.js.map