/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/blobMappers";
import * as Parameters from "../models/parameters";
/** Class representing a Blob. */
var Blob = /** @class */ (function () {
    /**
     * Create a Blob.
     * @param {StorageClientContext} client Reference to the service client.
     */
    function Blob(client) {
        this.client = client;
    }
    Blob.prototype.download = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, downloadOperationSpec, callback);
    };
    Blob.prototype.getProperties = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getPropertiesOperationSpec, callback);
    };
    Blob.prototype.deleteMethod = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, deleteMethodOperationSpec, callback);
    };
    Blob.prototype.setAccessControl = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, setAccessControlOperationSpec, callback);
    };
    Blob.prototype.getAccessControl = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getAccessControlOperationSpec, callback);
    };
    Blob.prototype.rename = function (renameSource, options, callback) {
        return this.client.sendOperationRequest({
            renameSource: renameSource,
            options: options
        }, renameOperationSpec, callback);
    };
    Blob.prototype.undelete = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, undeleteOperationSpec, callback);
    };
    Blob.prototype.setHTTPHeaders = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, setHTTPHeadersOperationSpec, callback);
    };
    Blob.prototype.setMetadata = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, setMetadataOperationSpec, callback);
    };
    Blob.prototype.acquireLease = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, acquireLeaseOperationSpec, callback);
    };
    Blob.prototype.releaseLease = function (leaseId, options, callback) {
        return this.client.sendOperationRequest({
            leaseId: leaseId,
            options: options
        }, releaseLeaseOperationSpec, callback);
    };
    Blob.prototype.renewLease = function (leaseId, options, callback) {
        return this.client.sendOperationRequest({
            leaseId: leaseId,
            options: options
        }, renewLeaseOperationSpec, callback);
    };
    Blob.prototype.changeLease = function (leaseId, proposedLeaseId, options, callback) {
        return this.client.sendOperationRequest({
            leaseId: leaseId,
            proposedLeaseId: proposedLeaseId,
            options: options
        }, changeLeaseOperationSpec, callback);
    };
    Blob.prototype.breakLease = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, breakLeaseOperationSpec, callback);
    };
    Blob.prototype.createSnapshot = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, createSnapshotOperationSpec, callback);
    };
    Blob.prototype.startCopyFromURL = function (copySource, options, callback) {
        return this.client.sendOperationRequest({
            copySource: copySource,
            options: options
        }, startCopyFromURLOperationSpec, callback);
    };
    Blob.prototype.copyFromURL = function (copySource, options, callback) {
        return this.client.sendOperationRequest({
            copySource: copySource,
            options: options
        }, copyFromURLOperationSpec, callback);
    };
    Blob.prototype.abortCopyFromURL = function (copyId, options, callback) {
        return this.client.sendOperationRequest({
            copyId: copyId,
            options: options
        }, abortCopyFromURLOperationSpec, callback);
    };
    Blob.prototype.setTier = function (tier, options, callback) {
        return this.client.sendOperationRequest({
            tier: tier,
            options: options
        }, setTierOperationSpec, callback);
    };
    Blob.prototype.getAccountInfo = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getAccountInfoOperationSpec, callback);
    };
    return Blob;
}());
export { Blob };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers, true);
var downloadOperationSpec = {
    httpMethod: "GET",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.range0,
        Parameters.rangeGetContentMD5,
        Parameters.rangeGetContentCRC64,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Stream"
                }
            },
            headersMapper: Mappers.BlobDownloadHeaders
        },
        206: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Stream"
                }
            },
            headersMapper: Mappers.BlobDownloadHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getPropertiesOperationSpec = {
    httpMethod: "HEAD",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobGetPropertiesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var deleteMethodOperationSpec = {
    httpMethod: "DELETE",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.deleteSnapshots,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        202: {
            headersMapper: Mappers.BlobDeleteHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var setAccessControlOperationSpec = {
    httpMethod: "PATCH",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.action5
    ],
    headerParameters: [
        Parameters.owner,
        Parameters.group,
        Parameters.posixPermissions,
        Parameters.posixAcl,
        Parameters.requestId,
        Parameters.version,
        Parameters.leaseId0,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobSetAccessControlHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getAccessControlOperationSpec = {
    httpMethod: "HEAD",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.upn,
        Parameters.action6
    ],
    headerParameters: [
        Parameters.requestId,
        Parameters.version,
        Parameters.leaseId0,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobGetAccessControlHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var renameOperationSpec = {
    httpMethod: "PUT",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.pathRenameMode
    ],
    headerParameters: [
        Parameters.renameSource,
        Parameters.directoryProperties,
        Parameters.posixPermissions,
        Parameters.posixUmask,
        Parameters.sourceLeaseId,
        Parameters.version,
        Parameters.requestId,
        Parameters.cacheControl,
        Parameters.contentType,
        Parameters.contentEncoding,
        Parameters.contentLanguage,
        Parameters.contentDisposition,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.BlobRenameHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var undeleteOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp8
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobUndeleteHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var setHTTPHeadersOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp0
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.blobCacheControl,
        Parameters.blobContentType,
        Parameters.blobContentMD5,
        Parameters.blobContentEncoding,
        Parameters.blobContentLanguage,
        Parameters.blobContentDisposition,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobSetHTTPHeadersHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var setMetadataOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp5
    ],
    headerParameters: [
        Parameters.metadata,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobSetMetadataHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var acquireLeaseOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp7
    ],
    headerParameters: [
        Parameters.duration,
        Parameters.proposedLeaseId0,
        Parameters.version,
        Parameters.requestId,
        Parameters.action0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.BlobAcquireLeaseHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var releaseLeaseOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp7
    ],
    headerParameters: [
        Parameters.leaseId1,
        Parameters.version,
        Parameters.requestId,
        Parameters.action1,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobReleaseLeaseHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var renewLeaseOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp7
    ],
    headerParameters: [
        Parameters.leaseId1,
        Parameters.version,
        Parameters.requestId,
        Parameters.action2,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobRenewLeaseHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var changeLeaseOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp7
    ],
    headerParameters: [
        Parameters.leaseId1,
        Parameters.proposedLeaseId1,
        Parameters.version,
        Parameters.requestId,
        Parameters.action4,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobChangeLeaseHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var breakLeaseOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp7
    ],
    headerParameters: [
        Parameters.breakPeriod,
        Parameters.version,
        Parameters.requestId,
        Parameters.action3,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        202: {
            headersMapper: Mappers.BlobBreakLeaseHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var createSnapshotOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp9
    ],
    headerParameters: [
        Parameters.metadata,
        Parameters.version,
        Parameters.requestId,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.leaseId0
    ],
    responses: {
        201: {
            headersMapper: Mappers.BlobCreateSnapshotHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var startCopyFromURLOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.metadata,
        Parameters.tier0,
        Parameters.rehydratePriority,
        Parameters.copySource,
        Parameters.version,
        Parameters.requestId,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.leaseId0
    ],
    responses: {
        202: {
            headersMapper: Mappers.BlobStartCopyFromURLHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var copyFromURLOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.metadata,
        Parameters.tier0,
        Parameters.copySource,
        Parameters.version,
        Parameters.requestId,
        Parameters.xMsRequiresSync,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.leaseId0
    ],
    responses: {
        202: {
            headersMapper: Mappers.BlobCopyFromURLHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var abortCopyFromURLOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.copyId,
        Parameters.timeout,
        Parameters.comp10
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.copyActionAbortConstant,
        Parameters.leaseId0
    ],
    responses: {
        204: {
            headersMapper: Mappers.BlobAbortCopyFromURLHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var setTierOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp11
    ],
    headerParameters: [
        Parameters.tier1,
        Parameters.rehydratePriority,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobSetTierHeaders
        },
        202: {
            headersMapper: Mappers.BlobSetTierHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getAccountInfoOperationSpec = {
    httpMethod: "GET",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.restype1,
        Parameters.comp0
    ],
    headerParameters: [
        Parameters.version
    ],
    responses: {
        200: {
            headersMapper: Mappers.BlobGetAccountInfoHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
//# sourceMappingURL=blob.js.map