/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as tslib_1 from "tslib";
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/blockBlobMappers";
import * as Parameters from "../models/parameters";
/** Class representing a BlockBlob. */
var BlockBlob = /** @class */ (function () {
    /**
     * Create a BlockBlob.
     * @param {StorageClientContext} client Reference to the service client.
     */
    function BlockBlob(client) {
        this.client = client;
    }
    BlockBlob.prototype.upload = function (body, contentLength, options, callback) {
        return this.client.sendOperationRequest({
            body: body,
            contentLength: contentLength,
            options: options
        }, uploadOperationSpec, callback);
    };
    BlockBlob.prototype.stageBlock = function (blockId, contentLength, body, options, callback) {
        return this.client.sendOperationRequest({
            blockId: blockId,
            contentLength: contentLength,
            body: body,
            options: options
        }, stageBlockOperationSpec, callback);
    };
    BlockBlob.prototype.stageBlockFromURL = function (blockId, contentLength, sourceUrl, options, callback) {
        return this.client.sendOperationRequest({
            blockId: blockId,
            contentLength: contentLength,
            sourceUrl: sourceUrl,
            options: options
        }, stageBlockFromURLOperationSpec, callback);
    };
    BlockBlob.prototype.commitBlockList = function (blocks, options, callback) {
        return this.client.sendOperationRequest({
            blocks: blocks,
            options: options
        }, commitBlockListOperationSpec, callback);
    };
    BlockBlob.prototype.getBlockList = function (listType, options, callback) {
        return this.client.sendOperationRequest({
            listType: listType,
            options: options
        }, getBlockListOperationSpec, callback);
    };
    return BlockBlob;
}());
export { BlockBlob };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers, true);
var uploadOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.metadata,
        Parameters.tier0,
        Parameters.version,
        Parameters.requestId,
        Parameters.blobType2,
        Parameters.blobContentType,
        Parameters.blobContentEncoding,
        Parameters.blobContentLanguage,
        Parameters.blobContentMD5,
        Parameters.blobCacheControl,
        Parameters.blobContentDisposition,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    requestBody: {
        parameterPath: "body",
        mapper: {
            required: true,
            serializedName: "body",
            type: {
                name: "Stream"
            }
        }
    },
    contentType: "application/octet-stream",
    responses: {
        201: {
            headersMapper: Mappers.BlockBlobUploadHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var stageBlockOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.blockId,
        Parameters.timeout,
        Parameters.comp16
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.transactionalContentMD5,
        Parameters.transactionalContentCrc64,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm
    ],
    requestBody: {
        parameterPath: "body",
        mapper: {
            required: true,
            serializedName: "body",
            type: {
                name: "Stream"
            }
        }
    },
    contentType: "application/octet-stream",
    responses: {
        201: {
            headersMapper: Mappers.BlockBlobStageBlockHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var stageBlockFromURLOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.blockId,
        Parameters.timeout,
        Parameters.comp16
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.sourceUrl,
        Parameters.sourceRange1,
        Parameters.sourceContentMD5,
        Parameters.sourceContentCrc64,
        Parameters.version,
        Parameters.requestId,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.leaseId0,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.BlockBlobStageBlockFromURLHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var commitBlockListOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp17
    ],
    headerParameters: [
        Parameters.transactionalContentMD5,
        Parameters.transactionalContentCrc64,
        Parameters.metadata,
        Parameters.tier0,
        Parameters.version,
        Parameters.requestId,
        Parameters.blobCacheControl,
        Parameters.blobContentType,
        Parameters.blobContentEncoding,
        Parameters.blobContentLanguage,
        Parameters.blobContentMD5,
        Parameters.blobContentDisposition,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    requestBody: {
        parameterPath: "blocks",
        mapper: tslib_1.__assign({}, Mappers.BlockLookupList, { required: true })
    },
    contentType: "application/xml; charset=utf-8",
    responses: {
        201: {
            headersMapper: Mappers.BlockBlobCommitBlockListHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getBlockListOperationSpec = {
    httpMethod: "GET",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.listType,
        Parameters.timeout,
        Parameters.comp17
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0
    ],
    responses: {
        200: {
            bodyMapper: Mappers.BlockList,
            headersMapper: Mappers.BlockBlobGetBlockListHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
//# sourceMappingURL=blockBlob.js.map