/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/directoryMappers";
import * as Parameters from "../models/parameters";
/** Class representing a Directory. */
var Directory = /** @class */ (function () {
    /**
     * Create a Directory.
     * @param {StorageClientContext} client Reference to the service client.
     */
    function Directory(client) {
        this.client = client;
    }
    Directory.prototype.create = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, createOperationSpec, callback);
    };
    Directory.prototype.rename = function (renameSource, options, callback) {
        return this.client.sendOperationRequest({
            renameSource: renameSource,
            options: options
        }, renameOperationSpec, callback);
    };
    Directory.prototype.deleteMethod = function (recursiveDirectoryDelete, options, callback) {
        return this.client.sendOperationRequest({
            recursiveDirectoryDelete: recursiveDirectoryDelete,
            options: options
        }, deleteMethodOperationSpec, callback);
    };
    Directory.prototype.setAccessControl = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, setAccessControlOperationSpec, callback);
    };
    Directory.prototype.getAccessControl = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getAccessControlOperationSpec, callback);
    };
    return Directory;
}());
export { Directory };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers, true);
var createOperationSpec = {
    httpMethod: "PUT",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.resource
    ],
    headerParameters: [
        Parameters.directoryProperties,
        Parameters.posixPermissions,
        Parameters.posixUmask,
        Parameters.version,
        Parameters.requestId,
        Parameters.cacheControl,
        Parameters.contentType,
        Parameters.contentEncoding,
        Parameters.contentLanguage,
        Parameters.contentDisposition,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.DirectoryCreateHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var renameOperationSpec = {
    httpMethod: "PUT",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.marker1,
        Parameters.pathRenameMode
    ],
    headerParameters: [
        Parameters.renameSource,
        Parameters.directoryProperties,
        Parameters.posixPermissions,
        Parameters.posixUmask,
        Parameters.sourceLeaseId,
        Parameters.version,
        Parameters.requestId,
        Parameters.cacheControl,
        Parameters.contentType,
        Parameters.contentEncoding,
        Parameters.contentLanguage,
        Parameters.contentDisposition,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.DirectoryRenameHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var deleteMethodOperationSpec = {
    httpMethod: "DELETE",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.recursiveDirectoryDelete,
        Parameters.marker1
    ],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.DirectoryDeleteHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var setAccessControlOperationSpec = {
    httpMethod: "PATCH",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.action5
    ],
    headerParameters: [
        Parameters.owner,
        Parameters.group,
        Parameters.posixPermissions,
        Parameters.posixAcl,
        Parameters.requestId,
        Parameters.version,
        Parameters.leaseId0,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince
    ],
    responses: {
        200: {
            headersMapper: Mappers.DirectorySetAccessControlHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getAccessControlOperationSpec = {
    httpMethod: "HEAD",
    path: "{filesystem}/{path}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.upn,
        Parameters.action6
    ],
    headerParameters: [
        Parameters.requestId,
        Parameters.version,
        Parameters.leaseId0,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince
    ],
    responses: {
        200: {
            headersMapper: Mappers.DirectoryGetAccessControlHeaders
        },
        default: {
            bodyMapper: Mappers.DataLakeStorageError
        }
    },
    isXML: true,
    serializer: serializer
};
//# sourceMappingURL=directory.js.map