/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import * as msRest from "@azure/ms-rest-js";
import * as Mappers from "../models/pageBlobMappers";
import * as Parameters from "../models/parameters";
/** Class representing a PageBlob. */
var PageBlob = /** @class */ (function () {
    /**
     * Create a PageBlob.
     * @param {StorageClientContext} client Reference to the service client.
     */
    function PageBlob(client) {
        this.client = client;
    }
    PageBlob.prototype.create = function (contentLength, blobContentLength, options, callback) {
        return this.client.sendOperationRequest({
            contentLength: contentLength,
            blobContentLength: blobContentLength,
            options: options
        }, createOperationSpec, callback);
    };
    PageBlob.prototype.uploadPages = function (body, contentLength, options, callback) {
        return this.client.sendOperationRequest({
            body: body,
            contentLength: contentLength,
            options: options
        }, uploadPagesOperationSpec, callback);
    };
    PageBlob.prototype.clearPages = function (contentLength, options, callback) {
        return this.client.sendOperationRequest({
            contentLength: contentLength,
            options: options
        }, clearPagesOperationSpec, callback);
    };
    PageBlob.prototype.uploadPagesFromURL = function (sourceUrl, sourceRange, contentLength, range, options, callback) {
        return this.client.sendOperationRequest({
            sourceUrl: sourceUrl,
            sourceRange: sourceRange,
            contentLength: contentLength,
            range: range,
            options: options
        }, uploadPagesFromURLOperationSpec, callback);
    };
    PageBlob.prototype.getPageRanges = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getPageRangesOperationSpec, callback);
    };
    PageBlob.prototype.getPageRangesDiff = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getPageRangesDiffOperationSpec, callback);
    };
    PageBlob.prototype.resize = function (blobContentLength, options, callback) {
        return this.client.sendOperationRequest({
            blobContentLength: blobContentLength,
            options: options
        }, resizeOperationSpec, callback);
    };
    PageBlob.prototype.updateSequenceNumber = function (sequenceNumberAction, options, callback) {
        return this.client.sendOperationRequest({
            sequenceNumberAction: sequenceNumberAction,
            options: options
        }, updateSequenceNumberOperationSpec, callback);
    };
    PageBlob.prototype.copyIncremental = function (copySource, options, callback) {
        return this.client.sendOperationRequest({
            copySource: copySource,
            options: options
        }, copyIncrementalOperationSpec, callback);
    };
    return PageBlob;
}());
export { PageBlob };
// Operation Specifications
var serializer = new msRest.Serializer(Mappers, true);
var createOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.metadata,
        Parameters.blobContentLength,
        Parameters.blobSequenceNumber,
        Parameters.version,
        Parameters.requestId,
        Parameters.tier0,
        Parameters.blobType0,
        Parameters.blobContentType,
        Parameters.blobContentEncoding,
        Parameters.blobContentLanguage,
        Parameters.blobContentMD5,
        Parameters.blobCacheControl,
        Parameters.blobContentDisposition,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.PageBlobCreateHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var uploadPagesOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp12
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.transactionalContentMD5,
        Parameters.transactionalContentCrc64,
        Parameters.range0,
        Parameters.version,
        Parameters.requestId,
        Parameters.pageWrite0,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifSequenceNumberLessThanOrEqualTo,
        Parameters.ifSequenceNumberLessThan,
        Parameters.ifSequenceNumberEqualTo,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    requestBody: {
        parameterPath: "body",
        mapper: {
            required: true,
            serializedName: "body",
            type: {
                name: "Stream"
            }
        }
    },
    contentType: "application/octet-stream",
    responses: {
        201: {
            headersMapper: Mappers.PageBlobUploadPagesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var clearPagesOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp12
    ],
    headerParameters: [
        Parameters.contentLength,
        Parameters.range0,
        Parameters.version,
        Parameters.requestId,
        Parameters.pageWrite1,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifSequenceNumberLessThanOrEqualTo,
        Parameters.ifSequenceNumberLessThan,
        Parameters.ifSequenceNumberEqualTo,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.PageBlobClearPagesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var uploadPagesFromURLOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp12
    ],
    headerParameters: [
        Parameters.sourceUrl,
        Parameters.sourceRange0,
        Parameters.sourceContentMD5,
        Parameters.sourceContentCrc64,
        Parameters.contentLength,
        Parameters.range1,
        Parameters.version,
        Parameters.requestId,
        Parameters.pageWrite0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.leaseId0,
        Parameters.ifSequenceNumberLessThanOrEqualTo,
        Parameters.ifSequenceNumberLessThan,
        Parameters.ifSequenceNumberEqualTo,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch,
        Parameters.sourceIfModifiedSince,
        Parameters.sourceIfUnmodifiedSince,
        Parameters.sourceIfMatch,
        Parameters.sourceIfNoneMatch
    ],
    responses: {
        201: {
            headersMapper: Mappers.PageBlobUploadPagesFromURLHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getPageRangesOperationSpec = {
    httpMethod: "GET",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.timeout,
        Parameters.comp13
    ],
    headerParameters: [
        Parameters.range0,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PageList,
            headersMapper: Mappers.PageBlobGetPageRangesHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var getPageRangesDiffOperationSpec = {
    httpMethod: "GET",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.snapshot,
        Parameters.timeout,
        Parameters.prevsnapshot,
        Parameters.comp13
    ],
    headerParameters: [
        Parameters.range0,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PageList,
            headersMapper: Mappers.PageBlobGetPageRangesDiffHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var resizeOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp0
    ],
    headerParameters: [
        Parameters.blobContentLength,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.encryptionKey,
        Parameters.encryptionKeySha256,
        Parameters.encryptionAlgorithm,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.PageBlobResizeHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var updateSequenceNumberOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp0
    ],
    headerParameters: [
        Parameters.sequenceNumberAction,
        Parameters.blobSequenceNumber,
        Parameters.version,
        Parameters.requestId,
        Parameters.leaseId0,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        200: {
            headersMapper: Mappers.PageBlobUpdateSequenceNumberHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
var copyIncrementalOperationSpec = {
    httpMethod: "PUT",
    path: "{containerName}/{blob}",
    urlParameters: [
        Parameters.url
    ],
    queryParameters: [
        Parameters.timeout,
        Parameters.comp14
    ],
    headerParameters: [
        Parameters.copySource,
        Parameters.version,
        Parameters.requestId,
        Parameters.ifModifiedSince,
        Parameters.ifUnmodifiedSince,
        Parameters.ifMatch,
        Parameters.ifNoneMatch
    ],
    responses: {
        202: {
            headersMapper: Mappers.PageBlobCopyIncrementalHeaders
        },
        default: {
            bodyMapper: Mappers.StorageError
        }
    },
    isXML: true,
    serializer: serializer
};
//# sourceMappingURL=pageBlob.js.map